"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSymlinkFollow = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const follow_mode_1 = require("./fs/follow-mode");
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case follow_mode_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case follow_mode_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case follow_mode_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case follow_mode_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHFDQUErQyxDQUFDLGdEQUFnRDtBQUNoRyxrREFBOEM7QUFDOUMsU0FBZ0IsZUFBZSxDQUFDLE1BQW1CO0lBQy9DLElBQUksQ0FBQyxNQUFNLEVBQUU7UUFDVCxPQUFPLFNBQVMsQ0FBQztLQUNwQjtJQUNELFFBQVEsTUFBTSxFQUFFO1FBQ1osS0FBSyx3QkFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsS0FBSyxDQUFDO1FBQ3RELEtBQUssd0JBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLE1BQU0sQ0FBQztRQUN4RCxLQUFLLHdCQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxjQUFjLENBQUM7UUFDeEUsS0FBSyx3QkFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsUUFBUSxDQUFDO1FBQzVEO1lBQ0ksTUFBTSxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUN6RDtBQUNMLENBQUM7QUFaRCwwQ0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN5bWxpbmtGb2xsb3dNb2RlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBGb2xsb3dNb2RlIH0gZnJvbSAnLi9mcy9mb2xsb3ctbW9kZSc7XG5leHBvcnQgZnVuY3Rpb24gdG9TeW1saW5rRm9sbG93KGZvbGxvdz86IEZvbGxvd01vZGUpOiBTeW1saW5rRm9sbG93TW9kZSB8IHVuZGVmaW5lZCB7XG4gICAgaWYgKCFmb2xsb3cpIHtcbiAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICB9XG4gICAgc3dpdGNoIChmb2xsb3cpIHtcbiAgICAgICAgY2FzZSBGb2xsb3dNb2RlLk5FVkVSOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuTkVWRVI7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5BTFdBWVM6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5BTFdBWVM7XG4gICAgICAgIGNhc2UgRm9sbG93TW9kZS5CTE9DS19FWFRFUk5BTDogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLkJMT0NLX0VYVEVSTkFMO1xuICAgICAgICBjYXNlIEZvbGxvd01vZGUuRVhURVJOQUw6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5FWFRFUk5BTDtcbiAgICAgICAgZGVmYXVsdDpcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcihgdW5rbm93biBmb2xsb3cgbW9kZTogJHtmb2xsb3d9YCk7XG4gICAgfVxufVxuIl19