# delphix-dct-api
Delphix DCT API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.2.0
- Package version: 2.2.0-rc1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import accounts_api
from delphix.api.gateway.model.account import Account
from delphix.api.gateway.model.account_create_parameter import AccountCreateParameter
from delphix.api.gateway.model.account_create_response import AccountCreateResponse
from delphix.api.gateway.model.account_update_parameter import AccountUpdateParameter
from delphix.api.gateway.model.change_password_parameter import ChangePasswordParameter
from delphix.api.gateway.model.delete_tag import DeleteTag
from delphix.api.gateway.model.list_accounts_response import ListAccountsResponse
from delphix.api.gateway.model.password_policies_params import PasswordPoliciesParams
from delphix.api.gateway.model.reset_password_parameter import ResetPasswordParameter
from delphix.api.gateway.model.search_accounts_response import SearchAccountsResponse
from delphix.api.gateway.model.search_body import SearchBody
from delphix.api.gateway.model.tags_request import TagsRequest
from delphix.api.gateway.model.tags_response import TagsResponse
# Defining the host is optional and defaults to http://localhost/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = accounts_api.AccountsApi(api_client)
    id = 1 # int | Numeric ID of the Account.
change_password_parameter = ChangePasswordParameter(
        old_password="old_password_example",
        new_password="new_password_example",
    ) # ChangePasswordParameter | 

    try:
        # Change Account Password. 
        api_instance.change_account_password(id, change_password_parameter)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling AccountsApi->change_account_password: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AccountsApi* | [**change_account_password**](docs/AccountsApi.md#change_account_password) | **POST** /management/accounts/{id}/change_password | Change Account Password. 
*AccountsApi* | [**create_account**](docs/AccountsApi.md#create_account) | **POST** /management/accounts | Create a new Account 
*AccountsApi* | [**create_account_tags**](docs/AccountsApi.md#create_account_tags) | **POST** /management/accounts/{id}/tags | Create tags for an Account.
*AccountsApi* | [**delete_account**](docs/AccountsApi.md#delete_account) | **DELETE** /management/accounts/{id} | Delete an Account
*AccountsApi* | [**delete_account_tags**](docs/AccountsApi.md#delete_account_tags) | **POST** /management/accounts/{id}/tags/delete | Delete tags for an Account.
*AccountsApi* | [**get_account**](docs/AccountsApi.md#get_account) | **GET** /management/accounts/{id} | Get an Account by id
*AccountsApi* | [**get_account_tags**](docs/AccountsApi.md#get_account_tags) | **GET** /management/accounts/{id}/tags | Get tags for an Account.
*AccountsApi* | [**get_accounts**](docs/AccountsApi.md#get_accounts) | **GET** /management/accounts | Returns a list of Accounts
*AccountsApi* | [**get_password_policies**](docs/AccountsApi.md#get_password_policies) | **GET** /management/accounts/password-policies | Returns the password policies
*AccountsApi* | [**reset_account_password**](docs/AccountsApi.md#reset_account_password) | **POST** /management/accounts/{id}/reset_password | Reset Account Password. 
*AccountsApi* | [**search_accounts**](docs/AccountsApi.md#search_accounts) | **POST** /management/accounts/search | Search for Accounts.
*AccountsApi* | [**update_account**](docs/AccountsApi.md#update_account) | **PUT** /management/accounts/{id} | Update an Account 
*AccountsApi* | [**update_password_policies**](docs/AccountsApi.md#update_password_policies) | **PATCH** /management/accounts/password-policies | Update password policies.
*ApiClientsApi* | [**create_api_client**](docs/ApiClientsApi.md#create_api_client) | **POST** /management/api-clients | Create a new API Client. 
*ApiClientsApi* | [**delete_api_client**](docs/ApiClientsApi.md#delete_api_client) | **DELETE** /management/api-clients/{id} | Delete an API client
*ApiClientsApi* | [**get_api_client**](docs/ApiClientsApi.md#get_api_client) | **GET** /management/api-clients/{id} | Get an API client by id
*ApiClientsApi* | [**get_api_clients**](docs/ApiClientsApi.md#get_api_clients) | **GET** /management/api-clients | Returns a list of API clients.
*ApiClientsApi* | [**update_api_client**](docs/ApiClientsApi.md#update_api_client) | **PUT** /management/api-clients/{id} | Update an Api client. 
*AuthorizationApi* | [**add_access_group_account_ids**](docs/AuthorizationApi.md#add_access_group_account_ids) | **POST** /access-groups/{accessGroupId}/account-ids | Add account ids to an Access group
*AuthorizationApi* | [**add_access_group_account_tags**](docs/AuthorizationApi.md#add_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags | Add account tags to an Access group
*AuthorizationApi* | [**add_access_group_policies**](docs/AuthorizationApi.md#add_access_group_policies) | **POST** /access-groups/{accessGroupId}/policies | Add policies to an Access group
*AuthorizationApi* | [**create_access_group**](docs/AuthorizationApi.md#create_access_group) | **POST** /access-groups | Create a new access group.
*AuthorizationApi* | [**delete_access_group**](docs/AuthorizationApi.md#delete_access_group) | **DELETE** /access-groups/{accessGroupId} | Delete an Access group.
*AuthorizationApi* | [**get_access_group_by_id**](docs/AuthorizationApi.md#get_access_group_by_id) | **GET** /access-groups/{accessGroupId} | Returns an Access group by ID.
*AuthorizationApi* | [**get_access_groups**](docs/AuthorizationApi.md#get_access_groups) | **GET** /access-groups | List all access groups.
*AuthorizationApi* | [**get_role_by_id**](docs/AuthorizationApi.md#get_role_by_id) | **GET** /roles/{roleId} | Returns role by ID.
*AuthorizationApi* | [**get_roles**](docs/AuthorizationApi.md#get_roles) | **GET** /roles | List all roles
*AuthorizationApi* | [**remove_access_group_account_id**](docs/AuthorizationApi.md#remove_access_group_account_id) | **DELETE** /access-groups/{accessGroupId}/account-ids/{accountId} | Remove the account from the access group.
*AuthorizationApi* | [**remove_access_group_account_tags**](docs/AuthorizationApi.md#remove_access_group_account_tags) | **POST** /access-groups/{accessGroupId}/tags/delete | Remove account tags from an access group.
*AuthorizationApi* | [**remove_access_group_policy**](docs/AuthorizationApi.md#remove_access_group_policy) | **DELETE** /access-groups/{accessGroupId}/policies/{policyId} | Remove the policy from the Access group.
*AuthorizationApi* | [**search_access_groups**](docs/AuthorizationApi.md#search_access_groups) | **POST** /access-groups/search | Search for access groups.
*AuthorizationApi* | [**update_access_group**](docs/AuthorizationApi.md#update_access_group) | **PATCH** /access-groups/{accessGroupId} | Update an Access group.
*BookmarksApi* | [**create_bookmark**](docs/BookmarksApi.md#create_bookmark) | **POST** /bookmarks | Create a bookmark at the current time.
*BookmarksApi* | [**create_bookmark_tags**](docs/BookmarksApi.md#create_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags | Create tags for a Bookmark.
*BookmarksApi* | [**delete_bookmark**](docs/BookmarksApi.md#delete_bookmark) | **DELETE** /bookmarks/{bookmarkId} | Delete a bookmark.
*BookmarksApi* | [**delete_bookmark_tags**](docs/BookmarksApi.md#delete_bookmark_tags) | **POST** /bookmarks/{bookmarkId}/tags/delete | Delete tags for a Bookmark.
*BookmarksApi* | [**get_bookmark_by_id**](docs/BookmarksApi.md#get_bookmark_by_id) | **GET** /bookmarks/{bookmarkId} | Get a bookmark by ID.
*BookmarksApi* | [**get_bookmark_tags**](docs/BookmarksApi.md#get_bookmark_tags) | **GET** /bookmarks/{bookmarkId}/tags | Get tags for a Bookmark.
*BookmarksApi* | [**get_bookmarks**](docs/BookmarksApi.md#get_bookmarks) | **GET** /bookmarks | List all bookmarks.
*BookmarksApi* | [**get_vdb_groups_by_bookmark**](docs/BookmarksApi.md#get_vdb_groups_by_bookmark) | **GET** /bookmarks/{bookmarkId}/vdb-groups | List VDB Groups compatible with this bookmark.
*BookmarksApi* | [**search_bookmarks**](docs/BookmarksApi.md#search_bookmarks) | **POST** /bookmarks/search | Search for bookmarks.
*ConnectivityApi* | [**connectivity_check**](docs/ConnectivityApi.md#connectivity_check) | **POST** /connectivity/check | Checks connectivity between an engine and a remote host machine on a given port.
*ConnectorsApi* | [**connectors_test**](docs/ConnectorsApi.md#connectors_test) | **POST** /connectors/{connectorId}/test | Checks connectivity between a masking engine and a remote data source.
*ConnectorsApi* | [**get_connector_by_id**](docs/ConnectorsApi.md#get_connector_by_id) | **GET** /connectors/{connectorId} | Retrieve a masking Connector by ID.
*ConnectorsApi* | [**get_connectors**](docs/ConnectorsApi.md#get_connectors) | **GET** /connectors | Retrieve the list of masking connectors.
*ConnectorsApi* | [**search_connectors**](docs/ConnectorsApi.md#search_connectors) | **POST** /connectors/search | Search for masking Connectors.
*ConnectorsApi* | [**update_connector_by_id**](docs/ConnectorsApi.md#update_connector_by_id) | **PATCH** /connectors/{connectorId} | Update a masking Connector by ID.
*DSourcesApi* | [**create_tags_dsource**](docs/DSourcesApi.md#create_tags_dsource) | **POST** /dsources/{dsourceId}/tags | Create tags for a dSource.
*DSourcesApi* | [**delete_tags_dsource**](docs/DSourcesApi.md#delete_tags_dsource) | **POST** /dsources/{dsourceId}/tags/delete | Delete tags for a dSource.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsource_snapshots**](docs/DSourcesApi.md#get_dsource_snapshots) | **GET** /dsources/{dsourceId}/snapshots | List Snapshots for a dSource.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*DSourcesApi* | [**get_tags_dsource**](docs/DSourcesApi.md#get_tags_dsource) | **GET** /dsources/{dsourceId}/tags | Get tags for a dSource.
*DSourcesApi* | [**search_dsources**](docs/DSourcesApi.md#search_dsources) | **POST** /dsources/search | Search for DSources.
*DSourcesApi* | [**snapshot_dsource**](docs/DSourcesApi.md#snapshot_dsource) | **POST** /dsources/{dsourceId}/snapshots | Snapshot a DSource.
*EnvironmentsApi* | [**create_environment**](docs/EnvironmentsApi.md#create_environment) | **POST** /environments | Create an environment.
*EnvironmentsApi* | [**create_environment_tags**](docs/EnvironmentsApi.md#create_environment_tags) | **POST** /environments/{environmentId}/tags | Create tags for an Environment.
*EnvironmentsApi* | [**create_environment_user**](docs/EnvironmentsApi.md#create_environment_user) | **POST** /environments/{environmentId}/users | Create environment user.
*EnvironmentsApi* | [**delete_environment**](docs/EnvironmentsApi.md#delete_environment) | **DELETE** /environments/{environmentId} | Delete an environment by ID.
*EnvironmentsApi* | [**delete_environment_tags**](docs/EnvironmentsApi.md#delete_environment_tags) | **POST** /environments/{environmentId}/tags/delete | Delete tags for an Environment.
*EnvironmentsApi* | [**delete_environment_user**](docs/EnvironmentsApi.md#delete_environment_user) | **DELETE** /environments/{environmentId}/users/{userRef} | Delete environment user.
*EnvironmentsApi* | [**disable_environment**](docs/EnvironmentsApi.md#disable_environment) | **POST** /environments/{environmentId}/disable | Disable environment.
*EnvironmentsApi* | [**enable_environment**](docs/EnvironmentsApi.md#enable_environment) | **POST** /environments/{environmentId}/enable | Enable a disabled environment.
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /environments/{environmentId} | Returns an environment by ID.
*EnvironmentsApi* | [**get_environments**](docs/EnvironmentsApi.md#get_environments) | **GET** /environments | List all environments.
*EnvironmentsApi* | [**get_tags_environment**](docs/EnvironmentsApi.md#get_tags_environment) | **GET** /environments/{environmentId}/tags | Get tags for an Environment.
*EnvironmentsApi* | [**list_environment_users**](docs/EnvironmentsApi.md#list_environment_users) | **GET** /environments/{environmentId}/users | List environment users.
*EnvironmentsApi* | [**primary_environment_user**](docs/EnvironmentsApi.md#primary_environment_user) | **POST** /environments/{environmentId}/users/{userRef}/primary | Set primary environment user.
*EnvironmentsApi* | [**refresh_environment**](docs/EnvironmentsApi.md#refresh_environment) | **POST** /environments/{environmentId}/refresh | Refresh environment.
*EnvironmentsApi* | [**search_environments**](docs/EnvironmentsApi.md#search_environments) | **POST** /environments/search | Search for environments.
*EnvironmentsApi* | [**update_environment**](docs/EnvironmentsApi.md#update_environment) | **PUT** /environments/{environmentId} | Update an environment by ID.
*EnvironmentsApi* | [**update_environment_user**](docs/EnvironmentsApi.md#update_environment_user) | **PUT** /environments/{environmentId}/users/{userRef} | Update environment user.
*JobsApi* | [**abandon_job**](docs/JobsApi.md#abandon_job) | **POST** /jobs/{jobId}/abandon | Abandons a job.
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /jobs/{jobId} | Returns a job by ID.
*JobsApi* | [**get_jobs**](docs/JobsApi.md#get_jobs) | **GET** /jobs | List all jobs.
*JobsApi* | [**search_jobs**](docs/JobsApi.md#search_jobs) | **POST** /jobs/search | Search for jobs.
*LoginApi* | [**account_login**](docs/LoginApi.md#account_login) | **POST** /login | Login to Account with Username and Password 
*LoginApi* | [**token_info**](docs/LoginApi.md#token_info) | **POST** /token-info | Get Token Information 
*ManagementApi* | [**create_engine_tags**](docs/ManagementApi.md#create_engine_tags) | **POST** /management/engines/{engineId}/tags | Create tags for a engine.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**delete_engine_tags**](docs/ManagementApi.md#delete_engine_tags) | **POST** /management/engines/{engineId}/tags/delete | Delete tags for an Engine.
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**get_engine_tags**](docs/ManagementApi.md#get_engine_tags) | **GET** /management/engines/{engineId}/tags | Get tags for a Engine.
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vaults**](docs/ManagementApi.md#get_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**get_ldap_config**](docs/ManagementApi.md#get_ldap_config) | **GET** /management/ldap-config | Returns the LDAP configuration
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**get_registered_engines**](docs/ManagementApi.md#get_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**get_smtp_config**](docs/ManagementApi.md#get_smtp_config) | **GET** /management/smtp | Returns the SMTP configuration
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**search_engines**](docs/ManagementApi.md#search_engines) | **POST** /management/engines/search | Search for engines.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_ldap_config**](docs/ManagementApi.md#update_ldap_config) | **PUT** /management/ldap-config | Update LDAP Config.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*ManagementApi* | [**update_smtp_config**](docs/ManagementApi.md#update_smtp_config) | **PUT** /management/smtp | Update SMTP Config.
*ManagementApi* | [**validate_ldap_config**](docs/ManagementApi.md#validate_ldap_config) | **POST** /management/ldap-config/validate | Validate LDAP Config.
*ManagementApi* | [**validate_smtp_config**](docs/ManagementApi.md#validate_smtp_config) | **POST** /management/smtp/validate | Validate SMTP Config.
*MaskingJobSetsApi* | [**copy_masking_job**](docs/MaskingJobSetsApi.md#copy_masking_job) | **POST** /masking-job-sets/{maskingJobSetId}/copy | Copies the masking job to another engine.
*MaskingJobSetsApi* | [**create_masking_job_set_tag**](docs/MaskingJobSetsApi.md#create_masking_job_set_tag) | **POST** /masking-job-sets/{maskingJobSetId}/tags | Create tags for a Masking Job Set.
*MaskingJobSetsApi* | [**delete_masking_job_set_tag**](docs/MaskingJobSetsApi.md#delete_masking_job_set_tag) | **POST** /masking-job-sets/{maskingJobSetId}/tags/delete | Delete tags for a Masking Job Set.
*MaskingJobSetsApi* | [**get_masking_job_set_by_id**](docs/MaskingJobSetsApi.md#get_masking_job_set_by_id) | **GET** /masking-job-sets/{maskingJobSetId} | Retrieve a MaskingJobSet by ID.
*MaskingJobSetsApi* | [**get_masking_job_set_connectors**](docs/MaskingJobSetsApi.md#get_masking_job_set_connectors) | **GET** /masking-job-sets/{maskingJobSetId}/connectors | Get connectors for a Masking Job Set for a specific engine.
*MaskingJobSetsApi* | [**get_masking_job_set_tag**](docs/MaskingJobSetsApi.md#get_masking_job_set_tag) | **GET** /masking-job-sets/{maskingJobSetId}/tags | Get tags for a Masking Job Set.
*MaskingJobSetsApi* | [**get_masking_job_sets**](docs/MaskingJobSetsApi.md#get_masking_job_sets) | **GET** /masking-job-sets | Retrieve the list of masking job sets.
*MaskingJobSetsApi* | [**remove_masking_job**](docs/MaskingJobSetsApi.md#remove_masking_job) | **POST** /masking-job-sets/{maskingJobSetId}/remove-job | Removes the masking job from the specified engine.
*MaskingJobSetsApi* | [**search_masking_job_sets**](docs/MaskingJobSetsApi.md#search_masking_job_sets) | **POST** /masking-job-sets/search | Search masking job sets.
*MaskingJobSetsApi* | [**update_masking_job_set_by_id**](docs/MaskingJobSetsApi.md#update_masking_job_set_by_id) | **PATCH** /masking-job-sets/{maskingJobSetId} | Update values of a MaskingJobSet.
*ReportingApi* | [**create_reporting_schedule**](docs/ReportingApi.md#create_reporting_schedule) | **POST** /reporting/schedule | Create a new report schedule.
*ReportingApi* | [**delete_reporting_schedule**](docs/ReportingApi.md#delete_reporting_schedule) | **DELETE** /reporting/schedule/{reportId} | Delete report schedule by ID.
*ReportingApi* | [**get_api_usage_report**](docs/ReportingApi.md#get_api_usage_report) | **GET** /reporting/api-usage-report | Gets the report of API usage metrics over a given time period.
*ReportingApi* | [**get_dsource_usage_report**](docs/ReportingApi.md#get_dsource_usage_report) | **GET** /reporting/dsource-usage-report | Gets the usage report for virtualization engine dSources.
*ReportingApi* | [**get_product_info**](docs/ReportingApi.md#get_product_info) | **GET** /reporting/product_info | Returns the DCT Product Information.
*ReportingApi* | [**get_reporting_schedule_by_id**](docs/ReportingApi.md#get_reporting_schedule_by_id) | **GET** /reporting/schedule/{reportId} | Returns a report schedule by ID.
*ReportingApi* | [**get_reporting_schedules**](docs/ReportingApi.md#get_reporting_schedules) | **GET** /reporting/schedule | List all report schedules.
*ReportingApi* | [**get_vdb_inventory_report**](docs/ReportingApi.md#get_vdb_inventory_report) | **GET** /reporting/vdb-inventory-report | Gets the inventory report for virtualization engine VDBs.
*ReportingApi* | [**get_virtualization_storage_summary_report**](docs/ReportingApi.md#get_virtualization_storage_summary_report) | **GET** /reporting/virtualization-storage-summary-report | Gets the storage summary report for virtualization engines.
*ReportingApi* | [**search_dsource_usage_report**](docs/ReportingApi.md#search_dsource_usage_report) | **POST** /reporting/dsource-usage-report/search | Search the usage report for virtualization engine dSources.
*ReportingApi* | [**search_vdb_inventory_report**](docs/ReportingApi.md#search_vdb_inventory_report) | **POST** /reporting/vdb-inventory-report/search | Search the inventory report for virtualization engine VDBs.
*ReportingApi* | [**search_virtualization_storage_summary_report**](docs/ReportingApi.md#search_virtualization_storage_summary_report) | **POST** /reporting/virtualization-storage-summary-report/search | Search the storage summary report for virtualization engines.
*ReportingApi* | [**update_reporting_schedule**](docs/ReportingApi.md#update_reporting_schedule) | **PUT** /reporting/schedule/{reportId} | Update a reporting schedule by ID.
*SnapshotsApi* | [**get_snapshot_by_id**](docs/SnapshotsApi.md#get_snapshot_by_id) | **GET** /snapshots/{snapshotId} | Get a Snapshot by ID.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*SourcesApi* | [**search_sources**](docs/SourcesApi.md#search_sources) | **POST** /sources/search | Search for Sources.
*TestApi* | [**time_to_update_sources**](docs/TestApi.md#time_to_update_sources) | **POST** /time-to-update-sources | set sources loop count variable - this is being used during performance testing.
*VDBGroupsApi* | [**create_vdb_group**](docs/VDBGroupsApi.md#create_vdb_group) | **POST** /vdb-groups | Create a new VDBGroup.
*VDBGroupsApi* | [**delete_vdb_group**](docs/VDBGroupsApi.md#delete_vdb_group) | **DELETE** /vdb-groups/{vdbGroupId} | Delete a VDBGoup.
*VDBGroupsApi* | [**get_bookmarks_by_vdb_group**](docs/VDBGroupsApi.md#get_bookmarks_by_vdb_group) | **GET** /vdb-groups/{vdbGroupId}/bookmarks | List bookmarks compatible with this VDB Group.
*VDBGroupsApi* | [**get_vdb_group**](docs/VDBGroupsApi.md#get_vdb_group) | **GET** /vdb-groups/{vdbGroupId} | Get a VDBGroup by name.
*VDBGroupsApi* | [**get_vdb_groups**](docs/VDBGroupsApi.md#get_vdb_groups) | **GET** /vdb-groups | List all VDBGroups.
*VDBGroupsApi* | [**provision_vdb_group_from_bookmark**](docs/VDBGroupsApi.md#provision_vdb_group_from_bookmark) | **POST** /vdb-groups/provision_from_bookmark | Provision a new VDB Group from a Bookmark.
*VDBGroupsApi* | [**refresh_vdb_group**](docs/VDBGroupsApi.md#refresh_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/refresh | Refresh a VDBGroup.
*VDBGroupsApi* | [**rollback_vdb_group**](docs/VDBGroupsApi.md#rollback_vdb_group) | **POST** /vdb-groups/{vdbGroupId}/rollback | Rollback a VDBGroup.
*VDBGroupsApi* | [**search_vdb_groups**](docs/VDBGroupsApi.md#search_vdb_groups) | **POST** /vdb-groups/search | Search for VDB Groups.
*VDBGroupsApi* | [**update_vdb_group_by_id**](docs/VDBGroupsApi.md#update_vdb_group_by_id) | **PATCH** /vdb-groups/{vdbGroupId} | Update values of a VDB group.
*VDBsApi* | [**create_vdb_tags**](docs/VDBsApi.md#create_vdb_tags) | **POST** /vdbs/{vdbId}/tags | Create tags for a VDB.
*VDBsApi* | [**delete_vdb**](docs/VDBsApi.md#delete_vdb) | **POST** /vdbs/{vdbId}/delete | Delete a VDB.
*VDBsApi* | [**delete_vdb_tags**](docs/VDBsApi.md#delete_vdb_tags) | **POST** /vdbs/{vdbId}/tags/delete | Delete tags for a VDB.
*VDBsApi* | [**disable_vdb**](docs/VDBsApi.md#disable_vdb) | **POST** /vdbs/{vdbId}/disable | Disable a VDB.
*VDBsApi* | [**enable_vdb**](docs/VDBsApi.md#enable_vdb) | **POST** /vdbs/{vdbId}/enable | Enable a VDB.
*VDBsApi* | [**get_tags_vdb**](docs/VDBsApi.md#get_tags_vdb) | **GET** /vdbs/{vdbId}/tags | Get tags for a VDB.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdb_snapshots**](docs/VDBsApi.md#get_vdb_snapshots) | **GET** /vdbs/{vdbId}/snapshots | List Snapshots for a VDB.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.
*VDBsApi* | [**provision_vdb_by_snapshot**](docs/VDBsApi.md#provision_vdb_by_snapshot) | **POST** /vdbs/provision_by_snapshot | Provision a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_timestamp**](docs/VDBsApi.md#provision_vdb_by_timestamp) | **POST** /vdbs/provision_by_timestamp | Provision a new VDB by timestamp.
*VDBsApi* | [**provision_vdb_from_bookmark**](docs/VDBsApi.md#provision_vdb_from_bookmark) | **POST** /vdbs/provision_from_bookmark | Provision a new VDB from a bookmark with a single VDB.
*VDBsApi* | [**refresh_vdb_by_snapshot**](docs/VDBsApi.md#refresh_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/refresh_by_snapshot | Refresh a VDB by snapshot.
*VDBsApi* | [**refresh_vdb_by_timestamp**](docs/VDBsApi.md#refresh_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/refresh_by_timestamp | Refresh a VDB by timestamp.
*VDBsApi* | [**refresh_vdb_from_bookmark**](docs/VDBsApi.md#refresh_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/refresh_from_bookmark | Refresh a VDB from bookmark with a single VDB.
*VDBsApi* | [**rollback_vdb_by_snapshot**](docs/VDBsApi.md#rollback_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/rollback_by_snapshot | Rollback a VDB by snapshot.
*VDBsApi* | [**rollback_vdb_by_timestamp**](docs/VDBsApi.md#rollback_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/rollback_by_timestamp | Rollback a VDB by timestamp.
*VDBsApi* | [**rollback_vdb_from_bookmark**](docs/VDBsApi.md#rollback_vdb_from_bookmark) | **POST** /vdbs/{vdbId}/rollback_from_bookmark | Rollback a VDB from a bookmark with only the same VDB.
*VDBsApi* | [**search_vdbs**](docs/VDBsApi.md#search_vdbs) | **POST** /vdbs/search | Search for VDBs.
*VDBsApi* | [**snapshot_vdb**](docs/VDBsApi.md#snapshot_vdb) | **POST** /vdbs/{vdbId}/snapshots | Snapshot a VDB.
*VDBsApi* | [**start_vdb**](docs/VDBsApi.md#start_vdb) | **POST** /vdbs/{vdbId}/start | Start a VDB.
*VDBsApi* | [**stop_vdb**](docs/VDBsApi.md#stop_vdb) | **POST** /vdbs/{vdbId}/stop | Stop a VDB.
*VDBsApi* | [**update_vdb_by_id**](docs/VDBsApi.md#update_vdb_by_id) | **PATCH** /vdbs/{vdbId} | Update values of a VDB


## Documentation For Models

 - [AccessGroup](docs/AccessGroup.md)
 - [AccessGroupAccountIdsRequest](docs/AccessGroupAccountIdsRequest.md)
 - [AccessGroupPoliciesRequest](docs/AccessGroupPoliciesRequest.md)
 - [AccessGroupPolicy](docs/AccessGroupPolicy.md)
 - [AccessGroupUpdateParameters](docs/AccessGroupUpdateParameters.md)
 - [Account](docs/Account.md)
 - [AccountCreateParameter](docs/AccountCreateParameter.md)
 - [AccountCreateResponse](docs/AccountCreateResponse.md)
 - [AccountLoginParameter](docs/AccountLoginParameter.md)
 - [AccountUpdateParameter](docs/AccountUpdateParameter.md)
 - [ApiClientCreateParameter](docs/ApiClientCreateParameter.md)
 - [ApiClientCreateResponse](docs/ApiClientCreateResponse.md)
 - [ApiUsageData](docs/ApiUsageData.md)
 - [ApiUsageReportResponse](docs/ApiUsageReportResponse.md)
 - [BaseProvisionVDBParameters](docs/BaseProvisionVDBParameters.md)
 - [BaseProvisionVDBParametersAllOf](docs/BaseProvisionVDBParametersAllOf.md)
 - [Bookmark](docs/Bookmark.md)
 - [ChangePasswordParameter](docs/ChangePasswordParameter.md)
 - [ConnectivityCheckParameters](docs/ConnectivityCheckParameters.md)
 - [ConnectivityCheckResponse](docs/ConnectivityCheckResponse.md)
 - [Connector](docs/Connector.md)
 - [ConnectorTestResponse](docs/ConnectorTestResponse.md)
 - [ConnectorUpdateParameters](docs/ConnectorUpdateParameters.md)
 - [CopyMaskingJobParameters](docs/CopyMaskingJobParameters.md)
 - [CopyMaskingJobResponse](docs/CopyMaskingJobResponse.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [CreateEnvironmentResponse](docs/CreateEnvironmentResponse.md)
 - [CreateEnvironmentUserResponse](docs/CreateEnvironmentUserResponse.md)
 - [CreateVDBGroupRequest](docs/CreateVDBGroupRequest.md)
 - [CreateVDBGroupResponse](docs/CreateVDBGroupResponse.md)
 - [DSource](docs/DSource.md)
 - [DSourceSnapshotParameters](docs/DSourceSnapshotParameters.md)
 - [DSourceUsageData](docs/DSourceUsageData.md)
 - [DSourceUsageReportResponse](docs/DSourceUsageReportResponse.md)
 - [DataPointBySnapshotParameters](docs/DataPointBySnapshotParameters.md)
 - [DataPointByTimestampParameters](docs/DataPointByTimestampParameters.md)
 - [DataPointFromBookmarkParameters](docs/DataPointFromBookmarkParameters.md)
 - [DeleteEngineResponse](docs/DeleteEngineResponse.md)
 - [DeleteEnvironmentResponse](docs/DeleteEnvironmentResponse.md)
 - [DeleteEnvironmentUserResponse](docs/DeleteEnvironmentUserResponse.md)
 - [DeleteTag](docs/DeleteTag.md)
 - [DeleteVDBParameters](docs/DeleteVDBParameters.md)
 - [DeleteVDBResponse](docs/DeleteVDBResponse.md)
 - [DisableEnvironmentResponse](docs/DisableEnvironmentResponse.md)
 - [DisableVDBParameters](docs/DisableVDBParameters.md)
 - [DisableVDBResponse](docs/DisableVDBResponse.md)
 - [Domain](docs/Domain.md)
 - [EnableEnvironmentResponse](docs/EnableEnvironmentResponse.md)
 - [EnableVDBParameters](docs/EnableVDBParameters.md)
 - [EnableVDBResponse](docs/EnableVDBResponse.md)
 - [Engine](docs/Engine.md)
 - [EngineRegistrationParameter](docs/EngineRegistrationParameter.md)
 - [Environment](docs/Environment.md)
 - [EnvironmentCreateParameters](docs/EnvironmentCreateParameters.md)
 - [EnvironmentUpdateParameters](docs/EnvironmentUpdateParameters.md)
 - [EnvironmentUser](docs/EnvironmentUser.md)
 - [EnvironmentUserParams](docs/EnvironmentUserParams.md)
 - [Error](docs/Error.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [Hook](docs/Hook.md)
 - [Host](docs/Host.md)
 - [Job](docs/Job.md)
 - [LDAPConfigParams](docs/LDAPConfigParams.md)
 - [ListAccessGroupsResponse](docs/ListAccessGroupsResponse.md)
 - [ListAccountsResponse](docs/ListAccountsResponse.md)
 - [ListApiClientsResponse](docs/ListApiClientsResponse.md)
 - [ListBookmarksByVDBGroupsResponse](docs/ListBookmarksByVDBGroupsResponse.md)
 - [ListBookmarksResponse](docs/ListBookmarksResponse.md)
 - [ListConnectorsResponse](docs/ListConnectorsResponse.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListEnvironmentUsers](docs/ListEnvironmentUsers.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListHashicorpVaultsResponse](docs/ListHashicorpVaultsResponse.md)
 - [ListJobsResponse](docs/ListJobsResponse.md)
 - [ListMaskingJobSetsResponse](docs/ListMaskingJobSetsResponse.md)
 - [ListRegisteredEnginesResponse](docs/ListRegisteredEnginesResponse.md)
 - [ListReportingScheduleResponse](docs/ListReportingScheduleResponse.md)
 - [ListRolesResponse](docs/ListRolesResponse.md)
 - [ListSnapshotsResponse](docs/ListSnapshotsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListVDBGroupsByBookmarkResponse](docs/ListVDBGroupsByBookmarkResponse.md)
 - [ListVDBGroupsResponse](docs/ListVDBGroupsResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [LoginToken](docs/LoginToken.md)
 - [MaskingJob](docs/MaskingJob.md)
 - [MaskingJobSet](docs/MaskingJobSet.md)
 - [MaskingJobSetConnectorsResponse](docs/MaskingJobSetConnectorsResponse.md)
 - [MaskingRuleset](docs/MaskingRuleset.md)
 - [ModelApiClient](docs/ModelApiClient.md)
 - [OracleRacCustomEnvFile](docs/OracleRacCustomEnvFile.md)
 - [OracleRacCustomEnvVar](docs/OracleRacCustomEnvVar.md)
 - [PaginatedResponseMetadata](docs/PaginatedResponseMetadata.md)
 - [PasswordPoliciesParams](docs/PasswordPoliciesParams.md)
 - [PrimaryEnvironmentUserResponse](docs/PrimaryEnvironmentUserResponse.md)
 - [ProductHistory](docs/ProductHistory.md)
 - [ProductInfo](docs/ProductInfo.md)
 - [ProvisionVDBBySnapshotParameters](docs/ProvisionVDBBySnapshotParameters.md)
 - [ProvisionVDBBySnapshotParametersAllOf](docs/ProvisionVDBBySnapshotParametersAllOf.md)
 - [ProvisionVDBByTimestampParameters](docs/ProvisionVDBByTimestampParameters.md)
 - [ProvisionVDBByTimestampParametersAllOf](docs/ProvisionVDBByTimestampParametersAllOf.md)
 - [ProvisionVDBFromBookmarkParameters](docs/ProvisionVDBFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkParameters](docs/ProvisionVDBGroupFromBookmarkParameters.md)
 - [ProvisionVDBGroupFromBookmarkResponse](docs/ProvisionVDBGroupFromBookmarkResponse.md)
 - [ProvisionVDBResponse](docs/ProvisionVDBResponse.md)
 - [RefreshEnvironmentResponse](docs/RefreshEnvironmentResponse.md)
 - [RefreshVDBBySnapshotParameters](docs/RefreshVDBBySnapshotParameters.md)
 - [RefreshVDBBySnapshotResponse](docs/RefreshVDBBySnapshotResponse.md)
 - [RefreshVDBByTimestampParameters](docs/RefreshVDBByTimestampParameters.md)
 - [RefreshVDBByTimestampParametersAllOf](docs/RefreshVDBByTimestampParametersAllOf.md)
 - [RefreshVDBByTimestampResponse](docs/RefreshVDBByTimestampResponse.md)
 - [RefreshVDBFromBookmarkParameters](docs/RefreshVDBFromBookmarkParameters.md)
 - [RefreshVDBFromBookmarkResponse](docs/RefreshVDBFromBookmarkResponse.md)
 - [RefreshVDBGroupParameters](docs/RefreshVDBGroupParameters.md)
 - [RefreshVDBGroupResponse](docs/RefreshVDBGroupResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [RemoveMaskingJobParameters](docs/RemoveMaskingJobParameters.md)
 - [RemoveMaskingJobResponse](docs/RemoveMaskingJobResponse.md)
 - [ReportingSchedule](docs/ReportingSchedule.md)
 - [Repository](docs/Repository.md)
 - [ResetPasswordParameter](docs/ResetPasswordParameter.md)
 - [Role](docs/Role.md)
 - [RollbackVDBBySnapshotParameters](docs/RollbackVDBBySnapshotParameters.md)
 - [RollbackVDBBySnapshotResponse](docs/RollbackVDBBySnapshotResponse.md)
 - [RollbackVDBByTimestampParameters](docs/RollbackVDBByTimestampParameters.md)
 - [RollbackVDBByTimestampResponse](docs/RollbackVDBByTimestampResponse.md)
 - [RollbackVDBFromBookmarkParameters](docs/RollbackVDBFromBookmarkParameters.md)
 - [RollbackVDBFromBookmarkResponse](docs/RollbackVDBFromBookmarkResponse.md)
 - [RollbackVDBGroupParameters](docs/RollbackVDBGroupParameters.md)
 - [RollbackVDBGroupResponse](docs/RollbackVDBGroupResponse.md)
 - [SMTPConfigParams](docs/SMTPConfigParams.md)
 - [SMTPConfigValidate](docs/SMTPConfigValidate.md)
 - [SearchAccessGroupsResponse](docs/SearchAccessGroupsResponse.md)
 - [SearchAccountsResponse](docs/SearchAccountsResponse.md)
 - [SearchBody](docs/SearchBody.md)
 - [SearchBookmarksResponse](docs/SearchBookmarksResponse.md)
 - [SearchConnectorsResponse](docs/SearchConnectorsResponse.md)
 - [SearchDSourcesResponse](docs/SearchDSourcesResponse.md)
 - [SearchEnginesResponse](docs/SearchEnginesResponse.md)
 - [SearchEnvironmentsResponse](docs/SearchEnvironmentsResponse.md)
 - [SearchJobsResponse](docs/SearchJobsResponse.md)
 - [SearchMaskingJobSetsResponse](docs/SearchMaskingJobSetsResponse.md)
 - [SearchSourcesResponse](docs/SearchSourcesResponse.md)
 - [SearchVDBGroupResponse](docs/SearchVDBGroupResponse.md)
 - [SearchVDBsResponse](docs/SearchVDBsResponse.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotDSourceResponse](docs/SnapshotDSourceResponse.md)
 - [SnapshotVDBResponse](docs/SnapshotVDBResponse.md)
 - [Source](docs/Source.md)
 - [StartVDBResponse](docs/StartVDBResponse.md)
 - [StopVDBResponse](docs/StopVDBResponse.md)
 - [Tag](docs/Tag.md)
 - [TagsRequest](docs/TagsRequest.md)
 - [TagsResponse](docs/TagsResponse.md)
 - [TimeToUpdateSourcesRequest](docs/TimeToUpdateSourcesRequest.md)
 - [TimeToUpdateSourcesResponse](docs/TimeToUpdateSourcesResponse.md)
 - [TokenInfoRequest](docs/TokenInfoRequest.md)
 - [TokenInfoResponse](docs/TokenInfoResponse.md)
 - [UpdateConnectorResponse](docs/UpdateConnectorResponse.md)
 - [UpdateEnvironmentResponse](docs/UpdateEnvironmentResponse.md)
 - [UpdateEnvironmentUserResponse](docs/UpdateEnvironmentUserResponse.md)
 - [UpdateMaskingJobSetParameters](docs/UpdateMaskingJobSetParameters.md)
 - [UpdateVDBGroupParameters](docs/UpdateVDBGroupParameters.md)
 - [UpdateVDBParameters](docs/UpdateVDBParameters.md)
 - [UpdateVDBResponse](docs/UpdateVDBResponse.md)
 - [VDB](docs/VDB.md)
 - [VDBGroup](docs/VDBGroup.md)
 - [VDBInventoryData](docs/VDBInventoryData.md)
 - [VDBInventoryReportResponse](docs/VDBInventoryReportResponse.md)
 - [VirtualDatasetHooks](docs/VirtualDatasetHooks.md)
 - [VirtualizationStorageSummaryData](docs/VirtualizationStorageSummaryData.md)
 - [VirtualizationStorageSummaryReportResponse](docs/VirtualizationStorageSummaryReportResponse.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

