/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils.graph;

import java.util.Objects;

public class Edge<V, E> {
    public final E label;
    public final V source;
    public final V target;

    public Edge(V src, E lbl, V trgt) {
        this.label = lbl;
        this.source = src;
        this.target = trgt;
    }

    public Edge<V, E> reverse() {
        return new Edge<V, E>(this.target, this.label, this.source);
    }

    public String toString() {
        String trg;
        String src = this.source == null ? "NULL" : this.source.toString();
        String string = trg = this.target == null ? "NULL" : this.target.toString();
        if (this.label == null || this.label.toString().trim().isEmpty()) {
            return String.format("%s --> %s", src, trg);
        }
        return String.format("%s --(%s)-> %s", src, this.label.toString(), trg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.source, other.source) && Objects.equals(this.target, other.target);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Objects.hashCode(this.label);
        hash = 53 * hash + Objects.hashCode(this.source);
        hash = 53 * hash + Objects.hashCode(this.target);
        return hash;
    }
}

