/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.utils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;

public class FileUtils {
    public static String[] listFilesWithSuffix(String dirPath, String suffix) {
        return FileUtils.listFilesWithSuffix(new File[]{new File(dirPath)}, suffix);
    }

    public static String[] listFilesWithSuffix(String[] args, String suffix) {
        ArrayList<File> files = new ArrayList<File>();
        for (String arg : args) {
            if (arg.contains("*")) {
                File[] matches;
                File dir = new File(System.getProperty("user.dir"));
                for (File file : matches = dir.listFiles(new WildcardFilter(arg))) {
                    if (!file.getName().endsWith(suffix)) continue;
                    files.add(file);
                }
                continue;
            }
            files.add(new File(arg));
        }
        return FileUtils.listFilesWithSuffix(files.toArray(new File[files.size()]), suffix);
    }

    public static String[] listFilesWithSuffix(File[] argFiles, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : argFiles) {
            if (file.isDirectory()) {
                list.addAll(Arrays.asList(FileUtils.listFilesWithSuffix(file.listFiles(), suffix)));
                continue;
            }
            if (!file.exists() || !file.getName().endsWith(suffix)) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }

    static class WildcardFilter
    implements FileFilter {
        private final String regex;

        public WildcardFilter(String wildcard) {
            this.regex = ".*" + wildcard.replaceAll("\\*", ".*");
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getPath().matches(this.regex);
        }
    }
}

