/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.dependence.pdg;

import codeintelligence.codeanalysis.extractors.dependence.pdg.JavaField;
import codeintelligence.codeanalysis.extractors.dependence.pdg.JavaMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class JavaClass {
    public final String NAME;
    public final String PACKAGE;
    public final String EXTENDS;
    public final String[] IMPORTS;
    private String typeParameters;
    private String[] implementations;
    private ArrayList<JavaField> fields;
    private ArrayList<JavaMethod> methods;

    public JavaClass(String name, String pkg, String extend, String[] imports) {
        this.NAME = name;
        this.PACKAGE = pkg;
        this.EXTENDS = extend;
        this.IMPORTS = imports;
        this.implementations = null;
        this.fields = new ArrayList();
        this.methods = new ArrayList();
    }

    public void setTypeParameters(String params) {
        this.typeParameters = params;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public void addField(JavaField field) {
        this.fields.add(field);
    }

    public boolean hasField(String name) {
        for (JavaField fld : this.fields) {
            if (!fld.NAME.equals(name)) continue;
            return true;
        }
        return false;
    }

    public JavaField[] getAllFields() {
        return this.fields.toArray(new JavaField[this.fields.size()]);
    }

    public void addMethod(JavaMethod mtd) {
        this.methods.add(mtd);
    }

    public boolean hasMethod(String name) {
        for (JavaMethod mtd : this.methods) {
            if (!mtd.NAME.equals(name)) continue;
            return true;
        }
        return false;
    }

    public JavaMethod[] getAllMethods() {
        return this.methods.toArray(new JavaMethod[this.methods.size()]);
    }

    public void setInterfaces(String[] intfs) {
        this.implementations = intfs;
    }

    public String[] getInterfaces() {
        return this.implementations;
    }

    public String toString() {
        String extend = this.EXTENDS == null ? "null" : this.EXTENDS;
        StringBuilder str = new StringBuilder("CLASS \n{\n");
        str.append("  NAME : \"").append(this.NAME).append("\",\n");
        str.append("  PACKAGE : \"").append(this.PACKAGE).append("\",\n");
        str.append("  EXTENDS : \"").append(extend).append("\",\n");
        str.append("  IMPLEMENTS : ").append(Arrays.toString(this.implementations)).append(",\n");
        str.append("  FIELDS : \n  [\n");
        for (JavaField fld : this.fields) {
            str.append("    ").append(fld).append(",\n");
        }
        str.append("  ],\n");
        str.append("  METHODS : \n  [\n");
        for (JavaMethod mtd : this.methods) {
            str.append("    ").append(mtd).append(",\n");
        }
        str.append("  ],\n");
        str.append("  IMPORTS : \n  [\n");
        for (Iterator<Object> iterator : this.IMPORTS) {
            str.append("    \"").append((String)((Object)iterator)).append("\",\n");
        }
        str.append("  ]\n");
        str.append("}");
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaClass)) {
            return false;
        }
        JavaClass cls = (JavaClass)obj;
        return this.NAME.equals(cls.NAME) && this.PACKAGE.equals(cls.PACKAGE);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + Objects.hashCode(this.NAME);
        hash = 11 * hash + Objects.hashCode(this.PACKAGE);
        return hash;
    }
}

