/*
 * Decompiled with CFR 0.152.
 */
package codeintelligence.codeanalysis.extractors.dependence.cfg;

import codeintelligence.codeanalysis.extractors.AbstractProgramGraph;
import codeintelligence.codeanalysis.extractors.dependence.DEPNode;
import codeintelligence.codeanalysis.extractors.dependence.cfg.CFEdge;
import codeintelligence.codeanalysis.utils.Logger;
import codeintelligence.codeanalysis.utils.StringUtils;
import codeintelligence.codeanalysis.utils.graph.Edge;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlFlowGraph
extends AbstractProgramGraph<DEPNode, CFEdge> {
    private String name;
    private DEPNode entry;

    public ControlFlowGraph(String name) {
        this.name = name;
        this.entry = null;
        this.properties.put("label", "CFG");
        this.properties.put("type", "Control Flow Graph (CFG)");
    }

    public String getName() {
        return this.name;
    }

    public void setEntry(DEPNode entry) {
        this.entry = entry;
    }

    public DEPNode getEntry() {
        return this.entry;
    }

    @Override
    public void exportDOT(String filepath) throws FileNotFoundException {
        try (PrintWriter dot = new PrintWriter(filepath, "UTF-8");){
            dot.println("digraph CFG {");
            dot.println("  // graph-vertices");
            LinkedHashMap<DEPNode, CallSite> nodeNames = new LinkedHashMap<DEPNode, CallSite>();
            int nodeCounter = 1;
            for (DEPNode node : this.allVertices) {
                String name = "v" + nodeCounter++;
                nodeNames.put(node, (CallSite)((Object)name));
                StringBuilder label = new StringBuilder("  [label=\"");
                if (node.getLineOfCode() > 0) {
                    label.append(node.getLineOfCode()).append(":  ");
                }
                label.append(StringUtils.escape(node.getCode())).append("\"];");
                dot.println("  " + name + label.toString());
            }
            dot.println("  // graph-edges");
            for (Edge edge : this.allEdges) {
                String src = (String)nodeNames.get(edge.source);
                String trg = (String)nodeNames.get(edge.target);
                if (((CFEdge)edge.label).getLabel().equals("")) {
                    dot.println("  " + src + " -> " + trg + ";");
                    continue;
                }
                dot.println("  " + src + " -> " + trg + "  [label=\"" + ((CFEdge)edge.label).getLabel() + "\"];");
            }
            dot.println("  // end-of-graph\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("CFG exported to: " + filepath);
    }

    @Override
    public void exportJSON(String filepath) throws FileNotFoundException {
        try (PrintWriter json = new PrintWriter(filepath, "UTF-8");){
            json.println("{\n  \"directed\": true,");
            json.println("  \"multigraph\": true,");
            block13: for (Map.Entry property : this.properties.entrySet()) {
                switch ((String)property.getKey()) {
                    case "directed": {
                        continue block13;
                    }
                }
                json.println("  \"" + (String)property.getKey() + "\": \"" + (String)property.getValue() + "\",");
            }
            json.println("  \"nodes\": [");
            LinkedHashMap<DEPNode, Integer> nodeIDs = new LinkedHashMap<DEPNode, Integer>();
            int nodeCounter = 0;
            for (DEPNode node : this.allVertices) {
                json.println("    {");
                json.println("      \"id\": " + nodeCounter + ",");
                json.println("      \"line\": " + node.getLineOfCode() + ",");
                json.println("      \"label\": \"" + StringUtils.escape(node.getCode()) + "\"");
                nodeIDs.put(node, nodeCounter);
                if (++nodeCounter == this.allVertices.size()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ],\n\n  \"edges\": [");
            int edgeCounter = 0;
            for (Edge edge : this.allEdges) {
                json.println("    {");
                json.println("      \"id\": " + edgeCounter + ",");
                json.println("      \"source\": " + nodeIDs.get(edge.source) + ",");
                json.println("      \"target\": " + nodeIDs.get(edge.target) + ",");
                json.println("      \"label\": \"" + ((CFEdge)edge.label).getLabel() + "\"");
                if (++edgeCounter == this.allEdges.size()) {
                    json.println("    }");
                    continue;
                }
                json.println("    },");
            }
            json.println("  ]\n}");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.error(ex);
        }
        Logger.info("CFG exported to: " + filepath);
    }
}

