# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.speechs = SpeechService(self)
        



class SpeechService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def file_recognize(self, body, tenant_key=None, timeout=None):
        # type: (SpeechFileRecognizeReqBody, str, int) -> SpeechFileRecognizeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return SpeechFileRecognizeReqCall(self, body, request_opts=request_opts)

    def stream_recognize(self, body, tenant_key=None, timeout=None):
        # type: (SpeechStreamRecognizeReqBody, str, int) -> SpeechStreamRecognizeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return SpeechStreamRecognizeReqCall(self, body, request_opts=request_opts)



class SpeechFileRecognizeReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpeechService, SpeechFileRecognizeReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[SpeechFileRecognizeResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/speech_to_text/v1/speech/file_recognize', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=SpeechFileRecognizeResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SpeechStreamRecognizeReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SpeechService, SpeechStreamRecognizeReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[SpeechStreamRecognizeResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('/open-apis/speech_to_text/v1/speech/stream_recognize', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=SpeechStreamRecognizeResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

