# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import List, Dict, Any
from ....utils.dt import to_json_decorator
import attr




@to_json_decorator
@attr.s
class AuditWebContext(object):
    user_agent = attr.ib(type=str, default=None, metadata={'json': 'user_agent'})
    i_p = attr.ib(type=str, default=None, metadata={'json': 'IP'})


@to_json_decorator
@attr.s
class AuditRecipientDetail(object):
    permission_action_type = attr.ib(type=str, default=None, metadata={'json': 'permission_action_type'})


@to_json_decorator
@attr.s
class AuditRecipientEntity(object):
    recipient_type = attr.ib(type=str, default=None, metadata={'json': 'recipient_type'})
    recipient_value = attr.ib(type=str, default=None, metadata={'json': 'recipient_value'})
    recipient_detail = attr.ib(type=AuditRecipientDetail, default=None, metadata={'json': 'recipient_detail'})


@to_json_decorator
@attr.s
class AuditPcContext(object):
    udid = attr.ib(type=str, default=None, metadata={'json': 'udid'})
    did = attr.ib(type=str, default=None, metadata={'json': 'did'})
    app_ver = attr.ib(type=str, default=None, metadata={'json': 'app_ver'})
    ver = attr.ib(type=str, default=None, metadata={'json': 'ver'})
    os = attr.ib(type=str, default=None, metadata={'json': 'os'})
    wifip = attr.ib(type=str, default=None, metadata={'json': 'wifip'})
    region = attr.ib(type=str, default=None, metadata={'json': 'region'})
    i_p = attr.ib(type=str, default=None, metadata={'json': 'IP'})


@to_json_decorator
@attr.s
class AuditObjectDetail(object):
    clone_source = attr.ib(type=str, default=None, metadata={'json': 'clone_source'})
    text_detail = attr.ib(type=str, default=None, metadata={'json': 'text_detail'})
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    third_party_app_i_d = attr.ib(type=str, default=None, metadata={'json': 'third_party_appID'})
    contain_file_num = attr.ib(type=int, default=None, metadata={'json': 'contain_file_num'})
    permission_setting_type = attr.ib(type=str, default=None, metadata={'json': 'permission_setting_type'})
    permission_external_access__type = attr.ib(type=bool, default=None, metadata={'json': 'permission_external_access_Type'})
    permission_share_type = attr.ib(type=str, default=None, metadata={'json': 'permission_share_type'})
    file_service_source = attr.ib(type=str, default=None, metadata={'json': 'file_service_source'})
    okr_download_content = attr.ib(type=str, default=None, metadata={'json': 'okr_download_content'})


@to_json_decorator
@attr.s
class AuditObjectEntity(object):
    object_type = attr.ib(type=str, default=None, metadata={'json': 'object_type'})
    object_value = attr.ib(type=str, default=None, metadata={'json': 'object_value'})
    object_name = attr.ib(type=str, default=None, metadata={'json': 'object_name'})
    object_owner = attr.ib(type=str, default=None, metadata={'json': 'object_owner'})
    object_detail = attr.ib(type=AuditObjectDetail, default=None, metadata={'json': 'object_detail'})


@to_json_decorator
@attr.s
class AuditIosContext(object):
    udid = attr.ib(type=str, default=None, metadata={'json': 'udid'})
    did = attr.ib(type=str, default=None, metadata={'json': 'did'})
    app_ver = attr.ib(type=str, default=None, metadata={'json': 'app_ver'})
    ver = attr.ib(type=str, default=None, metadata={'json': 'ver'})
    os = attr.ib(type=str, default=None, metadata={'json': 'os'})
    s_t_zone = attr.ib(type=str, default=None, metadata={'json': 'STZone'})
    m_l = attr.ib(type=str, default=None, metadata={'json': 'ML'})
    sjd = attr.ib(type=str, default=None, metadata={'json': 'sjd'})
    proxyip = attr.ib(type=str, default=None, metadata={'json': 'proxyip'})
    wifip = attr.ib(type=str, default=None, metadata={'json': 'wifip'})
    location = attr.ib(type=str, default=None, metadata={'json': 'location'})
    active_ip = attr.ib(type=str, default=None, metadata={'json': 'active_ip'})
    active_ip_detail = attr.ib(type=str, default=None, metadata={'json': 'active_ip_detail'})
    cell_base_station = attr.ib(type=str, default=None, metadata={'json': 'cell_base_station'})
    i_p = attr.ib(type=str, default=None, metadata={'json': 'IP'})


@to_json_decorator
@attr.s
class AuditEventExtend(object):
    comment_type = attr.ib(type=str, default=None, metadata={'json': 'comment_type'})
    app_detail = attr.ib(type=str, default=None, metadata={'json': 'app_detail'})
    two_step_validation = attr.ib(type=bool, default=None, metadata={'json': 'two_step_validation'})
    login_method = attr.ib(type=str, default=None, metadata={'json': 'login_method'})
    new_people_num_in_video = attr.ib(type=int, default=None, metadata={'json': 'new_people_num_in_video'})
    external_people_num_in_video = attr.ib(type=int, default=None, metadata={'json': 'external_people_num_in_video'})
    external_people_num_in_chat = attr.ib(type=int, default=None, metadata={'json': 'external_people_num_in_chat'})
    join_group = attr.ib(type=int, default=None, metadata={'json': 'join_group'})
    quit_group = attr.ib(type=int, default=None, metadata={'json': 'quit_group'})
    external_people_num_in_doc_share = attr.ib(type=int, default=None, metadata={'json': 'external_people_num_in_doc_share'})


@to_json_decorator
@attr.s
class AuditAndroidContext(object):
    udid = attr.ib(type=str, default=None, metadata={'json': 'udid'})
    did = attr.ib(type=str, default=None, metadata={'json': 'did'})
    app_ver = attr.ib(type=str, default=None, metadata={'json': 'app_ver'})
    ver = attr.ib(type=str, default=None, metadata={'json': 'ver'})
    region = attr.ib(type=str, default=None, metadata={'json': 'region'})
    id_i = attr.ib(type=str, default=None, metadata={'json': 'id_i'})
    id_r = attr.ib(type=str, default=None, metadata={'json': 'id_r'})
    hw_brand = attr.ib(type=str, default=None, metadata={'json': 'hw_brand'})
    hw_manuf = attr.ib(type=str, default=None, metadata={'json': 'hw_manuf'})
    wifip = attr.ib(type=str, default=None, metadata={'json': 'wifip'})
    route_iip = attr.ib(type=str, default=None, metadata={'json': 'route_iip'})
    route_gip = attr.ib(type=str, default=None, metadata={'json': 'route_gip'})
    env_su = attr.ib(type=str, default=None, metadata={'json': 'env_su'})
    env_tz = attr.ib(type=str, default=None, metadata={'json': 'env_tz'})
    env_ml = attr.ib(type=str, default=None, metadata={'json': 'env_ml'})
    location = attr.ib(type=str, default=None, metadata={'json': 'location'})
    active_ip = attr.ib(type=str, default=None, metadata={'json': 'active_ip'})
    active_ip_detail = attr.ib(type=str, default=None, metadata={'json': 'active_ip_detail'})
    cell_base_station = attr.ib(type=str, default=None, metadata={'json': 'cell_base_station'})
    i_p = attr.ib(type=str, default=None, metadata={'json': 'IP'})


@to_json_decorator
@attr.s
class AuditContext(object):
    terminal_type = attr.ib(type=int, default=None, metadata={'json': 'terminal_type'})
    ios_context = attr.ib(type=AuditIosContext, default=None, metadata={'json': 'ios_context'})
    pc_context = attr.ib(type=AuditPcContext, default=None, metadata={'json': 'pc_context'})
    web_context = attr.ib(type=AuditWebContext, default=None, metadata={'json': 'web_context'})
    android_context = attr.ib(type=AuditAndroidContext, default=None, metadata={'json': 'android_context'})


@to_json_decorator
@attr.s
class AuditInfo(object):
    event_id = attr.ib(type=str, default=None, metadata={'json': 'event_id'})
    event_name = attr.ib(type=str, default=None, metadata={'json': 'event_name'})
    department_ids = attr.ib(type=List[str], default=None, metadata={'json': 'department_ids'})
    event_module = attr.ib(type=int, default=None, metadata={'json': 'event_module'})
    operator_type = attr.ib(type=int, default=None, metadata={'json': 'operator_type'})
    operator_value = attr.ib(type=str, default=None, metadata={'json': 'operator_value'})
    objects = attr.ib(type=List[AuditObjectEntity], default=None, metadata={'json': 'objects'})
    recipients = attr.ib(type=List[AuditRecipientEntity], default=None, metadata={'json': 'recipients'})
    event_time = attr.ib(type=int, default=None, metadata={'json': 'event_time'})
    ip = attr.ib(type=str, default=None, metadata={'json': 'ip'})
    operator_app = attr.ib(type=str, default=None, metadata={'json': 'operator_app'})
    audit_context = attr.ib(type=AuditContext, default=None, metadata={'json': 'audit_context'})
    extend = attr.ib(type=AuditEventExtend, default=None, metadata={'json': 'extend'})
    operator_app_name = attr.ib(type=str, default=None, metadata={'json': 'operator_app_name'})


@to_json_decorator
@attr.s
class AdminDeptStat(object):
    date = attr.ib(type=str, default=None, metadata={'json': 'date'})
    department_id = attr.ib(type=str, default=None, metadata={'json': 'department_id'})
    department_name = attr.ib(type=str, default=None, metadata={'json': 'department_name'})
    department_path = attr.ib(type=str, default=None, metadata={'json': 'department_path'})
    total_user_num = attr.ib(type=int, default=None, metadata={'json': 'total_user_num'})
    active_user_num = attr.ib(type=int, default=None, metadata={'json': 'active_user_num'})
    active_user_rate = attr.ib(type=str, default=None, metadata={'json': 'active_user_rate'})
    suite_dau = attr.ib(type=int, default=None, metadata={'json': 'suite_dau'})
    suite_active_rate = attr.ib(type=str, default=None, metadata={'json': 'suite_active_rate'})
    new_user_num = attr.ib(type=int, default=None, metadata={'json': 'new_user_num'})
    new_active_num = attr.ib(type=int, default=None, metadata={'json': 'new_active_num'})
    resign_user_num = attr.ib(type=int, default=None, metadata={'json': 'resign_user_num'})
    im_dau = attr.ib(type=int, default=None, metadata={'json': 'im_dau'})
    send_messenger_user_num = attr.ib(type=int, default=None, metadata={'json': 'send_messenger_user_num'})
    send_messenger_num = attr.ib(type=int, default=None, metadata={'json': 'send_messenger_num'})
    avg_send_messenger_num = attr.ib(type=str, default=None, metadata={'json': 'avg_send_messenger_num'})
    docs_dau = attr.ib(type=int, default=None, metadata={'json': 'docs_dau'})
    create_docs_user_num = attr.ib(type=int, default=None, metadata={'json': 'create_docs_user_num'})
    create_docs_num = attr.ib(type=int, default=None, metadata={'json': 'create_docs_num'})
    avg_create_docs_num = attr.ib(type=str, default=None, metadata={'json': 'avg_create_docs_num'})
    cal_dau = attr.ib(type=int, default=None, metadata={'json': 'cal_dau'})
    create_cal_user_num = attr.ib(type=int, default=None, metadata={'json': 'create_cal_user_num'})
    create_cal_num = attr.ib(type=int, default=None, metadata={'json': 'create_cal_num'})
    avg_create_cal_num = attr.ib(type=str, default=None, metadata={'json': 'avg_create_cal_num'})
    vc_dau = attr.ib(type=int, default=None, metadata={'json': 'vc_dau'})
    vc_duration = attr.ib(type=int, default=None, metadata={'json': 'vc_duration'})
    avg_vc_duration = attr.ib(type=str, default=None, metadata={'json': 'avg_vc_duration'})


@to_json_decorator
@attr.s
class AdminUserStat(object):
    date = attr.ib(type=str, default=None, metadata={'json': 'date'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    user_name = attr.ib(type=str, default=None, metadata={'json': 'user_name'})
    department_name = attr.ib(type=str, default=None, metadata={'json': 'department_name'})
    department_path = attr.ib(type=str, default=None, metadata={'json': 'department_path'})
    create_time = attr.ib(type=str, default=None, metadata={'json': 'create_time'})
    user_active_flag = attr.ib(type=int, default=None, metadata={'json': 'user_active_flag'})
    register_time = attr.ib(type=str, default=None, metadata={'json': 'register_time'})
    suite_active_flag = attr.ib(type=int, default=None, metadata={'json': 'suite_active_flag'})
    last_active_time = attr.ib(type=str, default=None, metadata={'json': 'last_active_time'})
    im_active_flag = attr.ib(type=int, default=None, metadata={'json': 'im_active_flag'})
    send_messenger_num = attr.ib(type=int, default=None, metadata={'json': 'send_messenger_num'})
    docs_active_flag = attr.ib(type=int, default=None, metadata={'json': 'docs_active_flag'})
    create_docs_num = attr.ib(type=int, default=None, metadata={'json': 'create_docs_num'})
    cal_active_flag = attr.ib(type=int, default=None, metadata={'json': 'cal_active_flag'})
    create_cal_num = attr.ib(type=int, default=None, metadata={'json': 'create_cal_num'})
    vc_active_flag = attr.ib(type=int, default=None, metadata={'json': 'vc_active_flag'})
    vc_duration = attr.ib(type=int, default=None, metadata={'json': 'vc_duration'})
    active_os = attr.ib(type=str, default=None, metadata={'json': 'active_os'})


@to_json_decorator
@attr.s
class SplashPageStat(object):
    date = attr.ib(type=str, default=None, metadata={'json': 'date'})
    splash_id = attr.ib(type=str, default=None, metadata={'json': 'splash_id'})
    impression_count = attr.ib(type=int, default=None, metadata={'json': 'impression_count'})
    click_count = attr.ib(type=int, default=None, metadata={'json': 'click_count'})
    skip_count = attr.ib(type=int, default=None, metadata={'json': 'skip_count'})
    impression_count_accumulate = attr.ib(type=int, default=None, metadata={'json': 'impression_count_accumulate'})
    click_count_accumulate = attr.ib(type=int, default=None, metadata={'json': 'click_count_accumulate'})
    skip_count_accumulate = attr.ib(type=int, default=None, metadata={'json': 'skip_count_accumulate'})




@attr.s
class AdminDeptStatListResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[AdminDeptStat], default=None, metadata={'json': 'items'})



@attr.s
class AdminUserStatListResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[AdminUserStat], default=None, metadata={'json': 'items'})