[![Logo](./docs/source/_static/logo_blank_small.png)]()

[![License: GPL v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://github.com/EpistasisLab/pennai/blob/master/LICENSE) [![Master Build Status - Mac/Linux](https://travis-ci.org/EpistasisLab/pennai.svg?branch=master)](https://travis-ci.org/EpistasisLab/pennai)

PennAI: AI-Driven Data Science
==================================

**PennAI** is an easy-to-use data science assistant.
It allows researchers without machine learning or coding expertise to run supervised machine learning analysis through a clean web interface. 
It provides results visualization and reproducible scripts so that the analysis can be taken anywhere. 
And, it has an *AI* assistant that can choose the analysis to run for you.   Dataset profiles are generated and added to a knowledgebase as experiments are run, and the AI assistant learns from this to give more informed recommendations as it is used.   PennAI comes with an initial knowledgebase generated from the [PMLB benchmark suite](https://github.com/EpistasisLab/penn-ml-benchmarks).

[**Documentation**](https://epistasislab.github.io/pennai/) 

[**Latest Production Release**](https://github.com/EpistasisLab/pennai/releases/latest)

Browse the repo:
 - [User Guide](./docs/guides/userGuide.md)
 - [Developer Guide](./docs/guides/developerGuide.md) 

About the Project
=================

PennAI is actively developed by the [Institute for Biomedical Informatics](http://upibi.org) at the University of Pennsylvania.
Contributors include Heather Williams, Weixuan Fu, William La Cava, Josh Cohen,
Steve Vitale, Sharon Tartarone, Randal Olson, Patryk Orzechowski, and Jason Moore. 

Cite
====

An up-to-date paper describing AI methodology is available in [Bioinformatics](https://doi.org/10.1093/bioinformatics/btaa698) and [arxiv](http://arxiv.org/abs/1905.09205).
Here's the biblatex:

```
@article{pennai_2020,
	title = {Evaluating recommender systems for {AI}-driven biomedical informatics},
	url = {https://doi.org/10.1093/bioinformatics/btaa698},
	journaltitle = {Bioinformatics},
	doi = {10.1093/bioinformatics/btaa698},
	year = {2020},
	author = {La Cava, William and Williams, Heather and Fu, Weixuan and Vitale, Steve and Srivatsan, Durga and Moore, Jason H.},
	eprinttype = {arxiv},
	eprint = {1905.09205},
	keywords = {Computer Science - Machine Learning, Computer Science - Information Retrieval},
}
```

You can also find our original position paper on [arxiv](https://arxiv.org/abs/1705.00594).
