# ------------------------------------------------------------------------------
#  Created by Tyler Stegmaier.
#  Property of TrueLogic Company.
#  Copyright (c) 2020.
# ------------------------------------------------------------------------------


from .Setup.Classifiers import *
from .__version__ import *




__all__ = ('__author__',
           '__classifiers__',
           '__email__',
           '__license__',
           '__maintainer__',
           '__maintainer_email__',
           '__name__',
           '__short_description__',
           '__url__',
           '__version__',
           )

__name__ = 'PythonExtensions'
__author__ = "Tyler Stegmaier"
__email__ = "tyler.stegmaier.510@gmail.com"
__copyright__ = "Copyright 2020"
__credits__ = [
    "Tkinter library authors",
    "Copyright (c) 2020 Tyler Stegmaier",
    "Copyright (c) 2018 Pete Mojeiko for [Keyboard](src/Extensions/tk/Widgets/KeyBoard.py)",
    "Copyright (c) 2017 Ole Jakob Skjelten for [AnimatedGIF](src/Extensions/tk/Widgets/Custom.py)",
    "Copyright (c) 2018 paolo-gurisatti for [Html Widgets](src/Extensions/tk/Widgets/HTML.py)",
    ]
__license__ = "MIT"
__version__ = version
__maintainer__ = __author__
__maintainer_email__ = __email__

__status__ = Development_Status.Alpha

__url__ = r'https://github.com/Jakar510/PythonExtensions'
# download_url=f'https://github.com/Jakar510/PyDebug/TkinterExtensions/releases/tag/{version}'

__classifiers__ = [
    __status__,

    # Indicate who your project is intended for
    Intended_Audience.Developers,
    Intended_Audience.Education,
    Topic.Software_Development.Build_Tools,
    Typing.Typed,

    # Pick your license as you wish
    License.OSI_Approved.MIT_License,

    # Support platforms
    Operating_System.MacOS.MacOS,
    Operating_System.Microsoft.Windows.Windows,
    Operating_System.Microsoft.Windows.Windows_10,
    Operating_System.POSIX.Linux,
    Programming_Language.Python.Python,
    Programming_Language.Python.Three.Only,
    Programming_Language.Python.Nine,
    ]

__short_description__ = 'Strongly typed classes with multiple built in helper functions to speed up development.'
