# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/argoproj/argo-workflows/master/api/openapi-spec/swagger.json
#   timestamp: 2021-11-13T19:15:49+00:00

from __future__ import annotations

from typing import Dict, List, Optional

from pydantic import BaseModel, Field

from ...apimachinery.pkg.api import resource
from ...apimachinery.pkg.apis.meta import v1
from ...apimachinery.pkg.util import intstr


class AwsElasticBlockStoreVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore',
    )
    partition: Optional[int] = Field(
        None,
        description='The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).',
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description='Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore',
    )
    volume_id: str = Field(
        ...,
        alias="volumeID",
        description="Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
    )


class AzureDiskVolumeSource(BaseModel):
    caching_mode: Optional[str] = Field(
        None,
        alias="cachingMode",
        description="Host Caching mode: None, Read Only, Read Write.",
    )
    disk_name: str = Field(
        ...,
        alias="diskName",
        description="The Name of the data disk in the blob storage",
    )
    disk_uri: str = Field(
        ..., alias="diskURI", description="The URI the data disk in the blob storage"
    )
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    kind: Optional[str] = Field(
        None,
        description="Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )


class AzureFileVolumeSource(BaseModel):
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    secret_name: str = Field(
        ...,
        alias="secretName",
        description="the name of secret that contains Azure Storage Account Name and Key",
    )
    share_name: str = Field(..., alias="shareName", description="Share Name")


class Capabilities(BaseModel):
    add: Optional[List[str]] = Field(None, description="Added capabilities")
    drop: Optional[List[str]] = Field(None, description="Removed capabilities")


class ConfigMapEnvSource(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the ConfigMap must be defined"
    )


class ConfigMapKeySelector(BaseModel):
    key: str = Field(..., description="The key to select.")
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the ConfigMap or its key must be defined"
    )


class ContainerPort(BaseModel):
    container_port: int = Field(
        ...,
        alias="containerPort",
        description="Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.",
    )
    host_ip: Optional[str] = Field(
        None, alias="hostIP", description="What host IP to bind the external port to."
    )
    host_port: Optional[int] = Field(
        None,
        alias="hostPort",
        description="Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.",
    )
    name: Optional[str] = Field(
        None,
        description="If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.",
    )
    protocol: Optional[str] = Field(
        None,
        description='Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".',
    )


class EventSource(BaseModel):
    component: Optional[str] = Field(
        None, description="Component from which the event is generated."
    )
    host: Optional[str] = Field(
        None, description="Node name on which the event is generated."
    )


class ExecAction(BaseModel):
    command: Optional[List[str]] = Field(
        None,
        description="Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.",
    )


class FcVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    lun: Optional[int] = Field(None, description="Optional: FC target lun number")
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    target_ww_ns: Optional[List[str]] = Field(
        None,
        alias="targetWWNs",
        description="Optional: FC target worldwide names (WWNs)",
    )
    wwids: Optional[List[str]] = Field(
        None,
        description="Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.",
    )


class FlockerVolumeSource(BaseModel):
    dataset_name: Optional[str] = Field(
        None,
        alias="datasetName",
        description="Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated",
    )
    dataset_uuid: Optional[str] = Field(
        None,
        alias="datasetUUID",
        description="UUID of the dataset. This is unique identifier of a Flocker dataset",
    )


class GcePersistentDiskVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk',
    )
    partition: Optional[int] = Field(
        None,
        description='The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk',
    )
    pd_name: str = Field(
        ...,
        alias="pdName",
        description="Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
    )


class GitRepoVolumeSource(BaseModel):
    directory: Optional[str] = Field(
        None,
        description="Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.",
    )
    repository: str = Field(..., description="Repository URL")
    revision: Optional[str] = Field(
        None, description="Commit hash for the specified revision."
    )


class GlusterfsVolumeSource(BaseModel):
    endpoints: str = Field(
        ...,
        description="EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
    )
    path: str = Field(
        ...,
        description="Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
    )


class HttpHeader(BaseModel):
    name: str = Field(..., description="The header field name")
    value: str = Field(..., description="The header field value")


class HostAlias(BaseModel):
    hostnames: Optional[List[str]] = Field(
        None, description="Hostnames for the above IP address."
    )
    ip: Optional[str] = Field(None, description="IP address of the host file entry.")


class HostPathVolumeSource(BaseModel):
    path: str = Field(
        ...,
        description="Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
    )
    type: Optional[str] = Field(
        None,
        description='Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath',
    )


class KeyToPath(BaseModel):
    key: str = Field(..., description="The key to project.")
    mode: Optional[int] = Field(
        None,
        description="Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    path: str = Field(
        ...,
        description="The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.",
    )


class LocalObjectReference(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )


class NfsVolumeSource(BaseModel):
    path: str = Field(
        ...,
        description="Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
    )
    server: str = Field(
        ...,
        description="Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
    )


class NodeSelectorRequirement(BaseModel):
    key: str = Field(..., description="The label key that the selector applies to.")
    operator: str = Field(
        ...,
        description="Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
    )
    values: Optional[List[str]] = Field(
        None,
        description="An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
    )


class NodeSelectorTerm(BaseModel):
    match_expressions: Optional[List[NodeSelectorRequirement]] = Field(
        None,
        alias="matchExpressions",
        description="A list of node selector requirements by node's labels.",
    )
    match_fields: Optional[List[NodeSelectorRequirement]] = Field(
        None,
        alias="matchFields",
        description="A list of node selector requirements by node's fields.",
    )


class ObjectFieldSelector(BaseModel):
    api_version: Optional[str] = Field(
        None,
        alias="apiVersion",
        description='Version of the schema the FieldPath is written in terms of, defaults to "v1".',
    )
    field_path: str = Field(
        ...,
        alias="fieldPath",
        description="Path of the field to select in the specified API version.",
    )


class ObjectReference(BaseModel):
    api_version: Optional[str] = Field(
        None, alias="apiVersion", description="API version of the referent."
    )
    field_path: Optional[str] = Field(
        None,
        alias="fieldPath",
        description='If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: "spec.containers{name}" (where "name" refers to the name of the container that triggered the event) or if no container name is specified "spec.containers[2]" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.',
    )
    kind: Optional[str] = Field(
        None,
        description="Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    namespace: Optional[str] = Field(
        None,
        description="Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/",
    )
    resource_version: Optional[str] = Field(
        None,
        alias="resourceVersion",
        description="Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
    )
    uid: Optional[str] = Field(
        None,
        description="UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids",
    )


class PersistentVolumeClaimVolumeSource(BaseModel):
    claim_name: str = Field(
        ...,
        alias="claimName",
        description="ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Will force the ReadOnly setting in VolumeMounts. Default false.",
    )


class PhotonPersistentDiskVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    pd_id: str = Field(
        ...,
        alias="pdID",
        description="ID that identifies Photon Controller persistent disk",
    )


class PodDnsConfigOption(BaseModel):
    name: Optional[str] = Field(None, description="Required.")
    value: Optional[str] = None


class PortworxVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    volume_id: str = Field(
        ...,
        alias="volumeID",
        description="VolumeID uniquely identifies a Portworx volume",
    )


class PreferredSchedulingTerm(BaseModel):
    preference: NodeSelectorTerm = Field(
        ...,
        description="A node selector term, associated with the corresponding weight.",
    )
    weight: int = Field(
        ...,
        description="Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
    )


class QuobyteVolumeSource(BaseModel):
    group: Optional[str] = Field(
        None, description="Group to map volume access to Default is no group"
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.",
    )
    registry: str = Field(
        ...,
        description="Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes",
    )
    tenant: Optional[str] = Field(
        None,
        description="Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin",
    )
    user: Optional[str] = Field(
        None, description="User to map volume access to Defaults to serivceaccount user"
    )
    volume: str = Field(
        ...,
        description="Volume is a string that references an already created Quobyte volume by name.",
    )


class RbdVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd',
    )
    image: str = Field(
        ...,
        description="The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    keyring: Optional[str] = Field(
        None,
        description="Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    monitors: List[str] = Field(
        ...,
        description="A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    pool: Optional[str] = Field(
        None,
        description="The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )
    user: Optional[str] = Field(
        None,
        description="The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
    )


class SeLinuxOptions(BaseModel):
    level: Optional[str] = Field(
        None, description="Level is SELinux level label that applies to the container."
    )
    role: Optional[str] = Field(
        None, description="Role is a SELinux role label that applies to the container."
    )
    type: Optional[str] = Field(
        None, description="Type is a SELinux type label that applies to the container."
    )
    user: Optional[str] = Field(
        None, description="User is a SELinux user label that applies to the container."
    )


class ScaleIoVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".',
    )
    gateway: str = Field(
        ..., description="The host address of the ScaleIO API Gateway."
    )
    protection_domain: Optional[str] = Field(
        None,
        alias="protectionDomain",
        description="The name of the ScaleIO Protection Domain for the configured storage.",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    secret_ref: LocalObjectReference = Field(
        ...,
        alias="secretRef",
        description="SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.",
    )
    ssl_enabled: Optional[bool] = Field(
        None,
        alias="sslEnabled",
        description="Flag to enable/disable SSL communication with Gateway, default false",
    )
    storage_mode: Optional[str] = Field(
        None,
        alias="storageMode",
        description="Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.",
    )
    storage_pool: Optional[str] = Field(
        None,
        alias="storagePool",
        description="The ScaleIO Storage Pool associated with the protection domain.",
    )
    system: str = Field(
        ..., description="The name of the storage system as configured in ScaleIO."
    )
    volume_name: Optional[str] = Field(
        None,
        alias="volumeName",
        description="The name of a volume already created in the ScaleIO system that is associated with this volume source.",
    )


class SecretEnvSource(BaseModel):
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the Secret must be defined"
    )


class SecretKeySelector(BaseModel):
    key: str = Field(
        ...,
        description="The key of the secret to select from.  Must be a valid secret key.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the Secret or its key must be defined"
    )


class SecretProjection(BaseModel):
    items: Optional[List[KeyToPath]] = Field(
        None,
        description="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the Secret or its key must be defined"
    )


class SecretVolumeSource(BaseModel):
    default_mode: Optional[int] = Field(
        None,
        alias="defaultMode",
        description="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    items: Optional[List[KeyToPath]] = Field(
        None,
        description="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the Secret or its keys must be defined"
    )
    secret_name: Optional[str] = Field(
        None,
        alias="secretName",
        description="Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
    )


class ServiceAccountTokenProjection(BaseModel):
    audience: Optional[str] = Field(
        None,
        description="Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.",
    )
    expiration_seconds: Optional[int] = Field(
        None,
        alias="expirationSeconds",
        description="ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.",
    )
    path: str = Field(
        ...,
        description="Path is the path relative to the mount point of the file to project the token into.",
    )


class StorageOsVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.",
    )
    volume_name: Optional[str] = Field(
        None,
        alias="volumeName",
        description="VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.",
    )
    volume_namespace: Optional[str] = Field(
        None,
        alias="volumeNamespace",
        description='VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod\'s namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.',
    )


class Sysctl(BaseModel):
    name: str = Field(..., description="Name of a property to set")
    value: str = Field(..., description="Value of a property to set")


class Toleration(BaseModel):
    effect: Optional[str] = Field(
        None,
        description="Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.",
    )
    key: Optional[str] = Field(
        None,
        description="Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.",
    )
    operator: Optional[str] = Field(
        None,
        description="Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.",
    )
    toleration_seconds: Optional[int] = Field(
        None,
        alias="tolerationSeconds",
        description="TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.",
    )
    value: Optional[str] = Field(
        None,
        description="Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.",
    )


class TypedLocalObjectReference(BaseModel):
    api_group: Optional[str] = Field(
        None,
        alias="apiGroup",
        description="APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.",
    )
    kind: str = Field(..., description="Kind is the type of resource being referenced")
    name: str = Field(..., description="Name is the name of resource being referenced")


class VolumeDevice(BaseModel):
    device_path: str = Field(
        ...,
        alias="devicePath",
        description="devicePath is the path inside of the container that the device will be mapped to.",
    )
    name: str = Field(
        ...,
        description="name must match the name of a persistentVolumeClaim in the pod",
    )


class VolumeMount(BaseModel):
    mount_path: str = Field(
        ...,
        alias="mountPath",
        description="Path within the container at which the volume should be mounted.  Must not contain ':'.",
    )
    mount_propagation: Optional[str] = Field(
        None,
        alias="mountPropagation",
        description="mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.",
    )
    name: str = Field(..., description="This must match the Name of a Volume.")
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.",
    )
    sub_path: Optional[str] = Field(
        None,
        alias="subPath",
        description="Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).",
    )
    sub_path_expr: Optional[str] = Field(
        None,
        alias="subPathExpr",
        description="Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to \"\" (volume's root). SubPathExpr and SubPath are mutually exclusive.",
    )


class VsphereVirtualDiskVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.',
    )
    storage_policy_id: Optional[str] = Field(
        None,
        alias="storagePolicyID",
        description="Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.",
    )
    storage_policy_name: Optional[str] = Field(
        None,
        alias="storagePolicyName",
        description="Storage Policy Based Management (SPBM) profile name.",
    )
    volume_path: str = Field(
        ..., alias="volumePath", description="Path that identifies vSphere volume vmdk"
    )


class WindowsSecurityContextOptions(BaseModel):
    gmsa_credential_spec: Optional[str] = Field(
        None,
        alias="gmsaCredentialSpec",
        description="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.",
    )
    gmsa_credential_spec_name: Optional[str] = Field(
        None,
        alias="gmsaCredentialSpecName",
        description="GMSACredentialSpecName is the name of the GMSA credential spec to use. This field is alpha-level and is only honored by servers that enable the WindowsGMSA feature flag.",
    )
    run_as_user_name: Optional[str] = Field(
        None,
        alias="runAsUserName",
        description="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. This field is beta-level and may be disabled with the WindowsRunAsUserName feature flag.",
    )


class CsiVolumeSource(BaseModel):
    driver: str = Field(
        ...,
        description="Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.",
    )
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.',
    )
    node_publish_secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="nodePublishSecretRef",
        description="NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Specifies a read-only configuration for the volume. Defaults to false (read/write).",
    )
    volume_attributes: Optional[Dict[str, str]] = Field(
        None,
        alias="volumeAttributes",
        description="VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.",
    )


class CephFsVolumeSource(BaseModel):
    monitors: List[str] = Field(
        ...,
        description="Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
    )
    path: Optional[str] = Field(
        None,
        description="Optional: Used as the mounted root, rather than the full Ceph tree, default is /",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
    )
    secret_file: Optional[str] = Field(
        None,
        alias="secretFile",
        description="Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
    )
    user: Optional[str] = Field(
        None,
        description="Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
    )


class CinderVolumeSource(BaseModel):
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md',
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="Optional: points to a secret object containing parameters used to connect to OpenStack.",
    )
    volume_id: str = Field(
        ...,
        alias="volumeID",
        description="volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
    )


class ConfigMapProjection(BaseModel):
    items: Optional[List[KeyToPath]] = Field(
        None,
        description="If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the ConfigMap or its keys must be defined"
    )


class ConfigMapVolumeSource(BaseModel):
    default_mode: Optional[int] = Field(
        None,
        alias="defaultMode",
        description="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    items: Optional[List[KeyToPath]] = Field(
        None,
        description="If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    optional: Optional[bool] = Field(
        None, description="Specify whether the ConfigMap or its keys must be defined"
    )


class EmptyDirVolumeSource(BaseModel):
    medium: Optional[str] = Field(
        None,
        description='What type of storage medium should back this directory. The default is "" which means to use the node\'s default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir',
    )
    size_limit: Optional[resource.Quantity] = Field(
        None,
        alias="sizeLimit",
        description="Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
    )


class EnvFromSource(BaseModel):
    config_map_ref: Optional[ConfigMapEnvSource] = Field(
        None, alias="configMapRef", description="The ConfigMap to select from"
    )
    prefix: Optional[str] = Field(
        None,
        description="An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.",
    )
    secret_ref: Optional[SecretEnvSource] = Field(
        None, alias="secretRef", description="The Secret to select from"
    )


class EventSeries(BaseModel):
    count: Optional[int] = Field(
        None,
        description="Number of occurrences in this series up to the last heartbeat time",
    )
    last_observed_time: Optional[v1.MicroTime] = Field(
        None,
        alias="lastObservedTime",
        description="Time of the last occurrence observed",
    )
    state: Optional[str] = Field(
        None,
        description="State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18",
    )


class FlexVolumeSource(BaseModel):
    driver: str = Field(
        ..., description="Driver is the name of the driver to use for this volume."
    )
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.',
    )
    options: Optional[Dict[str, str]] = Field(
        None, description="Optional: Extra command options if any."
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.",
    )


class HttpGetAction(BaseModel):
    host: Optional[str] = Field(
        None,
        description='Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.',
    )
    http_headers: Optional[List[HttpHeader]] = Field(
        None,
        alias="httpHeaders",
        description="Custom headers to set in the request. HTTP allows repeated headers.",
    )
    path: Optional[str] = Field(None, description="Path to access on the HTTP server.")
    port: intstr.IntOrString = Field(
        ...,
        description="Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
    )
    scheme: Optional[str] = Field(
        None, description="Scheme to use for connecting to the host. Defaults to HTTP."
    )


class IscsiVolumeSource(BaseModel):
    chap_auth_discovery: Optional[bool] = Field(
        None,
        alias="chapAuthDiscovery",
        description="whether support iSCSI Discovery CHAP authentication",
    )
    chap_auth_session: Optional[bool] = Field(
        None,
        alias="chapAuthSession",
        description="whether support iSCSI Session CHAP authentication",
    )
    fs_type: Optional[str] = Field(
        None,
        alias="fsType",
        description='Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi',
    )
    initiator_name: Optional[str] = Field(
        None,
        alias="initiatorName",
        description="Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.",
    )
    iqn: str = Field(..., description="Target iSCSI Qualified Name.")
    iscsi_interface: Optional[str] = Field(
        None,
        alias="iscsiInterface",
        description="iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).",
    )
    lun: int = Field(..., description="iSCSI Target Lun number.")
    portals: Optional[List[str]] = Field(
        None,
        description="iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
    )
    read_only: Optional[bool] = Field(
        None,
        alias="readOnly",
        description="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.",
    )
    secret_ref: Optional[LocalObjectReference] = Field(
        None,
        alias="secretRef",
        description="CHAP Secret for iSCSI target and initiator authentication",
    )
    target_portal: str = Field(
        ...,
        alias="targetPortal",
        description="iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
    )


class NodeSelector(BaseModel):
    node_selector_terms: List[NodeSelectorTerm] = Field(
        ...,
        alias="nodeSelectorTerms",
        description="Required. A list of node selector terms. The terms are ORed.",
    )


class PersistentVolumeClaimCondition(BaseModel):
    last_probe_time: Optional[v1.Time] = Field(
        None, alias="lastProbeTime", description="Last time we probed the condition."
    )
    last_transition_time: Optional[v1.Time] = Field(
        None,
        alias="lastTransitionTime",
        description="Last time the condition transitioned from one status to another.",
    )
    message: Optional[str] = Field(
        None,
        description="Human-readable message indicating details about last transition.",
    )
    reason: Optional[str] = Field(
        None,
        description='Unique, this should be a short, machine understandable string that gives the reason for condition\'s last transition. If it reports "ResizeStarted" that means the underlying persistent volume is being resized.',
    )
    status: str
    type: str


class PersistentVolumeClaimStatus(BaseModel):
    access_modes: Optional[List[str]] = Field(
        None,
        alias="accessModes",
        description="AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
    )
    capacity: Optional[Dict[str, resource.Quantity]] = Field(
        None, description="Represents the actual resources of the underlying volume."
    )
    conditions: Optional[List[PersistentVolumeClaimCondition]] = Field(
        None,
        description="Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.",
    )
    phase: Optional[str] = Field(
        None, description="Phase represents the current phase of PersistentVolumeClaim."
    )


class PodDnsConfig(BaseModel):
    nameservers: Optional[List[str]] = Field(
        None,
        description="A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.",
    )
    options: Optional[List[PodDnsConfigOption]] = Field(
        None,
        description="A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.",
    )
    searches: Optional[List[str]] = Field(
        None,
        description="A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.",
    )


class PodSecurityContext(BaseModel):
    fs_group: Optional[int] = Field(
        None,
        alias="fsGroup",
        description="A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.",
    )
    run_as_group: Optional[int] = Field(
        None,
        alias="runAsGroup",
        description="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
    )
    run_as_non_root: Optional[bool] = Field(
        None,
        alias="runAsNonRoot",
        description="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )
    run_as_user: Optional[int] = Field(
        None,
        alias="runAsUser",
        description="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
    )
    se_linux_options: Optional[SeLinuxOptions] = Field(
        None,
        alias="seLinuxOptions",
        description="The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
    )
    supplemental_groups: Optional[List[int]] = Field(
        None,
        alias="supplementalGroups",
        description="A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.",
    )
    sysctls: Optional[List[Sysctl]] = Field(
        None,
        description="Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.",
    )
    windows_options: Optional[WindowsSecurityContextOptions] = Field(
        None,
        alias="windowsOptions",
        description="The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )


class ResourceFieldSelector(BaseModel):
    container_name: Optional[str] = Field(
        None,
        alias="containerName",
        description="Container name: required for volumes, optional for env vars",
    )
    divisor: Optional[resource.Quantity] = Field(
        None,
        description='Specifies the output format of the exposed resources, defaults to "1"',
    )
    resource: str = Field(..., description="Required: resource to select")


class ResourceRequirements(BaseModel):
    limits: Optional[Dict[str, resource.Quantity]] = Field(
        None,
        description="Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
    )
    requests: Optional[Dict[str, resource.Quantity]] = Field(
        None,
        description="Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
    )


class SecurityContext(BaseModel):
    allow_privilege_escalation: Optional[bool] = Field(
        None,
        alias="allowPrivilegeEscalation",
        description="AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN",
    )
    capabilities: Optional[Capabilities] = Field(
        None,
        description="The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.",
    )
    privileged: Optional[bool] = Field(
        None,
        description="Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.",
    )
    proc_mount: Optional[str] = Field(
        None,
        alias="procMount",
        description="procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.",
    )
    read_only_root_filesystem: Optional[bool] = Field(
        None,
        alias="readOnlyRootFilesystem",
        description="Whether this container has a read-only root filesystem. Default is false.",
    )
    run_as_group: Optional[int] = Field(
        None,
        alias="runAsGroup",
        description="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )
    run_as_non_root: Optional[bool] = Field(
        None,
        alias="runAsNonRoot",
        description="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )
    run_as_user: Optional[int] = Field(
        None,
        alias="runAsUser",
        description="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )
    se_linux_options: Optional[SeLinuxOptions] = Field(
        None,
        alias="seLinuxOptions",
        description="The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )
    windows_options: Optional[WindowsSecurityContextOptions] = Field(
        None,
        alias="windowsOptions",
        description="The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
    )


class ServicePort(BaseModel):
    name: Optional[str] = Field(
        None,
        description="The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.",
    )
    node_port: Optional[int] = Field(
        None,
        alias="nodePort",
        description="The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport",
    )
    port: int = Field(..., description="The port that will be exposed by this service.")
    protocol: Optional[str] = Field(
        None,
        description='The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is TCP.',
    )
    target_port: Optional[intstr.IntOrString] = Field(
        None,
        alias="targetPort",
        description="Number or name of the port to access on the pods targeted by the service. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this is a string, it will be looked up as a named port in the target Pod's container ports. If this is not specified, the value of the 'port' field is used (an identity map). This field is ignored for services with clusterIP=None, and should be omitted or set equal to the 'port' field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service",
    )


class TcpSocketAction(BaseModel):
    host: Optional[str] = Field(
        None, description="Optional: Host name to connect to, defaults to the pod IP."
    )
    port: intstr.IntOrString = Field(
        ...,
        description="Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
    )


class DownwardApiVolumeFile(BaseModel):
    field_ref: Optional[ObjectFieldSelector] = Field(
        None,
        alias="fieldRef",
        description="Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.",
    )
    mode: Optional[int] = Field(
        None,
        description="Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    path: str = Field(
        ...,
        description="Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'",
    )
    resource_field_ref: Optional[ResourceFieldSelector] = Field(
        None,
        alias="resourceFieldRef",
        description="Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
    )


class DownwardApiVolumeSource(BaseModel):
    default_mode: Optional[int] = Field(
        None,
        alias="defaultMode",
        description="Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    items: Optional[List[DownwardApiVolumeFile]] = Field(
        None, description="Items is a list of downward API volume file"
    )


class EnvVarSource(BaseModel):
    config_map_key_ref: Optional[ConfigMapKeySelector] = Field(
        None, alias="configMapKeyRef", description="Selects a key of a ConfigMap."
    )
    field_ref: Optional[ObjectFieldSelector] = Field(
        None,
        alias="fieldRef",
        description="Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.",
    )
    resource_field_ref: Optional[ResourceFieldSelector] = Field(
        None,
        alias="resourceFieldRef",
        description="Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.",
    )
    secret_key_ref: Optional[SecretKeySelector] = Field(
        None,
        alias="secretKeyRef",
        description="Selects a key of a secret in the pod's namespace",
    )


class Event(BaseModel):
    action: Optional[str] = Field(
        None,
        description="What action was taken/failed regarding to the Regarding object.",
    )
    api_version: Optional[str] = Field(
        None,
        alias="apiVersion",
        description="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
    )
    count: Optional[int] = Field(
        None, description="The number of times this event has occurred."
    )
    event_time: Optional[v1.MicroTime] = Field(
        None, alias="eventTime", description="Time when this Event was first observed."
    )
    first_timestamp: Optional[v1.Time] = Field(
        None,
        alias="firstTimestamp",
        description="The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)",
    )
    involved_object: ObjectReference = Field(
        ..., alias="involvedObject", description="The object that this event is about."
    )
    kind: Optional[str] = Field(
        None,
        description="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
    )
    last_timestamp: Optional[v1.Time] = Field(
        None,
        alias="lastTimestamp",
        description="The time at which the most recent occurrence of this event was recorded.",
    )
    message: Optional[str] = Field(
        None,
        description="A human-readable description of the status of this operation.",
    )
    metadata: v1.ObjectMeta = Field(
        ...,
        description="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
    )
    reason: Optional[str] = Field(
        None,
        description="This should be a short, machine understandable string that gives the reason for the transition into the object's current status.",
    )
    related: Optional[ObjectReference] = Field(
        None, description="Optional secondary object for more complex actions."
    )
    reporting_component: Optional[str] = Field(
        None,
        alias="reportingComponent",
        description="Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.",
    )
    reporting_instance: Optional[str] = Field(
        None,
        alias="reportingInstance",
        description="ID of the controller instance, e.g. `kubelet-xyzf`.",
    )
    series: Optional[EventSeries] = Field(
        None,
        description="Data about the Event series this event represents or nil if it's a singleton Event.",
    )
    source: Optional[EventSource] = Field(
        None,
        description="The component reporting this event. Should be a short machine understandable string.",
    )
    type: Optional[str] = Field(
        None,
        description="Type of this event (Normal, Warning), new types could be added in the future",
    )


class Handler(BaseModel):
    exec: Optional[ExecAction] = Field(
        None,
        description="One and only one of the following should be specified. Exec specifies the action to take.",
    )
    http_get: Optional[HttpGetAction] = Field(
        None,
        alias="httpGet",
        description="HTTPGet specifies the http request to perform.",
    )
    tcp_socket: Optional[TcpSocketAction] = Field(
        None,
        alias="tcpSocket",
        description="TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
    )


class Lifecycle(BaseModel):
    post_start: Optional[Handler] = Field(
        None,
        alias="postStart",
        description="PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
    )
    pre_stop: Optional[Handler] = Field(
        None,
        alias="preStop",
        description="PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
    )


class NodeAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Optional[
        List[PreferredSchedulingTerm]
    ] = Field(
        None,
        alias="preferredDuringSchedulingIgnoredDuringExecution",
        description='The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.',
    )
    required_during_scheduling_ignored_during_execution: Optional[NodeSelector] = Field(
        None,
        alias="requiredDuringSchedulingIgnoredDuringExecution",
        description="If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
    )


class PersistentVolumeClaimSpec(BaseModel):
    access_modes: Optional[List[str]] = Field(
        None,
        alias="accessModes",
        description="AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
    )
    data_source: Optional[TypedLocalObjectReference] = Field(
        None,
        alias="dataSource",
        description="This field requires the VolumeSnapshotDataSource alpha feature gate to be enabled and currently VolumeSnapshot is the only supported data source. If the provisioner can support VolumeSnapshot data source, it will create a new volume and data will be restored to the volume at the same time. If the provisioner does not support VolumeSnapshot data source, volume will not be created and the failure will be reported as an event. In the future, we plan to support more data source types and the behavior of the provisioner may change.",
    )
    resources: Optional[ResourceRequirements] = Field(
        None,
        description="Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources",
    )
    selector: Optional[v1.LabelSelector] = Field(
        None, description="A label query over volumes to consider for binding."
    )
    storage_class_name: Optional[str] = Field(
        None,
        alias="storageClassName",
        description="Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1",
    )
    volume_mode: Optional[str] = Field(
        None,
        alias="volumeMode",
        description="volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is a beta feature.",
    )
    volume_name: Optional[str] = Field(
        None,
        alias="volumeName",
        description="VolumeName is the binding reference to the PersistentVolume backing this claim.",
    )


class PersistentVolumeClaimTemplate(BaseModel):
    metadata: Optional[v1.ObjectMeta] = Field(
        None,
        description="May contain labels and annotations that will be copied into the PVC\nwhen creating it. No other fields are allowed and will be rejected during\nvalidation.\n\n+optional",
    )
    spec: Optional[PersistentVolumeClaimSpec] = Field(
        None,
        description="The specification for the PersistentVolumeClaim. The entire content is\ncopied unchanged into the PVC that gets created from this\ntemplate. The same fields as in a PersistentVolumeClaim\nare also valid here.",
    )


class PodAffinityTerm(BaseModel):
    label_selector: Optional[v1.LabelSelector] = Field(
        None,
        alias="labelSelector",
        description="A label query over a set of resources, in this case pods.",
    )
    namespaces: Optional[List[str]] = Field(
        None,
        description='namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means "this pod\'s namespace"',
    )
    topology_key: str = Field(
        ...,
        alias="topologyKey",
        description="This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.",
    )


class Probe(BaseModel):
    exec: Optional[ExecAction] = Field(
        None,
        description="One and only one of the following should be specified. Exec specifies the action to take.",
    )
    failure_threshold: Optional[int] = Field(
        None,
        alias="failureThreshold",
        description="Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.",
    )
    http_get: Optional[HttpGetAction] = Field(
        None,
        alias="httpGet",
        description="HTTPGet specifies the http request to perform.",
    )
    initial_delay_seconds: Optional[int] = Field(
        None,
        alias="initialDelaySeconds",
        description="Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
    )
    period_seconds: Optional[int] = Field(
        None,
        alias="periodSeconds",
        description="How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.",
    )
    success_threshold: Optional[int] = Field(
        None,
        alias="successThreshold",
        description="Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.",
    )
    tcp_socket: Optional[TcpSocketAction] = Field(
        None,
        alias="tcpSocket",
        description="TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
    )
    timeout_seconds: Optional[int] = Field(
        None,
        alias="timeoutSeconds",
        description="Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
    )


class WeightedPodAffinityTerm(BaseModel):
    pod_affinity_term: PodAffinityTerm = Field(
        ...,
        alias="podAffinityTerm",
        description="Required. A pod affinity term, associated with the corresponding weight.",
    )
    weight: int = Field(
        ...,
        description="weight associated with matching the corresponding podAffinityTerm, in the range 1-100.",
    )


class DownwardApiProjection(BaseModel):
    items: Optional[List[DownwardApiVolumeFile]] = Field(
        None, description="Items is a list of DownwardAPIVolume file"
    )


class EnvVar(BaseModel):
    name: str = Field(
        ..., description="Name of the environment variable. Must be a C_IDENTIFIER."
    )
    value: Optional[str] = Field(
        None,
        description='Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".',
    )
    value_from: Optional[EnvVarSource] = Field(
        None,
        alias="valueFrom",
        description="Source for the environment variable's value. Cannot be used if value is not empty.",
    )


class EphemeralVolumeSource(BaseModel):
    volume_claim_template: Optional[PersistentVolumeClaimTemplate] = Field(
        None,
        alias="volumeClaimTemplate",
        description="Will be used to create a stand-alone PVC to provision the volume.\nThe pod in which this EphemeralVolumeSource is embedded will be the\nowner of the PVC, i.e. the PVC will be deleted together with the\npod.  The name of the PVC will be `<pod name>-<volume name>` where\n`<volume name>` is the name from the `PodSpec.Volumes` array\nentry. Pod validation will reject the pod if the concatenated name\nis not valid for a PVC (for example, too long).\n\nAn existing PVC with that name that is not owned by the pod\nwill *not* be used for the pod to avoid using an unrelated\nvolume by mistake. Starting the pod is then blocked until\nthe unrelated PVC is removed. If such a pre-created PVC is\nmeant to be used by the pod, the PVC has to updated with an\nowner reference to the pod once the pod exists. Normally\nthis should not be necessary, but it may be useful when\nmanually reconstructing a broken cluster.\n\nThis field is read-only and no changes will be made by Kubernetes\nto the PVC after it has been created.\n\nRequired, must not be nil.",
    )


class PersistentVolumeClaim(BaseModel):
    api_version: Optional[str] = Field(
        None,
        alias="apiVersion",
        description="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
    )
    kind: Optional[str] = Field(
        None,
        description="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
    )
    metadata: Optional[v1.ObjectMeta] = Field(
        None,
        description="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
    )
    spec: Optional[PersistentVolumeClaimSpec] = Field(
        None,
        description="Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
    )
    status: Optional[PersistentVolumeClaimStatus] = Field(
        None,
        description="Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
    )


class PodAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Optional[
        List[WeightedPodAffinityTerm]
    ] = Field(
        None,
        alias="preferredDuringSchedulingIgnoredDuringExecution",
        description='The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.',
    )
    required_during_scheduling_ignored_during_execution: Optional[
        List[PodAffinityTerm]
    ] = Field(
        None,
        alias="requiredDuringSchedulingIgnoredDuringExecution",
        description="If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
    )


class PodAntiAffinity(BaseModel):
    preferred_during_scheduling_ignored_during_execution: Optional[
        List[WeightedPodAffinityTerm]
    ] = Field(
        None,
        alias="preferredDuringSchedulingIgnoredDuringExecution",
        description='The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.',
    )
    required_during_scheduling_ignored_during_execution: Optional[
        List[PodAffinityTerm]
    ] = Field(
        None,
        alias="requiredDuringSchedulingIgnoredDuringExecution",
        description="If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
    )


class VolumeProjection(BaseModel):
    config_map: Optional[ConfigMapProjection] = Field(
        None,
        alias="configMap",
        description="information about the configMap data to project",
    )
    downward_api: Optional[DownwardApiProjection] = Field(
        None,
        alias="downwardAPI",
        description="information about the downwardAPI data to project",
    )
    secret: Optional[SecretProjection] = Field(
        None, description="information about the secret data to project"
    )
    service_account_token: Optional[ServiceAccountTokenProjection] = Field(
        None,
        alias="serviceAccountToken",
        description="information about the serviceAccountToken data to project",
    )


class Affinity(BaseModel):
    node_affinity: Optional[NodeAffinity] = Field(
        None,
        alias="nodeAffinity",
        description="Describes node affinity scheduling rules for the pod.",
    )
    pod_affinity: Optional[PodAffinity] = Field(
        None,
        alias="podAffinity",
        description="Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).",
    )
    pod_anti_affinity: Optional[PodAntiAffinity] = Field(
        None,
        alias="podAntiAffinity",
        description="Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).",
    )


class Container(BaseModel):
    args: Optional[List[str]] = Field(
        None,
        description="Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
    )
    command: Optional[List[str]] = Field(
        None,
        description="Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
    )
    env: Optional[List[EnvVar]] = Field(
        None,
        description="List of environment variables to set in the container. Cannot be updated.",
    )
    env_from: Optional[List[EnvFromSource]] = Field(
        None,
        alias="envFrom",
        description="List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.",
    )
    image: str = Field(
        ...,
        description="Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.",
    )
    image_pull_policy: Optional[str] = Field(
        None,
        alias="imagePullPolicy",
        description="Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
    )
    lifecycle: Optional[Lifecycle] = Field(
        None,
        description="Actions that the management system should take in response to container lifecycle events. Cannot be updated.",
    )
    liveness_probe: Optional[Probe] = Field(
        None,
        alias="livenessProbe",
        description="Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
    )
    name: Optional[str] = Field(
        None,
        description="Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.",
    )
    ports: Optional[List[ContainerPort]] = Field(
        None,
        description='List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated.',
    )
    readiness_probe: Optional[Probe] = Field(
        None,
        alias="readinessProbe",
        description="Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
    )
    resources: Optional[ResourceRequirements] = Field(
        None,
        description="Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
    )
    security_context: Optional[SecurityContext] = Field(
        None,
        alias="securityContext",
        description="Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/",
    )
    startup_probe: Optional[Probe] = Field(
        None,
        alias="startupProbe",
        description="StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. This is an alpha feature enabled by the StartupProbe feature flag. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
    )
    stdin: Optional[bool] = Field(
        None,
        description="Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
    )
    stdin_once: Optional[bool] = Field(
        None,
        alias="stdinOnce",
        description="Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
    )
    termination_message_path: Optional[str] = Field(
        None,
        alias="terminationMessagePath",
        description="Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.",
    )
    termination_message_policy: Optional[str] = Field(
        None,
        alias="terminationMessagePolicy",
        description="Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.",
    )
    tty: Optional[bool] = Field(
        None,
        description="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
    )
    volume_devices: Optional[List[VolumeDevice]] = Field(
        None,
        alias="volumeDevices",
        description="volumeDevices is the list of block devices to be used by the container. This is a beta feature.",
    )
    volume_mounts: Optional[List[VolumeMount]] = Field(
        None,
        alias="volumeMounts",
        description="Pod volumes to mount into the container's filesystem. Cannot be updated.",
    )
    working_dir: Optional[str] = Field(
        None,
        alias="workingDir",
        description="Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
    )


class ProjectedVolumeSource(BaseModel):
    default_mode: Optional[int] = Field(
        None,
        alias="defaultMode",
        description="Mode bits to use on created files by default. Must be a value between 0 and 0777. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
    )
    sources: List[VolumeProjection] = Field(
        ..., description="list of volume projections"
    )


class Volume(BaseModel):
    aws_elastic_block_store: Optional[AwsElasticBlockStoreVolumeSource] = Field(
        None,
        alias="awsElasticBlockStore",
        description="AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
    )
    azure_disk: Optional[AzureDiskVolumeSource] = Field(
        None,
        alias="azureDisk",
        description="AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
    )
    azure_file: Optional[AzureFileVolumeSource] = Field(
        None,
        alias="azureFile",
        description="AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
    )
    cephfs: Optional[CephFsVolumeSource] = Field(
        None,
        description="CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
    )
    cinder: Optional[CinderVolumeSource] = Field(
        None,
        description="Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
    )
    config_map: Optional[ConfigMapVolumeSource] = Field(
        None,
        alias="configMap",
        description="ConfigMap represents a configMap that should populate this volume",
    )
    csi: Optional[CsiVolumeSource] = Field(
        None,
        description="CSI (Container Storage Interface) represents storage that is handled by an external CSI driver (Alpha feature).",
    )
    downward_api: Optional[DownwardApiVolumeSource] = Field(
        None,
        alias="downwardAPI",
        description="DownwardAPI represents downward API about the pod that should populate this volume",
    )
    empty_dir: Optional[EmptyDirVolumeSource] = Field(
        None,
        alias="emptyDir",
        description="EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
    )
    fc: Optional[FcVolumeSource] = Field(
        None,
        description="FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
    )
    flex_volume: Optional[FlexVolumeSource] = Field(
        None,
        alias="flexVolume",
        description="FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.",
    )
    flocker: Optional[FlockerVolumeSource] = Field(
        None,
        description="Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running",
    )
    gce_persistent_disk: Optional[GcePersistentDiskVolumeSource] = Field(
        None,
        alias="gcePersistentDisk",
        description="GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
    )
    git_repo: Optional[GitRepoVolumeSource] = Field(
        None,
        alias="gitRepo",
        description="GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.",
    )
    glusterfs: Optional[GlusterfsVolumeSource] = Field(
        None,
        description="Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md",
    )
    host_path: Optional[HostPathVolumeSource] = Field(
        None,
        alias="hostPath",
        description="HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
    )
    iscsi: Optional[IscsiVolumeSource] = Field(
        None,
        description="ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md",
    )
    name: str = Field(
        ...,
        description="Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
    )
    nfs: Optional[NfsVolumeSource] = Field(
        None,
        description="NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
    )
    persistent_volume_claim: Optional[PersistentVolumeClaimVolumeSource] = Field(
        None,
        alias="persistentVolumeClaim",
        description="PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
    )
    photon_persistent_disk: Optional[PhotonPersistentDiskVolumeSource] = Field(
        None,
        alias="photonPersistentDisk",
        description="PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
    )
    portworx_volume: Optional[PortworxVolumeSource] = Field(
        None,
        alias="portworxVolume",
        description="PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
    )
    projected: Optional[ProjectedVolumeSource] = Field(
        None,
        description="Items for all in one resources secrets, configmaps, and downward API",
    )
    quobyte: Optional[QuobyteVolumeSource] = Field(
        None,
        description="Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
    )
    rbd: Optional[RbdVolumeSource] = Field(
        None,
        description="RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md",
    )
    scale_io: Optional[ScaleIoVolumeSource] = Field(
        None,
        alias="scaleIO",
        description="ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
    )
    secret: Optional[SecretVolumeSource] = Field(
        None,
        description="Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
    )
    storageos: Optional[StorageOsVolumeSource] = Field(
        None,
        description="StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.",
    )
    vsphere_volume: Optional[VsphereVirtualDiskVolumeSource] = Field(
        None,
        alias="vsphereVolume",
        description="VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
    )
