from ._base import HTMLGenerator

class MarkSafe(HTMLGenerator):
	'''
	A string that should not be escaped.

	Useful for, ie, HTML that you're fetching from a database.

	Note that strings generated by markupsafe or Django's format_html() are handled automatically - you don't need to wrap them in this class.
	'''
	def __init__(self, html):
		self._html = html

	def __iter__(self):
		yield self._html