from distutils.core import setup

setup(
    name = 'pytilities',
    packages = ['pytilities', 'pytilities.event', 'pytilities.types', 'pytilities.descriptors', 'pytilities.overloading', 'pytilities.delegation', 'pytilities.aop', 'pytilities.aop.aspects', 'pytilities.test', 'pytilities.test.event', 'pytilities.test.types', 'pytilities.test.infinity', 'pytilities.test.descriptors', 'pytilities.test.overloading', 'pytilities.test.delegation', 'pytilities.test.aop', 'pytilities.test.geometry', 'pytilities.geometry'],
    provides = ['pytilities', 'pytilities.event', 'pytilities.types', 'pytilities.descriptors', 'pytilities.overloading', 'pytilities.delegation', 'pytilities.aop', 'pytilities.aop.aspects', 'pytilities.test', 'pytilities.test.event', 'pytilities.test.types', 'pytilities.test.infinity', 'pytilities.test.descriptors', 'pytilities.test.overloading', 'pytilities.test.delegation', 'pytilities.test.aop', 'pytilities.test.geometry', 'pytilities.geometry'],
    version = '1.0.0',
    description = 'A collection of python coding utilities',
    author = 'Tim Diels',
    author_email = 'limyreth@users.sourceforge.net',
    url = 'http://pytilities.sourceforge.net',
    keywords = ['utility', 'library', 'aop', 'aspect', 'oriented', 'event', 'overloading'],
    classifiers = ['Development Status :: 5 - Production/Stable', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Operating System :: OS Independent', 'Programming Language :: Python', 'Programming Language :: Python :: 3', 'Programming Language :: Python :: 3.0', 'Programming Language :: Python :: 3.1', 'Programming Language :: Python :: 3.2', 'Topic :: Software Development :: Libraries', 'Topic :: Software Development :: Libraries :: Python Modules'],
    long_description = "Pytilities is a python3 utility library for developers.\n\nLinks\n=====\n\n- `Pytilities homepage`_\n- `Documentation`_\n\n\nFeatures\n========\n\n- Aspect oriented programming: \n\n  - Give advice to class/instance descriptors (i.e. methods, properties, ...)\n  - Use aspects to create new attributes on classes/instances\n- Event dispatching: Observer/Subject like event dispatching with wrappers\n  for hiding events on dispatchers and combining dispatchers\n- Function overloading\n- Basic geometry: Vector, Rectangle classes\n- Various: cross platform infinity number, ...\n\n\n.. _Pytilities homepage: http://pytilities.sourceforge.net/\n.. _Documentation: http://pytilities.sourceforge.net/doc/1.0.0/\n\n\nChangelog\n=========\n\n1.0.0 \n-----\n\nThe library moved to python3, older python versions are no longer supported.\nThere a lot of changes, breaking quite a bit of the previous interface. All\nchanges are listed below.\n\n\npytilities \n''''''''''\n\n:Added:\n    - get_annotations: gets annotations of an object, allows to add new ones,\n      ...\n    - get_attr_name, get_attr_value, has_attr_name, has_attr_value: gets an\n      attribute, bypassing regular lookup (no descriptor.__get__, ..., does\n      support inheritance though)\n\n:Removed: \n    - AttributeCollection, AttributeCollectionBase: use aop instead (see User\n      Guide)\n\n:Changed:\n    - mangle: \n\n      - You can now pass an instance as well.\n      - Small fix involving class names that start with a '_'\n\npytilities.aop \n''''''''''''''\n\nThis package brings aspect oriented language features to python (in a handy\nformat). You can apply advice on classes and instances, using aspects that can\nbe applied and unapplied, enabled, disabled, ...\n\n:Added:\n    - advisor: singleton that aspects use to give advice (you shouldn't use\n      this directly, derive from Aspect and use its methods instead)\n    - proceed, return_close, return\\_, arguments, advised, obj, name yields for\n      advice functions\n    - Aspect: base class to write your own aspects with (you are not required\n      to use this, but it is greatly recommended)\n    - AOPMeta: classes that are given * advice require to have AOPMeta as\n      metaclass, other advised classes may benefit from this metaclass as it\n      reduces memory usage\n\npytilities.delegation \n'''''''''''''''''''''\n\n:Added:\n    - DelegationAspect: delegate attributes from a source instance/cls to a\n      target. Only supports direct mappings (mappings with the same source and\n      target attributes).\n    - in_profile, profile_carrier: used to more easily place some profiles on a\n      class\n\n:Changed:\n    - Profile\n\n:Removed:\n    - Delegator, DelegatorFactory: use delegate or any of the other\n      possibilities listed in the User Guide instead\n    - delegator_factory: use profile_carrier instead.\n    - delegated: use in_profile instead.\n    - delegate: use DelegationAspect instead. You may want to read about AOP in\n      the user guide first\n\npytilities.descriptors (new) \n''''''''''''''''''''''''''''\n\n:Added:\n    - AttributeDescriptor: turns a regular attribute into a descriptor\n    - DereferencedDescriptor: returns inner_desc.get.get, sets\n      inner_desc.get.set, ...\n    - BoundDescriptor: binds an instance to a descriptor, much like bound\n      methods\n    - RestrictedDescriptor: strip of the get, set or del of a descriptor\n\npytilities.event \n''''''''''''''''\n\n:Removed:\n    - dispatcher, dispatcherswitch (decorators): normally you'd send events\n      from an aspect as it's a crosscutting concern, so these no longer have to\n      be supported. Use a custom Aspect + DelegationAspect instead.\n\npytilities.geometry \n'''''''''''''''''''\n\n:Added:\n    - DiscreteVector, DiscreteRectangle: A Vector/Rectangle with a discrete\n      coordinate space. All aspects and views for Vector/Rectangle work on\n      these as well.\n    - verbose_rectangle_aspect, verbose_vector_aspect: Aspects to make a\n      Rectangle/Vector send out (change) events.\n    - ImmutableRectangle, ImmutableVector: immutable views of a\n      Rectangle/Vector\n    - immutable_rectangle_aspect, immutable_vector_aspect: makes a\n      Rectangle/Vector immutable\n\n:Changed:\n    - Vector, Rectangle: Due to a change in int division mechanisms in python3,\n      these classes will always operate with a continuous coordinate space. I.e\n      if your vector has coords (3, 1), then when divided by 2 they become\n      (1.5, 0.5) and not (1, 0) as they used to be in previous versions. Use\n      DiscreteVector and DiscreteRectangle instead, to get similar behaviour\n      back.\n    - Vector, DiscreteVector: have an extra overload for assign that accepts\n      (x,y) as args\n\n:Removed:\n    - BoundVector: use Vector directly instead (use its bound properties\n      overload)\n    - VerboseVector: make a Vector and do verbose_vector_aspect.apply(v)\n      instead. This works for DiscreteVectors as well.\n    - VerboseRectangle: make a Rectangle and do\n      verbose_rectangle_aspect.apply(v) instead. This works for DiscreteVectors\n      as well.\n\npytilities.overloading \n''''''''''''''''''''''\n\n:Changed:\n    - overloaded: its returned function now has a process_args method as well\n    - Parameter: its ctor was incorrectly overloaded (ironically). This has\n      been fixed, its overloads changed slightly because of this.\n\npytilities.infinity (new) \n'''''''''''''''''''''''''\n\nProvides a cross-platform alternative to float('inf').\n\n:Added:\n    - infinity, negative_infinity, nan\n    - is_infinity\n\npytilities.tests \n''''''''''''''''\n\n:Added:\n    - is_public, is_protected, is_private, is_special: attribute name checks\n\n\n0.1.4\n-----\n\n- Mangle, mangling and event.dispatcher: fixed a slight name clash\n- Overhauled testing, it is now easier to use\n- Removed inheritance feature of DelegatorFactory, it was too vague\n- Removed __init_delegation_profiles, there are other ways to achieve the same\n  thing\n- Changed the DelegatorFactory interface so that it is hopefully more intuitive\n  to use\n- Added all set operators to delegation.Profile\n- Added more tests and fixed some docstrings\n- RestrictedDispatcher: Made allow and disallow mutually exclusive. It made no\n  sense to specify both\n\n\n0.1.3\n-----\n\n- Added html reference documentation\n\n\n0.1.2\n-----\n\n- Added runtests.py, which allows running unit tests\n- Added the types package (forgot this in last release)\n\n\n0.1.1\n-----\n\n- Fixed: the last release wouldn't parse\n\n\n0.1.0\n-----\n\n- Initial release: delegation tools, events, overloading, ...\n\n"
)
    