# Copyright (C) 2010 Tim Diels <limyreth@users.sourceforge.net>
# 
# This file is part of pytilities.
# 
# pytilities is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# pytilities is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with pytilities.  If not, see <http://www.gnu.org/licenses/>.
#

__docformat__ = 'reStructuredText'

from pytilities.aop.aspects import ImmutableAspect, create_view

immutable_rectangle_aspect = ImmutableAspect(('left', 'top', 'right', 'bottom'))

ImmutableRectangle = create_view(immutable_rectangle_aspect)
ImmutableRectangle.__doc__ = """
    An immutable view of a `Rectangle` or `DiscreteRectangle`.
    
    All tries to mutate the rectangle will result in an exception.
    """

