/**
* @author ٺط
* @company ӹɷ޹˾
* @file HSTradeApi.h
* @brief ˽׽ӿ
* @date    20170927
*/
#ifndef _HS_TRADE_API_H_
#define _HS_TRADE_API_H_

#include "HSStruct.h"

#ifdef WIN32
    #define TRADE_API_EXPORT
#else
    #ifdef HSTRADEAPI_EXPORTS
        #define TRADE_API_EXPORT __attribute__((visibility("default"))) 
    #else
        #define TRADE_API_EXPORT
    #endif
#endif

/// ص
class CHSTradeSpi
{
public:
    /// Description: ͻ뽻׺̨ʼͨӣӳɹ˷ص
    virtual void OnFrontConnected(){};

    /// Description:ͻ뽻׺̨ͨ쳣ʱ÷á
    /// Others     :ͨGetApiErrorMsg(nResult)ȡϸϢ
    virtual void OnFrontDisconnected(int nResult){};

	/// Description:ͻ֤
	virtual void OnRspAuthenticate(CHSRspAuthenticateField *pRspAuthenticate, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ͻ¼
    virtual void OnRspUserLogin(CHSRspUserLoginField *pRspUserLogin, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:
    virtual void OnRspUserPasswordUpdate(CHSRspUserPasswordUpdateField *pRspUserPasswordUpdate, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:¼
    /// Others     :˷صpRspOrderInsertʱĽṹݡ
    virtual void OnRspErrorOrderInsert(CHSRspOrderInsertField *pRspOrderInsert, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:
    virtual void OnRspOrderAction(CHSRspOrderActionField *pRspOrderAction, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ȩ¼
    /// Others     :Ȩ¼˷صpRspExerciseOrderInsertʱĽṹݡ
    virtual void OnRspErrorExerciseOrderInsert(CHSRspExerciseOrderInsertField *pRspExerciseOrderInsert, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ȩ
    virtual void OnRspExerciseOrderAction(CHSRspExerciseOrderActionField *pRspExerciseOrderAction, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:¼
    /// Others     :˷صpRspExerciseOrderActionʱĽṹݡ
    virtual void OnRspErrorLockInsert(CHSRspLockInsertField *pRspExerciseOrderAction, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ѯ¼
    virtual void OnRspForQuoteInsert(CHSRspForQuoteInsertField *pRspForQuoteInsert, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:¼
    virtual void OnRspErrorCombActionInsert(CHSRspCombActionInsertField *pRspCombActionInsert, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:󱨵ȡ
    virtual void OnRspQueryMaxOrderVolume(CHSRspQueryMaxOrderVolumeField *pRspQueryMaxOrderVolume, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ȡ
    virtual void OnRspQueryLockVolume(CHSRspQueryLockVolumeField *pRspQueryLockVolume, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ȩȡ
    virtual void OnRspQueryExerciseVolume(CHSRspQueryExerciseVolumeField *pRspQueryExerciseVolume, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ֲֲѯ
    virtual void OnRspQryPosition(CHSRspQryPositionField *pRspQryPosition, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ʽ˻ѯ
    virtual void OnRspQryTradingAccount(CHSRspQryTradingAccountField *pRspQryTradingAccount, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ѯ
    virtual void OnRspQryOrder(CHSOrderField *pRspQryOrder, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ɽѯ
    virtual void OnRspQryTrade(CHSTradeField *pRspQryTrade, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ȩѯ
    virtual void OnRspQryExercise(CHSExerciseField *pRspQryExercise, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ѯ
    virtual void OnRspQryLock(CHSLockField *pRspQryLock, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ϲѯ
    virtual void OnRspQryCombAction(CHSCombActionField *pRspQryCombAction, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ϳֲϸѯ
    virtual void OnRspQryPositionCombineDetail(CHSRspQryPositionCombineDetailField *pRspQryPositionCombineDetail, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ԼϢѯ
    virtual void OnRspQryInstrument(CHSRspQryInstrumentField *pRspQryInstrument, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ȱڲѯ
    virtual void OnRspQryCoveredShort(CHSRspQryCoveredShortField *pRspQryCoveredShort, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ȩָɲѯ
    virtual void OnRspQryExerciseAssign(CHSRspQryExerciseAssignField *pRspQryExerciseAssign, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ת
    virtual void OnRspTransfer(CHSRspTransferField *pRspTransfer, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ת˲ѯ
    virtual void OnRspQryTransfer(CHSRspQryTransferField *pRspQryTransfer, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ѯ
    virtual void OnRspQueryBankBalance(CHSRspQueryBankBalanceField *pRspQueryBankBalance, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:˻ѯ
    virtual void OnRspQueryBankAccount(CHSRspQueryBankAccountField *pRspQueryBankAccount, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ͻ˵ѯ
    virtual void OnRspQueryBillContent(CHSRspQueryBillContentField *pRspQueryBillContent, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ͻ˵ȷ
    virtual void OnRspBillConfirm(CHSRspBillConfirmField *pRspBillConfirm, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:֤ѯ
    virtual void OnRspQryMargin(CHSRspQryMarginField *pRspQryMargin, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:Ѳѯ
    virtual void OnRspQryCommission(CHSRspQryCommissionField *pRspQryCommission, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ֲϸѯ
    virtual void OnRspQryPositionDetail(CHSRspQryPositionDetailField *pRspQryPositionDetail, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    // Description:ʲѯ
    virtual void OnRspQryExchangeRate(CHSRspQryExchangeRateField *pRspQryExchangeRate, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:͹˾òѯ
    virtual void OnRspQrySysConfig(CHSRspQrySysConfigField *pRspQrySysConfig, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description:ѯ
    virtual void OnRspQryDepthMarketData(CHSDepthMarketDataField *pRspQryDepthMarketData, CHSRspInfoField *pRspInfo, int nRequestID, bool bIsLast){};

    /// Description: -ɽر
    virtual void OnRtnTrade(CHSTradeField *pRtnTrade) {};

    /// Description: -ر
    virtual void OnRtnOrder(CHSOrderField *pRtnOrder) {};

    /// Description: -Ȩ
    virtual void OnRtnExercise(CHSExerciseField *pRtnExercise) {};

    /// Description: -
    virtual void OnRtnCombAction(CHSCombActionField *pRtnCombAction) {};

    /// Description: -
    virtual void OnRtnLock(CHSLockField *pRtnLock) {};
};

///
class  CHSTradeApi
{
public:
    /// Description: ɾӿڶ
    virtual void ReleaseApi() = 0;

    /// Description: ʼ
    ///              pszLicFile            ͨѶ֤
    ///              pszSafeLevel          ȫ
    ///              pszPwd                ͨѶ
    ///              pszSslFile            SSL֤
    ///              pszSslPwd             SSL
    virtual int Init(const char *pszLicFile, const char *pszSafeLevel = "", const char *pszPwd = "", const char *pszSslFile = "", const char *pszSslPwd = "") = 0;

    /// Description: APIͽ׹̨ӣӽɹ̻߳ȴû߳˳
    /// Return     : int 0ʾӽɹʾʧܣͨGetApiErrorMsgԻȡϸϢ
    virtual int Join() = 0;

    /// Description: עᶩģʽδ֧֣
    /// Input      : ķʽ
    ///                 HS_TERT_RESTART://ӱտʼش
    ///                 HS_TERT_RESUME: //ϴյ
    ///                 HS_TERT_QUICK:  //ӵ¼µĿʼ
    virtual int RegisterSubModel(const char *pszSubModel) = 0;

    /// Description: עǰûַ
    /// Input      : pszFrontAddress           ǰûַ 磺tcp://127.0.0.1:17001
    /// Return     : int 0ʾóɹʾʧܣͨGetApiErrorMsgԻȡϸϢ
    virtual int RegisterFront(const char *pszFrontAddress) = 0;

    /// Description: עFensַ
    /// Input      : pszFensAddress            Fensַ
    /// Input      : pszAccountID              ˺
    /// Return     : int 0ʾóɹʾʧܣͨGetApiErrorMsgԻȡϸϢ
    virtual int RegisterFensServer(const char *pszFensAddress, const char *pszAccountID) = 0;

    /// Description: עصӿ
    /// Input      : pSpi            Իصӿʵ     
    virtual void RegisterSpi(CHSTradeSpi *pSpi) = 0;

    /// Description: ôϸϢ
    virtual const char* GetApiErrorMsg(int nErrorCode) = 0;

    /// Description: ȡǰ
    virtual int GetTradingDate() = 0;

    /// Description: ֤ 
    virtual int ReqAuthenticate(CHSReqAuthenticateField *pReqAuthenticate,int nRequestID) = 0;

    /// Description:ͻ¼
    virtual int  ReqUserLogin(CHSReqUserLoginField *pReqUserLogin, int nRequestID) = 0;

    /// Description:
    virtual int  ReqUserPasswordUpdate(CHSReqUserPasswordUpdateField *pReqUserPasswordUpdate, int nRequestID) = 0;

    /// Description:¼
    virtual int  ReqOrderInsert(CHSReqOrderInsertField *pReqOrderInsert, int nRequestID) = 0;

    /// Description:
    virtual int  ReqOrderAction(CHSReqOrderActionField *pReqOrderAction, int nRequestID) = 0;

    /// Description:Ȩ¼
    virtual int  ReqExerciseOrderInsert(CHSReqExerciseOrderInsertField *pReqExerciseOrderInsert, int nRequestID) = 0;

    /// Description:Ȩ
    virtual int  ReqExerciseOrderAction(CHSReqExerciseOrderActionField *pReqExerciseOrderAction, int nRequestID) = 0;

    /// Description:¼
    virtual int  ReqLockInsert(CHSReqLockInsertField *pReqLockInsert, int nRequestID) = 0;

    /// Description:ѯ¼
    virtual int  ReqForQuoteInsert(CHSReqForQuoteInsertField *pReqForQuoteInsert, int nRequestID) = 0;

    /// Description:¼
    virtual int  ReqCombActionInsert(CHSReqCombActionInsertField *pReqCombActionInsert, int nRequestID) = 0;

    /// Description:󱨵ȡ
    virtual int  ReqQueryMaxOrderVolume(CHSReqQueryMaxOrderVolumeField *pReqQueryMaxOrderVolume, int nRequestID) = 0;

    /// Description:ȡ
    virtual int  ReqQueryLockVolume(CHSReqQueryLockVolumeField *pReqQueryLockVolume, int nRequestID) = 0;

    /// Description:Ȩȡ
    virtual int  ReqQueryExerciseVolume(CHSReqQueryExerciseVolumeField *pReqQueryExerciseVolume, int nRequestID) = 0;

    /// Description:ֲֻܲѯ
    virtual int  ReqQryPosition(CHSReqQryPositionField *pReqQryPosition, int nRequestID) = 0;

    /// Description:ʽ˻ѯ
    virtual int  ReqQryTradingAccount(CHSReqQryTradingAccountField *pReqQryTradingAccount, int nRequestID) = 0;

    /// Description:ѯ
    virtual int  ReqQryOrder(CHSReqQryOrderField *pReqQryOrder, int nRequestID) = 0;

    /// Description:ɽѯ
    virtual int  ReqQryTrade(CHSReqQryTradeField *pReqQryTrade, int nRequestID) = 0;

    /// Description:Ȩѯ
    virtual int  ReqQryExercise(CHSReqQryExerciseField *pReqQryExercise, int nRequestID) = 0;

    /// Description:ѯ
    virtual int  ReqQryLock(CHSReqQryLockField *pReqQryLock, int nRequestID) = 0;

    /// Description:ϲѯ
    virtual int  ReqQryCombAction(CHSReqQryCombActionField *pReqQryCombAction, int nRequestID) = 0;

    /// Description:ϳֲϸѯ
    virtual int  ReqQryPositionCombineDetail(CHSReqQryPositionCombineDetailField *pReqQryPositionCombineDetail, int nRequestID) = 0;

    /// Description:ԼϢѯ
    virtual int  ReqQryInstrument(CHSReqQryInstrumentField *pReqQryInstrument, int nRequestID) = 0;

    /// Description:ȱڲѯ
    virtual int  ReqQryCoveredShort(CHSReqQryCoveredShortField *pReqQryCoveredShort, int nRequestID) = 0;

    /// Description:Ȩָɲѯ
    virtual int  ReqQryExerciseAssign(CHSReqQryExerciseAssignField *pReqQryExerciseAssign, int nRequestID) = 0;

    /// Description:ת
    virtual int  ReqTransfer(CHSReqTransferField *pReqTransfer, int nRequestID) = 0;

    /// Description:ת˲ѯ
    virtual int  ReqQryTransfer(CHSReqQryTransferField *pReqQryTransfer, int nRequestID) = 0;

    /// Description:ѯ
    virtual int  ReqQueryBankBalance(CHSReqQueryBankBalanceField *pReqQueryBankBalance, int nRequestID) = 0;

    /// Description:˻ѯ
    virtual int  ReqQueryBankAccount(CHSReqQueryBankAccountField *pReqQueryBankAccount, int nRequestID) = 0;

    /// Description:ͻ˵ѯ
    virtual int  ReqQueryBillContent(CHSReqQueryBillContentField *pReqQueryBillContent, int nRequestID) = 0;

    /// Description:ͻ˵ȷ
    virtual int  ReqBillConfirm(CHSReqBillConfirmField *pReqBillConfirm, int nRequestID) = 0;

    /// Description:֤ѯ
    virtual int  ReqQryMargin(CHSReqQryMarginField *pReqQryMargin, int nRequestID) = 0;

    /// Description:Ѳѯ
    virtual int  ReqQryCommission(CHSReqQryCommissionField *pReqQryCommission, int nRequestID) = 0;

	/// Description:ʲѯ
	virtual int  ReqQryExchangeRate(CHSReqQryExchangeRateField *pReqQryExchangeRate, int nRequestID) = 0;

    /// Description:ֲϸѯ
    virtual int  ReqQryPositionDetail(CHSReqQryPositionDetailField *pReqQryPositionDetail, int nRequestID) = 0;

    /// Description:͹˾òѯ
    virtual int  ReqQrySysConfig(CHSReqQrySysConfigField *pReqQrySysConfig, int nRequestID) = 0;

    /// Description:ѯ
    virtual int  ReqQryDepthMarketData(CHSReqQryDepthMarketDataField *pReqQryDepthMarketData, int nRequestID) = 0;
protected:
    ~CHSTradeApi(){};
};

#ifdef __cplusplus
extern "C"
{
#endif
    /// Description: ȡAPI汾
    TRADE_API_EXPORT const char*  GetTradeApiVersion();

    /// Description: ׽ӿ    
    /// Input      : pszFlowPath    ־·   
    TRADE_API_EXPORT CHSTradeApi* NewTradeApi(const char *pszFlowPath);

#ifdef __cplusplus
}
#endif
#endif


