# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_filters_groups', 'django_filters_groups.templatetags']

package_data = \
{'': ['*'],
 'django_filters_groups': ['static/django_filters_groups/*',
                           'templates/django_filters_groups/*']}

install_requires = \
['Django>=2', 'django-filter>=2.4.0']

setup_kwargs = {
    'name': 'django-filter-groups',
    'version': '0.4.1',
    'description': '',
    'long_description': '# django filter groups\n\nThis package groups filters generated by django-filter\nThe main reason to use it - don\'t show all filters (show only selected filters)\n\n## how to use\n```\npip install django-filter-groups\n```\nadd to your `INSTALLED_APPS` after `django-filter`\n```python\nINSTALLED_APPS = [\n  ...\n  "django_filters",\n  "django_filters_groups",\n  ...\n]\n```\n\nuse it in your template:\n- add `{% add_select_filter_form_to_context %}` to the top of your template. \n  It allows you to place `{{ select_filter_form.media }}` anywhere you want\n- add `{% filters_by_groups %}`\n- add `{{ select_filter_form.media }}`\n\nIf FilterSet name is not \'filter\' -> add filterset \\\n`{% add_select_filter_form_to_context my_custom_filterset %}`\\\n`{% filters_by_groups my_custom_filterset %}`\nor filterset name\n`{% filters_by_groups "my_custom_filterset" %}`\n`{% add_select_filter_form_to_context "my_custom_filterset" %}`\n\n\n## default settings\n\n```\n# django settings\nFILTERS_GROUPS_SELECT_FILTER_FORM_LABEL = "Select a label"\n```\n```js\n// static/django_filters_groups/filter-defaults.js\nlet filterDefaults = {\n  filterWrapperSelector: "p", // p is necessary when you use {{ form.as_p }}\n  submitOnFilterDelete: false,\n};\n```\n\n## change group name\nYou can set group name directly in 2 ways:\n- add `filter_group_label` to your custom filter\n```python\nclass FFieldCountFilter(django_filters.NumberFilter):\n    filter_group_label = "custom_group_label"\n```\n- use `get_filter_class_with_custom_label`\n```python\nfrom django_filters_groups.utils import get_filter_class_with_group_label\n\nclass MyFilterSet(django_filters.FilterSet):\n  custom_filter = get_filter_class_with_group_label(django_filters.NumberFilter, "hello1111")(label="1123")\n```\n',
    'author': 'pnoryk',
    'author_email': 'pnoryk@mail.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/PNoryk/django-filter-groups',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
