#!/usr/bin/env python3
# -*- coding: utf-8 -*-
from refinery.lib import chunks

from refinery.units.crypto.cipher import Arg, StreamCipherUnit
from refinery.lib.crypto import rotl32

from array import array


class Sosemanuk:

    lfsr0: int
    lfsr1: int
    lfsr2: int
    lfsr3: int
    lfsr4: int
    lfsr5: int
    lfsr6: int
    lfsr7: int
    lfsr8: int
    lfsr9: int
    fsmR1: int
    fsmR2: int

    def __init__(self, key: bytearray, nonce: bytearray):
        self.mul_alpha = array('I')
        self.div_alpha = array('I')
        self.serpent24_sub_keys = [0] * 100
        expb = bytearray(0x100)
        logb = bytearray(0x100)
        x = 1
        for i in range(0xFF):
            expb[i] = x
            x <<= 1
            if x > 0xFF:
                x ^= 0x1A9
        expb[0xFF] = 0
        assert set(expb) == set(range(0x100))
        for i in range(0x100):
            logb[expb[i]] = i
        self.mul_alpha.append(0x00000000)
        self.div_alpha.append(0x00000000)
        for x in range(1, 0x100):
            ma, da, ex = 0, 0, logb[x]
            ma |= expb[(ex + 0x17) % 255] << 0x18
            ma |= expb[(ex + 0xF5) % 255] << 0x10
            ma |= expb[(ex + 0x30) % 255] << 0x08
            ma |= expb[(ex + 0xEF) % 255] << 0x00
            da |= expb[(ex + 0x10) % 255] << 0x18
            da |= expb[(ex + 0x27) % 255] << 0x10
            da |= expb[(ex + 0x06) % 255] << 0x08
            da |= expb[(ex + 0x40) % 255] << 0x00
            self.mul_alpha.append(ma)
            self.div_alpha.append(da)

        self._set_secret(key)
        self._set_vector(nonce)

    def _set_secret(self, key: bytearray):
        n = len(key)
        if not 1 <= n <= 32:
            raise ValueError('bad key length')
        lkey = bytearray(32)
        lkey[:n] = key
        if n < 32:
            lkey[n] = 0x01

        i = 0

        w0, w1, w2, w3, w4, w5, w6, w7 = chunks.unpack(lkey, 4)
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779b9
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779b8
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779bb
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779ba
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r0
        r0 |= r3
        r3 ^= r1
        r1 &= r4
        r4 ^= r2
        r2 ^= r3
        r3 &= r0
        r4 |= r1
        r3 ^= r4
        r0 ^= r1
        r4 &= r0
        r1 ^= r3
        r4 ^= r2
        r1 |= r0
        r1 ^= r2
        r0 ^= r3
        r2 = r1
        r1 |= r3
        r1 ^= r0
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779bd
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779bc
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779bf
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779be
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r4 = r0
        r0 &= r2
        r0 ^= r3
        r2 ^= r1
        r2 ^= r0
        r3 |= r4
        r3 ^= r1
        r4 ^= r2
        r1 = r3
        r3 |= r4
        r3 ^= r0
        r0 &= r1
        r4 ^= r0
        r1 ^= r3
        r1 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779b1
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779b0
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779b3
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779b2
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 = ~r0 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r0
        r0 &= r1
        r2 ^= r0
        r0 |= r3
        r3 ^= r2
        r1 ^= r0
        r0 ^= r4
        r4 |= r1
        r1 ^= r3
        r2 |= r0
        r2 &= r4
        r0 ^= r1
        r1 &= r2
        r1 ^= r0
        r0 &= r2
        r0 ^= r4
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779b5
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779b4
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779b7
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779b6
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r4 ^= r2
        r1 ^= r0
        r0 |= r3
        r0 ^= r4
        r4 ^= r3
        r3 ^= r2
        r2 |= r1
        r2 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        r4 |= r1
        r1 ^= r3
        r1 ^= r4
        r3 |= r0
        r1 ^= r3
        r4 ^= r3
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779a9
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779a8
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779ab
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779aa
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r1
        r1 |= r2
        r1 ^= r3
        r4 ^= r2
        r2 ^= r1
        r3 |= r4
        r3 &= r0
        r4 ^= r2
        r3 ^= r1
        r1 |= r4
        r1 ^= r0
        r0 |= r4
        r0 ^= r2
        r1 ^= r4
        r2 ^= r1
        r1 &= r0
        r1 ^= r4
        r2 = ~r2 & 0xFFFFFFFF
        r2 |= r0
        r4 ^= r2
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779ad
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779ac
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779af
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779ae
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r3
        r3 &= r0
        r0 ^= r4
        r3 ^= r2
        r2 |= r4
        r1 ^= r3
        r2 ^= r0
        r0 |= r1
        r2 ^= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r4 ^= r3
        r4 ^= r0
        r3 = ~r3 & 0xFFFFFFFF
        r2 &= r4
        r2 ^= r3
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779a1
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779a0
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779a3
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779a2
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 ^= r1
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r4 = r1
        r1 &= r0
        r2 ^= r3
        r1 ^= r2
        r2 |= r4
        r4 ^= r3
        r3 &= r1
        r3 ^= r0
        r4 ^= r1
        r4 ^= r2
        r2 ^= r0
        r0 &= r3
        r2 = ~r2 & 0xFFFFFFFF
        r0 ^= r4
        r4 |= r3
        r2 ^= r4
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779a5
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779a4
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779a7
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779a6
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r2 ^= r3
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r1 ^= r2
        r4 ^= r3
        r0 ^= r4
        r2 &= r4
        r2 ^= r0
        r0 &= r1
        r3 ^= r0
        r4 |= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r2 &= r3
        r0 = ~r0 & 0xFFFFFFFF
        r4 ^= r2
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e377999
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e377998
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e37799b
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e37799a
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r0
        r0 |= r3
        r3 ^= r1
        r1 &= r4
        r4 ^= r2
        r2 ^= r3
        r3 &= r0
        r4 |= r1
        r3 ^= r4
        r0 ^= r1
        r4 &= r0
        r1 ^= r3
        r4 ^= r2
        r1 |= r0
        r1 ^= r2
        r0 ^= r3
        r2 = r1
        r1 |= r3
        r1 ^= r0
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e37799d
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e37799c
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e37799f
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e37799e
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r4 = r0
        r0 &= r2
        r0 ^= r3
        r2 ^= r1
        r2 ^= r0
        r3 |= r4
        r3 ^= r1
        r4 ^= r2
        r1 = r3
        r3 |= r4
        r3 ^= r0
        r0 &= r1
        r4 ^= r0
        r1 ^= r3
        r1 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e377991
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e377990
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e377993
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e377992
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 = ~r0 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r0
        r0 &= r1
        r2 ^= r0
        r0 |= r3
        r3 ^= r2
        r1 ^= r0
        r0 ^= r4
        r4 |= r1
        r1 ^= r3
        r2 |= r0
        r2 &= r4
        r0 ^= r1
        r1 &= r2
        r1 ^= r0
        r0 &= r2
        r0 ^= r4
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e377995
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e377994
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e377997
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e377996
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r4 ^= r2
        r1 ^= r0
        r0 |= r3
        r0 ^= r4
        r4 ^= r3
        r3 ^= r2
        r2 |= r1
        r2 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        r4 |= r1
        r1 ^= r3
        r1 ^= r4
        r3 |= r0
        r1 ^= r3
        r4 ^= r3
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e377989
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e377988
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e37798b
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e37798a
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r1
        r1 |= r2
        r1 ^= r3
        r4 ^= r2
        r2 ^= r1
        r3 |= r4
        r3 &= r0
        r4 ^= r2
        r3 ^= r1
        r1 |= r4
        r1 ^= r0
        r0 |= r4
        r0 ^= r2
        r1 ^= r4
        r2 ^= r1
        r1 &= r0
        r1 ^= r4
        r2 = ~r2 & 0xFFFFFFFF
        r2 |= r0
        r4 ^= r2
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e37798d
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e37798c
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e37798f
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e37798e
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r3
        r3 &= r0
        r0 ^= r4
        r3 ^= r2
        r2 |= r4
        r1 ^= r3
        r2 ^= r0
        r0 |= r1
        r2 ^= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r4 ^= r3
        r4 ^= r0
        r3 = ~r3 & 0xFFFFFFFF
        r2 &= r4
        r2 ^= r3
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e377981
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e377980
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e377983
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e377982
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 ^= r1
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r4 = r1
        r1 &= r0
        r2 ^= r3
        r1 ^= r2
        r2 |= r4
        r4 ^= r3
        r3 &= r1
        r3 ^= r0
        r4 ^= r1
        r4 ^= r2
        r2 ^= r0
        r0 &= r3
        r2 = ~r2 & 0xFFFFFFFF
        r0 ^= r4
        r4 |= r3
        r2 ^= r4
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e377985
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e377984
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e377987
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e377986
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r2 ^= r3
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r1 ^= r2
        r4 ^= r3
        r0 ^= r4
        r2 &= r4
        r2 ^= r0
        r0 &= r1
        r3 ^= r0
        r4 |= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r2 &= r3
        r0 = ~r0 & 0xFFFFFFFF
        r4 ^= r2
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779f9
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779f8
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779fb
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779fa
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r0
        r0 |= r3
        r3 ^= r1
        r1 &= r4
        r4 ^= r2
        r2 ^= r3
        r3 &= r0
        r4 |= r1
        r3 ^= r4
        r0 ^= r1
        r4 &= r0
        r1 ^= r3
        r4 ^= r2
        r1 |= r0
        r1 ^= r2
        r0 ^= r3
        r2 = r1
        r1 |= r3
        r1 ^= r0
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779fd
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779fc
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779ff
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779fe
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r4 = r0
        r0 &= r2
        r0 ^= r3
        r2 ^= r1
        r2 ^= r0
        r3 |= r4
        r3 ^= r1
        r4 ^= r2
        r1 = r3
        r3 |= r4
        r3 ^= r0
        r0 &= r1
        r4 ^= r0
        r1 ^= r3
        r1 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779f1
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779f0
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779f3
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779f2
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 = ~r0 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r0
        r0 &= r1
        r2 ^= r0
        r0 |= r3
        r3 ^= r2
        r1 ^= r0
        r0 ^= r4
        r4 |= r1
        r1 ^= r3
        r2 |= r0
        r2 &= r4
        r0 ^= r1
        r1 &= r2
        r1 ^= r0
        r0 &= r2
        r0 ^= r4
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779f5
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779f4
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779f7
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779f6
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r4 ^= r2
        r1 ^= r0
        r0 |= r3
        r0 ^= r4
        r4 ^= r3
        r3 ^= r2
        r2 |= r1
        r2 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        r4 |= r1
        r1 ^= r3
        r1 ^= r4
        r3 |= r0
        r1 ^= r3
        r4 ^= r3
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779e9
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779e8
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779eb
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779ea
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r1
        r1 |= r2
        r1 ^= r3
        r4 ^= r2
        r2 ^= r1
        r3 |= r4
        r3 &= r0
        r4 ^= r2
        r3 ^= r1
        r1 |= r4
        r1 ^= r0
        r0 |= r4
        r0 ^= r2
        r1 ^= r4
        r2 ^= r1
        r1 &= r0
        r1 ^= r4
        r2 = ~r2 & 0xFFFFFFFF
        r2 |= r0
        r4 ^= r2
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779ed
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779ec
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779ef
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779ee
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r3
        r3 &= r0
        r0 ^= r4
        r3 ^= r2
        r2 |= r4
        r1 ^= r3
        r2 ^= r0
        r0 |= r1
        r2 ^= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r4 ^= r3
        r4 ^= r0
        r3 = ~r3 & 0xFFFFFFFF
        r2 &= r4
        r2 ^= r3
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779e1
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779e0
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779e3
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779e2
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r0 ^= r1
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r4 = r1
        r1 &= r0
        r2 ^= r3
        r1 ^= r2
        r2 |= r4
        r4 ^= r3
        r3 &= r1
        r3 ^= r0
        r4 ^= r1
        r4 ^= r2
        r2 ^= r0
        r0 &= r3
        r2 = ~r2 & 0xFFFFFFFF
        r0 ^= r4
        r4 |= r3
        r2 ^= r4
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        tt = w4 ^ w7 ^ w1 ^ w3 ^ 0x9e3779e5
        w4 = rotl32(tt, 11)
        tt = w5 ^ w0 ^ w2 ^ w4 ^ 0x9e3779e4
        w5 = rotl32(tt, 11)
        tt = w6 ^ w1 ^ w3 ^ w5 ^ 0x9e3779e7
        w6 = rotl32(tt, 11)
        tt = w7 ^ w2 ^ w4 ^ w6 ^ 0x9e3779e6
        w7 = rotl32(tt, 11)
        r0 = w4
        r1 = w5
        r2 = w6
        r3 = w7
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r2 ^= r3
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r1 ^= r2
        r4 ^= r3
        r0 ^= r4
        r2 &= r4
        r2 ^= r0
        r0 &= r1
        r3 ^= r0
        r4 |= r1
        r4 ^= r0
        r0 |= r3
        r0 ^= r2
        r2 &= r3
        r0 = ~r0 & 0xFFFFFFFF
        r4 ^= r2
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1
        self.serpent24_sub_keys[i] = r0
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        tt = w0 ^ w3 ^ w5 ^ w7 ^ 0x9e3779d9
        w0 = rotl32(tt, 11)
        tt = w1 ^ w4 ^ w6 ^ w0 ^ 0x9e3779d8
        w1 = rotl32(tt, 11)
        tt = w2 ^ w5 ^ w7 ^ w1 ^ 0x9e3779db
        w2 = rotl32(tt, 11)
        tt = w3 ^ w6 ^ w0 ^ w2 ^ 0x9e3779da
        w3 = rotl32(tt, 11)
        r0 = w0
        r1 = w1
        r2 = w2
        r3 = w3
        r4 = r0
        r0 |= r3
        r3 ^= r1
        r1 &= r4
        r4 ^= r2
        r2 ^= r3
        r3 &= r0
        r4 |= r1
        r3 ^= r4
        r0 ^= r1
        r4 &= r0
        r1 ^= r3
        r4 ^= r2
        r1 |= r0
        r1 ^= r2
        r0 ^= r3
        r2 = r1
        r1 |= r3
        r1 ^= r0
        self.serpent24_sub_keys[i] = r1
        i += 1
        self.serpent24_sub_keys[i] = r2
        i += 1
        self.serpent24_sub_keys[i] = r3
        i += 1
        self.serpent24_sub_keys[i] = r4
        i += 1

    def _set_vector(self, nonce: bytearray):
        n = len(nonce)
        if n > 16:
            raise ValueError('bad IV length')
        pnonce = bytearray(16)
        pnonce[:n] = nonce

        r0, r1, r2, r3 = chunks.unpack(pnonce, 4)

        r0 ^= self.serpent24_sub_keys[0]
        r1 ^= self.serpent24_sub_keys[0 + 1]
        r2 ^= self.serpent24_sub_keys[0 + 2]
        r3 ^= self.serpent24_sub_keys[0 + 3]
        r3 ^= r0
        r4 = r1
        r1 &= r3
        r4 ^= r2
        r1 ^= r0
        r0 |= r3
        r0 ^= r4
        r4 ^= r3
        r3 ^= r2
        r2 |= r1
        r2 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        r4 |= r1
        r1 ^= r3
        r1 ^= r4
        r3 |= r0
        r1 ^= r3
        r4 ^= r3
        r1 = rotl32(r1, 13)
        r2 = rotl32(r2, 3)
        r4 = r4 ^ r1 ^ r2
        r0 = r0 ^ r2 ^ (r1 << 3)
        r0 &= 0xFFFFFFFF
        r4 = rotl32(r4, 1)
        r0 = rotl32(r0, 7)
        r1 = r1 ^ r4 ^ r0
        r2 = r2 ^ r0 ^ (r4 << 7)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r2 = rotl32(r2, 22)
        r1 ^= self.serpent24_sub_keys[4]
        r4 ^= self.serpent24_sub_keys[4 + 1]
        r2 ^= self.serpent24_sub_keys[4 + 2]
        r0 ^= self.serpent24_sub_keys[4 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r3 = r1
        r1 &= r4
        r2 ^= r1
        r1 |= r0
        r0 ^= r2
        r4 ^= r1
        r1 ^= r3
        r3 |= r4
        r4 ^= r0
        r2 |= r1
        r2 &= r3
        r1 ^= r4
        r4 &= r2
        r4 ^= r1
        r1 &= r2
        r1 ^= r3
        r2 = rotl32(r2, 13)
        r0 = rotl32(r0, 3)
        r1 = r1 ^ r2 ^ r0
        r4 = r4 ^ r0 ^ (r2 << 3)
        r4 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r4 = rotl32(r4, 7)
        r2 = r2 ^ r1 ^ r4
        r0 = r0 ^ r4 ^ (r1 << 7)
        r0 &= 0xFFFFFFFF
        r2 = rotl32(r2, 5)
        r0 = rotl32(r0, 22)
        r2 ^= self.serpent24_sub_keys[8]
        r1 ^= self.serpent24_sub_keys[8 + 1]
        r0 ^= self.serpent24_sub_keys[8 + 2]
        r4 ^= self.serpent24_sub_keys[8 + 3]
        r3 = r2
        r2 &= r0
        r2 ^= r4
        r0 ^= r1
        r0 ^= r2
        r4 |= r3
        r4 ^= r1
        r3 ^= r0
        r1 = r4
        r4 |= r3
        r4 ^= r2
        r2 &= r1
        r3 ^= r2
        r1 ^= r4
        r1 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r0 = rotl32(r0, 13)
        r1 = rotl32(r1, 3)
        r4 = r4 ^ r0 ^ r1
        r3 = r3 ^ r1 ^ (r0 << 3)
        r3 &= 0xFFFFFFFF
        r4 = rotl32(r4, 1)
        r3 = rotl32(r3, 7)
        r0 = r0 ^ r4 ^ r3
        r1 = r1 ^ r3 ^ (r4 << 7)
        r1 &= 0xFFFFFFFF
        r0 = rotl32(r0, 5)
        r1 = rotl32(r1, 22)
        r0 ^= self.serpent24_sub_keys[12]
        r4 ^= self.serpent24_sub_keys[12 + 1]
        r1 ^= self.serpent24_sub_keys[12 + 2]
        r3 ^= self.serpent24_sub_keys[12 + 3]
        r2 = r0
        r0 |= r3
        r3 ^= r4
        r4 &= r2
        r2 ^= r1
        r1 ^= r3
        r3 &= r0
        r2 |= r4
        r3 ^= r2
        r0 ^= r4
        r2 &= r0
        r4 ^= r3
        r2 ^= r1
        r4 |= r0
        r4 ^= r1
        r0 ^= r3
        r1 = r4
        r4 |= r3
        r4 ^= r0
        r4 = rotl32(r4, 13)
        r3 = rotl32(r3, 3)
        r1 = r1 ^ r4 ^ r3
        r2 = r2 ^ r3 ^ (r4 << 3)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r2 = rotl32(r2, 7)
        r4 = r4 ^ r1 ^ r2
        r3 = r3 ^ r2 ^ (r1 << 7)
        r3 &= 0xFFFFFFFF
        r4 = rotl32(r4, 5)
        r3 = rotl32(r3, 22)
        r4 ^= self.serpent24_sub_keys[16]
        r1 ^= self.serpent24_sub_keys[16 + 1]
        r3 ^= self.serpent24_sub_keys[16 + 2]
        r2 ^= self.serpent24_sub_keys[16 + 3]
        r1 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r3 ^= r2
        r2 ^= r4
        r0 = r1
        r1 &= r2
        r1 ^= r3
        r0 ^= r2
        r4 ^= r0
        r3 &= r0
        r3 ^= r4
        r4 &= r1
        r2 ^= r4
        r0 |= r1
        r0 ^= r4
        r4 |= r2
        r4 ^= r3
        r3 &= r2
        r4 = ~r4 & 0xFFFFFFFF
        r0 ^= r3
        r1 = rotl32(r1, 13)
        r4 = rotl32(r4, 3)
        r0 = r0 ^ r1 ^ r4
        r2 = r2 ^ r4 ^ (r1 << 3)
        r2 &= 0xFFFFFFFF
        r0 = rotl32(r0, 1)
        r2 = rotl32(r2, 7)
        r1 = r1 ^ r0 ^ r2
        r4 = r4 ^ r2 ^ (r0 << 7)
        r4 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r4 = rotl32(r4, 22)
        r1 ^= self.serpent24_sub_keys[20]
        r0 ^= self.serpent24_sub_keys[20 + 1]
        r4 ^= self.serpent24_sub_keys[20 + 2]
        r2 ^= self.serpent24_sub_keys[20 + 3]
        r1 ^= r0
        r0 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r3 = r0
        r0 &= r1
        r4 ^= r2
        r0 ^= r4
        r4 |= r3
        r3 ^= r2
        r2 &= r0
        r2 ^= r1
        r3 ^= r0
        r3 ^= r4
        r4 ^= r1
        r1 &= r2
        r4 = ~r4 & 0xFFFFFFFF
        r1 ^= r3
        r3 |= r2
        r4 ^= r3
        r0 = rotl32(r0, 13)
        r1 = rotl32(r1, 3)
        r2 = r2 ^ r0 ^ r1
        r4 = r4 ^ r1 ^ (r0 << 3)
        r4 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r4 = rotl32(r4, 7)
        r0 = r0 ^ r2 ^ r4
        r1 = r1 ^ r4 ^ (r2 << 7)
        r1 &= 0xFFFFFFFF
        r0 = rotl32(r0, 5)
        r1 = rotl32(r1, 22)
        r0 ^= self.serpent24_sub_keys[24]
        r2 ^= self.serpent24_sub_keys[24 + 1]
        r1 ^= self.serpent24_sub_keys[24 + 2]
        r4 ^= self.serpent24_sub_keys[24 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r3 = r4
        r4 &= r0
        r0 ^= r3
        r4 ^= r1
        r1 |= r3
        r2 ^= r4
        r1 ^= r0
        r0 |= r2
        r1 ^= r2
        r3 ^= r0
        r0 |= r4
        r0 ^= r1
        r3 ^= r4
        r3 ^= r0
        r4 = ~r4 & 0xFFFFFFFF
        r1 &= r3
        r1 ^= r4
        r0 = rotl32(r0, 13)
        r3 = rotl32(r3, 3)
        r2 = r2 ^ r0 ^ r3
        r1 = r1 ^ r3 ^ (r0 << 3)
        r1 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r1 = rotl32(r1, 7)
        r0 = r0 ^ r2 ^ r1
        r3 = r3 ^ r1 ^ (r2 << 7)
        r3 &= 0xFFFFFFFF
        r0 = rotl32(r0, 5)
        r3 = rotl32(r3, 22)
        r0 ^= self.serpent24_sub_keys[28]
        r2 ^= self.serpent24_sub_keys[28 + 1]
        r3 ^= self.serpent24_sub_keys[28 + 2]
        r1 ^= self.serpent24_sub_keys[28 + 3]
        r4 = r2
        r2 |= r3
        r2 ^= r1
        r4 ^= r3
        r3 ^= r2
        r1 |= r4
        r1 &= r0
        r4 ^= r3
        r1 ^= r2
        r2 |= r4
        r2 ^= r0
        r0 |= r4
        r0 ^= r3
        r2 ^= r4
        r3 ^= r2
        r2 &= r0
        r2 ^= r4
        r3 = ~r3 & 0xFFFFFFFF
        r3 |= r0
        r4 ^= r3
        r4 = rotl32(r4, 13)
        r2 = rotl32(r2, 3)
        r1 = r1 ^ r4 ^ r2
        r0 = r0 ^ r2 ^ (r4 << 3)
        r0 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r0 = rotl32(r0, 7)
        r4 = r4 ^ r1 ^ r0
        r2 = r2 ^ r0 ^ (r1 << 7)
        r2 &= 0xFFFFFFFF
        r4 = rotl32(r4, 5)
        r2 = rotl32(r2, 22)
        r4 ^= self.serpent24_sub_keys[32]
        r1 ^= self.serpent24_sub_keys[32 + 1]
        r2 ^= self.serpent24_sub_keys[32 + 2]
        r0 ^= self.serpent24_sub_keys[32 + 3]
        r0 ^= r4
        r3 = r1
        r1 &= r0
        r3 ^= r2
        r1 ^= r4
        r4 |= r0
        r4 ^= r3
        r3 ^= r0
        r0 ^= r2
        r2 |= r1
        r2 ^= r3
        r3 = ~r3 & 0xFFFFFFFF
        r3 |= r1
        r1 ^= r0
        r1 ^= r3
        r0 |= r4
        r1 ^= r0
        r3 ^= r0
        r1 = rotl32(r1, 13)
        r2 = rotl32(r2, 3)
        r3 = r3 ^ r1 ^ r2
        r4 = r4 ^ r2 ^ (r1 << 3)
        r4 &= 0xFFFFFFFF
        r3 = rotl32(r3, 1)
        r4 = rotl32(r4, 7)
        r1 = r1 ^ r3 ^ r4
        r2 = r2 ^ r4 ^ (r3 << 7)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r2 = rotl32(r2, 22)
        r1 ^= self.serpent24_sub_keys[36]
        r3 ^= self.serpent24_sub_keys[36 + 1]
        r2 ^= self.serpent24_sub_keys[36 + 2]
        r4 ^= self.serpent24_sub_keys[36 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r0 = r1
        r1 &= r3
        r2 ^= r1
        r1 |= r4
        r4 ^= r2
        r3 ^= r1
        r1 ^= r0
        r0 |= r3
        r3 ^= r4
        r2 |= r1
        r2 &= r0
        r1 ^= r3
        r3 &= r2
        r3 ^= r1
        r1 &= r2
        r1 ^= r0
        r2 = rotl32(r2, 13)
        r4 = rotl32(r4, 3)
        r1 = r1 ^ r2 ^ r4
        r3 = r3 ^ r4 ^ (r2 << 3)
        r3 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r3 = rotl32(r3, 7)
        r2 = r2 ^ r1 ^ r3
        r4 = r4 ^ r3 ^ (r1 << 7)
        r4 &= 0xFFFFFFFF
        r2 = rotl32(r2, 5)
        r4 = rotl32(r4, 22)
        r2 ^= self.serpent24_sub_keys[40]
        r1 ^= self.serpent24_sub_keys[40 + 1]
        r4 ^= self.serpent24_sub_keys[40 + 2]
        r3 ^= self.serpent24_sub_keys[40 + 3]
        r0 = r2
        r2 &= r4
        r2 ^= r3
        r4 ^= r1
        r4 ^= r2
        r3 |= r0
        r3 ^= r1
        r0 ^= r4
        r1 = r3
        r3 |= r0
        r3 ^= r2
        r2 &= r1
        r0 ^= r2
        r1 ^= r3
        r1 ^= r0
        r0 = ~r0 & 0xFFFFFFFF
        r4 = rotl32(r4, 13)
        r1 = rotl32(r1, 3)
        r3 = r3 ^ r4 ^ r1
        r0 = r0 ^ r1 ^ (r4 << 3)
        r0 &= 0xFFFFFFFF
        r3 = rotl32(r3, 1)
        r0 = rotl32(r0, 7)
        r4 = r4 ^ r3 ^ r0
        r1 = r1 ^ r0 ^ (r3 << 7)
        r1 &= 0xFFFFFFFF
        r4 = rotl32(r4, 5)
        r1 = rotl32(r1, 22)
        r4 ^= self.serpent24_sub_keys[44]
        r3 ^= self.serpent24_sub_keys[44 + 1]
        r1 ^= self.serpent24_sub_keys[44 + 2]
        r0 ^= self.serpent24_sub_keys[44 + 3]
        r2 = r4
        r4 |= r0
        r0 ^= r3
        r3 &= r2
        r2 ^= r1
        r1 ^= r0
        r0 &= r4
        r2 |= r3
        r0 ^= r2
        r4 ^= r3
        r2 &= r4
        r3 ^= r0
        r2 ^= r1
        r3 |= r4
        r3 ^= r1
        r4 ^= r0
        r1 = r3
        r3 |= r0
        r3 ^= r4
        r3 = rotl32(r3, 13)
        r0 = rotl32(r0, 3)
        r1 = r1 ^ r3 ^ r0
        r2 = r2 ^ r0 ^ (r3 << 3)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r2 = rotl32(r2, 7)
        r3 = r3 ^ r1 ^ r2
        r0 = r0 ^ r2 ^ (r1 << 7)
        r0 &= 0xFFFFFFFF
        r3 = rotl32(r3, 5)
        r0 = rotl32(r0, 22)
        self.lfsr9 = r3
        self.lfsr8 = r1
        self.lfsr7 = r0
        self.lfsr6 = r2
        r3 ^= self.serpent24_sub_keys[48]
        r1 ^= self.serpent24_sub_keys[48 + 1]
        r0 ^= self.serpent24_sub_keys[48 + 2]
        r2 ^= self.serpent24_sub_keys[48 + 3]
        r1 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r0 ^= r2
        r2 ^= r3
        r4 = r1
        r1 &= r2
        r1 ^= r0
        r4 ^= r2
        r3 ^= r4
        r0 &= r4
        r0 ^= r3
        r3 &= r1
        r2 ^= r3
        r4 |= r1
        r4 ^= r3
        r3 |= r2
        r3 ^= r0
        r0 &= r2
        r3 = ~r3 & 0xFFFFFFFF
        r4 ^= r0
        r1 = rotl32(r1, 13)
        r3 = rotl32(r3, 3)
        r4 = r4 ^ r1 ^ r3
        r2 = r2 ^ r3 ^ (r1 << 3)
        r2 &= 0xFFFFFFFF
        r4 = rotl32(r4, 1)
        r2 = rotl32(r2, 7)
        r1 = r1 ^ r4 ^ r2
        r3 = r3 ^ r2 ^ (r4 << 7)
        r3 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r3 = rotl32(r3, 22)
        r1 ^= self.serpent24_sub_keys[52]
        r4 ^= self.serpent24_sub_keys[52 + 1]
        r3 ^= self.serpent24_sub_keys[52 + 2]
        r2 ^= self.serpent24_sub_keys[52 + 3]
        r1 ^= r4
        r4 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r0 = r4
        r4 &= r1
        r3 ^= r2
        r4 ^= r3
        r3 |= r0
        r0 ^= r2
        r2 &= r4
        r2 ^= r1
        r0 ^= r4
        r0 ^= r3
        r3 ^= r1
        r1 &= r2
        r3 = ~r3 & 0xFFFFFFFF
        r1 ^= r0
        r0 |= r2
        r3 ^= r0
        r4 = rotl32(r4, 13)
        r1 = rotl32(r1, 3)
        r2 = r2 ^ r4 ^ r1
        r3 = r3 ^ r1 ^ (r4 << 3)
        r3 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r3 = rotl32(r3, 7)
        r4 = r4 ^ r2 ^ r3
        r1 = r1 ^ r3 ^ (r2 << 7)
        r1 &= 0xFFFFFFFF
        r4 = rotl32(r4, 5)
        r1 = rotl32(r1, 22)
        r4 ^= self.serpent24_sub_keys[56]
        r2 ^= self.serpent24_sub_keys[56 + 1]
        r1 ^= self.serpent24_sub_keys[56 + 2]
        r3 ^= self.serpent24_sub_keys[56 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r0 = r3
        r3 &= r4
        r4 ^= r0
        r3 ^= r1
        r1 |= r0
        r2 ^= r3
        r1 ^= r4
        r4 |= r2
        r1 ^= r2
        r0 ^= r4
        r4 |= r3
        r4 ^= r1
        r0 ^= r3
        r0 ^= r4
        r3 = ~r3 & 0xFFFFFFFF
        r1 &= r0
        r1 ^= r3
        r4 = rotl32(r4, 13)
        r0 = rotl32(r0, 3)
        r2 = r2 ^ r4 ^ r0
        r1 = r1 ^ r0 ^ (r4 << 3)
        r1 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r1 = rotl32(r1, 7)
        r4 = r4 ^ r2 ^ r1
        r0 = r0 ^ r1 ^ (r2 << 7)
        r0 &= 0xFFFFFFFF
        r4 = rotl32(r4, 5)
        r0 = rotl32(r0, 22)
        r4 ^= self.serpent24_sub_keys[60]
        r2 ^= self.serpent24_sub_keys[60 + 1]
        r0 ^= self.serpent24_sub_keys[60 + 2]
        r1 ^= self.serpent24_sub_keys[60 + 3]
        r3 = r2
        r2 |= r0
        r2 ^= r1
        r3 ^= r0
        r0 ^= r2
        r1 |= r3
        r1 &= r4
        r3 ^= r0
        r1 ^= r2
        r2 |= r3
        r2 ^= r4
        r4 |= r3
        r4 ^= r0
        r2 ^= r3
        r0 ^= r2
        r2 &= r4
        r2 ^= r3
        r0 = ~r0 & 0xFFFFFFFF
        r0 |= r4
        r3 ^= r0
        r3 = rotl32(r3, 13)
        r2 = rotl32(r2, 3)
        r1 = r1 ^ r3 ^ r2
        r4 = r4 ^ r2 ^ (r3 << 3)
        r4 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r4 = rotl32(r4, 7)
        r3 = r3 ^ r1 ^ r4
        r2 = r2 ^ r4 ^ (r1 << 7)
        r2 &= 0xFFFFFFFF
        r3 = rotl32(r3, 5)
        r2 = rotl32(r2, 22)
        r3 ^= self.serpent24_sub_keys[64]
        r1 ^= self.serpent24_sub_keys[64 + 1]
        r2 ^= self.serpent24_sub_keys[64 + 2]
        r4 ^= self.serpent24_sub_keys[64 + 3]
        r4 ^= r3
        r0 = r1
        r1 &= r4
        r0 ^= r2
        r1 ^= r3
        r3 |= r4
        r3 ^= r0
        r0 ^= r4
        r4 ^= r2
        r2 |= r1
        r2 ^= r0
        r0 = ~r0 & 0xFFFFFFFF
        r0 |= r1
        r1 ^= r4
        r1 ^= r0
        r4 |= r3
        r1 ^= r4
        r0 ^= r4
        r1 = rotl32(r1, 13)
        r2 = rotl32(r2, 3)
        r0 = r0 ^ r1 ^ r2
        r3 = r3 ^ r2 ^ (r1 << 3)
        r3 &= 0xFFFFFFFF
        r0 = rotl32(r0, 1)
        r3 = rotl32(r3, 7)
        r1 = r1 ^ r0 ^ r3
        r2 = r2 ^ r3 ^ (r0 << 7)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r2 = rotl32(r2, 22)
        r1 ^= self.serpent24_sub_keys[68]
        r0 ^= self.serpent24_sub_keys[68 + 1]
        r2 ^= self.serpent24_sub_keys[68 + 2]
        r3 ^= self.serpent24_sub_keys[68 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r1
        r1 &= r0
        r2 ^= r1
        r1 |= r3
        r3 ^= r2
        r0 ^= r1
        r1 ^= r4
        r4 |= r0
        r0 ^= r3
        r2 |= r1
        r2 &= r4
        r1 ^= r0
        r0 &= r2
        r0 ^= r1
        r1 &= r2
        r1 ^= r4
        r2 = rotl32(r2, 13)
        r3 = rotl32(r3, 3)
        r1 = r1 ^ r2 ^ r3
        r0 = r0 ^ r3 ^ (r2 << 3)
        r0 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r0 = rotl32(r0, 7)
        r2 = r2 ^ r1 ^ r0
        r3 = r3 ^ r0 ^ (r1 << 7)
        r3 &= 0xFFFFFFFF
        r2 = rotl32(r2, 5)
        r3 = rotl32(r3, 22)
        self.fsmR1 = r2
        self.lfsr4 = r1
        self.fsmR2 = r3
        self.lfsr5 = r0
        r2 ^= self.serpent24_sub_keys[72]
        r1 ^= self.serpent24_sub_keys[72 + 1]
        r3 ^= self.serpent24_sub_keys[72 + 2]
        r0 ^= self.serpent24_sub_keys[72 + 3]
        r4 = r2
        r2 &= r3
        r2 ^= r0
        r3 ^= r1
        r3 ^= r2
        r0 |= r4
        r0 ^= r1
        r4 ^= r3
        r1 = r0
        r0 |= r4
        r0 ^= r2
        r2 &= r1
        r4 ^= r2
        r1 ^= r0
        r1 ^= r4
        r4 = ~r4 & 0xFFFFFFFF
        r3 = rotl32(r3, 13)
        r1 = rotl32(r1, 3)
        r0 = r0 ^ r3 ^ r1
        r4 = r4 ^ r1 ^ (r3 << 3)
        r4 &= 0xFFFFFFFF
        r0 = rotl32(r0, 1)
        r4 = rotl32(r4, 7)
        r3 = r3 ^ r0 ^ r4
        r1 = r1 ^ r4 ^ (r0 << 7)
        r1 &= 0xFFFFFFFF
        r3 = rotl32(r3, 5)
        r1 = rotl32(r1, 22)
        r3 ^= self.serpent24_sub_keys[76]
        r0 ^= self.serpent24_sub_keys[76 + 1]
        r1 ^= self.serpent24_sub_keys[76 + 2]
        r4 ^= self.serpent24_sub_keys[76 + 3]
        r2 = r3
        r3 |= r4
        r4 ^= r0
        r0 &= r2
        r2 ^= r1
        r1 ^= r4
        r4 &= r3
        r2 |= r0
        r4 ^= r2
        r3 ^= r0
        r2 &= r3
        r0 ^= r4
        r2 ^= r1
        r0 |= r3
        r0 ^= r1
        r3 ^= r4
        r1 = r0
        r0 |= r4
        r0 ^= r3
        r0 = rotl32(r0, 13)
        r4 = rotl32(r4, 3)
        r1 = r1 ^ r0 ^ r4
        r2 = r2 ^ r4 ^ (r0 << 3)
        r2 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r2 = rotl32(r2, 7)
        r0 = r0 ^ r1 ^ r2
        r4 = r4 ^ r2 ^ (r1 << 7)
        r4 &= 0xFFFFFFFF
        r0 = rotl32(r0, 5)
        r4 = rotl32(r4, 22)
        r0 ^= self.serpent24_sub_keys[80]
        r1 ^= self.serpent24_sub_keys[80 + 1]
        r4 ^= self.serpent24_sub_keys[80 + 2]
        r2 ^= self.serpent24_sub_keys[80 + 3]
        r1 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r4 ^= r2
        r2 ^= r0
        r3 = r1
        r1 &= r2
        r1 ^= r4
        r3 ^= r2
        r0 ^= r3
        r4 &= r3
        r4 ^= r0
        r0 &= r1
        r2 ^= r0
        r3 |= r1
        r3 ^= r0
        r0 |= r2
        r0 ^= r4
        r4 &= r2
        r0 = ~r0 & 0xFFFFFFFF
        r3 ^= r4
        r1 = rotl32(r1, 13)
        r0 = rotl32(r0, 3)
        r3 = r3 ^ r1 ^ r0
        r2 = r2 ^ r0 ^ (r1 << 3)
        r2 &= 0xFFFFFFFF
        r3 = rotl32(r3, 1)
        r2 = rotl32(r2, 7)
        r1 = r1 ^ r3 ^ r2
        r0 = r0 ^ r2 ^ (r3 << 7)
        r0 &= 0xFFFFFFFF
        r1 = rotl32(r1, 5)
        r0 = rotl32(r0, 22)
        r1 ^= self.serpent24_sub_keys[84]
        r3 ^= self.serpent24_sub_keys[84 + 1]
        r0 ^= self.serpent24_sub_keys[84 + 2]
        r2 ^= self.serpent24_sub_keys[84 + 3]
        r1 ^= r3
        r3 ^= r2
        r2 = ~r2 & 0xFFFFFFFF
        r4 = r3
        r3 &= r1
        r0 ^= r2
        r3 ^= r0
        r0 |= r4
        r4 ^= r2
        r2 &= r3
        r2 ^= r1
        r4 ^= r3
        r4 ^= r0
        r0 ^= r1
        r1 &= r2
        r0 = ~r0 & 0xFFFFFFFF
        r1 ^= r4
        r4 |= r2
        r0 ^= r4
        r3 = rotl32(r3, 13)
        r1 = rotl32(r1, 3)
        r2 = r2 ^ r3 ^ r1
        r0 = r0 ^ r1 ^ (r3 << 3)
        r0 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r0 = rotl32(r0, 7)
        r3 = r3 ^ r2 ^ r0
        r1 = r1 ^ r0 ^ (r2 << 7)
        r1 &= 0xFFFFFFFF
        r3 = rotl32(r3, 5)
        r1 = rotl32(r1, 22)
        r3 ^= self.serpent24_sub_keys[88]
        r2 ^= self.serpent24_sub_keys[88 + 1]
        r1 ^= self.serpent24_sub_keys[88 + 2]
        r0 ^= self.serpent24_sub_keys[88 + 3]
        r1 = ~r1 & 0xFFFFFFFF
        r4 = r0
        r0 &= r3
        r3 ^= r4
        r0 ^= r1
        r1 |= r4
        r2 ^= r0
        r1 ^= r3
        r3 |= r2
        r1 ^= r2
        r4 ^= r3
        r3 |= r0
        r3 ^= r1
        r4 ^= r0
        r4 ^= r3
        r0 = ~r0 & 0xFFFFFFFF
        r1 &= r4
        r1 ^= r0
        r3 = rotl32(r3, 13)
        r4 = rotl32(r4, 3)
        r2 = r2 ^ r3 ^ r4
        r1 = r1 ^ r4 ^ (r3 << 3)
        r1 &= 0xFFFFFFFF
        r2 = rotl32(r2, 1)
        r1 = rotl32(r1, 7)
        r3 = r3 ^ r2 ^ r1
        r4 = r4 ^ r1 ^ (r2 << 7)
        r4 &= 0xFFFFFFFF
        r3 = rotl32(r3, 5)
        r4 = rotl32(r4, 22)
        r3 ^= self.serpent24_sub_keys[92]
        r2 ^= self.serpent24_sub_keys[92 + 1]
        r4 ^= self.serpent24_sub_keys[92 + 2]
        r1 ^= self.serpent24_sub_keys[92 + 3]
        r0 = r2
        r2 |= r4
        r2 ^= r1
        r0 ^= r4
        r4 ^= r2
        r1 |= r0
        r1 &= r3
        r0 ^= r4
        r1 ^= r2
        r2 |= r0
        r2 ^= r3
        r3 |= r0
        r3 ^= r4
        r2 ^= r0
        r4 ^= r2
        r2 &= r3
        r2 ^= r0
        r4 = ~r4 & 0xFFFFFFFF
        r4 |= r3
        r0 ^= r4
        r0 = rotl32(r0, 13)
        r2 = rotl32(r2, 3)
        r1 = r1 ^ r0 ^ r2
        r3 = r3 ^ r2 ^ (r0 << 3)
        r3 &= 0xFFFFFFFF
        r1 = rotl32(r1, 1)
        r3 = rotl32(r3, 7)
        r0 = r0 ^ r1 ^ r3
        r2 = r2 ^ r3 ^ (r1 << 7)
        r2 &= 0xFFFFFFFF
        r0 = rotl32(r0, 5)
        r2 = rotl32(r2, 22)
        r0 ^= self.serpent24_sub_keys[96]
        r1 ^= self.serpent24_sub_keys[96 + 1]
        r2 ^= self.serpent24_sub_keys[96 + 2]
        r3 ^= self.serpent24_sub_keys[96 + 3]
        self.lfsr3 = r0
        self.lfsr2 = r1
        self.lfsr1 = r2
        self.lfsr0 = r3

    def generate_block(self):
        s0 = self.lfsr0
        s1 = self.lfsr1
        s2 = self.lfsr2
        s3 = self.lfsr3
        s4 = self.lfsr4
        s5 = self.lfsr5
        s6 = self.lfsr6
        s7 = self.lfsr7
        s8 = self.lfsr8
        s9 = self.lfsr9
        r1 = self.fsmR1
        r2 = self.fsmR2

        ma = self.mul_alpha
        da = self.div_alpha

        tt = r1
        r1 = r2 + (s1 ^ (s8 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v0 = s0
        s0 = ((s0 << 8) ^ ma[s0 >> 24]) ^ ((s3 >> 8) ^ da[s3 & 0xFF]) ^ s9
        s0 &= 0xFFFFFFFF
        f0 = (s9 + r1) ^ r2
        f0 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s2 ^ (s9 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v1 = s1
        s1 = ((s1 << 8) ^ ma[s1 >> 24]) ^ ((s4 >> 8) ^ da[s4 & 0xFF]) ^ s0
        s1 &= 0xFFFFFFFF
        f1 = (s0 + r1) ^ r2
        f1 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s3 ^ (s0 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v2 = s2
        s2 = ((s2 << 8) ^ ma[s2 >> 24]) ^ ((s5 >> 8) ^ da[s5 & 0xFF]) ^ s1
        s2 &= 0xFFFFFFFF
        f2 = (s1 + r1) ^ r2
        f2 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s4 ^ (s1 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v3 = s3
        s3 = ((s3 << 8) ^ ma[s3 >> 24]) ^ ((s6 >> 8) ^ da[s6 & 0xFF]) ^ s2
        s3 &= 0xFFFFFFFF
        f3 = (s2 + r1) ^ r2
        f3 &= 0xFFFFFFFF

        f4 = f0
        f0 &= f2
        f0 ^= f3
        f2 ^= f1
        f2 ^= f0
        f3 |= f4
        f3 ^= f1
        f4 ^= f2
        f1 = f3
        f3 |= f4
        f3 ^= f0
        f0 &= f1
        f4 ^= f0
        f1 ^= f3
        f1 ^= f4
        f4 = ~f4 & 0xFFFFFFFF

        yield from chunks.pack([f2 ^ v0, f3 ^ v1, f1 ^ v2, f4 ^ v3], 4)

        tt = r1
        r1 = r2 + (s5 ^ (s2 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v0 = s4
        s4 = ((s4 << 8) ^ ma[s4 >> 24]) ^ ((s7 >> 8) ^ da[s7 & 0xFF]) ^ s3
        s4 &= 0xFFFFFFFF
        f0 = (s3 + r1) ^ r2
        f0 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s6 ^ (s3 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v1 = s5
        s5 = ((s5 << 8) ^ ma[s5 >> 24]) ^ ((s8 >> 8) ^ da[s8 & 0xFF]) ^ s4
        s5 &= 0xFFFFFFFF
        f1 = (s4 + r1) ^ r2
        f1 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s7 ^ (s4 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v2 = s6
        s6 = ((s6 << 8) ^ ma[s6 >> 24]) ^ ((s9 >> 8) ^ da[s9 & 0xFF]) ^ s5
        s6 &= 0xFFFFFFFF
        f2 = (s5 + r1) ^ r2
        f2 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s8 ^ (s5 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v3 = s7
        s7 = ((s7 << 8) ^ ma[s7 >> 24]) ^ ((s0 >> 8) ^ da[s0 & 0xFF]) ^ s6
        s7 &= 0xFFFFFFFF
        f3 = (s6 + r1) ^ r2
        f3 &= 0xFFFFFFFF

        f4 = f0
        f0 &= f2
        f0 ^= f3
        f2 ^= f1
        f2 ^= f0
        f3 |= f4
        f3 ^= f1
        f4 ^= f2
        f1 = f3
        f3 |= f4
        f3 ^= f0
        f0 &= f1
        f4 ^= f0
        f1 ^= f3
        f1 ^= f4
        f4 = ~f4 & 0xFFFFFFFF

        yield from chunks.pack([f2 ^ v0, f3 ^ v1, f1 ^ v2, f4 ^ v3], 4)

        tt = r1
        r1 = r2 + (s9 ^ (s6 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v0 = s8
        s8 = ((s8 << 8) ^ ma[s8 >> 24]) ^ ((s1 >> 8) ^ da[s1 & 0xFF]) ^ s7
        s8 &= 0xFFFFFFFF
        f0 = (s7 + r1) ^ r2
        f0 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s0 ^ (s7 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v1 = s9
        s9 = ((s9 << 8) ^ ma[s9 >> 24]) ^ ((s2 >> 8) ^ da[s2 & 0xFF]) ^ s8
        s9 &= 0xFFFFFFFF
        f1 = (s8 + r1) ^ r2
        f1 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s1 ^ (s8 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v2 = s0
        s0 = ((s0 << 8) ^ ma[s0 >> 24]) ^ ((s3 >> 8) ^ da[s3 & 0xFF]) ^ s9
        s0 &= 0xFFFFFFFF
        f2 = (s9 + r1) ^ r2
        f2 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s2 ^ (s9 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v3 = s1
        s1 = ((s1 << 8) ^ ma[s1 >> 24]) ^ ((s4 >> 8) ^ da[s4 & 0xFF]) ^ s0
        s1 &= 0xFFFFFFFF
        f3 = (s0 + r1) ^ r2
        f3 &= 0xFFFFFFFF

        f4 = f0
        f0 &= f2
        f0 ^= f3
        f2 ^= f1
        f2 ^= f0
        f3 |= f4
        f3 ^= f1
        f4 ^= f2
        f1 = f3
        f3 |= f4
        f3 ^= f0
        f0 &= f1
        f4 ^= f0
        f1 ^= f3
        f1 ^= f4
        f4 = ~f4 & 0xFFFFFFFF

        yield from chunks.pack([f2 ^ v0, f3 ^ v1, f1 ^ v2, f4 ^ v3], 4)

        tt = r1
        r1 = r2 + (s3 ^ (s0 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v0 = s2
        s2 = ((s2 << 8) ^ ma[s2 >> 24]) ^ ((s5 >> 8) ^ da[s5 & 0xFF]) ^ s1
        s2 &= 0xFFFFFFFF
        f0 = (s1 + r1) ^ r2
        f0 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s4 ^ (s1 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v1 = s3
        s3 = ((s3 << 8) ^ ma[s3 >> 24]) ^ ((s6 >> 8) ^ da[s6 & 0xFF]) ^ s2
        s3 &= 0xFFFFFFFF
        f1 = (s2 + r1) ^ r2
        f1 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s5 ^ (s2 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v2 = s4
        s4 = ((s4 << 8) ^ ma[s4 >> 24]) ^ ((s7 >> 8) ^ da[s7 & 0xFF]) ^ s3
        s4 &= 0xFFFFFFFF
        f2 = (s3 + r1) ^ r2
        f2 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s6 ^ (s3 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v3 = s5
        s5 = ((s5 << 8) ^ ma[s5 >> 24]) ^ ((s8 >> 8) ^ da[s8 & 0xFF]) ^ s4
        s5 &= 0xFFFFFFFF
        f3 = (s4 + r1) ^ r2
        f3 &= 0xFFFFFFFF

        f4 = f0
        f0 &= f2
        f0 ^= f3
        f2 ^= f1
        f2 ^= f0
        f3 |= f4
        f3 ^= f1
        f4 ^= f2
        f1 = f3
        f3 |= f4
        f3 ^= f0
        f0 &= f1
        f4 ^= f0
        f1 ^= f3
        f1 ^= f4
        f4 = ~f4 & 0xFFFFFFFF

        yield from chunks.pack([f2 ^ v0, f3 ^ v1, f1 ^ v2, f4 ^ v3], 4)

        tt = r1
        r1 = r2 + (s7 ^ (s4 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v0 = s6
        s6 = ((s6 << 8) ^ ma[s6 >> 24]) ^ ((s9 >> 8) ^ da[s9 & 0xFF]) ^ s5
        s6 &= 0xFFFFFFFF
        f0 = (s5 + r1) ^ r2
        f0 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s8 ^ (s5 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v1 = s7
        s7 = ((s7 << 8) ^ ma[s7 >> 24]) ^ ((s0 >> 8) ^ da[s0 & 0xFF]) ^ s6
        s7 &= 0xFFFFFFFF
        f1 = (s6 + r1) ^ r2
        f1 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s9 ^ (s6 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v2 = s8
        s8 = ((s8 << 8) ^ ma[s8 >> 24]) ^ ((s1 >> 8) ^ da[s1 & 0xFF]) ^ s7
        s8 &= 0xFFFFFFFF
        f2 = (s7 + r1) ^ r2
        f2 &= 0xFFFFFFFF

        tt = r1
        r1 = r2 + (s0 ^ (s7 if r1 & 1 else 0))
        r1 &= 0xFFFFFFFF
        r2 = rotl32(tt * 0x54655307 & 0xFFFFFFFF, 7)
        v3 = s9
        s9 = ((s9 << 8) ^ ma[s9 >> 24]) ^ ((s2 >> 8) ^ da[s2 & 0xFF]) ^ s8
        s9 &= 0xFFFFFFFF
        f3 = (s8 + r1) ^ r2
        f3 &= 0xFFFFFFFF

        f4 = f0
        f0 &= f2
        f0 ^= f3
        f2 ^= f1
        f2 ^= f0
        f3 |= f4
        f3 ^= f1
        f4 ^= f2
        f1 = f3
        f3 |= f4
        f3 ^= f0
        f0 &= f1
        f4 ^= f0
        f1 ^= f3
        f1 ^= f4
        f4 = ~f4 & 0xFFFFFFFF

        yield from chunks.pack([f2 ^ v0, f3 ^ v1, f1 ^ v2, f4 ^ v3], 4)

        self.lfsr0 = s0
        self.lfsr1 = s1
        self.lfsr2 = s2
        self.lfsr3 = s3
        self.lfsr4 = s4
        self.lfsr5 = s5
        self.lfsr6 = s6
        self.lfsr7 = s7
        self.lfsr8 = s8
        self.lfsr9 = s9
        self.fsmR1 = r1
        self.fsmR2 = r2

    def __iter__(self):
        while True:
            yield from self.generate_block()


class sosemanuk(StreamCipherUnit):

    def __init__(
        self, key, stateful=False, discard=0,
        nonce: Arg(help='The nonce. Default is empty, which is equivalent to 16 null bytes.') = B'',
    ):
        super().__init__(key=key, nonce=nonce, stateful=stateful, discard=discard)

    def keystream(self):
        yield from Sosemanuk(self.args.key, self.args.nonce)
