import setuptools

from qctic.__version__ import __version__

setuptools.setup(
    name="qctic",
    version=__version__,
    keywords="quantum simulator qiskit",
    author="Andres Garcia Mangas",
    author_email="andres.garcia@fundacionctic.org",
    description="Qiskit provider to interact with the CTIC Erwin quantum simulator platform",
    packages=setuptools.find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "License :: OSI Approved :: MIT License"
    ],
    python_requires=">=3.6",
    install_requires=[
        "qiskit-aer>=0.4.0,<1.0.0",
        "marshmallow>=3.0,<4.0",
        "tornado>=6.0,<7.0"
    ],
    extras_require={
        "dev": [
            "autopep8>=1.5,<2.0",
            "pylint>=2.0,<3.0",
            "rope>=0.16.0,<1.0",
            "pytest>=5.0,<6.0",
            "bumpversion>=0.5.3,<1.0",
            "pytest-httpserver>=0.3.0,<1.0",
            "coloredlogs>=14.0,<15.0",
            "pytest-cov>=2.8.1,<3.0",
            "pytest-asyncio>=0.10.0,<1.0"
        ]
    }
)
