# This file has been autogenerated by the pywayland scanner

# Copyright © 2018 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..xdg_shell import XdgToplevel
from .zxdg_toplevel_decoration_v1 import ZxdgToplevelDecorationV1


class ZxdgDecorationManagerV1(Interface):
    """Window decoration manager

    This interface allows a compositor to announce support for server-side
    decorations.

    A window decoration is a set of window controls as deemed appropriate by
    the party managing them, such as user interface components used to move,
    resize and change a window's state.

    A client can use this protocol to request being decorated by a supporting
    compositor.

    If compositor and client do not negotiate the use of a server-side
    decoration using this protocol, clients continue to self-decorate as they
    see fit.

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zxdg_decoration_manager_v1"
    version = 1


class ZxdgDecorationManagerV1Proxy(Proxy):
    interface = ZxdgDecorationManagerV1

    @ZxdgDecorationManagerV1.request()
    def destroy(self):
        """Destroy the decoration manager object

        Destroy the decoration manager. This doesn't destroy objects created
        with the manager.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgDecorationManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZxdgToplevelDecorationV1),
        Argument(ArgumentType.Object, interface=XdgToplevel),
    )
    def get_toplevel_decoration(self, toplevel):
        """Create a new toplevel decoration object

        Create a new decoration object associated with the given toplevel.

        Creating an xdg_toplevel_decoration from an
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` which has a buffer
        attached or committed is a client error, and any attempts by a client
        to attach or manipulate a buffer prior to the first
        xdg_toplevel_decoration.configure event must also be treated as errors.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :returns:
            :class:`~pywayland.protocol.xdg_decoration_unstable_v1.ZxdgToplevelDecorationV1`
        """
        id = self._marshal_constructor(1, ZxdgToplevelDecorationV1, toplevel)
        return id


class ZxdgDecorationManagerV1Resource(Resource):
    interface = ZxdgDecorationManagerV1


class ZxdgDecorationManagerV1Global(Global):
    interface = ZxdgDecorationManagerV1


ZxdgDecorationManagerV1._gen_c()
ZxdgDecorationManagerV1.proxy_class = ZxdgDecorationManagerV1Proxy
ZxdgDecorationManagerV1.resource_class = ZxdgDecorationManagerV1Resource
ZxdgDecorationManagerV1.global_class = ZxdgDecorationManagerV1Global
