# This file was autogenerated. Do not edit.

import logging
import traceback
from dataclasses import dataclass
from abc import abstractmethod
from hikaru import DiffDetail
from hikaru.model.rel_1_26 import Pod,ReplicaSet,DaemonSet,Deployment,StatefulSet,Service,Event,HorizontalPodAutoscaler,Node,ClusterRole,ClusterRoleBinding,Job,Namespace,ServiceAccount,PersistentVolume,PersistentVolumeClaim,NetworkPolicy,ConfigMap,Ingress
from hikaru.utils import Response
from pydantic import BaseModel
from typing import Union, Optional, List
from ..base_event import K8sBaseChangeEvent
from ....core.model.events import ExecutionBaseEvent, ExecutionEventBaseParams
from ....core.reporting.base import FindingSubject
from ....core.reporting.consts import FindingSubjectType, FindingSource
from ....core.reporting.finding_subjects import KubeObjFindingSubject
from  robusta.integrations.kubernetes.custom_models import DeploymentConfig, RobustaDeployment, RobustaJob, RobustaPod, Rollout
from hikaru.model.rel_1_26.v1 import ClusterRole as v1ClusterRole
from hikaru.model.rel_1_26.v1 import ClusterRoleBinding as v1ClusterRoleBinding
from hikaru.model.rel_1_26.v1 import ConfigMap as v1ConfigMap
from hikaru.model.rel_1_26.v1 import DaemonSet as v1DaemonSet
from hikaru.model.rel_1_26.v1 import Deployment as v1Deployment
from hikaru.model.rel_1_26.v1 import Event as v1Event
from hikaru.model.rel_1_26.v1 import HorizontalPodAutoscaler as v1HorizontalPodAutoscaler
from hikaru.model.rel_1_26.v1 import Ingress as v1Ingress
from hikaru.model.rel_1_26.v1 import Job as v1Job
from hikaru.model.rel_1_26.v1 import Namespace as v1Namespace
from hikaru.model.rel_1_26.v1 import NetworkPolicy as v1NetworkPolicy
from hikaru.model.rel_1_26.v1 import Node as v1Node
from hikaru.model.rel_1_26.v1 import PersistentVolume as v1PersistentVolume
from hikaru.model.rel_1_26.v1 import PersistentVolumeClaim as v1PersistentVolumeClaim
from hikaru.model.rel_1_26.v1 import Pod as v1Pod
from hikaru.model.rel_1_26.v1 import ReplicaSet as v1ReplicaSet
from hikaru.model.rel_1_26.v1 import Service as v1Service
from hikaru.model.rel_1_26.v1 import ServiceAccount as v1ServiceAccount
from hikaru.model.rel_1_26.v1 import StatefulSet as v1StatefulSet


LOADERS_MAPPINGS = {
    "pod": (True, RobustaPod.readNamespacedPod),
    "replicaset": (True, ReplicaSet.readNamespacedReplicaSet),
    "daemonset": (True, DaemonSet.readNamespacedDaemonSet),
    "deployment": (True, RobustaDeployment.readNamespacedDeployment),
    "statefulset": (True, StatefulSet.readNamespacedStatefulSet),
    "service": (True, Service.readNamespacedService),
    "event": (True, Event.readNamespacedEvent),
    "horizontalpodautoscaler": (True, HorizontalPodAutoscaler.readNamespacedHorizontalPodAutoscaler),
    "node": (False, Node.readNode),
    "clusterrole": (False, ClusterRole.readClusterRole),
    "clusterrolebinding": (False, ClusterRoleBinding.readClusterRoleBinding),
    "job": (True, RobustaJob.readNamespacedJob),
    "namespace": (False, Namespace.readNamespace),
    "serviceaccount": (True, ServiceAccount.readNamespacedServiceAccount),
    "persistentvolume": (False, PersistentVolume.readPersistentVolume),
    "persistentvolumeclaim": (True, PersistentVolumeClaim.readNamespacedPersistentVolumeClaim),
    "networkpolicy": (True, NetworkPolicy.readNamespacedNetworkPolicy),
    "configmap": (True, ConfigMap.readNamespacedConfigMap),
    "ingress": (True, Ingress.readNamespacedIngress),
    "deploymentconfig": (True, DeploymentConfig.readNamespaced),
    "rollout": (True, Rollout.readNamespaced),
}


class ResourceLoader:
    @staticmethod
    def read_resource(kind: str, name: str, namespace: str = None) -> Response:
        resource_mapper = LOADERS_MAPPINGS[kind.lower()]
        if not resource_mapper:
            raise Exception("resource loader not found")

        if resource_mapper[0]:  # namespaced resource
            return resource_mapper[1](name=name, namespace=namespace)
        else:
            return resource_mapper[1](name=name)


class ResourceAttributes(ExecutionEventBaseParams):
    kind: str
    name: str
    namespace: Optional[str] = None


@dataclass
class KubernetesResourceEvent(ExecutionBaseEvent):
    obj: Optional[Union[RobustaPod,ReplicaSet,DaemonSet,RobustaDeployment,StatefulSet,Service,Event,HorizontalPodAutoscaler,Node,ClusterRole,ClusterRoleBinding,RobustaJob,Namespace,ServiceAccount,PersistentVolume,PersistentVolumeClaim,NetworkPolicy,ConfigMap,Ingress,DeploymentConfig,Rollout]] = None

    def __init__(self, obj: Union[RobustaPod,ReplicaSet,DaemonSet,RobustaDeployment,StatefulSet,Service,Event,HorizontalPodAutoscaler,Node,ClusterRole,ClusterRoleBinding,RobustaJob,Namespace,ServiceAccount,PersistentVolume,PersistentVolumeClaim,NetworkPolicy,ConfigMap,Ingress,DeploymentConfig,Rollout], named_sinks: List[str]):
        super().__init__(named_sinks=named_sinks)
        self.obj = obj

    def get_resource(self) -> Optional[Union[RobustaPod,ReplicaSet,DaemonSet,RobustaDeployment,StatefulSet,Service,Event,HorizontalPodAutoscaler,Node,ClusterRole,ClusterRoleBinding,RobustaJob,Namespace,ServiceAccount,PersistentVolume,PersistentVolumeClaim,NetworkPolicy,ConfigMap,Ingress,DeploymentConfig,Rollout]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )

    @classmethod
    def get_source(cls) -> FindingSource:
        return FindingSource.KUBERNETES_API_SERVER

    @staticmethod
    def from_params(params: ResourceAttributes) -> Optional["KubernetesResourceEvent"]:
        try:
            obj = ResourceLoader.read_resource(
                kind=params.kind,
                name=params.name,
                namespace=params.namespace
            ).obj
        except Exception:
            logging.error(f"Could not load resource {params}", exc_info=True)
            return None
        return KubernetesResourceEvent(obj=obj, named_sinks=params.named_sinks)


@dataclass
class KubernetesAnyChangeEvent(K8sBaseChangeEvent):
    obj: Optional[Union[RobustaDeployment,RobustaJob,RobustaPod,v1ClusterRole,v1ClusterRoleBinding,v1ConfigMap,v1DaemonSet,v1Event,v1HorizontalPodAutoscaler,v1Ingress,v1Namespace,v1NetworkPolicy,v1Node,v1PersistentVolume,v1PersistentVolumeClaim,v1ReplicaSet,v1Service,v1ServiceAccount,v1StatefulSet]] = None
    obj_filtered: Optional[Union[RobustaDeployment,RobustaJob,RobustaPod,v1ClusterRole,v1ClusterRoleBinding,v1ConfigMap,v1DaemonSet,v1Event,v1HorizontalPodAutoscaler,v1Ingress,v1Namespace,v1NetworkPolicy,v1Node,v1PersistentVolume,v1PersistentVolumeClaim,v1ReplicaSet,v1Service,v1ServiceAccount,v1StatefulSet]] = None
    old_obj: Optional[Union[RobustaDeployment,RobustaJob,RobustaPod,v1ClusterRole,v1ClusterRoleBinding,v1ConfigMap,v1DaemonSet,v1Event,v1HorizontalPodAutoscaler,v1Ingress,v1Namespace,v1NetworkPolicy,v1Node,v1PersistentVolume,v1PersistentVolumeClaim,v1ReplicaSet,v1Service,v1ServiceAccount,v1StatefulSet]] = None
    old_obj_filtered: Optional[Union[RobustaDeployment,RobustaJob,RobustaPod,v1ClusterRole,v1ClusterRoleBinding,v1ConfigMap,v1DaemonSet,v1Event,v1HorizontalPodAutoscaler,v1Ingress,v1Namespace,v1NetworkPolicy,v1Node,v1PersistentVolume,v1PersistentVolumeClaim,v1ReplicaSet,v1Service,v1ServiceAccount,v1StatefulSet]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_resource(self) -> Optional[Union[RobustaDeployment,RobustaJob,RobustaPod,v1ClusterRole,v1ClusterRoleBinding,v1ConfigMap,v1DaemonSet,v1Event,v1HorizontalPodAutoscaler,v1Ingress,v1Namespace,v1NetworkPolicy,v1Node,v1PersistentVolume,v1PersistentVolumeClaim,v1ReplicaSet,v1Service,v1ServiceAccount,v1StatefulSet]]:
        return self.obj


class PodAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class PodEvent(KubernetesResourceEvent):
    def __init__(self, obj: RobustaPod, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_pod(self) -> Optional[RobustaPod]:
        return self.obj

    @staticmethod
    def from_params(params: PodAttributes) -> Optional["PodEvent"]:
        try:
            obj = RobustaPod.readNamespacedPod(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Pod {params}", exc_info=True)
            return None
        return PodEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class PodChangeEvent(PodEvent, KubernetesAnyChangeEvent):
    obj: Optional[RobustaPod] = None
    obj_filtered: Optional[RobustaPod] = None
    old_obj: Optional[RobustaPod] = None
    old_obj_filtered: Optional[RobustaPod] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_pod(self) -> Optional[RobustaPod]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ReplicaSetAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class ReplicaSetEvent(KubernetesResourceEvent):
    def __init__(self, obj: ReplicaSet, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_replicaset(self) -> Optional[ReplicaSet]:
        return self.obj

    @staticmethod
    def from_params(params: ReplicaSetAttributes) -> Optional["ReplicaSetEvent"]:
        try:
            obj = ReplicaSet.readNamespacedReplicaSet(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load ReplicaSet {params}", exc_info=True)
            return None
        return ReplicaSetEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ReplicaSetChangeEvent(ReplicaSetEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1ReplicaSet]] = None
    obj_filtered: Optional[Union[v1ReplicaSet]] = None
    old_obj: Optional[Union[v1ReplicaSet]] = None
    old_obj_filtered: Optional[Union[v1ReplicaSet]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_replicaset(self) -> Optional[Union[v1ReplicaSet]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class DaemonSetAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class DaemonSetEvent(KubernetesResourceEvent):
    def __init__(self, obj: DaemonSet, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_daemonset(self) -> Optional[DaemonSet]:
        return self.obj

    @staticmethod
    def from_params(params: DaemonSetAttributes) -> Optional["DaemonSetEvent"]:
        try:
            obj = DaemonSet.readNamespacedDaemonSet(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load DaemonSet {params}", exc_info=True)
            return None
        return DaemonSetEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class DaemonSetChangeEvent(DaemonSetEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1DaemonSet]] = None
    obj_filtered: Optional[Union[v1DaemonSet]] = None
    old_obj: Optional[Union[v1DaemonSet]] = None
    old_obj_filtered: Optional[Union[v1DaemonSet]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_daemonset(self) -> Optional[Union[v1DaemonSet]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class DeploymentAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class DeploymentEvent(KubernetesResourceEvent):
    def __init__(self, obj: RobustaDeployment, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_deployment(self) -> Optional[RobustaDeployment]:
        return self.obj

    @staticmethod
    def from_params(params: DeploymentAttributes) -> Optional["DeploymentEvent"]:
        try:
            obj = RobustaDeployment.readNamespacedDeployment(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Deployment {params}", exc_info=True)
            return None
        return DeploymentEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class DeploymentChangeEvent(DeploymentEvent, KubernetesAnyChangeEvent):
    obj: Optional[RobustaDeployment] = None
    obj_filtered: Optional[RobustaDeployment] = None
    old_obj: Optional[RobustaDeployment] = None
    old_obj_filtered: Optional[RobustaDeployment] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_deployment(self) -> Optional[RobustaDeployment]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class StatefulSetAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class StatefulSetEvent(KubernetesResourceEvent):
    def __init__(self, obj: StatefulSet, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_statefulset(self) -> Optional[StatefulSet]:
        return self.obj

    @staticmethod
    def from_params(params: StatefulSetAttributes) -> Optional["StatefulSetEvent"]:
        try:
            obj = StatefulSet.readNamespacedStatefulSet(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load StatefulSet {params}", exc_info=True)
            return None
        return StatefulSetEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class StatefulSetChangeEvent(StatefulSetEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1StatefulSet]] = None
    obj_filtered: Optional[Union[v1StatefulSet]] = None
    old_obj: Optional[Union[v1StatefulSet]] = None
    old_obj_filtered: Optional[Union[v1StatefulSet]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_statefulset(self) -> Optional[Union[v1StatefulSet]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ServiceAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class ServiceEvent(KubernetesResourceEvent):
    def __init__(self, obj: Service, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_service(self) -> Optional[Service]:
        return self.obj

    @staticmethod
    def from_params(params: ServiceAttributes) -> Optional["ServiceEvent"]:
        try:
            obj = Service.readNamespacedService(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Service {params}", exc_info=True)
            return None
        return ServiceEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ServiceChangeEvent(ServiceEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1Service]] = None
    obj_filtered: Optional[Union[v1Service]] = None
    old_obj: Optional[Union[v1Service]] = None
    old_obj_filtered: Optional[Union[v1Service]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_service(self) -> Optional[Union[v1Service]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class EventAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class EventEvent(KubernetesResourceEvent):
    def __init__(self, obj: Event, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_event(self) -> Optional[Event]:
        return self.obj

    @staticmethod
    def from_params(params: EventAttributes) -> Optional["EventEvent"]:
        try:
            obj = Event.readNamespacedEvent(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Event {params}", exc_info=True)
            return None
        return EventEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class EventChangeEvent(EventEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1Event]] = None
    obj_filtered: Optional[Union[v1Event]] = None
    old_obj: Optional[Union[v1Event]] = None
    old_obj_filtered: Optional[Union[v1Event]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_event(self) -> Optional[Union[v1Event]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class HorizontalPodAutoscalerAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class HorizontalPodAutoscalerEvent(KubernetesResourceEvent):
    def __init__(self, obj: HorizontalPodAutoscaler, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_horizontalpodautoscaler(self) -> Optional[HorizontalPodAutoscaler]:
        return self.obj

    @staticmethod
    def from_params(params: HorizontalPodAutoscalerAttributes) -> Optional["HorizontalPodAutoscalerEvent"]:
        try:
            obj = HorizontalPodAutoscaler.readNamespacedHorizontalPodAutoscaler(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load HorizontalPodAutoscaler {params}", exc_info=True)
            return None
        return HorizontalPodAutoscalerEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class HorizontalPodAutoscalerChangeEvent(HorizontalPodAutoscalerEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1HorizontalPodAutoscaler]] = None
    obj_filtered: Optional[Union[v1HorizontalPodAutoscaler]] = None
    old_obj: Optional[Union[v1HorizontalPodAutoscaler]] = None
    old_obj_filtered: Optional[Union[v1HorizontalPodAutoscaler]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_horizontalpodautoscaler(self) -> Optional[Union[v1HorizontalPodAutoscaler]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class NodeAttributes(ExecutionEventBaseParams):
    name: str



@dataclass
class NodeEvent(KubernetesResourceEvent):
    def __init__(self, obj: Node, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_node(self) -> Optional[Node]:
        return self.obj

    @staticmethod
    def from_params(params: NodeAttributes) -> Optional["NodeEvent"]:
        try:
            obj = Node.readNode(name=params.name).obj
        except Exception:
            logging.error(f"Could not load Node {params}", exc_info=True)
            return None
        return NodeEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class NodeChangeEvent(NodeEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1Node]] = None
    obj_filtered: Optional[Union[v1Node]] = None
    old_obj: Optional[Union[v1Node]] = None
    old_obj_filtered: Optional[Union[v1Node]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_node(self) -> Optional[Union[v1Node]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ClusterRoleAttributes(ExecutionEventBaseParams):
    name: str



@dataclass
class ClusterRoleEvent(KubernetesResourceEvent):
    def __init__(self, obj: ClusterRole, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_clusterrole(self) -> Optional[ClusterRole]:
        return self.obj

    @staticmethod
    def from_params(params: ClusterRoleAttributes) -> Optional["ClusterRoleEvent"]:
        try:
            obj = ClusterRole.readClusterRole(name=params.name).obj
        except Exception:
            logging.error(f"Could not load ClusterRole {params}", exc_info=True)
            return None
        return ClusterRoleEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ClusterRoleChangeEvent(ClusterRoleEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1ClusterRole]] = None
    obj_filtered: Optional[Union[v1ClusterRole]] = None
    old_obj: Optional[Union[v1ClusterRole]] = None
    old_obj_filtered: Optional[Union[v1ClusterRole]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_clusterrole(self) -> Optional[Union[v1ClusterRole]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ClusterRoleBindingAttributes(ExecutionEventBaseParams):
    name: str



@dataclass
class ClusterRoleBindingEvent(KubernetesResourceEvent):
    def __init__(self, obj: ClusterRoleBinding, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_clusterrolebinding(self) -> Optional[ClusterRoleBinding]:
        return self.obj

    @staticmethod
    def from_params(params: ClusterRoleBindingAttributes) -> Optional["ClusterRoleBindingEvent"]:
        try:
            obj = ClusterRoleBinding.readClusterRoleBinding(name=params.name).obj
        except Exception:
            logging.error(f"Could not load ClusterRoleBinding {params}", exc_info=True)
            return None
        return ClusterRoleBindingEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ClusterRoleBindingChangeEvent(ClusterRoleBindingEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1ClusterRoleBinding]] = None
    obj_filtered: Optional[Union[v1ClusterRoleBinding]] = None
    old_obj: Optional[Union[v1ClusterRoleBinding]] = None
    old_obj_filtered: Optional[Union[v1ClusterRoleBinding]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_clusterrolebinding(self) -> Optional[Union[v1ClusterRoleBinding]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class JobAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class JobEvent(KubernetesResourceEvent):
    def __init__(self, obj: RobustaJob, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_job(self) -> Optional[RobustaJob]:
        return self.obj

    @staticmethod
    def from_params(params: JobAttributes) -> Optional["JobEvent"]:
        try:
            obj = RobustaJob.readNamespacedJob(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Job {params}", exc_info=True)
            return None
        return JobEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class JobChangeEvent(JobEvent, KubernetesAnyChangeEvent):
    obj: Optional[RobustaJob] = None
    obj_filtered: Optional[RobustaJob] = None
    old_obj: Optional[RobustaJob] = None
    old_obj_filtered: Optional[RobustaJob] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_job(self) -> Optional[RobustaJob]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class NamespaceAttributes(ExecutionEventBaseParams):
    name: str



@dataclass
class NamespaceEvent(KubernetesResourceEvent):
    def __init__(self, obj: Namespace, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_namespace(self) -> Optional[Namespace]:
        return self.obj

    @staticmethod
    def from_params(params: NamespaceAttributes) -> Optional["NamespaceEvent"]:
        try:
            obj = Namespace.readNamespace(name=params.name).obj
        except Exception:
            logging.error(f"Could not load Namespace {params}", exc_info=True)
            return None
        return NamespaceEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class NamespaceChangeEvent(NamespaceEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1Namespace]] = None
    obj_filtered: Optional[Union[v1Namespace]] = None
    old_obj: Optional[Union[v1Namespace]] = None
    old_obj_filtered: Optional[Union[v1Namespace]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_namespace(self) -> Optional[Union[v1Namespace]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ServiceAccountAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class ServiceAccountEvent(KubernetesResourceEvent):
    def __init__(self, obj: ServiceAccount, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_serviceaccount(self) -> Optional[ServiceAccount]:
        return self.obj

    @staticmethod
    def from_params(params: ServiceAccountAttributes) -> Optional["ServiceAccountEvent"]:
        try:
            obj = ServiceAccount.readNamespacedServiceAccount(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load ServiceAccount {params}", exc_info=True)
            return None
        return ServiceAccountEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ServiceAccountChangeEvent(ServiceAccountEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1ServiceAccount]] = None
    obj_filtered: Optional[Union[v1ServiceAccount]] = None
    old_obj: Optional[Union[v1ServiceAccount]] = None
    old_obj_filtered: Optional[Union[v1ServiceAccount]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_serviceaccount(self) -> Optional[Union[v1ServiceAccount]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class PersistentVolumeAttributes(ExecutionEventBaseParams):
    name: str



@dataclass
class PersistentVolumeEvent(KubernetesResourceEvent):
    def __init__(self, obj: PersistentVolume, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_persistentvolume(self) -> Optional[PersistentVolume]:
        return self.obj

    @staticmethod
    def from_params(params: PersistentVolumeAttributes) -> Optional["PersistentVolumeEvent"]:
        try:
            obj = PersistentVolume.readPersistentVolume(name=params.name).obj
        except Exception:
            logging.error(f"Could not load PersistentVolume {params}", exc_info=True)
            return None
        return PersistentVolumeEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class PersistentVolumeChangeEvent(PersistentVolumeEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1PersistentVolume]] = None
    obj_filtered: Optional[Union[v1PersistentVolume]] = None
    old_obj: Optional[Union[v1PersistentVolume]] = None
    old_obj_filtered: Optional[Union[v1PersistentVolume]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_persistentvolume(self) -> Optional[Union[v1PersistentVolume]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class PersistentVolumeClaimAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class PersistentVolumeClaimEvent(KubernetesResourceEvent):
    def __init__(self, obj: PersistentVolumeClaim, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_persistentvolumeclaim(self) -> Optional[PersistentVolumeClaim]:
        return self.obj

    @staticmethod
    def from_params(params: PersistentVolumeClaimAttributes) -> Optional["PersistentVolumeClaimEvent"]:
        try:
            obj = PersistentVolumeClaim.readNamespacedPersistentVolumeClaim(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load PersistentVolumeClaim {params}", exc_info=True)
            return None
        return PersistentVolumeClaimEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class PersistentVolumeClaimChangeEvent(PersistentVolumeClaimEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1PersistentVolumeClaim]] = None
    obj_filtered: Optional[Union[v1PersistentVolumeClaim]] = None
    old_obj: Optional[Union[v1PersistentVolumeClaim]] = None
    old_obj_filtered: Optional[Union[v1PersistentVolumeClaim]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_persistentvolumeclaim(self) -> Optional[Union[v1PersistentVolumeClaim]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class NetworkPolicyAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class NetworkPolicyEvent(KubernetesResourceEvent):
    def __init__(self, obj: NetworkPolicy, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_networkpolicy(self) -> Optional[NetworkPolicy]:
        return self.obj

    @staticmethod
    def from_params(params: NetworkPolicyAttributes) -> Optional["NetworkPolicyEvent"]:
        try:
            obj = NetworkPolicy.readNamespacedNetworkPolicy(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load NetworkPolicy {params}", exc_info=True)
            return None
        return NetworkPolicyEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class NetworkPolicyChangeEvent(NetworkPolicyEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1NetworkPolicy]] = None
    obj_filtered: Optional[Union[v1NetworkPolicy]] = None
    old_obj: Optional[Union[v1NetworkPolicy]] = None
    old_obj_filtered: Optional[Union[v1NetworkPolicy]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_networkpolicy(self) -> Optional[Union[v1NetworkPolicy]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class ConfigMapAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class ConfigMapEvent(KubernetesResourceEvent):
    def __init__(self, obj: ConfigMap, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_configmap(self) -> Optional[ConfigMap]:
        return self.obj

    @staticmethod
    def from_params(params: ConfigMapAttributes) -> Optional["ConfigMapEvent"]:
        try:
            obj = ConfigMap.readNamespacedConfigMap(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load ConfigMap {params}", exc_info=True)
            return None
        return ConfigMapEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class ConfigMapChangeEvent(ConfigMapEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1ConfigMap]] = None
    obj_filtered: Optional[Union[v1ConfigMap]] = None
    old_obj: Optional[Union[v1ConfigMap]] = None
    old_obj_filtered: Optional[Union[v1ConfigMap]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_configmap(self) -> Optional[Union[v1ConfigMap]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )


class IngressAttributes(ExecutionEventBaseParams):
    name: str
    namespace: str


@dataclass
class IngressEvent(KubernetesResourceEvent):
    def __init__(self, obj: Ingress, named_sinks: List[str]):
        super().__init__(obj=obj, named_sinks=named_sinks)

    def get_ingress(self) -> Optional[Ingress]:
        return self.obj

    @staticmethod
    def from_params(params: IngressAttributes) -> Optional["IngressEvent"]:
        try:
            obj = Ingress.readNamespacedIngress(name=params.name, namespace=params.namespace).obj
        except Exception:
            logging.error(f"Could not load Ingress {params}", exc_info=True)
            return None
        return IngressEvent(obj=obj, named_sinks=params.named_sinks)

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



@dataclass
class IngressChangeEvent(IngressEvent, KubernetesAnyChangeEvent):
    obj: Optional[Union[v1Ingress]] = None
    obj_filtered: Optional[Union[v1Ingress]] = None
    old_obj: Optional[Union[v1Ingress]] = None
    old_obj_filtered: Optional[Union[v1Ingress]] = None
    filtered_diffs: Optional[List[DiffDetail]] = None

    def get_ingress(self) -> Optional[Union[v1Ingress]]:
        return self.obj

    def get_subject(self) -> FindingSubject:
        return FindingSubject(
            name=self.obj.metadata.name,
            subject_type=FindingSubjectType.from_kind(self.obj.kind),
            namespace=self.obj.metadata.namespace,
            node=KubeObjFindingSubject.get_node_name(self.obj),
            labels=self.obj.metadata.labels,
            annotations=self.obj.metadata.annotations,
        )



KIND_TO_EVENT_CLASS = {
    'pod': PodChangeEvent,
    'replicaset': ReplicaSetChangeEvent,
    'daemonset': DaemonSetChangeEvent,
    'deployment': DeploymentChangeEvent,
    'statefulset': StatefulSetChangeEvent,
    'service': ServiceChangeEvent,
    'event': EventChangeEvent,
    'horizontalpodautoscaler': HorizontalPodAutoscalerChangeEvent,
    'node': NodeChangeEvent,
    'clusterrole': ClusterRoleChangeEvent,
    'clusterrolebinding': ClusterRoleBindingChangeEvent,
    'job': JobChangeEvent,
    'namespace': NamespaceChangeEvent,
    'serviceaccount': ServiceAccountChangeEvent,
    'persistentvolume': PersistentVolumeChangeEvent,
    'persistentvolumeclaim': PersistentVolumeClaimChangeEvent,
    'networkpolicy': NetworkPolicyChangeEvent,
    'configmap': ConfigMapChangeEvent,
    'ingress': IngressChangeEvent
}
