import { CommonActionProps, IStage, ActionBindOptions, ActionConfig } from 'aws-cdk-lib/aws-codepipeline';
import { Action } from 'aws-cdk-lib/aws-codepipeline-actions';
import { Construct } from 'constructs';
import { ChannelTypes } from './channel-types';
export interface SlackApprovalActionProps extends CommonActionProps {
    readonly slackBotToken: string;
    readonly slackSigningSecret: string;
    readonly slackChannel?: string;
    readonly slackChannelId?: string;
    readonly slackChannelTypes?: ChannelTypes[];
    readonly slackBotName?: string;
    readonly slackBotIcon?: string;
    readonly additionalInformation?: string;
    readonly externalEntityLink?: string;
}
export declare class SlackApprovalAction extends Action {
    private props;
    constructor(props: SlackApprovalActionProps);
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    protected bound(scope: Construct, stage: IStage, options: ActionBindOptions): ActionConfig;
}
