# Generated by Django 2.0.5 on 2018-08-08 13:16

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AuthenticationInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(help_text='The username.', max_length=150, verbose_name='Username')),
                ('password', models.CharField(help_text='The password for the user.', max_length=25, verbose_name='Password')),
                ('type', models.CharField(help_text='The type of authentication to use.  For example, Basic, Digest, SSH, etc.  This is optional depending on whether or not any steps require this information.', max_length=25, verbose_name='Type')),
                ('description', models.CharField(help_text='An optional description.', max_length=200, null=True, verbose_name='Description')),
                ('private_key', models.TextField(help_text='Any private key value if applicable.', null=True, verbose_name='Private Key')),
                ('public_key', models.TextField(help_text='Any public key info if applicable.', null=True, verbose_name='Public Key')),
            ],
        ),
        migrations.CreateModel(
            name='EndPoint',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of the endpoint', max_length=150, verbose_name='Name')),
                ('urn', models.CharField(help_text='A uniform resource locator that includes protocol information.', max_length=1000, verbose_name='URL')),
            ],
        ),
        migrations.CreateModel(
            name='EPCISOutputCriteria',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='The name of the endpoint', max_length=150, verbose_name='Name')),
                ('event_type', models.CharField(choices=[('Object', 'Object'), ('Transaction', 'Transaction'), ('Transformation', 'Transformation'), ('Aggregation', 'Aggregation')], help_text='The type of EPCIS event.', max_length=20, null=True, verbose_name='Event Type')),
                ('action', models.CharField(choices=[('ADD', 'Add'), ('OBSERVE', 'Observe'), ('DELETE', 'Delete')], help_text="The EPCIS event's ACTION type.", max_length=20, null=True, verbose_name='Action')),
                ('biz_step', models.CharField(help_text='The business step URN.  Can be a CBV value or any customuri.  If CBV it must be exactly as specified in v1.2', max_length=150, null=True, verbose_name='Business Step (BizStep)')),
                ('disposition', models.CharField(help_text='A Disposition URN- can be CBV or custom.', max_length=150, null=True, verbose_name='Disposition')),
                ('read_point', models.CharField(help_text='The read point URN.  Typically representing a sub-site.', max_length=150, null=True, verbose_name='Read Point')),
                ('biz_location', models.CharField(help_text='The business location URN.  Typically representing a site', max_length=150, null=True, verbose_name='Business Location')),
                ('source_type', models.CharField(help_text='The type of the source- a CBV 1.2 URI or custom URI.', max_length=150, null=True, verbose_name='Source Type')),
                ('source_id', models.CharField(help_text='A URI that identifies the source specified in the Source Type field.', max_length=200, null=True, verbose_name='Source ID')),
                ('destination_type', models.CharField(help_text='The type of the Destination- a CBV 1.2 URI or custom URI.', max_length=150, null=True, verbose_name='Destination Type')),
                ('destination_id', models.CharField(help_text='A URI that identifies the Destination specified in the Destination Type field.', max_length=200, null=True, verbose_name='Destination ID')),
                ('authentication_info', models.ForeignKey(help_text='The Authentication Info to use.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='quartet_output.AuthenticationInfo', verbose_name='Authentication Info')),
                ('end_point', models.ForeignKey(help_text='A prtocol-specific endpoint defining where any output data will be sent.', on_delete=django.db.models.deletion.PROTECT, to='quartet_output.EndPoint', verbose_name='End Point')),
            ],
            options={
                'verbose_name': 'EPCIS Output Criteria',
                'verbose_name_plural': 'EPCIS Output Criteria',
            },
        ),
    ]
