## Security

If you believe you have found a security vulnerability in this repository, please report it to us as described below.
Please also read the existing [security advisories](https://github.com/pkjmesra/nseta/blob/main/security/README.md)

## Reporting Security Issues

**Please do not report security vulnerabilities through public GitHub issues.**

Instead, please report them to the author: pkjmesra@gmail.com

You should receive a response within a week. If for some reason you do not, please follow up via email to ensure we received your original message.

Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:

 *  Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
 *  Full paths of source file(s) related to the manifestation of the issue
 *  The location of the affected source code (tag/branch/commit or direct URL)
 *  Any special configuration required to reproduce the issue
 *  Step-by-step instructions to reproduce the issue
 *  Proof-of-concept or exploit code (if possible)
 *  Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.

This repository does not have a bug bounty program.

## Preferred Languages

We prefer all communications to be in English.

## Policy

Once an issue is reported, we use the following disclosure process:

	* When a report is received, we confirm the issue and determine its severity.
	* If we know of specific third-party services or software based on nseta that require mitigation before publication, those projects will be notified.
	* An advisory is prepared (but not published) which details the problem and steps for mitigation.
	* Wherever possible, fixes are prepared for the last minor release of the two latest major releases, as well as the master branch. We will attempt to commit these fixes as soon as possible, and as close together as possible.
	* Patch releases are published for all fixed released versions, a notification is sent to the respective stakeholders, and the advisory is published.
