# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_vmm_py_client.api_client import ApiClient


class VmDataProtectionApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def revert_vm(self, body, extId, **kwargs):  # noqa: E501
        """Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.
        Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.

        >>> response = api.revert_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revert_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.VmRevert body: Specify the VM Recovery Point Id to which the VM would be reverted. (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RevertVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.revert_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.revert_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def revert_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.
        Revert VM identified by {extId}. This does an in-place VM restore from a specified VM Recovery Point.

        >>> response = api.revert_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.revert_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.VmRevert body: Specify the VM Recovery Point Id to which the VM would be reverted. (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RevertVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method revert_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `revert_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `revert_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/revert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.RevertVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
