# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_vmm_py_client.api_client import ApiClient


class VmApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assign_ip(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """IP address assignment to a VM NIC.
        IP address assignment to a VM NIC.

        >>> response = api.assign_ip(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assign_ip(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.AssignIp body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.AssignIpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.assign_ip_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.assign_ip_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def assign_ip_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """IP address assignment to a VM NIC.
        IP address assignment to a VM NIC.

        >>> response = api.assign_ip(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.assign_ip_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.AssignIp body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.AssignIpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assign_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `assign_ip`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `assign_ip`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `assign_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}/$actions/assign-ip', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.AssignIpResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def attach_vm_category(self, body, extId, **kwargs):  # noqa: E501
        """Attach a category for the VM.
        Attach a category for the VM.

        >>> response = api.attach_vm_category(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.attach_vm_category(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CategoryReference body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.AttachVmCategoryResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.attach_vm_category_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.attach_vm_category_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def attach_vm_category_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Attach a category for the VM.
        Attach a category for the VM.

        >>> response = api.attach_vm_category(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.attach_vm_category_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CategoryReference body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.AttachVmCategoryResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_vm_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `attach_vm_category`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `attach_vm_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/categories/$actions/attach', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.AttachVmCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clone_vm(self, extId, **kwargs):  # noqa: E501
        """Clone a VM
        Clone a VM

        >>> response = api.clone_vm(extId, (optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param vmm.v4.ahv.config.CloneOverride body:
        :param bool async_req:
        :return: vmm.v4.ahv.config.CloneVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.clone_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.clone_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def clone_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Clone a VM
        Clone a VM

        >>> response = api.clone_vm(extId, (optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.clone_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param vmm.v4.ahv.config.CloneOverride body:
        :param bool async_req:
        :return: vmm.v4.ahv.config.CloneVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `clone_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/clone', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CloneVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cdrom(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a CD-ROM for the VM.
        Create a CD-ROM for the VM.

        >>> response = api.create_cdrom(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cdrom(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Cdrom body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cdrom_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cdrom_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
            return data

    def create_cdrom_with_http_info(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a CD-ROM for the VM.
        Create a CD-ROM for the VM.

        >>> response = api.create_cdrom(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_cdrom_with_http_info(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Cdrom body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cdrom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_cdrom`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `create_cdrom`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_disk(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a Disk for the VM.
        Create a Disk for the VM.

        >>> response = api.create_disk(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_disk(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Disk body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_disk_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_disk_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
            return data

    def create_disk_with_http_info(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a Disk for the VM.
        Create a Disk for the VM.

        >>> response = api.create_disk(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_disk_with_http_info(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Disk body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_disk" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_disk`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `create_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/disks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateDiskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_gpu(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a GPU for the VM.
        Create a GPU for the VM.

        >>> response = api.create_gpu(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gpu(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Gpu body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_gpu_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_gpu_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
            return data

    def create_gpu_with_http_info(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a GPU for the VM.
        Create a GPU for the VM.

        >>> response = api.create_gpu(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_gpu_with_http_info(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Gpu body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gpu" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_gpu`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `create_gpu`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/gpus', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateGpuResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_nic(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a NIC for the VM.
        Create a NIC for the VM.

        >>> response = api.create_nic(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_nic(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Nic body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_nic_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_nic_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
            return data

    def create_nic_with_http_info(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a NIC for the VM.
        Create a NIC for the VM.

        >>> response = api.create_nic(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_nic_with_http_info(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Nic body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_nic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_nic`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `create_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateNicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_serial_port(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a SerialPort for the VM.
        Create a SerialPort for the VM.

        >>> response = api.create_serial_port(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_serial_port(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.SerialPort body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_serial_port_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.create_serial_port_with_http_info(body, vmExtId, **kwargs)  # noqa: E501
            return data

    def create_serial_port_with_http_info(self, body, vmExtId, **kwargs):  # noqa: E501
        """Create a SerialPort for the VM.
        Create a SerialPort for the VM.

        >>> response = api.create_serial_port(body, vmExtId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_serial_port_with_http_info(body, vmExtId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.SerialPort body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_serial_port" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_serial_port`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `create_serial_port`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/serial-ports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateSerialPortResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_vm(self, body, **kwargs):  # noqa: E501
        """Create a VM.
        Create a VM.

        >>> response = api.create_vm(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm(body, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Vm body: (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_vm_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_vm_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_vm_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create a VM.
        Create a VM.

        >>> response = api.create_vm(body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_vm_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Vm body: (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CreateVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CreateVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customize_guest_vm(self, body, extId, **kwargs):  # noqa: E501
        """Customize a guest VM.
        Customize a guest VM.

        >>> response = api.customize_guest_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.customize_guest_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestCustomization body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CustomizeGuestVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customize_guest_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.customize_guest_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def customize_guest_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Customize a guest VM.
        Customize a guest VM.

        >>> response = api.customize_guest_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.customize_guest_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestCustomization body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.CustomizeGuestVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customize_guest_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customize_guest_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `customize_guest_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/customize-guest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.CustomizeGuestVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cdrom(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete CD-ROM for the VM.
        Delete CD-ROM for the VM.

        >>> response = api.delete_cdrom(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cdrom(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cdrom_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cdrom_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def delete_cdrom_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete CD-ROM for the VM.
        Delete CD-ROM for the VM.

        >>> response = api.delete_cdrom(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_cdrom_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cdrom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `delete_cdrom`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_cdrom`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_disk(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete Disk for the VM.
        Delete Disk for the VM.

        >>> response = api.delete_disk(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_disk(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_disk_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_disk_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def delete_disk_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete Disk for the VM.
        Delete Disk for the VM.

        >>> response = api.delete_disk(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_disk_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_disk" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `delete_disk`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/disks/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteDiskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_gpu(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete GPU for the VM.
        Delete GPU for the VM.

        >>> response = api.delete_gpu(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_gpu(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM GPU. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_gpu_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_gpu_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def delete_gpu_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete GPU for the VM.
        Delete GPU for the VM.

        >>> response = api.delete_gpu(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_gpu_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM GPU. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_gpu" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `delete_gpu`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_gpu`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/gpus/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteGpuResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_nic(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete NIC for the VM.
        Delete NIC for the VM.

        >>> response = api.delete_nic(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_nic(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_nic_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_nic_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def delete_nic_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete NIC for the VM.
        Delete NIC for the VM.

        >>> response = api.delete_nic(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_nic_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_nic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `delete_nic`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteNicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_serial_port(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete SerialPort for the VM.
        Delete SerialPort for the VM.

        >>> response = api.delete_serial_port(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_serial_port(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_serial_port_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_serial_port_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def delete_serial_port_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Delete SerialPort for the VM.
        Delete SerialPort for the VM.

        >>> response = api.delete_serial_port(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_serial_port_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_serial_port" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `delete_serial_port`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_serial_port`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/serial-ports/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteSerialPortResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_vm(self, extId, **kwargs):  # noqa: E501
        """Delete a VM.
        Delete a VM.

        >>> response = api.delete_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def delete_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Delete a VM.
        Delete a VM.

        >>> response = api.delete_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DeleteVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `delete_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DeleteVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def detach_vm_category(self, body, extId, **kwargs):  # noqa: E501
        """Detach a category from the VM.
        Detach a category from the VM.

        >>> response = api.detach_vm_category(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.detach_vm_category(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CategoryReference body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DetachVmCategoryResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.detach_vm_category_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.detach_vm_category_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def detach_vm_category_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Detach a category from the VM.
        Detach a category from the VM.

        >>> response = api.detach_vm_category(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.detach_vm_category_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CategoryReference body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.DetachVmCategoryResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method detach_vm_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `detach_vm_category`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `detach_vm_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/categories/$actions/detach', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.DetachVmCategoryResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def eject_cdrom(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Update CD-ROM for the VM.
        Update CD-ROM for the VM.

        >>> response = api.eject_cdrom(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.eject_cdrom(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.EjectCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.eject_cdrom_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.eject_cdrom_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def eject_cdrom_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Update CD-ROM for the VM.
        Update CD-ROM for the VM.

        >>> response = api.eject_cdrom(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.eject_cdrom_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.EjectCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method eject_cdrom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `eject_cdrom`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `eject_cdrom`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms/{extId}/$actions/eject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.EjectCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cdrom_by_ext_id(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get CD-ROM for the VM.
        Get CD-ROM for the VM.

        >>> response = api.get_cdrom_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cdrom_by_ext_id(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cdrom_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cdrom_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def get_cdrom_by_ext_id_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get CD-ROM for the VM.
        Get CD-ROM for the VM.

        >>> response = api.get_cdrom_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_cdrom_by_ext_id_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cdrom_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `get_cdrom_by_ext_id`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_cdrom_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_disk_by_ext_id(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get Disk for the VM.
        Get Disk for the VM.

        >>> response = api.get_disk_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_disk_by_ext_id(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_disk_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_disk_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def get_disk_by_ext_id_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get Disk for the VM.
        Get Disk for the VM.

        >>> response = api.get_disk_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_disk_by_ext_id_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_disk_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `get_disk_by_ext_id`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_disk_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/disks/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetDiskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_gpu_by_ext_id(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get GPU for the VM.
        Get GPU for the VM.

        >>> response = api.get_gpu_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_by_ext_id(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM GPU. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_gpu_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_gpu_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def get_gpu_by_ext_id_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get GPU for the VM.
        Get GPU for the VM.

        >>> response = api.get_gpu_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_gpu_by_ext_id_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM GPU. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetGpuResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gpu_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `get_gpu_by_ext_id`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_gpu_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/gpus/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetGpuResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_guest_tools(self, extId, **kwargs):  # noqa: E501
        """Get Nutanix Guest Tools information for a VM.
        Get Nutanix Guest Tools information for a VM.

        >>> response = api.get_guest_tools(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_guest_tools(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_guest_tools_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_guest_tools_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_guest_tools_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get Nutanix Guest Tools information for a VM.
        Get Nutanix Guest Tools information for a VM.

        >>> response = api.get_guest_tools(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_guest_tools_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools-config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_nic_by_ext_id(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get NIC for the VM identified by the VM external Id.
        Get NIC for the VM identified by the VM external Id.

        >>> response = api.get_nic_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_nic_by_ext_id(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_nic_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_nic_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def get_nic_by_ext_id_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get NIC for the VM identified by the VM external Id.
        Get NIC for the VM identified by the VM external Id.

        >>> response = api.get_nic_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_nic_by_ext_id_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_nic_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `get_nic_by_ext_id`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_nic_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetNicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_serial_port_by_ext_id(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get SerialPort for the VM.
        Get SerialPort for the VM.

        >>> response = api.get_serial_port_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_serial_port_by_ext_id(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_serial_port_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_serial_port_by_ext_id_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def get_serial_port_by_ext_id_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Get SerialPort for the VM.
        Get SerialPort for the VM.

        >>> response = api.get_serial_port_by_ext_id(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_serial_port_by_ext_id_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_serial_port_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `get_serial_port_by_ext_id`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_serial_port_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/serial-ports/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetSerialPortResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vm_by_ext_id(self, extId, **kwargs):  # noqa: E501
        """Get VM of the provided VM external Id.
        Get VM of the provided VM external Id.

        >>> response = api.get_vm_by_ext_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_by_ext_id(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vm_by_ext_id_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vm_by_ext_id_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_vm_by_ext_id_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get VM of the provided VM external Id.
        Get VM of the provided VM external Id.

        >>> response = api.get_vm_by_ext_id(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_by_ext_id_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_by_ext_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_vm_by_ext_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vm_categories(self, extId, **kwargs):  # noqa: E501
        """Get categories for the VM.
        Get categories for the VM.

        >>> response = api.get_vm_categories(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_categories(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmCategoriesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vm_categories_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vm_categories_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_vm_categories_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get categories for the VM.
        Get categories for the VM.

        >>> response = api.get_vm_categories(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_categories_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmCategoriesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_vm_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetVmCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vm_ownership_info(self, extId, **kwargs):  # noqa: E501
        """Get ownership information for the VM identified by the VM external Id.
        Get ownership information for the VM identified by the VM external Id.

        >>> response = api.get_vm_ownership_info(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_ownership_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmOwnershipInfoResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vm_ownership_info_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vm_ownership_info_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def get_vm_ownership_info_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get ownership information for the VM identified by the VM external Id.
        Get ownership information for the VM identified by the VM external Id.

        >>> response = api.get_vm_ownership_info(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_vm_ownership_info_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.GetVmOwnershipInfoResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vm_ownership_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `get_vm_ownership_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/ownership-info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.GetVmOwnershipInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def guest_reboot_vm(self, body, extId, **kwargs):  # noqa: E501
        """Restart the VM using Nutanix Guest Tools.
        Restart the VM using Nutanix Guest Tools.

        >>> response = api.guest_reboot_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.guest_reboot_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RebootVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.guest_reboot_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.guest_reboot_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def guest_reboot_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Restart the VM using Nutanix Guest Tools.
        Restart the VM using Nutanix Guest Tools.

        >>> response = api.guest_reboot_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.guest_reboot_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RebootVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method guest_reboot_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `guest_reboot_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `guest_reboot_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/guest-reboot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.RebootVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def guest_shutdown_vm(self, body, extId, **kwargs):  # noqa: E501
        """Shutdown the VM using Nutanix Guest Tools.
        Shutdown the VM using Nutanix Guest Tools.

        >>> response = api.guest_shutdown_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.guest_shutdown_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ShutdownVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.guest_shutdown_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.guest_shutdown_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def guest_shutdown_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Shutdown the VM using Nutanix Guest Tools.
        Shutdown the VM using Nutanix Guest Tools.

        >>> response = api.guest_shutdown_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.guest_shutdown_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ShutdownVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method guest_shutdown_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `guest_shutdown_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `guest_shutdown_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/guest-shutdown', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ShutdownVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_cdrom(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Insert an ISO image or VM disk to a CD-ROM for the VM.
        Insert an ISO image or VM disk to a CD-ROM for the VM.

        >>> response = api.insert_cdrom(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insert_cdrom(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CdromInsert body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InsertCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_cdrom_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_cdrom_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def insert_cdrom_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Insert an ISO image or VM disk to a CD-ROM for the VM.
        Insert an ISO image or VM disk to a CD-ROM for the VM.

        >>> response = api.insert_cdrom(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insert_cdrom_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.CdromInsert body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InsertCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_cdrom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `insert_cdrom`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `insert_cdrom`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `insert_cdrom`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms/{extId}/$actions/insert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.InsertCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def insert_vm_guest_tools(self, body, extId, **kwargs):  # noqa: E501
        """Insert Nutanix Guest Tools ISO into an available slot.
        Insert Nutanix Guest Tools ISO into an available slot.

        >>> response = api.insert_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insert_vm_guest_tools(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsInsertConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InsertVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.insert_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.insert_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def insert_vm_guest_tools_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Insert Nutanix Guest Tools ISO into an available slot.
        Insert Nutanix Guest Tools ISO into an available slot.

        >>> response = api.insert_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.insert_vm_guest_tools_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsInsertConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InsertVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method insert_vm_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `insert_vm_guest_tools`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `insert_vm_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools/$actions/insert-iso', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.InsertVmGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def install_vm_guest_tools(self, body, extId, **kwargs):  # noqa: E501
        """Install Nutanix Guest Tools.
        Install Nutanix Guest Tools.

        >>> response = api.install_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.install_vm_guest_tools(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsInstallConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InstallVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.install_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.install_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def install_vm_guest_tools_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Install Nutanix Guest Tools.
        Install Nutanix Guest Tools.

        >>> response = api.install_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.install_vm_guest_tools_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsInstallConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.InstallVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method install_vm_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `install_vm_guest_tools`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `install_vm_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools/$actions/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.InstallVmGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cdroms(self, vmExtId, **kwargs):  # noqa: E501
        """List CD-ROMs for the VM.
        List CD-ROMs for the VM.

        >>> response = api.list_cdroms(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cdroms(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListCdromsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cdroms_with_http_info(vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_cdroms_with_http_info(vmExtId, **kwargs)  # noqa: E501
            return data

    def list_cdroms_with_http_info(self, vmExtId, **kwargs):  # noqa: E501
        """List CD-ROMs for the VM.
        List CD-ROMs for the VM.

        >>> response = api.list_cdroms(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_cdroms_with_http_info(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListCdromsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cdroms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `list_cdroms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListCdromsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_disks(self, vmExtId, **kwargs):  # noqa: E501
        """List Disks for the VM.
        List Disks for the VM.

        >>> response = api.list_disks(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_disks(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListDisksResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_disks_with_http_info(vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_disks_with_http_info(vmExtId, **kwargs)  # noqa: E501
            return data

    def list_disks_with_http_info(self, vmExtId, **kwargs):  # noqa: E501
        """List Disks for the VM.
        List Disks for the VM.

        >>> response = api.list_disks(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_disks_with_http_info(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListDisksResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_disks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `list_disks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/disks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListDisksResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_gpus(self, vmExtId, **kwargs):  # noqa: E501
        """List GPUs for the VM.
        List GPUs for the VM.

        >>> response = api.list_gpus(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_gpus(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_gpus_with_http_info(vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_gpus_with_http_info(vmExtId, **kwargs)  # noqa: E501
            return data

    def list_gpus_with_http_info(self, vmExtId, **kwargs):  # noqa: E501
        """List GPUs for the VM.
        List GPUs for the VM.

        >>> response = api.list_gpus(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_gpus_with_http_info(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListGpusResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_gpus" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `list_gpus`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/gpus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListGpusResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_nics(self, vmExtId, **kwargs):  # noqa: E501
        """List NICs for the VM.
        List NICs for the VM.

        >>> response = api.list_nics(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_nics(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListNicsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_nics_with_http_info(vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_nics_with_http_info(vmExtId, **kwargs)  # noqa: E501
            return data

    def list_nics_with_http_info(self, vmExtId, **kwargs):  # noqa: E501
        """List NICs for the VM.
        List NICs for the VM.

        >>> response = api.list_nics(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_nics_with_http_info(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListNicsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_nics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `list_nics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListNicsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_serial_ports(self, vmExtId, **kwargs):  # noqa: E501
        """List SerialPort for the VM.
        List SerialPort for the VM.

        >>> response = api.list_serial_ports(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_serial_ports(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListSerialPortsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_serial_ports_with_http_info(vmExtId, **kwargs)  # noqa: E501
        else:
            (data) = self.list_serial_ports_with_http_info(vmExtId, **kwargs)  # noqa: E501
            return data

    def list_serial_ports_with_http_info(self, vmExtId, **kwargs):  # noqa: E501
        """List SerialPort for the VM.
        List SerialPort for the VM.

        >>> response = api.list_serial_ports(vmExtId, (optional) _page, (optional) _limit)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_serial_ports_with_http_info(vmExtId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param bool async_req:
        :return: vmm.v4.ahv.config.ListSerialPortsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', '_page', '_limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_serial_ports" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `list_serial_ports`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/serial-ports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListSerialPortsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_vms(self, **kwargs):  # noqa: E501
        """List VMs.
        List VMs.

        >>> response = api.list_vms((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vms(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/extId
        - cpuPassthroughEnabled
        - gpuConsoleEnabled
        - hardwareClockTimezone
        - host/extId
        - isAgentVm
        - liveMigrateCapable
        - machineType
        - memoryOvercommitEnabled
        - memorySizeBytes
        - name
        - numCoresPerSocket
        - numSockets
        - numThreadsPerCore
        - numVnumaNodes
        - powerState
        - vgaConsoleEnabled
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - memorySizeBytes
        - name
        - numCoresPerSocket
        - numSockets
        - numThreadsPerCore
        - numVnumaNodes
        
        :param bool async_req:
        :return: vmm.v4.ahv.config.ListVmsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_vms_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_vms_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_vms_with_http_info(self, **kwargs):  # noqa: E501
        """List VMs.
        List VMs.

        >>> response = api.list_vms((optional) _page, (optional) _limit, (optional) _filter, (optional) _orderby)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_vms_with_http_info(async_req=True)
        >>> result = thread.get()

        :param int _page: A URL query parameter that specifies the page number of the result set.  Must be a positive integer between 0 and the maximum number of pages that are available for that resource. Any number out of this range will lead to no results being returned.

        :param int _limit: A URL query parameter that specifies the total number of records returned in the result set.  Must be a positive integer between 0 and 100. Any number out of this range will lead to a validation error. If the limit is not provided a default value of 50 records will be returned in the result set.

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - cluster/extId
        - cpuPassthroughEnabled
        - gpuConsoleEnabled
        - hardwareClockTimezone
        - host/extId
        - isAgentVm
        - liveMigrateCapable
        - machineType
        - memoryOvercommitEnabled
        - memorySizeBytes
        - name
        - numCoresPerSocket
        - numSockets
        - numThreadsPerCore
        - numVnumaNodes
        - powerState
        - vgaConsoleEnabled
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - memorySizeBytes
        - name
        - numCoresPerSocket
        - numSockets
        - numThreadsPerCore
        - numVnumaNodes
        
        :param bool async_req:
        :return: vmm.v4.ahv.config.ListVmsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_page', '_limit', '_filter', '_orderby']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_vms" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_page' in params:
            query_params.append(('$page', params['_page']))  # noqa: E501
        if '_limit' in params:
            query_params.append(('$limit', params['_limit']))  # noqa: E501
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ListVmsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def migrate_nic(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Migrate a VM NIC.
        Migrate a VM NIC.

        >>> response = api.migrate_nic(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_nic(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.MigrateNicConfig body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.MigrateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.migrate_nic_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.migrate_nic_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def migrate_nic_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Migrate a VM NIC.
        Migrate a VM NIC.

        >>> response = api.migrate_nic(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.migrate_nic_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.MigrateNicConfig body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.MigrateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method migrate_nic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `migrate_nic`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `migrate_nic`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `migrate_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}/$actions/migrate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.MigrateNicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def power_cycle_vm(self, extId, **kwargs):  # noqa: E501
        """Restart the VM.
        Restart the VM.

        >>> response = api.power_cycle_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_cycle_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerCycleVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.power_cycle_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.power_cycle_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def power_cycle_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Restart the VM.
        Restart the VM.

        >>> response = api.power_cycle_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_cycle_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerCycleVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method power_cycle_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `power_cycle_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/power-cycle', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.PowerCycleVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def power_off_vm(self, extId, **kwargs):  # noqa: E501
        """Turn off the VM.
        Turn off the VM.

        >>> response = api.power_off_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_off_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerOffVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.power_off_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.power_off_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def power_off_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Turn off the VM.
        Turn off the VM.

        >>> response = api.power_off_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_off_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerOffVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method power_off_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `power_off_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/power-off', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.PowerOffVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def power_on_vm(self, extId, **kwargs):  # noqa: E501
        """Turn on the VM.
        Turn on the VM.

        >>> response = api.power_on_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_on_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerOnVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.power_on_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.power_on_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def power_on_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Turn on the VM.
        Turn on the VM.

        >>> response = api.power_on_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.power_on_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.PowerOnVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method power_on_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `power_on_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/power-on', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.PowerOnVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reboot_vm(self, body, extId, **kwargs):  # noqa: E501
        """Restart the VM using ACPI.
        Restart the VM using ACPI.

        >>> response = api.reboot_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reboot_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.ACPIPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RebootVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reboot_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.reboot_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def reboot_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Restart the VM using ACPI.
        Restart the VM using ACPI.

        >>> response = api.reboot_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reboot_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.ACPIPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.RebootVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reboot_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `reboot_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `reboot_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/reboot', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.RebootVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def release_ip(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Release an IP address from a VM NIC.
        Release an IP address from a VM NIC.

        >>> response = api.release_ip(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.release_ip(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ReleaseIpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.release_ip_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.release_ip_with_http_info(vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def release_ip_with_http_info(self, vmExtId, extId, **kwargs):  # noqa: E501
        """Release an IP address from a VM NIC.
        Release an IP address from a VM NIC.

        >>> response = api.release_ip(vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.release_ip_with_http_info(vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ReleaseIpResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method release_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `release_ip`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `release_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}/$actions/release-ip', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ReleaseIpResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reset_vm(self, extId, **kwargs):  # noqa: E501
        """Reset the VM immediately without waiting for the guest VM to shutdown itself.
        Reset the VM immediately without waiting for the guest VM to shutdown itself.

        >>> response = api.reset_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_vm(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ResetVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reset_vm_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.reset_vm_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def reset_vm_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Reset the VM immediately without waiting for the guest VM to shutdown itself.
        Reset the VM immediately without waiting for the guest VM to shutdown itself.

        >>> response = api.reset_vm(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_vm_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ResetVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reset_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `reset_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/reset', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ResetVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def shutdown_vm(self, body, extId, **kwargs):  # noqa: E501
        """Shutdown the VM using ACPI.
        Shutdown the VM using ACPI.

        >>> response = api.shutdown_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shutdown_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.ACPIPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ShutdownVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.shutdown_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.shutdown_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def shutdown_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Shutdown the VM using ACPI.
        Shutdown the VM using ACPI.

        >>> response = api.shutdown_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shutdown_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.ACPIPowerOptions body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.ShutdownVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method shutdown_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `shutdown_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `shutdown_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/$actions/shutdown', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.ShutdownVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def uninstall_vm_guest_tools(self, extId, **kwargs):  # noqa: E501
        """Uninstall Nutanix Guest Tools.
        Uninstall Nutanix Guest Tools.

        >>> response = api.uninstall_vm_guest_tools(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.uninstall_vm_guest_tools(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UninstallVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.uninstall_vm_guest_tools_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.uninstall_vm_guest_tools_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def uninstall_vm_guest_tools_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Uninstall Nutanix Guest Tools.
        Uninstall Nutanix Guest Tools.

        >>> response = api.uninstall_vm_guest_tools(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.uninstall_vm_guest_tools_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UninstallVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method uninstall_vm_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `uninstall_vm_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools/$actions/uninstall', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UninstallVmGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_cdrom(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update CD-ROM for the VM.
        Update CD-ROM for the VM.

        >>> response = api.update_cdrom(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_cdrom(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Cdrom body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_cdrom_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_cdrom_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def update_cdrom_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update CD-ROM for the VM.
        Update CD-ROM for the VM.

        >>> response = api.update_cdrom(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_cdrom_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Cdrom body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a CD-ROM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateCdromResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_cdrom" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_cdrom`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `update_cdrom`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_cdrom`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/cdroms/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateCdromResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_disk(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update Disk for the VM.
        Update Disk for the VM.

        >>> response = api.update_disk(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_disk(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Disk body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_disk_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_disk_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def update_disk_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update Disk for the VM.
        Update Disk for the VM.

        >>> response = api.update_disk(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_disk_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Disk body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM disk. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateDiskResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_disk" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_disk`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `update_disk`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_disk`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/disks/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateDiskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_guest_tools(self, body, extId, **kwargs):  # noqa: E501
        """Update Nutanix Guest Tools information for a VM.
        Update Nutanix Guest Tools information for a VM.

        >>> response = api.update_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_guest_tools(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestTools body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_guest_tools_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update Nutanix Guest Tools information for a VM.
        Update Nutanix Guest Tools information for a VM.

        >>> response = api.update_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_guest_tools_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestTools body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_guest_tools`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools-config', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_nic(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update NIC for the VM.
        Update NIC for the VM.

        >>> response = api.update_nic(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_nic(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Nic body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_nic_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_nic_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def update_nic_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update NIC for the VM.
        Update NIC for the VM.

        >>> response = api.update_nic(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_nic_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Nic body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a VM NIC. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateNicResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_nic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_nic`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `update_nic`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_nic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/nics/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateNicResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_serial_port(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update SerialPort for the VM.
        Update SerialPort for the VM.

        >>> response = api.update_serial_port(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_serial_port(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.SerialPort body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_serial_port_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_serial_port_with_http_info(body, vmExtId, extId, **kwargs)  # noqa: E501
            return data

    def update_serial_port_with_http_info(self, body, vmExtId, extId, **kwargs):  # noqa: E501
        """Update SerialPort for the VM.
        Update SerialPort for the VM.

        >>> response = api.update_serial_port(body, vmExtId, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_serial_port_with_http_info(body, vmExtId, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.SerialPort body: (required)
        :param str vmExtId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param str extId: Globally unique identifier of a serial port. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateSerialPortResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'vmExtId', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_serial_port" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_serial_port`")  # noqa: E501
        # verify the required parameter 'vmExtId' is set
        if ('vmExtId' not in params or
                params['vmExtId'] is None):
            raise ValueError("Missing the required parameter `vmExtId` when calling `update_serial_port`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_serial_port`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'vmExtId' in params:
            path_params['vmExtId'] = params['vmExtId']  # noqa: E501
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{vmExtId}/serial-ports/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateSerialPortResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_vm(self, body, extId, **kwargs):  # noqa: E501
        """Update VM.
        Update VM.

        >>> response = api.update_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Vm body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_vm_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_vm_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update VM.
        Update VM.

        >>> response = api.update_vm(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.Vm body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_vm`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_vm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateVmResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_vm_categories(self, body, extId, **kwargs):  # noqa: E501
        """Update categories for the VM.
        Update categories for the VM.

        >>> response = api.update_vm_categories(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_categories(body, extId, async_req=True)
        >>> result = thread.get()

        :param list[vmm.v4.ahv.config.CategoryReference] body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmCategoriesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_vm_categories_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_vm_categories_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_vm_categories_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update categories for the VM.
        Update categories for the VM.

        >>> response = api.update_vm_categories(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_categories_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param list[vmm.v4.ahv.config.CategoryReference] body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmCategoriesResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_vm_categories`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_vm_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/categories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateVmCategoriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_vm_ownership_info(self, body, extId, **kwargs):  # noqa: E501
        """Update ownership information for the VM.
        Update ownership information for the VM.

        >>> response = api.update_vm_ownership_info(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_ownership_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.OwnershipInfo body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmOwnershipInfoResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_vm_ownership_info_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.update_vm_ownership_info_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def update_vm_ownership_info_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Update ownership information for the VM.
        Update ownership information for the VM.

        >>> response = api.update_vm_ownership_info(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_vm_ownership_info_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.OwnershipInfo body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpdateVmOwnershipInfoResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_vm_ownership_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_vm_ownership_info`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `update_vm_ownership_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/ownership-info', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpdateVmOwnershipInfoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upgrade_vm_guest_tools(self, body, extId, **kwargs):  # noqa: E501
        """Upgrade Nutanix Guest Tools.
        Upgrade Nutanix Guest Tools.

        >>> response = api.upgrade_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upgrade_vm_guest_tools(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsUpgradeConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpgradeVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upgrade_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
        else:
            (data) = self.upgrade_vm_guest_tools_with_http_info(body, extId, **kwargs)  # noqa: E501
            return data

    def upgrade_vm_guest_tools_with_http_info(self, body, extId, **kwargs):  # noqa: E501
        """Upgrade Nutanix Guest Tools.
        Upgrade Nutanix Guest Tools.

        >>> response = api.upgrade_vm_guest_tools(body, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upgrade_vm_guest_tools_with_http_info(body, extId, async_req=True)
        >>> result = thread.get()

        :param vmm.v4.ahv.config.GuestToolsUpgradeConfig body: (required)
        :param str extId: Globally unique identifier of a VM. It should be of type UUID. (required)
        :param bool async_req:
        :return: vmm.v4.ahv.config.UpgradeVmGuestToolsResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_vm_guest_tools" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `upgrade_vm_guest_tools`")  # noqa: E501
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `upgrade_vm_guest_tools`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/vmm/v4.0.a1/ahv/config/vms/{extId}/guest-tools/$actions/upgrade', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='vmm.v4.ahv.config.UpgradeVmGuestToolsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
