# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.NetworkFunctionNicType import NetworkFunctionNicType  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.NicMacAddress import NicMacAddress  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.NicModel import NicModel  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.NicType import NicType  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.Reference import Reference  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.VMTemplateIPAddress import VMTemplateIPAddress  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.VlanMode import VlanMode  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VMTemplateNic(object):
    """VMTemplateNic - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'nic_id': 'str',
        'nic_type': 'vmm.v4.config.NicType',
        'vlan_mode': 'vmm.v4.config.VlanMode',
        'trunked_vlans': 'list[int]',
        'mac_address': 'vmm.v4.config.NicMacAddress',
        'ip_endpoints': 'list[vmm.v4.config.VMTemplateIPAddress]',
        'subnet_reference': 'vmm.v4.config.Reference',
        'network_function_chain_reference': 'vmm.v4.config.Reference',
        'network_function_nic_type': 'vmm.v4.config.NetworkFunctionNicType',
        'model': 'vmm.v4.config.NicModel',
        'is_connected': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'nic_id': 'nicId',
        'nic_type': 'nicType',
        'vlan_mode': 'vlanMode',
        'trunked_vlans': 'trunkedVlans',
        'mac_address': 'macAddress',
        'ip_endpoints': 'ipEndpoints',
        'subnet_reference': 'subnetReference',
        'network_function_chain_reference': 'networkFunctionChainReference',
        'network_function_nic_type': 'networkFunctionNicType',
        'model': 'model',
        'is_connected': 'isConnected',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, nic_id=None, nic_type=None, vlan_mode=None, trunked_vlans=None, mac_address=None, ip_endpoints=None, subnet_reference=None, network_function_chain_reference=None, network_function_nic_type=None, model=None, is_connected=None, *args, **kwargs):  # noqa: E501
        """VMTemplateNic - a model defined in Swagger
            \nVirtual Machine NIC.
        """
        self.__nic_id = None
        self.__nic_type = None
        self.__vlan_mode = None
        self.__trunked_vlans = None
        self.__mac_address = None
        self.__ip_endpoints = None
        self.__subnet_reference = None
        self.__network_function_chain_reference = None
        self.__network_function_nic_type = None
        self.__model = None
        self.__is_connected = None
        self.discriminator = None
        if nic_id is not None:
            self.__nic_id = nic_id
        if nic_type is not None:
            self.__nic_type = nic_type
        if vlan_mode is not None:
            self.__vlan_mode = vlan_mode
        if trunked_vlans is not None:
            self.__trunked_vlans = trunked_vlans
        if mac_address is not None:
            self.__mac_address = mac_address
        if ip_endpoints is not None:
            self.__ip_endpoints = ip_endpoints
        if subnet_reference is not None:
            self.__subnet_reference = subnet_reference
        if network_function_chain_reference is not None:
            self.__network_function_chain_reference = network_function_chain_reference
        if network_function_nic_type is not None:
            self.__network_function_nic_type = network_function_nic_type
        if model is not None:
            self.__model = model
        if is_connected is not None:
            self.__is_connected = is_connected
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'vmm.v4.config.VMTemplateNic'

    def _initialize_fq_object_type(self):
        return 'vmm.v4.r0.a1.config.VMTemplateNic'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def nic_id(self):
        """`{ str }`
            \nThe NIC's UUID, which is used to uniquely identify this particular NIC. This UUID may be used to refer to the NIC outside the context of the particular VM it is attached to.
        """ # noqa: E501
        return self.__nic_id

    @nic_id.setter
    def nic_id(self, nic_id):
        if nic_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', nic_id):  # noqa: E501
            raise ValueError(r"Invalid value for `nic_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__nic_id = nic_id

    @property
    def nic_type(self):
        """`{ vmm.v4.config.NicType }`
            
        """ # noqa: E501
        return self.__nic_type

    @nic_type.setter
    def nic_type(self, nic_type):

        self.__nic_type = nic_type

    @property
    def vlan_mode(self):
        """`{ vmm.v4.config.VlanMode }`
            
        """ # noqa: E501
        return self.__vlan_mode

    @vlan_mode.setter
    def vlan_mode(self, vlan_mode):

        self.__vlan_mode = vlan_mode

    @property
    def trunked_vlans(self):
        """`{ list[int] }`
            \nList of networks to trunk if vlanMode is TRUNKED. If empty and VLAN mode is TRUNKED, all VLANs are trunked.
        """ # noqa: E501
        return self.__trunked_vlans

    @trunked_vlans.setter
    def trunked_vlans(self, trunked_vlans):

        self.__trunked_vlans = trunked_vlans

    @property
    def mac_address(self):
        """`{ vmm.v4.config.NicMacAddress }`
            
        """ # noqa: E501
        return self.__mac_address

    @mac_address.setter
    def mac_address(self, mac_address):

        self.__mac_address = mac_address

    @property
    def ip_endpoints(self):
        """`{ list[vmm.v4.config.VMTemplateIPAddress] }`
            \nIP endpoints for the adapter. Currently, IPv4 addresses are supported.
        """ # noqa: E501
        return self.__ip_endpoints

    @ip_endpoints.setter
    def ip_endpoints(self, ip_endpoints):

        self.__ip_endpoints = ip_endpoints

    @property
    def subnet_reference(self):
        """`{ vmm.v4.config.Reference }`
            
        """ # noqa: E501
        return self.__subnet_reference

    @subnet_reference.setter
    def subnet_reference(self, subnet_reference):

        self.__subnet_reference = subnet_reference

    @property
    def network_function_chain_reference(self):
        """`{ vmm.v4.config.Reference }`
            
        """ # noqa: E501
        return self.__network_function_chain_reference

    @network_function_chain_reference.setter
    def network_function_chain_reference(self, network_function_chain_reference):

        self.__network_function_chain_reference = network_function_chain_reference

    @property
    def network_function_nic_type(self):
        """`{ vmm.v4.config.NetworkFunctionNicType }`
            
        """ # noqa: E501
        return self.__network_function_nic_type

    @network_function_nic_type.setter
    def network_function_nic_type(self, network_function_nic_type):

        self.__network_function_nic_type = network_function_nic_type

    @property
    def model(self):
        """`{ vmm.v4.config.NicModel }`
            
        """ # noqa: E501
        return self.__model

    @model.setter
    def model(self, model):

        self.__model = model

    @property
    def is_connected(self):
        """`{ bool }`
            \nWhether or not the NIC is connected. True by default.
        """ # noqa: E501
        return self.__is_connected

    @is_connected.setter
    def is_connected(self, is_connected):

        self.__is_connected = is_connected

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(VMTemplateNic, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMTemplateNic):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

