# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.DataSourceReference import DataSourceReference  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.DiskDeviceProperties import DiskDeviceProperties  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.Reference import Reference  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.config.VMTemplateDiskStorage import VMTemplateDiskStorage  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VMTemplateDisk(object):
    """VMTemplateDisk - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'disk_id': 'str',
        'device_properties': 'vmm.v4.config.DiskDeviceProperties',
        'disk_size_mib': 'int',
        'disk_size_bytes': 'int',
        'data_source_reference': 'vmm.v4.config.DataSourceReference',
        'volume_group_reference': 'vmm.v4.config.Reference',
        'storage_config': 'vmm.v4.config.VMTemplateDiskStorage',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'disk_id': 'diskId',
        'device_properties': 'deviceProperties',
        'disk_size_mib': 'diskSizeMib',
        'disk_size_bytes': 'diskSizeBytes',
        'data_source_reference': 'dataSourceReference',
        'volume_group_reference': 'volumeGroupReference',
        'storage_config': 'storageConfig',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, disk_id=None, device_properties=None, disk_size_mib=None, disk_size_bytes=None, data_source_reference=None, volume_group_reference=None, storage_config=None, *args, **kwargs):  # noqa: E501
        """VMTemplateDisk - a model defined in Swagger
            \nDisk attached to the VM.
        """
        self.__disk_id = None
        self.__device_properties = None
        self.__disk_size_mib = None
        self.__disk_size_bytes = None
        self.__data_source_reference = None
        self.__volume_group_reference = None
        self.__storage_config = None
        self.discriminator = None
        if disk_id is not None:
            self.__disk_id = disk_id
        if device_properties is not None:
            self.__device_properties = device_properties
        if disk_size_mib is not None:
            self.__disk_size_mib = disk_size_mib
        if disk_size_bytes is not None:
            self.__disk_size_bytes = disk_size_bytes
        if data_source_reference is not None:
            self.__data_source_reference = data_source_reference
        if volume_group_reference is not None:
            self.__volume_group_reference = volume_group_reference
        if storage_config is not None:
            self.__storage_config = storage_config
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'vmm.v4.config.VMTemplateDisk'

    def _initialize_fq_object_type(self):
        return 'vmm.v4.r0.a1.config.VMTemplateDisk'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def disk_id(self):
        """`{ str }`
            \nThe device ID which is used to uniquely identify this particular disk.
        """ # noqa: E501
        return self.__disk_id

    @disk_id.setter
    def disk_id(self, disk_id):
        if disk_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', disk_id):  # noqa: E501
            raise ValueError(r"Invalid value for `disk_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__disk_id = disk_id

    @property
    def device_properties(self):
        """`{ vmm.v4.config.DiskDeviceProperties }`
            
        """ # noqa: E501
        return self.__device_properties

    @device_properties.setter
    def device_properties(self, device_properties):

        self.__device_properties = device_properties

    @property
    def disk_size_mib(self):
        """`{ int }`
            \nSize of the disk in MiB. Must match the size specified in diskSizeBytes rounded up to the nearest MiB - when that field is present.
        """ # noqa: E501
        return self.__disk_size_mib

    @disk_size_mib.setter
    def disk_size_mib(self, disk_size_mib):
        if disk_size_mib is not None and disk_size_mib < 1:  # noqa: E501
            raise ValueError("Invalid value for `disk_size_mib`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__disk_size_mib = disk_size_mib

    @property
    def disk_size_bytes(self):
        """`{ int }`
            \nSize of the disk in Bytes.
        """ # noqa: E501
        return self.__disk_size_bytes

    @disk_size_bytes.setter
    def disk_size_bytes(self, disk_size_bytes):
        if disk_size_bytes is not None and disk_size_bytes < 1:  # noqa: E501
            raise ValueError("Invalid value for `disk_size_bytes`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__disk_size_bytes = disk_size_bytes

    @property
    def data_source_reference(self):
        """`{ vmm.v4.config.DataSourceReference }`
            
        """ # noqa: E501
        return self.__data_source_reference

    @data_source_reference.setter
    def data_source_reference(self, data_source_reference):

        self.__data_source_reference = data_source_reference

    @property
    def volume_group_reference(self):
        """`{ vmm.v4.config.Reference }`
            
        """ # noqa: E501
        return self.__volume_group_reference

    @volume_group_reference.setter
    def volume_group_reference(self, volume_group_reference):

        self.__volume_group_reference = volume_group_reference

    @property
    def storage_config(self):
        """`{ vmm.v4.config.VMTemplateDiskStorage }`
            
        """ # noqa: E501
        return self.__storage_config

    @storage_config.setter
    def storage_config(self, storage_config):

        self.__storage_config = storage_config

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(VMTemplateDisk, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMTemplateDisk):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

