# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_vmm_py_client.Ntnx.vmm.v4.ahv.config.DataSource import DataSource  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.ahv.config.VmDiskContainerReference import VmDiskContainerReference  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.vmm.v4.ahv.config.VmDiskStorageConfig import VmDiskStorageConfig  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class VmDisk(object):
    """VmDisk - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'disk_ext_id': 'str',
        'disk_size_bytes': 'int',
        'storage_container': 'vmm.v4.ahv.config.VmDiskContainerReference',
        'storage_config': 'vmm.v4.ahv.config.VmDiskStorageConfig',
        'data_source': 'vmm.v4.ahv.config.DataSource',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'disk_ext_id': 'diskExtId',
        'disk_size_bytes': 'diskSizeBytes',
        'storage_container': 'storageContainer',
        'storage_config': 'storageConfig',
        'data_source': 'dataSource',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, disk_ext_id=None, disk_size_bytes=None, storage_container=None, storage_config=None, data_source=None, *args, **kwargs):  # noqa: E501
        """VmDisk - a model defined in Swagger
            \nStorage provided by Nutanix ADSF
        """
        self.__disk_ext_id = None
        self.__disk_size_bytes = None
        self.__storage_container = None
        self.__storage_config = None
        self.__data_source = None
        self.discriminator = None
        if disk_ext_id is not None:
            self.__disk_ext_id = disk_ext_id
        if disk_size_bytes is not None:
            self.__disk_size_bytes = disk_size_bytes
        if storage_container is not None:
            self.__storage_container = storage_container
        if storage_config is not None:
            self.__storage_config = storage_config
        if data_source is not None:
            self.__data_source = data_source
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'vmm.v4.ahv.config.VmDisk'

    def _initialize_fq_object_type(self):
        return 'vmm.v4.r0.a1.ahv.config.VmDisk'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def disk_ext_id(self):
        """`{ str }`
            \nGlobally unique identifier of a VM disk. It should be of type UUID.
        """ # noqa: E501
        return self.__disk_ext_id

    @disk_ext_id.setter
    def disk_ext_id(self, disk_ext_id):
        if disk_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', disk_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `disk_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__disk_ext_id = disk_ext_id

    @property
    def disk_size_bytes(self):
        """`{ int }`
            \nSize of the disk in Bytes
        """ # noqa: E501
        return self.__disk_size_bytes

    @disk_size_bytes.setter
    def disk_size_bytes(self, disk_size_bytes):
        if disk_size_bytes is not None and disk_size_bytes < 1:  # noqa: E501
            raise ValueError("Invalid value for `disk_size_bytes`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__disk_size_bytes = disk_size_bytes

    @property
    def storage_container(self):
        """`{ vmm.v4.ahv.config.VmDiskContainerReference }`
            
        """ # noqa: E501
        return self.__storage_container

    @storage_container.setter
    def storage_container(self, storage_container):

        self.__storage_container = storage_container

    @property
    def storage_config(self):
        """`{ vmm.v4.ahv.config.VmDiskStorageConfig }`
            
        """ # noqa: E501
        return self.__storage_config

    @storage_config.setter
    def storage_config(self, storage_config):

        self.__storage_config = storage_config

    @property
    def data_source(self):
        """`{ vmm.v4.ahv.config.DataSource }`
            
        """ # noqa: E501
        return self.__data_source

    @data_source.setter
    def data_source(self, data_source):

        self.__data_source = data_source

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(VmDisk, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VmDisk):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

