# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_vmm_py_client.Ntnx.vmm.v4.ahv.config.EmulatedNicModel import EmulatedNicModel  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class EmulatedNic(object):
    """EmulatedNic - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'model': 'vmm.v4.ahv.config.EmulatedNicModel',
        'mac_address': 'str',
        'is_connected': 'bool',
        'num_queues': 'int',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'model': 'model',
        'mac_address': 'macAddress',
        'is_connected': 'isConnected',
        'num_queues': 'numQueues',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, model=None, mac_address=None, is_connected=True, num_queues=1, *args, **kwargs):  # noqa: E501
        """EmulatedNic - a model defined in Swagger
            \nDefines a NIC emulated by the hypervisor
        """
        self.__model = None
        self.__mac_address = None
        self.__is_connected = None
        self.__num_queues = None
        self.discriminator = None
        if model is not None:
            self.__model = model
        if mac_address is not None:
            self.__mac_address = mac_address
        if is_connected is not None:
            self.__is_connected = is_connected
        if num_queues is not None:
            self.__num_queues = num_queues
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'vmm.v4.ahv.config.EmulatedNic'

    def _initialize_fq_object_type(self):
        return 'vmm.v4.r0.a1.ahv.config.EmulatedNic'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def model(self):
        """`{ vmm.v4.ahv.config.EmulatedNicModel }`
            
        """ # noqa: E501
        return self.__model

    @model.setter
    def model(self, model):

        self.__model = model

    @property
    def mac_address(self):
        """`{ str }`
            \nMAC address of the emulated NIC.
        """ # noqa: E501
        return self.__mac_address

    @mac_address.setter
    def mac_address(self, mac_address):
        if mac_address is not None and not re.search('^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$', mac_address):  # noqa: E501
            raise ValueError(r"Invalid value for `mac_address`, must be a follow pattern or equal to `/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$/`")  # noqa: E501

        self.__mac_address = mac_address

    @property
    def is_connected(self):
        """`{ bool }`
            \nIndicates whether the NIC is connected or not. Default is True.
        """ # noqa: E501
        return self.__is_connected

    @is_connected.setter
    def is_connected(self, is_connected):

        self.__is_connected = is_connected

    @property
    def num_queues(self):
        """`{ int }`
            \nThe number of Tx/Rx queue pairs for this NIC.
        """ # noqa: E501
        return self.__num_queues

    @num_queues.setter
    def num_queues(self, num_queues):

        self.__num_queues = num_queues

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(EmulatedNic, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EmulatedNic):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

