# coding: utf-8


"""
IGNORE:
    Nutanix Vmm Versioned APIs

    Manage the life-cycle of virtual machines hosted on Nutanix  # noqa: E501

    OpenAPI spec version: 4.0.2-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_vmm_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.dataprotection.v4.config.RecoveryPointStatus import RecoveryPointStatus  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.dataprotection.v4.config.RecoveryPointType import RecoveryPointType  # noqa: F401,E501
from ntnx_vmm_py_client.Ntnx.dataprotection.v4.config.VendorSpecificProperty import VendorSpecificProperty  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class RecoveryPointProperties(ExternalizableAbstractModel):
    """RecoveryPointProperties - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'location_agnostic_id': 'str',
        'name': 'str',
        'creation_time': 'datetime',
        'expiration_time': 'datetime',
        'status': 'dataprotection.v4.config.RecoveryPointStatus',
        'recovery_point_type': 'dataprotection.v4.config.RecoveryPointType',
        'consistency_group_ext_id': 'str',
        'consistency_group_name': 'str',
        'vendor_specific_properties': 'list[dataprotection.v4.config.VendorSpecificProperty]',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'location_agnostic_id': 'locationAgnosticId',
        'name': 'name',
        'creation_time': 'creationTime',
        'expiration_time': 'expirationTime',
        'status': 'status',
        'recovery_point_type': 'recoveryPointType',
        'consistency_group_ext_id': 'consistencyGroupExtId',
        'consistency_group_name': 'consistencyGroupName',
        'vendor_specific_properties': 'vendorSpecificProperties',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, location_agnostic_id=None, name=None, creation_time=None, expiration_time=None, status=None, recovery_point_type=None, consistency_group_ext_id=None, consistency_group_name=None, vendor_specific_properties=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """RecoveryPointProperties - a model defined in Swagger
            \nA model that represents common properties of a Recovery point resources
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__location_agnostic_id = None
        self.__name = None
        self.__creation_time = None
        self.__expiration_time = None
        self.__status = None
        self.__recovery_point_type = None
        self.__consistency_group_ext_id = None
        self.__consistency_group_name = None
        self.__vendor_specific_properties = None
        self.discriminator = None
        if location_agnostic_id is not None:
            self.__location_agnostic_id = location_agnostic_id
        if name is not None:
            self.__name = name
        if creation_time is not None:
            self.__creation_time = creation_time
        if expiration_time is not None:
            self.__expiration_time = expiration_time
        if status is not None:
            self.__status = status
        if recovery_point_type is not None:
            self.__recovery_point_type = recovery_point_type
        if consistency_group_ext_id is not None:
            self.__consistency_group_ext_id = consistency_group_ext_id
        if consistency_group_name is not None:
            self.__consistency_group_name = consistency_group_name
        if vendor_specific_properties is not None:
            self.__vendor_specific_properties = vendor_specific_properties

    def _initialize_object_type(self):
        return 'dataprotection.v4.config.RecoveryPointProperties'

    def _initialize_fq_object_type(self):
        return 'dataprotection.v4.r0.a2.config.RecoveryPointProperties'


    @property
    def location_agnostic_id(self):
        """`{ str }`
            \nLocation agnostic identifier of the Recovery point.
        """ # noqa: E501
        return self.__location_agnostic_id

    @location_agnostic_id.setter
    def location_agnostic_id(self, location_agnostic_id):
        if location_agnostic_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', location_agnostic_id):  # noqa: E501
            raise ValueError(r"Invalid value for `location_agnostic_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__location_agnostic_id = location_agnostic_id

    @property
    def name(self):
        """`{ str }`
            \nThe name of the Recovery point.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):

        self.__name = name

    @property
    def creation_time(self):
        """`{ datetime }`
            \nThe UTC date and time in ISO-8601 format when the Recovery point is created.
        """ # noqa: E501
        return self.__creation_time

    @creation_time.setter
    def creation_time(self, creation_time):

        self.__creation_time = creation_time

    @property
    def expiration_time(self):
        """`{ datetime }`
            \nThe UTC date and time in ISO-8601 format when the current Recovery point expires and will be garbage collected.
        """ # noqa: E501
        return self.__expiration_time

    @expiration_time.setter
    def expiration_time(self, expiration_time):

        self.__expiration_time = expiration_time

    @property
    def status(self):
        """`{ dataprotection.v4.config.RecoveryPointStatus }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def recovery_point_type(self):
        """`{ dataprotection.v4.config.RecoveryPointType }`
            
        """ # noqa: E501
        return self.__recovery_point_type

    @recovery_point_type.setter
    def recovery_point_type(self, recovery_point_type):

        self.__recovery_point_type = recovery_point_type

    @property
    def consistency_group_ext_id(self):
        """`{ str }`
            \nThe external identifier that can be used to retrieve the consistency group using its URL.
        """ # noqa: E501
        return self.__consistency_group_ext_id

    @consistency_group_ext_id.setter
    def consistency_group_ext_id(self, consistency_group_ext_id):
        if consistency_group_ext_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', consistency_group_ext_id):  # noqa: E501
            raise ValueError(r"Invalid value for `consistency_group_ext_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__consistency_group_ext_id = consistency_group_ext_id

    @property
    def consistency_group_name(self):
        """`{ str }`
            \nName of the Consistency group.
        """ # noqa: E501
        return self.__consistency_group_name

    @consistency_group_name.setter
    def consistency_group_name(self, consistency_group_name):

        self.__consistency_group_name = consistency_group_name

    @property
    def vendor_specific_properties(self):
        """`{ list[dataprotection.v4.config.VendorSpecificProperty] }`
            \nList of additional metadata provided by the client at the time of Recovery point creation.
        """ # noqa: E501
        return self.__vendor_specific_properties

    @vendor_specific_properties.setter
    def vendor_specific_properties(self, vendor_specific_properties):

        self.__vendor_specific_properties = vendor_specific_properties

    def _to_dict(self, sanitize):
        """
        Returns the model properties as a dict. Omits None properties based on the provided "sanitize" parameter.
        :param bool sanitize
        """

        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x._to_dict(sanitize) if hasattr(x, "_to_dict") else x,
                    value
                ))
            elif hasattr(value, "_to_dict"):
                result[attr] = value._to_dict(sanitize)
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1]._to_dict(sanitize))
                    if hasattr(item[1], "_to_dict") else item,
                    six.iteritems(value)
                ))
            else:
                if sanitize:
                    if value is not None:
                        result[attr] = value
                else:
                    result[attr] = value
        if issubclass(RecoveryPointProperties, dict):
            for key, value in six.iteritems(self):
                result[key] = value

        return result

    def to_dict(self):
        """Returns the model properties as a dict"""
        return self._to_dict(False)

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self._to_dict(True))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecoveryPointProperties):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

