<h1 align="center">
  OLS Client
</h1>

<p align="center">
    <a href="https://github.com/cthoyt/ols-client/actions?query=workflow%3ATests">
        <img alt="Tests" src="https://github.com/cthoyt/ols-client/workflows/Tests/badge.svg" />
    </a>
    <a href="https://pypi.org/project/ols_client">
        <img alt="PyPI" src="https://img.shields.io/pypi/v/ols_client" />
    </a>
    <a href="https://pypi.org/project/ols_client">
        <img alt="PyPI - Python Version" src="https://img.shields.io/pypi/pyversions/ols_client" />
    </a>
    <a href="https://github.com/cthoyt/ols-client/blob/main/LICENSE">
        <img alt="PyPI - License" src="https://img.shields.io/pypi/l/ols_client" />
    </a>
    <a href='https://ols_client.readthedocs.io/en/latest/?badge=latest'>
        <img src='https://readthedocs.org/projects/ols_client/badge/?version=latest' alt='Documentation Status' />
    </a>
    <a href="https://codecov.io/gh/cthoyt/ols-client/branch/main">
        <img src="https://codecov.io/gh/cthoyt/ols-client/branch/main/graph/badge.svg" alt="Codecov status" />
    </a>  
    <a href="https://github.com/cthoyt/cookiecutter-python-package">
        <img alt="Cookiecutter template from @cthoyt" src="https://img.shields.io/badge/Cookiecutter-snekpack-blue" /> 
    </a>
    <a href='https://github.com/psf/black'>
        <img src='https://img.shields.io/badge/code%20style-black-000000.svg' alt='Code style: black' />
    </a>
    <a href="https://github.com/cthoyt/ols-client/blob/main/.github/CODE_OF_CONDUCT.md">
        <img src="https://img.shields.io/badge/Contributor%20Covenant-2.1-4baaaa.svg" alt="Contributor Covenant"/>
    </a>
    <a href="https://zenodo.org/badge/latestdoi/97004286">
        <img src="https://zenodo.org/badge/97004286.svg" alt="DOI">
    </a>
</p>

A client to the EBI Ontology Lookup Service (OLS) and other instances.

## 💪 Getting Started

One of several OLS clients can be instantiated and accessed with the same API:

```python
from ols_client import EBIClient

ebi_client = EBIClient()
ontologies = ebi_client.get_ontologies()
```

Further documentation can be found at
[ols-client.readthedocs.io](https://ols-client.readthedocs.io).

## 🚀 Installation

The most recent release can be installed from
[PyPI](https://pypi.org/project/ols_client/) with:

```bash
$ pip install ols_client
```

The most recent code and data can be installed directly from GitHub with:

```bash
$ pip install git+https://github.com/cthoyt/ols-client.git
```

## 👐 Contributing

Contributions, whether filing an issue, making a pull request, or forking, are appreciated. See
[CONTRIBUTING.md](https://github.com/cthoyt/ols-client/blob/master/.github/CONTRIBUTING.md) for more information on getting involved.

## 👋 Attribution

### ⚖️ License

The code in this package is licensed under the MIT License.

### Related

Since the creation of this repository, the EBI has also generated their
own client that can be found at https://github.com/Ensembl/ols-client and
on PyPI as `ebi-ols-client`.

### 🍪 Cookiecutter

This package was created with [@audreyfeldroy](https://github.com/audreyfeldroy)'s
[cookiecutter](https://github.com/cookiecutter/cookiecutter) package using [@cthoyt](https://github.com/cthoyt)'s
[cookiecutter-snekpack](https://github.com/cthoyt/cookiecutter-snekpack) template.

## 🛠️ For Developers

<details>
  <summary>See developer instructions</summary>


The final section of the README is for if you want to get involved by making a code contribution.

### Development Installation

To install in development mode, use the following:

```bash
$ git clone git+https://github.com/cthoyt/ols-client.git
$ cd ols-client
$ pip install -e .
```

### 🥼 Testing

After cloning the repository and installing `tox` with `pip install tox`, the unit tests in the `tests/` folder can be
run reproducibly with:

```shell
$ tox
```

Additionally, these tests are automatically re-run with each commit in a [GitHub Action](https://github.com/cthoyt/ols-client/actions?query=workflow%3ATests).

### 📖 Building the Documentation

The documentation can be built locally using the following:

```shell
$ git clone git+https://github.com/cthoyt/ols-client.git
$ cd ols-client
$ tox -e docs
$ open docs/build/html/index.html
``` 

The documentation automatically installs the package as well as the `docs`
extra specified in the [`setup.cfg`](setup.cfg). `sphinx` plugins
like `texext` can be added there. Additionally, they need to be added to the
`extensions` list in [`docs/source/conf.py`](docs/source/conf.py).

### 📦 Making a Release

After installing the package in development mode and installing
`tox` with `pip install tox`, the commands for making a new release are contained within the `finish` environment
in `tox.ini`. Run the following from the shell:

```shell
$ tox -e finish
```

This script does the following:

1. Uses [Bump2Version](https://github.com/c4urself/bump2version) to switch the version number in the `setup.cfg`,
   `src/ols_client/version.py`, and [`docs/source/conf.py`](docs/source/conf.py) to not have the `-dev` suffix
2. Packages the code in both a tar archive and a wheel using [`build`](https://github.com/pypa/build)
3. Uploads to PyPI using [`twine`](https://github.com/pypa/twine). Be sure to have a `.pypirc` file configured to avoid the need for manual input at this
   step
4. Push to GitHub. You'll need to make a release going with the commit where the version was bumped.
5. Bump the version to the next patch. If you made big changes and want to bump the version by minor, you can
   use `tox -e bumpversion minor` after.
</details>
