/*
 * Decompiled with CFR 0.152.
 */
package mdbtools;

import java.io.IOException;
import mdbtools.jdbc2.File;
import mdbtools.libmdb.Catalog;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.file;
import mdbtools.libmdb.mem;

public class mdb_tables {
    public static void main(String[] args) {
        MdbHandle mdb;
        int i;
        char delimiter = '\u0000';
        boolean line_break = false;
        boolean skip_sys = true;
        if (args.length < 1) {
            System.out.println("Usage: mdb_tables [-S] [-1 | -d<delimiter>] <file>");
            return;
        }
        block9: for (i = 0; i < args.length; ++i) {
            char opt = args[i].charAt(0);
            if (opt != '-') continue;
            opt = args[i].charAt(1);
            switch (opt) {
                case 'S': {
                    skip_sys = false;
                }
                case '1': {
                    line_break = true;
                    continue block9;
                }
                case 'd': {
                    delimiter = args[i].charAt(2);
                }
            }
        }
        mem.mdb_init();
        try {
            mdb = file.mdb_open(new File(args[0]));
            Catalog.mdb_read_catalog(mdb, 1);
        }
        catch (IOException e) {
            System.out.println("Couldn't open or read database.\n");
            e.printStackTrace();
            return;
        }
        System.out.println("num_catalog: " + mdb.num_catalog);
        for (i = 0; i < mdb.num_catalog; ++i) {
            MdbCatalogEntry entry = (MdbCatalogEntry)mdb.catalog.get(i);
            if (entry.object_type != 1 || skip_sys && entry.object_name.startsWith("MSys")) continue;
            if (line_break) {
                System.out.println(entry.object_name);
                continue;
            }
            if (delimiter != '\u0000') {
                System.out.print(entry.object_name + delimiter);
                continue;
            }
            System.out.print(entry.object_name + " ");
        }
        if (!line_break) {
            System.out.println("");
        }
        try {
            mem.mdb_free_handle(mdb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

