/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ColumbusReader
extends FormatReader {
    private static final String XML_FILE = "MeasurementIndex.ColumbusIDX.xml";
    private static final String MAGIC = "ColumbusMeasurementIndex";
    private ArrayList<String> metadataFiles = new ArrayList();
    private ArrayList<Plane> planes = new ArrayList();
    private MinimalTiffReader reader;
    private int nFields = 0;
    private String acquisitionDate;

    public ColumbusReader() {
        super("PerkinElmer Columbus", new String[]{"xml"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.suffixSufficient = false;
        this.datasetDescription = "Directory with XML file and one .tif/.tiff file per plane";
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 2;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        String localName = new Location(name).getName();
        if (localName.equals(XML_FILE)) {
            return true;
        }
        if (null != ColumbusReader.findXML(name)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String check = stream.readString(1024);
        return check.indexOf(MAGIC) > 0;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        for (String file2 : this.metadataFiles) {
            if (!new Location(file2).exists()) continue;
            files.add(file2);
        }
        if (!noPixels) {
            for (Plane p : this.planes) {
                if (p.series != this.getSeries() || files.contains(p.file) || !new Location(p.file).exists()) continue;
                files.add(p.file);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.metadataFiles.clear();
            this.planes.clear();
            this.nFields = 0;
            this.acquisitionDate = null;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] zct = this.getZCTCoords(no);
        Plane p = null;
        for (Plane plane : this.planes) {
            if (plane.series != this.getSeries() || plane.timepoint != zct[2] || plane.channel != zct[1]) continue;
            p = plane;
            break;
        }
        Arrays.fill(buf, (byte)0);
        if (p != null && new Location(p.file).exists()) {
            this.reader.setId(p.file);
            if (p.fileIndex < this.reader.getImageCount()) {
                this.reader.openBytes(p.fileIndex, buf, x, y, w, h2);
            } else {
                LOGGER.warn("Blank plane for series {} plane {}; {} may be truncated", this.getSeries(), no, p.file);
            }
        }
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Location xml = ColumbusReader.findXML(id);
        if (null == xml) {
            throw new FormatException("Could not find MeasurementIndex.ColumbusIDX.xml");
        }
        id = xml.getAbsolutePath();
        super.initFile(id);
        Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
        String xmlData = DataTools.readFile(id);
        MeasurementHandler handler = new MeasurementHandler();
        XMLTools.parseXML(xmlData, (DefaultHandler)handler);
        Object[] parentDirectories = parent.list(true);
        Arrays.sort(parentDirectories);
        ArrayList<String> timepointDirs = new ArrayList<String>();
        for (Object file2 : parentDirectories) {
            Location absFile = new Location(parent, (String)file2);
            if (!absFile.isDirectory()) continue;
            timepointDirs.add(absFile.getAbsolutePath());
            for (String f : absFile.list(true)) {
                if (ColumbusReader.checkSuffix(f, "tif") || this.metadataFiles.contains((String)file2 + File.separator + f)) continue;
                this.metadataFiles.add((String)file2 + File.separator + f);
            }
        }
        for (int i = 0; i < this.metadataFiles.size(); ++i) {
            String metadataFile = this.metadataFiles.get(i);
            int end = metadataFile.indexOf(File.separator);
            String timepointPath = end < 0 ? "" : parent + File.separator + metadataFile.substring(0, end);
            Location f = new Location(parent + File.separator + metadataFile);
            if (!f.exists()) {
                metadataFile = metadataFile.substring(end + 1);
                f = new Location(parent, metadataFile);
            }
            String path = f.getAbsolutePath();
            this.metadataFiles.set(i, path);
            if (!ColumbusReader.checkSuffix(path, "columbusidx.xml")) continue;
            int timepoint = timepointDirs.indexOf(timepointPath);
            if (timepointDirs.size() == 0) {
                timepoint = 0;
            }
            this.parseImageXML(path, timepoint);
        }
        Comparator<Plane> planeComp = new Comparator<Plane>(){

            @Override
            public int compare(Plane p1, Plane p2) {
                if (p1.row != p2.row) {
                    return p1.row - p2.row;
                }
                if (p1.col != p2.col) {
                    return p1.col - p2.col;
                }
                if (p1.field != p2.field) {
                    return p1.field - p2.field;
                }
                if (p1.timepoint != p2.timepoint) {
                    return p1.timepoint - p2.timepoint;
                }
                if (p1.channel != p2.channel) {
                    return p1.channel - p2.channel;
                }
                return 0;
            }
        };
        Plane[] tmpPlanes = this.planes.toArray(new Plane[this.planes.size()]);
        Arrays.sort(tmpPlanes, planeComp);
        this.planes.clear();
        this.reader = new MinimalTiffReader();
        this.reader.setId(tmpPlanes[0].file);
        this.core = this.reader.getCoreMetadataList();
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeC = 0;
        m3.sizeT = 0;
        ArrayList<Integer> uniqueSamples = new ArrayList<Integer>();
        ArrayList<Integer> uniqueRows = new ArrayList<Integer>();
        ArrayList<Integer> uniqueCols = new ArrayList<Integer>();
        for (Plane p : tmpPlanes) {
            this.planes.add(p);
            int sampleIndex = p.row * handler.getPlateColumns() + p.col;
            if (!uniqueSamples.contains(sampleIndex)) {
                uniqueSamples.add(sampleIndex);
            }
            if (!uniqueRows.contains(p.row)) {
                uniqueRows.add(p.row);
            }
            if (!uniqueCols.contains(p.col)) {
                uniqueCols.add(p.col);
            }
            if (p.field >= this.nFields) {
                this.nFields = p.field + 1;
            }
            if (p.channel >= this.getSizeC()) {
                m3.sizeC = p.channel + 1;
            }
            if (p.timepoint < this.getSizeT()) continue;
            m3.sizeT = p.timepoint + 1;
        }
        m3.sizeZ = 1;
        m3.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m3.dimensionOrder = "XYCTZ";
        m3.rgb = false;
        int seriesCount = uniqueSamples.size() * this.nFields;
        for (int i = 1; i < seriesCount; ++i) {
            this.core.add(m3);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        store.setScreenID(MetadataTools.createLSID("Screen", 0), 0);
        store.setScreenName(handler.getScreenName(), 0);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateName(handler.getPlateName(), 0);
        store.setPlateRows(new PositiveInteger(handler.getPlateRows()), 0);
        store.setPlateColumns(new PositiveInteger(handler.getPlateColumns()), 0);
        String imagePrefix = handler.getPlateName() + " Well ";
        int wellSample = 0;
        int nextWell = -1;
        Timestamp date = new Timestamp(this.acquisitionDate);
        long timestampSeconds = date.asInstant().getMillis() / 1000L;
        for (Integer row : uniqueRows) {
            for (Integer col : uniqueCols) {
                if (!uniqueSamples.contains(row * handler.getPlateColumns() + col)) continue;
                store.setWellID(MetadataTools.createLSID("Well", 0, ++nextWell), 0, nextWell);
                store.setWellRow(new NonNegativeInteger(row), 0, nextWell);
                store.setWellColumn(new NonNegativeInteger(col), 0, nextWell);
                for (int field = 0; field < this.nFields; ++field) {
                    Plane p = this.lookupPlane(row, col, field, 0, 0);
                    String wellSampleID = MetadataTools.createLSID("WellSample", 0, nextWell, field);
                    store.setWellSampleID(wellSampleID, 0, nextWell, field);
                    store.setWellSampleIndex(new NonNegativeInteger(wellSample), 0, nextWell, field);
                    if (p != null) {
                        store.setWellSamplePositionX(new Length(p.positionX, UNITS.REFERENCEFRAME), 0, nextWell, field);
                        store.setWellSamplePositionY(new Length(p.positionY, UNITS.REFERENCEFRAME), 0, nextWell, field);
                    }
                    String imageID = MetadataTools.createLSID("Image", wellSample);
                    store.setImageID(imageID, wellSample);
                    store.setWellSampleImageRef(imageID, 0, nextWell, field);
                    store.setImageName(imagePrefix + (char)(row + 65) + (col + 1) + " Field #" + (field + 1), wellSample);
                    store.setImageAcquisitionDate(date, wellSample);
                    if (p != null) {
                        p.series = wellSample;
                        store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(p.sizeX), p.series);
                        store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(p.sizeY), p.series);
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            p = this.lookupPlane(row, col, field, 0, c);
                            if (p != null) {
                                p.series = wellSample;
                                store.setChannelName(p.channelName, p.series, p.channel);
                                if ((int)p.emWavelength > 0) {
                                    store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength(p.emWavelength), p.series, p.channel);
                                }
                                if ((int)p.exWavelength > 0) {
                                    store.setChannelExcitationWavelength(FormatTools.getExcitationWavelength(p.exWavelength), p.series, p.channel);
                                }
                                store.setChannelColor(p.channelColor, p.series, p.channel);
                            }
                            for (int t = 0; t < this.getSizeT(); ++t) {
                                p = this.lookupPlane(row, col, field, t, c);
                                if (p == null) continue;
                                p.series = wellSample;
                                store.setPlaneDeltaT(new Time(p.deltaT - (double)timestampSeconds, UNITS.SECOND), p.series, this.getIndex(0, c, t));
                            }
                        }
                    }
                    ++wellSample;
                }
            }
        }
    }

    private void parseImageXML(String filename, int externalTime) throws FormatException, IOException {
        NodeList images;
        LOGGER.info("Parsing image data from {} with timepoint {}", (Object)filename, (Object)externalTime);
        String xml = DataTools.readFile(filename);
        Location parent = new Location(filename).getParentFile();
        Element root = null;
        try {
            ByteArrayInputStream s2 = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            root = XMLTools.parseDOM(s2).getDocumentElement();
            s2.close();
        }
        catch (ParserConfigurationException e) {
            throw new FormatException(e);
        }
        catch (SAXException e) {
            throw new FormatException(e);
        }
        NodeList plates = root.getElementsByTagName("Plates");
        if (plates == null) {
            LOGGER.debug("Plates node not found");
            return;
        }
        if ((plates = ((Element)plates.item(0)).getElementsByTagName("Plate")) == null) {
            LOGGER.debug("Plate nodes not found");
            return;
        }
        NodeList timestamps = ((Element)plates.item(0)).getElementsByTagName("MeasurementStartTime");
        if (externalTime <= 0) {
            this.acquisitionDate = ((Element)timestamps.item(0)).getTextContent();
        }
        if ((images = root.getElementsByTagName("Images")) == null) {
            LOGGER.debug("Images node not found");
            return;
        }
        if ((images = ((Element)images.item(0)).getElementsByTagName("Image")) == null) {
            LOGGER.debug("Image nodes not found");
            return;
        }
        LOGGER.debug("Found {} image definitions", (Object)images.getLength());
        for (int i = 0; i < images.getLength(); ++i) {
            Element image = (Element)images.item(i);
            Plane p = new Plane();
            NodeList children = image.getChildNodes();
            for (int q = 0; q < children.getLength(); ++q) {
                String unit;
                Node child = children.item(q);
                String name = child.getNodeName();
                String value = child.getTextContent();
                NamedNodeMap attrs = child.getAttributes();
                if (name.equals("URL")) {
                    p.file = new Location(parent, value).getAbsolutePath();
                    String buffer = attrs.getNamedItem("BufferNo").getNodeValue();
                    p.fileIndex = Integer.parseInt(buffer);
                    continue;
                }
                if (name.equals("Row")) {
                    p.row = Integer.parseInt(value) - 1;
                    continue;
                }
                if (name.equals("Col")) {
                    p.col = Integer.parseInt(value) - 1;
                    continue;
                }
                if (name.equals("FieldID")) {
                    p.field = Integer.parseInt(value) - 1;
                    continue;
                }
                if (name.equals("TimepointID")) {
                    p.timepoint = Integer.parseInt(value) - 1;
                    if (p.timepoint != 0) continue;
                    p.timepoint = externalTime;
                    continue;
                }
                if (name.equals("ChannelID")) {
                    p.channel = Integer.parseInt(value) - 1;
                    continue;
                }
                if (name.equals("ChannelName")) {
                    p.channelName = value;
                    continue;
                }
                if (name.equals("ChannelColor")) {
                    Long color = new Long(value);
                    int blue = (int)(color >> 24 & 0xFFL);
                    int green = (int)(color >> 16 & 0xFFL);
                    int red = (int)(color >> 8 & 0xFFL);
                    int n = (int)(color & 0xFFL);
                    continue;
                }
                if (name.equals("MeasurementTimeOffset")) {
                    p.deltaT = new Double(value);
                    continue;
                }
                if (name.equals("AbsTime")) {
                    p.deltaT = (double)new Timestamp(value).asInstant().getMillis() / 1000.0;
                    continue;
                }
                if (name.equals("MainEmissionWavelength")) {
                    p.emWavelength = new Double(value);
                    continue;
                }
                if (name.equals("MainExcitationWavelength")) {
                    p.exWavelength = new Double(value);
                    continue;
                }
                if (name.equals("ImageResolutionX")) {
                    unit = attrs.getNamedItem("Unit").getNodeValue();
                    p.sizeX = this.correctUnits(new Double(value), unit);
                    continue;
                }
                if (name.equals("ImageResolutionY")) {
                    unit = attrs.getNamedItem("Unit").getNodeValue();
                    p.sizeY = this.correctUnits(new Double(value), unit);
                    continue;
                }
                if (name.equals("PositionX")) {
                    unit = attrs.getNamedItem("Unit").getNodeValue();
                    p.positionX = this.correctUnits(new Double(value), unit);
                    continue;
                }
                if (name.equals("PositionY")) {
                    unit = attrs.getNamedItem("Unit").getNodeValue();
                    p.positionY = this.correctUnits(new Double(value), unit);
                    continue;
                }
                if (!name.equals("PositionZ")) continue;
                unit = attrs.getNamedItem("Unit").getNodeValue();
                p.positionZ = this.correctUnits(new Double(value), unit);
            }
            this.planes.add(p);
        }
    }

    private Double correctUnits(Double v, String unit) {
        if (unit == null) {
            return v;
        }
        if (unit.equals("m")) {
            return v * 1000000.0;
        }
        if (unit.equals("cm")) {
            return v * 10000.0;
        }
        if (unit.equals("nm")) {
            v = v / 1000.0;
            return v;
        }
        return v;
    }

    private Plane lookupPlane(int row, int col, int field, int t, int c) {
        for (Plane p : this.planes) {
            if (p.row != row || p.col != col || p.field != field || p.timepoint != t || p.channel != c) continue;
            return p;
        }
        LOGGER.warn("Could not find plane for row={}, column={}, field={}, t={}, c={}", row, col, field, t, c);
        return null;
    }

    private static Location findXML(String name) {
        Location parent = new Location(name).getAbsoluteFile().getParentFile();
        Location xml = new Location(parent, XML_FILE);
        if (xml.exists()) {
            return xml;
        }
        if (parent.getParent() != null && (xml = new Location(parent.getParentFile(), XML_FILE)).exists()) {
            return xml;
        }
        return null;
    }

    class Plane {
        public String file;
        public int fileIndex;
        public int row;
        public int col;
        public int field;
        public int timepoint;
        public int channel;
        public double deltaT;
        public double emWavelength;
        public double exWavelength;
        public String channelName;
        public Color channelColor;
        public double sizeX;
        public double sizeY;
        public double positionX;
        public double positionY;
        public double positionZ;
        public int series;

        Plane() {
        }
    }

    class MeasurementHandler
    extends BaseHandler {
        private String currentName;
        private String screenName;
        private String plateName;
        private String plateType;
        private String measurementID;
        private String measurementName;
        private Integer plateRows;
        private Integer plateColumns;
        private StringBuffer currentValue;

        MeasurementHandler() {
        }

        public String getScreenName() {
            return this.screenName;
        }

        public String getPlateName() {
            return this.plateName;
        }

        public String getPlateType() {
            return this.plateType;
        }

        public String getMeasurementID() {
            return this.measurementID;
        }

        public String getMeasurementName() {
            return this.measurementName;
        }

        public Integer getPlateRows() {
            return this.plateRows;
        }

        public Integer getPlateColumns() {
            return this.plateColumns;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            this.currentValue.append(value);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentName = qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                if (!this.currentName.equals("Measurement") || !name.equals("MeasurementID")) continue;
                this.measurementID = value;
            }
            this.currentValue = new StringBuffer();
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.currentName == null) {
                return;
            }
            String value = this.currentValue.toString();
            ColumbusReader.this.addGlobalMeta(this.currentName, value);
            if (this.currentName.equals("ScreenName")) {
                this.screenName = value;
            } else if (this.currentName.equals("PlateName")) {
                this.plateName = value;
            } else if (this.currentName.equals("PlateType")) {
                this.plateType = value;
            } else if (this.currentName.equals("Measurement")) {
                this.measurementName = value;
            } else if (this.currentName.equals("Reference")) {
                ColumbusReader.this.metadataFiles.add(new Location(value).toString());
            } else if (this.currentName.equals("PlateRows")) {
                this.plateRows = new Integer(value);
            } else if (this.currentName.equals("PlateColumns")) {
                this.plateColumns = new Integer(value);
            }
            this.currentName = null;
        }
    }
}

