/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.utilities;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class ResourceUtilities {
    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix) {
        try {
            return ResourceUtilities.copyResourceToTempFile(resource, prefix, postfix);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String tryCopyResourceToTempFile(String resource, String prefix, String postfix, boolean cleanUpOldResources) {
        try {
            return ResourceUtilities.copyResourceToTempFile(resource, prefix, postfix, cleanUpOldResources);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String copyResourceToTempFile(String resource, String prefix, String postfix) throws IOExceptionUnchecked {
        return ResourceUtilities.copyResourceToTempFile(resource, prefix, postfix, false);
    }

    public static String copyResourceToTempFile(String resource, String prefix, String postfix, boolean cleanUpOldResources) throws IOExceptionUnchecked {
        InputStream resourceStream;
        if (cleanUpOldResources) {
            ResourceUtilities.deleteOldResourceTempFiles(prefix, postfix);
        }
        if ((resourceStream = ResourceUtilities.class.getResourceAsStream(resource)) == null) {
            throw new IllegalArgumentException("Resource '" + resource + "' not found.");
        }
        try {
            File tempFile = File.createTempFile(prefix, postfix);
            tempFile.deleteOnExit();
            FileOutputStream fileStream = new FileOutputStream(tempFile);
            try {
                IOUtils.copy(resourceStream, (OutputStream)fileStream);
                ((OutputStream)fileStream).close();
            }
            finally {
                IOUtils.closeQuietly(fileStream);
            }
            String string = tempFile.getAbsolutePath();
            return string;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly(resourceStream);
        }
    }

    private static void deleteOldResourceTempFiles(String prefix, String postfix) {
        WildcardFileFilter filter = new WildcardFileFilter(String.valueOf(prefix) + "*" + postfix);
        File[] fileArray = new File(System.getProperty("java.io.tmpdir")).listFiles(filter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            file2.delete();
            ++n2;
        }
    }
}

