[![Build Status](https://www.travis-ci.com/vantage-sh/vantage-python.svg?branch=main)](https://www.travis-ci.com/vantage-sh/vantage-python)

# Vantage Python Client

![Vantage Picture](https://uploads-ssl.webflow.com/5f9ba05ba40d6414f341df34/5f9bb1764b6670c6f7739564_moutain-scene.svg)

[Vantage](http://vantage.sh/) is a cloud cost transparency platform. This is the official Ruby client for the [Vantage API](http://vantage.readme.io/). You can use the API to get EC2 instance price and product information through a few simple-to-use API calls. The data offered through this API is heavily inspired from data avaiable from [ec2instances.info](http://ec2instances.info/). The feedback we get from users is that this API is significantly easier than learning and using AWS Pricing APIs. We have plans to expand the data available through this API in the future.

## Need Help?

Feel free to join us in our [community Slack](https://join.slack.com/t/vantagecommunity/shared_invite/zt-oey52myv-gq4AWRKkX25kjp1UGziPTw) in the #api channel. We're happy to chat and help. You're also welcome to email support@vantage.sh or ping [@JoinVantage](https://twitter.com/joinvantage) on Twitter and we're happy to give assistance. Lastly, we monitor issues on this repo if you have any feature requests or issues. 

## Installation

The easiest way to get going is to install the client through RubyGems:

```shell
pip install vantage-client
```

Then import the package:
```python
import vantage 
```

## Generate a Free API Token
The Vantage API is provided completely for free but requires an API token to use. To generate a free API token, follow these steps:

* Head to [http://vantage.sh/](http://vantage.sh/)
* Register a free account and confirm your email
* When you're asked _"What would you like to do first?"_ click _"Access Cloud Pricing API"_
* Create an API token from the account profile page and you're all set

You'll only need to do this once and you can use your API token for all usage going forward. 

## Client

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.1
- Package version: 0.1.0b2
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.vantage.sh](https://www.vantage.sh)

## Requirements.

Python 2.7 and 3.4+

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import vantage
from vantage.rest import ApiException
from pprint import pprint

# Configure OAuth2 access token for authorization: oauth2
configuration = vantage.Configuration()
configuration.access_token = 'YOUR_ACCESS_TOKEN'

# create an instance of the API class
api_instance = vantage.CostsApi(vantage.ApiClient(configuration))
report_id = 'report_id_example' # str | 
start_date = 'start_date_example' # str | Query costs by the first date you would like to filter from. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00. (optional)
end_date = 'end_date_example' # str | Query costs by the last date you would like to filter to. ISO 8601 Formatted - 2021-07-15 or 2021-07-15T19:20:48+00:00. (optional)
page = 2 # int | The page of results to return. (optional)
limit = 500 # int | The amount of results to return. The maximum is 1000 (optional)

try:
    api_response = api_instance.get_costs(report_id, start_date=start_date, end_date=end_date, page=page, limit=limit)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CostsApi->get_costs: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.vantage.sh*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CostsApi* | [**get_costs**](docs/CostsApi.md#get_costs) | **GET** /v1/reports/{report_id}/costs | 
*CostsApi* | [**get_report**](docs/CostsApi.md#get_report) | **GET** /v1/reports/{report_id} | 
*CostsApi* | [**get_reports**](docs/CostsApi.md#get_reports) | **GET** /v1/reports | 
*PingApi* | [**ping**](docs/PingApi.md#ping) | **GET** /v1/ping | 
*PricesApi* | [**get_price**](docs/PricesApi.md#get_price) | **GET** /v1/products/{product_id}/prices/{id} | 
*PricesApi* | [**get_prices**](docs/PricesApi.md#get_prices) | **GET** /v1/products/{product_id}/prices | 
*PricesApi* | [**get_product**](docs/PricesApi.md#get_product) | **GET** /v1/products/{id} | 
*PricesApi* | [**get_products**](docs/PricesApi.md#get_products) | **GET** /v1/products | 
*PricesApi* | [**get_providers**](docs/PricesApi.md#get_providers) | **GET** /v1/providers | 
*PricesApi* | [**get_services**](docs/PricesApi.md#get_services) | **GET** /v1/services | 


## Documentation For Models

 - [Cost](docs/Cost.md)
 - [Costs](docs/Costs.md)
 - [Price](docs/Price.md)
 - [Prices](docs/Prices.md)
 - [Product](docs/Product.md)
 - [Products](docs/Products.md)
 - [Provider](docs/Provider.md)
 - [Providers](docs/Providers.md)
 - [Report](docs/Report.md)
 - [Reports](docs/Reports.md)
 - [Service](docs/Service.md)
 - [Services](docs/Services.md)


## Documentation For Authorization


## oauth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **read**: Grants read access


## Author

support@vantage.sh

