Moon Phases API
============

Moon Phases is a simple tool for getting the moon phases. It returns the moon phase for a given date.

![Build Status](https://img.shields.io/badge/build-passing-green)
![Code Climate](https://img.shields.io/badge/maintainability-B-purple)
![Prod Ready](https://img.shields.io/badge/production-ready-blue)

This is a Python API Wrapper for the [Moon Phases API](https://apiverve.com/marketplace/api/moonphases)

---

## Installation
	pip install apiverve-moonphases

---

## Configuration

Before using the moonphases API client, you have to setup your account and obtain your API Key.  
You can get it by signing up at [https://apiverve.com](https://apiverve.com)

---

## Usage

The Moon Phases API documentation is found here: [https://docs.apiverve.com/api/moonphases](https://docs.apiverve.com/api/moonphases).  
You can find parameters, example responses, and status codes documented here.

### Setup

```
# Import the client module
from apiverve_moonphases.apiClient import MoonphasesAPIClient

# Initialize the client with your APIVerve API key
api = MoonphasesAPIClient("[YOUR_API_KEY]")
```

---


### Perform Request
Using the API client, you can perform requests to the API.

###### Define Query

```
query = { "date": "05-26-2024" }
```

###### Simple Request

```
# Make a request to the API
result = api.execute(query)

# Print the result
print(result)
```

###### Example Response

```
{
  "status": "ok",
  "error": null,
  "data": {
    "phase": "First Quarter",
    "phaseEmoji": "🌓",
    "waxing": true,
    "waning": false,
    "lunarAge": 7.6931005661480931,
    "lunarAgePercent": 0.26051295161482813,
    "lunationNumber": 1254,
    "lunarDistance": 63.3482661665232,
    "nextFullMoon": "2024-06-15T00:00:00Z",
    "lastFullMoon": "2024-04-16T00:00:00Z"
  }
}
```

---

## Customer Support

Need any assistance? [Get in touch with Customer Support](https://apiverve.com/contact).

---

## Updates
Stay up to date by following [@apiverveHQ](https://twitter.com/apiverveHQ) on Twitter.

---

## Legal

All usage of the APIVerve website, API, and services is subject to the [APIVerve Terms of Service](https://apiverve.com/terms) and all legal documents and agreements.

---

## License
Licensed under the The MIT License (MIT)

Copyright (&copy;) 2024 APIVerve, and Evlar LLC

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.