"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailLogging = exports.TrailLoggingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailLoggingProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrailLogging; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ACTIONTRAIL::TrailLogging`, which is used to enable or disable trail logging.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTrailLogging`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-actiontrail-traillogging
 */
class TrailLogging extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTrailLogging = new actiontrail_generated_1.RosTrailLogging(this, id, {
            enable: props.enable,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrailLogging;
        this.attrIsLogging = rosTrailLogging.attrIsLogging;
        this.attrLatestDeliveryError = rosTrailLogging.attrLatestDeliveryError;
        this.attrLatestDeliveryTime = rosTrailLogging.attrLatestDeliveryTime;
        this.attrStartLoggingTime = rosTrailLogging.attrStartLoggingTime;
        this.attrStopLoggingTime = rosTrailLogging.attrStopLoggingTime;
    }
}
exports.TrailLogging = TrailLogging;
//# sourceMappingURL=data:application/json;base64,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