"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trail = exports.TrailProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrail; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ACTIONTRAIL::Trail`, which is used to create a trail to deliver events to Simple Log Service or Object Storage Service (OSS).
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTrail`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-actiontrail-trail
 */
class Trail extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTrail = new actiontrail_generated_1.RosTrail(this, id, {
            slsProjectArn: props.slsProjectArn,
            roleName: props.roleName,
            eventRw: props.eventRw === undefined || props.eventRw === null ? 'Write' : props.eventRw,
            ossKeyPrefix: props.ossKeyPrefix,
            ossBucketName: props.ossBucketName,
            slsWriteRoleArn: props.slsWriteRoleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrail;
        this.attrName = rosTrail.attrName;
    }
}
exports.Trail = Trail;
//# sourceMappingURL=data:application/json;base64,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