# Generated by Django 1.10.5 on 2017-02-15 09:34
from django.db import migrations


def rename_settings(apps, schema_editor):
    """Rename settings."""
    LocalConfig = apps.get_model("core", "LocalConfig")
    lc = LocalConfig.objects.first()
    condition = (
        lc and
        "admin" in lc._parameters and
        "default_domain_quota" in lc._parameters["admin"]
    )
    if condition:
        lc._parameters["admin"]["default_mailbox_quota"] = (
            lc._parameters["admin"]["default_domain_quota"])
        del lc._parameters["admin"]["default_domain_quota"]
        lc.save(update_fields=["_parameters"])


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0011_auto_20161104_2217'),
    ]

    operations = [
        migrations.RunPython(rename_settings)
    ]
