# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_misc_utils.ipynb.

# %% auto 0
__all__ = ['Timer', 'print_red', 'DivertedPrints']

# %% ../nbs/00_misc_utils.ipynb 3
import sys
from io import StringIO
import time

# %% ../nbs/00_misc_utils.ipynb 4
class Timer():
    text = "Elapsed time: {:0.4f} seconds"
    logger = print
    _start_time = None

    def start(self):
        self._start_time = time.perf_counter()

    def stop(self):
        elapsed_time = time.perf_counter() - self._start_time
        self._start_time = None
        if self.logger:
            self.logger(self.text.format(elapsed_time))

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, *exc_info):
        self.stop()

# %% ../nbs/00_misc_utils.ipynb 6
def print_red(text):
    print(f"\x1b[31m{text}\x1b[0m")

# %% ../nbs/00_misc_utils.ipynb 9
class DivertedPrints:
    """A context manager for suppressing `print` output"""
    def __enter__(self):
        self._original_stdout = sys.stdout
        self.diverted = StringIO()
        sys.stdout = self.diverted
        return self.diverted
    def __exit__(self, exc_type, exc_val, exc_tb):
        sys.stdout = self._original_stdout
        self.diverted.close()
