# Changelog

## 4.4.1 (2025-07-09)

Full Changelog: [v4.4.0...v4.4.1](https://github.com/orbcorp/orb-python/compare/v4.4.0...v4.4.1)

### Bug Fixes

* **parsing:** correctly handle nested discriminated unions ([7911534](https://github.com/orbcorp/orb-python/commit/791153479d7474d601721dee8f6d3776738fb166))


### Chores

* **internal:** bump pinned h11 dep ([efc47f2](https://github.com/orbcorp/orb-python/commit/efc47f2b2d20840cbef95824091cd2d5a9676dbf))
* **package:** mark python 3.13 as supported ([21d5e3b](https://github.com/orbcorp/orb-python/commit/21d5e3b4494b542d1b72ff9deab08d6736c349e1))

## 4.4.0 (2025-07-08)

Full Changelog: [v4.3.0...v4.4.0](https://github.com/orbcorp/orb-python/compare/v4.3.0...v4.4.0)

### Features

* **api:** api update ([28ac408](https://github.com/orbcorp/orb-python/commit/28ac408261fe805dffaa9460a9d4697309684d81))


### Chores

* **internal:** codegen related update ([80cb62d](https://github.com/orbcorp/orb-python/commit/80cb62d0ffe9ce19db93c6fa9bbd1b92acd7b5b3))

## 4.3.0 (2025-07-04)

Full Changelog: [v4.2.2...v4.3.0](https://github.com/orbcorp/orb-python/compare/v4.2.2...v4.3.0)

### Features

* **api:** api update ([0b3de08](https://github.com/orbcorp/orb-python/commit/0b3de08c2025ef8eb906445dcf00a7e807ad5efa))


### Chores

* **ci:** change upload type ([5faccd9](https://github.com/orbcorp/orb-python/commit/5faccd99a99d35c4f2a2a9de676b97f971f31cb1))

## 4.2.2 (2025-06-29)

Full Changelog: [v4.2.1...v4.2.2](https://github.com/orbcorp/orb-python/compare/v4.2.1...v4.2.2)

### Bug Fixes

* **ci:** correct conditional ([b0e1f19](https://github.com/orbcorp/orb-python/commit/b0e1f199cb2e10484399e0af3604a91e3c7d48bb))


### Chores

* **ci:** only run for pushes and fork pull requests ([e1cbecc](https://github.com/orbcorp/orb-python/commit/e1cbeccba5d407c8a7314c52e98a8b05c0b0049c))

## 4.2.1 (2025-06-26)

Full Changelog: [v4.2.0...v4.2.1](https://github.com/orbcorp/orb-python/compare/v4.2.0...v4.2.1)

### Bug Fixes

* **ci:** release-doctor — report correct token name ([1d8a57a](https://github.com/orbcorp/orb-python/commit/1d8a57a938f215d4b2ef504ae3c537b2c2a87d29))

## 4.2.0 (2025-06-26)

Full Changelog: [v4.1.0...v4.2.0](https://github.com/orbcorp/orb-python/compare/v4.1.0...v4.2.0)

### Features

* **api:** api update ([80e56fb](https://github.com/orbcorp/orb-python/commit/80e56fbdab24c23f26e22cb49b50b4a087522bc9))

## 4.1.0 (2025-06-23)

Full Changelog: [v4.0.1...v4.1.0](https://github.com/orbcorp/orb-python/compare/v4.0.1...v4.1.0)

### Features

* **api:** api update ([145fb49](https://github.com/orbcorp/orb-python/commit/145fb49e263d98b69ebc44766fb21256792fb408))
* **api:** api update ([3e7554d](https://github.com/orbcorp/orb-python/commit/3e7554d9cb500e444e5e72c39324e8d478842dde))
* **api:** api update ([54a55d0](https://github.com/orbcorp/orb-python/commit/54a55d0284936e49b95b011203a57c1c844c34f9))
* **client:** add support for aiohttp ([afa214a](https://github.com/orbcorp/orb-python/commit/afa214aa4a2fc5db65335f063784df2e6e61292e))


### Bug Fixes

* **tests:** fix: tests which call HTTP endpoints directly with the example parameters ([9e77c70](https://github.com/orbcorp/orb-python/commit/9e77c705608f1f437d3487d1a8f3dbb383a7e533))


### Chores

* **ci:** enable for pull requests ([897e15e](https://github.com/orbcorp/orb-python/commit/897e15e361e1fd1a5941122f2fcbc025610c231b))
* **internal:** update conftest.py ([981e413](https://github.com/orbcorp/orb-python/commit/981e41335feb9bc86d7e465b12112854c5277c55))
* **readme:** update badges ([121b76c](https://github.com/orbcorp/orb-python/commit/121b76c47ed179936c95dd3a4033e25a49d68d8a))
* **tests:** add tests for httpx client instantiation & proxies ([41f738c](https://github.com/orbcorp/orb-python/commit/41f738c81995546912f43a79c61172557fe2153a))
* **tests:** skip some failing tests on the latest python versions ([b67c12c](https://github.com/orbcorp/orb-python/commit/b67c12ca7d3e2c860848de2a3018eb6b24a69c4d))


### Documentation

* **client:** fix httpx.Timeout documentation reference ([3d851a6](https://github.com/orbcorp/orb-python/commit/3d851a625d25c16779644d2bba29e0f8c9e87c7e))

## 4.0.1 (2025-06-12)

Full Changelog: [v4.0.0...v4.0.1](https://github.com/orbcorp/orb-python/compare/v4.0.0...v4.0.1)

### Bug Fixes

* **client:** correctly parse binary response | stream ([08ecc1c](https://github.com/orbcorp/orb-python/commit/08ecc1c10f8c26e66c02e333b89e910cedd61570))


### Chores

* **tests:** run tests in parallel ([f228f15](https://github.com/orbcorp/orb-python/commit/f228f15fa9f2fdaf5b7398a3f233aea4419ba3fb))

## 4.0.0 (2025-06-09)

Full Changelog: [v3.24.0...v4.0.0](https://github.com/orbcorp/orb-python/compare/v3.24.0...v4.0.0)

### ⚠ BREAKING CHANGES

* **client:** breaking change to re-use types

### Features

* **api:** api update ([1703727](https://github.com/orbcorp/orb-python/commit/17037277fa161738f83680233c04f597741b1c1c))
* **api:** api update ([a76a33a](https://github.com/orbcorp/orb-python/commit/a76a33a422924747a24845a5e083cdca26e59c9b))
* **api:** manual updates ([45ce124](https://github.com/orbcorp/orb-python/commit/45ce124f58e30ccb43cc3e0d3e3ce9c28c0b54a2))
* **client:** breaking change to re-use types ([fd639a0](https://github.com/orbcorp/orb-python/commit/fd639a083f97949fea5cdbc9c0e24b593445d44f))

## 3.24.0 (2025-06-04)

Full Changelog: [v3.23.0...v3.24.0](https://github.com/orbcorp/orb-python/compare/v3.23.0...v3.24.0)

### Features

* **api:** api update ([4e8a240](https://github.com/orbcorp/orb-python/commit/4e8a2406e262ffcb459d2b1bbac33c40f2a785a6))
* **api:** api update ([46147bc](https://github.com/orbcorp/orb-python/commit/46147bca3aac31572571312652965f1c84cd07ee))

## 3.23.0 (2025-06-03)

Full Changelog: [v3.22.0...v3.23.0](https://github.com/orbcorp/orb-python/compare/v3.22.0...v3.23.0)

### Features

* **api:** api update ([da2ddad](https://github.com/orbcorp/orb-python/commit/da2ddad9a2cc90f81402d472bc2a3964690e73ec))

## 3.22.0 (2025-06-02)

Full Changelog: [v3.21.0...v3.22.0](https://github.com/orbcorp/orb-python/compare/v3.21.0...v3.22.0)

### Features

* **api:** api update ([3deb3ab](https://github.com/orbcorp/orb-python/commit/3deb3ab6bf04d89551aa40deba99afcd29ee8099))
* **client:** add follow_redirects request option ([5185843](https://github.com/orbcorp/orb-python/commit/51858434884f222b3c9974529aaf1958e5fba808))


### Chores

* **docs:** remove reference to rye shell ([c0cdb68](https://github.com/orbcorp/orb-python/commit/c0cdb684679416fb188bc77f8e822f8bcb345b50))

## 3.21.0 (2025-05-30)

Full Changelog: [v3.20.0...v3.21.0](https://github.com/orbcorp/orb-python/compare/v3.20.0...v3.21.0)

### Features

* **api:** api update ([d82dadb](https://github.com/orbcorp/orb-python/commit/d82dadb202a59dcf2a3d7f64a3352ea79f63ac18))

## 3.20.0 (2025-05-28)

Full Changelog: [v3.19.4...v3.20.0](https://github.com/orbcorp/orb-python/compare/v3.19.4...v3.20.0)

### Features

* **api:** api update ([fdbf7cd](https://github.com/orbcorp/orb-python/commit/fdbf7cdf4722807ab09f34d7fdc99b7858b8c516))
* **api:** api update ([3d10507](https://github.com/orbcorp/orb-python/commit/3d10507620fa336baa4832e15bcea21d90f238bb))
* **api:** manual updates ([28fd390](https://github.com/orbcorp/orb-python/commit/28fd390a506a484ea47673df0ce56a9b391bf150))


### Chores

* **docs:** grammar improvements ([a64eaa1](https://github.com/orbcorp/orb-python/commit/a64eaa14476b601c1a2d97761dd112d3fe90161e))

## 3.19.4 (2025-05-15)

Full Changelog: [v3.19.3...v3.19.4](https://github.com/orbcorp/orb-python/compare/v3.19.3...v3.19.4)

### Chores

* **ci:** fix installation instructions ([997813b](https://github.com/orbcorp/orb-python/commit/997813bc837a49c3426c21b8180cd12c0c43ac04))
* **ci:** upload sdks to package manager ([de596fc](https://github.com/orbcorp/orb-python/commit/de596fc553718d58021c546d77d0d655cfbc1129))

## 3.19.3 (2025-05-09)

Full Changelog: [v3.19.2...v3.19.3](https://github.com/orbcorp/orb-python/compare/v3.19.2...v3.19.3)

### Bug Fixes

* **package:** support direct resource imports ([f1b3637](https://github.com/orbcorp/orb-python/commit/f1b36376d33f17c1f2e6a6233a75ea278587398e))


### Chores

* broadly detect json family of content-type headers ([3acaf7c](https://github.com/orbcorp/orb-python/commit/3acaf7c67e8d50d65b70f9e17fc5f828297a7f17))
* **ci:** only use depot for staging repos ([3bec73f](https://github.com/orbcorp/orb-python/commit/3bec73ffde0195acc8fb8bf662f4ebaf787ff6bc))
* **ci:** run on more branches and use depot runners ([8e10744](https://github.com/orbcorp/orb-python/commit/8e107446f9a89c01a62ef4e853ffb3f17f7e4277))
* **internal:** avoid errors for isinstance checks on proxies ([5bbd76d](https://github.com/orbcorp/orb-python/commit/5bbd76d645f33c75a78272cd080096196c1f1407))
* **internal:** minor formatting changes ([0e52bb3](https://github.com/orbcorp/orb-python/commit/0e52bb34ec9734c03ca0a225467c4b6d6e158b4e))
* use lazy imports for resources ([e79a6ec](https://github.com/orbcorp/orb-python/commit/e79a6ec9eb46e1b04b0b511edaf25294e27934fc))

## 3.19.2 (2025-04-22)

Full Changelog: [v3.19.1...v3.19.2](https://github.com/orbcorp/orb-python/compare/v3.19.1...v3.19.2)

### Bug Fixes

* **pydantic v1:** more robust ModelField.annotation check ([57796bf](https://github.com/orbcorp/orb-python/commit/57796bf80e447c8ef5687bbfe0c60a2d0038f981))


### Chores

* **ci:** add timeout thresholds for CI jobs ([c1a4723](https://github.com/orbcorp/orb-python/commit/c1a472380f49e766d1ea3adaa8f621112687e93d))
* **internal:** fix list file params ([4281d11](https://github.com/orbcorp/orb-python/commit/4281d1153244369d4424731fffb29a52d55d91a8))
* **internal:** import reformatting ([3912d52](https://github.com/orbcorp/orb-python/commit/3912d5225dce95e20ae41f51342f2dde1f960aca))
* **internal:** refactor retries to not use recursion ([dd2a4b7](https://github.com/orbcorp/orb-python/commit/dd2a4b7e48c890763c1fddbd4285713f6658ce49))
* **internal:** update models test ([28df611](https://github.com/orbcorp/orb-python/commit/28df611e6d0c3948cefb2ed95f5b931c4da01d7a))

## 3.19.1 (2025-04-16)

Full Changelog: [v3.19.0...v3.19.1](https://github.com/orbcorp/orb-python/compare/v3.19.0...v3.19.1)

### Bug Fixes

* **client:** correctly reuse idempotency key ([0cdec4a](https://github.com/orbcorp/orb-python/commit/0cdec4a9188032b28280671e1a07839207f32265))
* **perf:** optimize some hot paths ([a5f8e2b](https://github.com/orbcorp/orb-python/commit/a5f8e2b0e5a1069c23864821e6d07c3b314a89bd))
* **perf:** skip traversing types for NotGiven values ([1416a8e](https://github.com/orbcorp/orb-python/commit/1416a8e2345aed3f03d5e2e0f144a3f100e0383b))


### Chores

* **internal:** base client updates ([d2a8b98](https://github.com/orbcorp/orb-python/commit/d2a8b98bfe31a91f12f8ef7a5e6d648755967d1b))
* **internal:** bump pyright version ([35933d9](https://github.com/orbcorp/orb-python/commit/35933d9adaacef7d1603c294ff334433919506c7))
* **internal:** expand CI branch coverage ([#619](https://github.com/orbcorp/orb-python/issues/619)) ([c1d283c](https://github.com/orbcorp/orb-python/commit/c1d283c07516a7df63dbde00d762afac5877f50c))
* **internal:** reduce CI branch coverage ([45f5613](https://github.com/orbcorp/orb-python/commit/45f56132576369cc18c94075b3b963ce080ce1f3))
* **internal:** update pyright settings ([e528807](https://github.com/orbcorp/orb-python/commit/e52880726bdbb63354c0163871756b3a809fef7f))

## 3.19.0 (2025-04-08)

Full Changelog: [v3.18.2...v3.19.0](https://github.com/orbcorp/orb-python/compare/v3.18.2...v3.19.0)

### Features

* **api:** api update ([#614](https://github.com/orbcorp/orb-python/issues/614)) ([900d258](https://github.com/orbcorp/orb-python/commit/900d258b7af45e1c777b20b561373b9438e42abb))


### Chores

* **internal:** slight transform perf improvement ([#616](https://github.com/orbcorp/orb-python/issues/616)) ([de565f2](https://github.com/orbcorp/orb-python/commit/de565f252353fa7f951ad8cc10574f82919e35aa))
* **tests:** improve enum examples ([#617](https://github.com/orbcorp/orb-python/issues/617)) ([a0d4366](https://github.com/orbcorp/orb-python/commit/a0d4366a82d86555d6ac41a912ce22414b74dd50))

## 3.18.2 (2025-04-07)

Full Changelog: [v3.18.1...v3.18.2](https://github.com/orbcorp/orb-python/compare/v3.18.1...v3.18.2)

### Bug Fixes

* **api:** naming for sync_payment_methods methods ([#612](https://github.com/orbcorp/orb-python/issues/612)) ([48d1f64](https://github.com/orbcorp/orb-python/commit/48d1f64569419343f34cc10e14da8b8f98ea368a))


### Chores

* **internal:** remove trailing character ([#610](https://github.com/orbcorp/orb-python/issues/610)) ([28aac34](https://github.com/orbcorp/orb-python/commit/28aac34bfbb0778e153a70fbac727a508e839a8c))

## 3.18.1 (2025-04-02)

Full Changelog: [v3.18.0...v3.18.1](https://github.com/orbcorp/orb-python/compare/v3.18.0...v3.18.1)

### Chores

* fix typos ([#606](https://github.com/orbcorp/orb-python/issues/606)) ([b6c691e](https://github.com/orbcorp/orb-python/commit/b6c691e84186bb62b295b5d1b01598691174eabe))
* **internal:** minor test fixes ([#608](https://github.com/orbcorp/orb-python/issues/608)) ([7e79541](https://github.com/orbcorp/orb-python/commit/7e79541c498fdde340c4b52abac285bc5a89fd44))

## 3.18.0 (2025-03-20)

Full Changelog: [v3.17.3...v3.18.0](https://github.com/orbcorp/orb-python/compare/v3.17.3...v3.18.0)

### Features

* **api:** api update ([#603](https://github.com/orbcorp/orb-python/issues/603)) ([c55c63a](https://github.com/orbcorp/orb-python/commit/c55c63ae29ec4e910aaf53ffae6ffe9a302e8793))

## 3.17.3 (2025-03-17)

Full Changelog: [v3.17.2...v3.17.3](https://github.com/orbcorp/orb-python/compare/v3.17.2...v3.17.3)

### Bug Fixes

* **ci:** remove publishing patch ([#600](https://github.com/orbcorp/orb-python/issues/600)) ([c101cf7](https://github.com/orbcorp/orb-python/commit/c101cf7a02d71c102ea050f415a11e14e91a57e0))

## 3.17.2 (2025-03-17)

Full Changelog: [v3.17.1...v3.17.2](https://github.com/orbcorp/orb-python/compare/v3.17.1...v3.17.2)

### Bug Fixes

* **ci:** ensure pip is always available ([#597](https://github.com/orbcorp/orb-python/issues/597)) ([cd94bf9](https://github.com/orbcorp/orb-python/commit/cd94bf96bad35abbd0c7aee391e46537e3c38601))

## 3.17.1 (2025-03-14)

Full Changelog: [v3.17.0...v3.17.1](https://github.com/orbcorp/orb-python/compare/v3.17.0...v3.17.1)

### Bug Fixes

* **types:** handle more discriminated union shapes ([#595](https://github.com/orbcorp/orb-python/issues/595)) ([2bc33f5](https://github.com/orbcorp/orb-python/commit/2bc33f5903503bf2787acd44098c9d2944a3da0f))


### Chores

* **internal:** bump rye to 0.44.0 ([#592](https://github.com/orbcorp/orb-python/issues/592)) ([101b233](https://github.com/orbcorp/orb-python/commit/101b2337c48dfd31b4692089904c97abdb7da3b1))
* **internal:** codegen related update ([#594](https://github.com/orbcorp/orb-python/issues/594)) ([04863c0](https://github.com/orbcorp/orb-python/commit/04863c0e2d319c3aa902dc48f9c3db8320e6dd54))

## 3.17.0 (2025-03-14)

Full Changelog: [v3.16.0...v3.17.0](https://github.com/orbcorp/orb-python/compare/v3.16.0...v3.17.0)

### Features

* **api:** api update ([#590](https://github.com/orbcorp/orb-python/issues/590)) ([1848cf8](https://github.com/orbcorp/orb-python/commit/1848cf80341718b42dd0917d6a4fb06dca89f287))


### Chores

* **api:** correctly support ExternalCustomerID array filter on Subscriptions.List ([#589](https://github.com/orbcorp/orb-python/issues/589)) ([90163b2](https://github.com/orbcorp/orb-python/commit/90163b24a6491e3681238288a19fe29a319cb7e0))
* **internal:** remove extra empty newlines ([#587](https://github.com/orbcorp/orb-python/issues/587)) ([55cc8c8](https://github.com/orbcorp/orb-python/commit/55cc8c80728bb3ed890ba6755a3668bbc473e10b))

## 3.16.0 (2025-03-11)

Full Changelog: [v3.15.0...v3.16.0](https://github.com/orbcorp/orb-python/compare/v3.15.0...v3.16.0)

### Features

* **api:** api update ([#584](https://github.com/orbcorp/orb-python/issues/584)) ([2288608](https://github.com/orbcorp/orb-python/commit/2288608ce9ab4827c7d36826476d30ed7522068f))

## 3.15.0 (2025-03-11)

Full Changelog: [v3.14.0...v3.15.0](https://github.com/orbcorp/orb-python/compare/v3.14.0...v3.15.0)

### Features

* **api:** api update ([#578](https://github.com/orbcorp/orb-python/issues/578)) ([04eaf67](https://github.com/orbcorp/orb-python/commit/04eaf6721083e11b758e90427f5b4337ba9b0d91))
* **api:** api update ([#580](https://github.com/orbcorp/orb-python/issues/580)) ([5d04ab2](https://github.com/orbcorp/orb-python/commit/5d04ab2dc9d6404f3092241470e379ef5c5693b3))
* **api:** api update ([#581](https://github.com/orbcorp/orb-python/issues/581)) ([dd09767](https://github.com/orbcorp/orb-python/commit/dd097673811c2082c8c95ee39dda5e613fd2c6a2))

## 3.14.0 (2025-03-05)

Full Changelog: [v3.13.0...v3.14.0](https://github.com/orbcorp/orb-python/compare/v3.13.0...v3.14.0)

### Features

* **api:** manual updates ([#575](https://github.com/orbcorp/orb-python/issues/575)) ([fd2bf64](https://github.com/orbcorp/orb-python/commit/fd2bf64445c35ed7503a0b42a0838ff5c44b80ca))

## 3.13.0 (2025-03-05)

Full Changelog: [v3.12.0...v3.13.0](https://github.com/orbcorp/orb-python/compare/v3.12.0...v3.13.0)

### Features

* **api:** manual updates ([#572](https://github.com/orbcorp/orb-python/issues/572)) ([6f728ae](https://github.com/orbcorp/orb-python/commit/6f728ae08a126538c82bc3c978f53462f0749d21))

## 3.12.0 (2025-03-05)

Full Changelog: [v3.11.0...v3.12.0](https://github.com/orbcorp/orb-python/compare/v3.11.0...v3.12.0)

### Features

* **api:** manual updates ([#569](https://github.com/orbcorp/orb-python/issues/569)) ([d6ef667](https://github.com/orbcorp/orb-python/commit/d6ef667612110bf78ab000d941c9e7b982259133))

## 3.11.0 (2025-03-05)

Full Changelog: [v3.10.0...v3.11.0](https://github.com/orbcorp/orb-python/compare/v3.10.0...v3.11.0)

### Features

* **api:** api update ([#567](https://github.com/orbcorp/orb-python/issues/567)) ([247a81c](https://github.com/orbcorp/orb-python/commit/247a81c8582c9aebb0787789426b1454d16f1134))


### Chores

* **internal:** codegen related update ([#564](https://github.com/orbcorp/orb-python/issues/564)) ([03b058d](https://github.com/orbcorp/orb-python/commit/03b058d6125ca84365fe4622432a9ada74aa288f))
* **internal:** remove unused http client options forwarding ([#566](https://github.com/orbcorp/orb-python/issues/566)) ([aa7b3cf](https://github.com/orbcorp/orb-python/commit/aa7b3cf321a322150f12014674d914f2aa4a3c1e))

## 3.10.0 (2025-03-01)

Full Changelog: [v3.9.0...v3.10.0](https://github.com/orbcorp/orb-python/compare/v3.9.0...v3.10.0)

### Features

* **api:** api update ([#561](https://github.com/orbcorp/orb-python/issues/561)) ([52612af](https://github.com/orbcorp/orb-python/commit/52612afe670d53aaf3849acc06629be2f8c54d05))

## 3.9.0 (2025-02-27)

Full Changelog: [v3.8.0...v3.9.0](https://github.com/orbcorp/orb-python/compare/v3.8.0...v3.9.0)

### Features

* **api:** api update ([#559](https://github.com/orbcorp/orb-python/issues/559)) ([0ea58b5](https://github.com/orbcorp/orb-python/commit/0ea58b5e7bcd0ded6a04f5875198f73c961acc1e))


### Chores

* **internal:** properly set __pydantic_private__ ([#557](https://github.com/orbcorp/orb-python/issues/557)) ([5df04a9](https://github.com/orbcorp/orb-python/commit/5df04a9fdffc8eba2dbbe81503f4a8280f8e7dbd))

## 3.8.0 (2025-02-25)

Full Changelog: [v3.7.0...v3.8.0](https://github.com/orbcorp/orb-python/compare/v3.7.0...v3.8.0)

### Features

* **api:** api update ([#554](https://github.com/orbcorp/orb-python/issues/554)) ([e527839](https://github.com/orbcorp/orb-python/commit/e527839d462ba74b094bcd8f6e2f9a36c5c94928))

## 3.7.0 (2025-02-21)

Full Changelog: [v3.6.0...v3.7.0](https://github.com/orbcorp/orb-python/compare/v3.6.0...v3.7.0)

### Features

* **api:** api update ([#551](https://github.com/orbcorp/orb-python/issues/551)) ([9af0efd](https://github.com/orbcorp/orb-python/commit/9af0efd82d4c18870479dd0ce966899d04f14485))

## 3.6.0 (2025-02-21)

Full Changelog: [v3.5.0...v3.6.0](https://github.com/orbcorp/orb-python/compare/v3.5.0...v3.6.0)

### Features

* **api:** api update ([#549](https://github.com/orbcorp/orb-python/issues/549)) ([e3c12c7](https://github.com/orbcorp/orb-python/commit/e3c12c77930b84c59c81e155d2cba86ee88b8301))


### Chores

* **internal:** fix devcontainers setup ([#547](https://github.com/orbcorp/orb-python/issues/547)) ([8a41ae9](https://github.com/orbcorp/orb-python/commit/8a41ae94bb215e52c4a523ad592c3fb62155ad3d))

## 3.5.0 (2025-02-20)

Full Changelog: [v3.4.1...v3.5.0](https://github.com/orbcorp/orb-python/compare/v3.4.1...v3.5.0)

### Features

* **api:** api update ([#543](https://github.com/orbcorp/orb-python/issues/543)) ([7bd608e](https://github.com/orbcorp/orb-python/commit/7bd608e2f10290c7ca754737127dc821bda7e08c))
* **api:** api update ([#545](https://github.com/orbcorp/orb-python/issues/545)) ([b309efd](https://github.com/orbcorp/orb-python/commit/b309efd0ff24740c47ad0423f409b6d2c29992cd))
* **client:** allow passing `NotGiven` for body ([#544](https://github.com/orbcorp/orb-python/issues/544)) ([d8b593c](https://github.com/orbcorp/orb-python/commit/d8b593cb7f57f9c4a7d2ad7a0a9461908c1adecf))


### Bug Fixes

* **client:** mark some request bodies as optional ([d8b593c](https://github.com/orbcorp/orb-python/commit/d8b593cb7f57f9c4a7d2ad7a0a9461908c1adecf))


### Chores

* **internal:** codegen related update ([#541](https://github.com/orbcorp/orb-python/issues/541)) ([c30d716](https://github.com/orbcorp/orb-python/commit/c30d716e16300e0b421e7d510455cf5714c07346))

## 3.4.1 (2025-02-15)

Full Changelog: [v3.4.0...v3.4.1](https://github.com/orbcorp/orb-python/compare/v3.4.0...v3.4.1)

### Bug Fixes

* asyncify on non-asyncio runtimes ([#538](https://github.com/orbcorp/orb-python/issues/538)) ([a07f92d](https://github.com/orbcorp/orb-python/commit/a07f92dacc0153fb06e800af73d1f728f41a3dbf))

## 3.4.0 (2025-02-14)

Full Changelog: [v3.3.0...v3.4.0](https://github.com/orbcorp/orb-python/compare/v3.3.0...v3.4.0)

### Features

* **api:** api update ([#535](https://github.com/orbcorp/orb-python/issues/535)) ([546bfa0](https://github.com/orbcorp/orb-python/commit/546bfa0021c27e59e6be15a5a011796c740abf3e))

## 3.3.0 (2025-02-13)

Full Changelog: [v3.2.0...v3.3.0](https://github.com/orbcorp/orb-python/compare/v3.2.0...v3.3.0)

### Features

* **api:** api update ([#533](https://github.com/orbcorp/orb-python/issues/533)) ([579e4fc](https://github.com/orbcorp/orb-python/commit/579e4fcaba68a73f77fcb3a4e3be04ea904b26ee))


### Chores

* **internal:** update client tests ([#531](https://github.com/orbcorp/orb-python/issues/531)) ([e8c0abe](https://github.com/orbcorp/orb-python/commit/e8c0abe0dd656b03012cfaa2da786c03befd1f74))

## 3.2.0 (2025-02-11)

Full Changelog: [v3.1.0...v3.2.0](https://github.com/orbcorp/orb-python/compare/v3.1.0...v3.2.0)

### Features

* **api:** api update ([#528](https://github.com/orbcorp/orb-python/issues/528)) ([091fd4c](https://github.com/orbcorp/orb-python/commit/091fd4cb9df5721bd0e80ecae6f145d6395cedce))

## 3.1.0 (2025-02-07)

Full Changelog: [v3.0.0...v3.1.0](https://github.com/orbcorp/orb-python/compare/v3.0.0...v3.1.0)

### Features

* **api:** api update ([#526](https://github.com/orbcorp/orb-python/issues/526)) ([8cd8251](https://github.com/orbcorp/orb-python/commit/8cd82517459b39259d4551ce972c0b1ba2096586))
* **client:** send `X-Stainless-Read-Timeout` header ([#522](https://github.com/orbcorp/orb-python/issues/522)) ([0ddac77](https://github.com/orbcorp/orb-python/commit/0ddac777a1d37ef24b57c95a9f5db00db2c67674))


### Chores

* **internal:** fix type traversing dictionary params ([#524](https://github.com/orbcorp/orb-python/issues/524)) ([23de87d](https://github.com/orbcorp/orb-python/commit/23de87d4360b0159a279697b2e8cf9015b7d434b))
* **internal:** minor type handling changes ([#525](https://github.com/orbcorp/orb-python/issues/525)) ([67a742b](https://github.com/orbcorp/orb-python/commit/67a742b9f14b924a84709174512ca2b0a58a1d0b))

## 3.0.0 (2025-02-04)

Full Changelog: [v2.26.0...v3.0.0](https://github.com/orbcorp/orb-python/compare/v2.26.0...v3.0.0)

### Features

* **api:** api update ([#520](https://github.com/orbcorp/orb-python/issues/520)) ([d65f3c3](https://github.com/orbcorp/orb-python/commit/d65f3c35553f6add695fbb4c42ea1f649f3593cf))


### Chores

* **internal:** bummp ruff dependency ([#519](https://github.com/orbcorp/orb-python/issues/519)) ([fe614e7](https://github.com/orbcorp/orb-python/commit/fe614e7f4b37decad63e04ac2cc87f6d3b26636c))
* **internal:** change default timeout to an int ([#518](https://github.com/orbcorp/orb-python/issues/518)) ([87ee784](https://github.com/orbcorp/orb-python/commit/87ee784c143f83c606fd8c4f34614bbce884d499))
* **internal:** codegen related update ([#516](https://github.com/orbcorp/orb-python/issues/516)) ([24fc2d8](https://github.com/orbcorp/orb-python/commit/24fc2d8daa8d548e8a4477a20e638dddd7aedd06))

## 2.26.0 (2025-01-30)

Full Changelog: [v2.25.0...v2.26.0](https://github.com/orbcorp/orb-python/compare/v2.25.0...v2.26.0)

### Features

* **api:** api update ([#513](https://github.com/orbcorp/orb-python/issues/513)) ([e67b68c](https://github.com/orbcorp/orb-python/commit/e67b68cb9acf4217ab9aecf7f96c06f6fcf785da))

## 2.25.0 (2025-01-23)

Full Changelog: [v2.24.0...v2.25.0](https://github.com/orbcorp/orb-python/compare/v2.24.0...v2.25.0)

### Features

* **api:** api update ([#511](https://github.com/orbcorp/orb-python/issues/511)) ([052d15d](https://github.com/orbcorp/orb-python/commit/052d15d9822356db28a4a42ea085133a29b183aa))


### Chores

* **internal:** minor formatting changes ([#509](https://github.com/orbcorp/orb-python/issues/509)) ([15852c1](https://github.com/orbcorp/orb-python/commit/15852c155fa49397b3184cd648603070fbf59a87))

## 2.24.0 (2025-01-21)

Full Changelog: [v2.23.1...v2.24.0](https://github.com/orbcorp/orb-python/compare/v2.23.1...v2.24.0)

### Features

* **api:** api update ([#507](https://github.com/orbcorp/orb-python/issues/507)) ([62cb28f](https://github.com/orbcorp/orb-python/commit/62cb28f34cd5f729ac29a7531d749c92e1c98176))


### Chores

* **internal:** minor style changes ([#506](https://github.com/orbcorp/orb-python/issues/506)) ([a515f42](https://github.com/orbcorp/orb-python/commit/a515f4224c1c1ccfa26bca120c1f04cd2c52831a))
* **internal:** version bump ([#503](https://github.com/orbcorp/orb-python/issues/503)) ([af3a6ef](https://github.com/orbcorp/orb-python/commit/af3a6efffcd03a674f85e2c739974af4b9632617))

## 2.23.1 (2025-01-20)

Full Changelog: [v2.23.0...v2.23.1](https://github.com/orbcorp/orb-python/compare/v2.23.0...v2.23.1)

### Bug Fixes

* **tests:** make test_get_platform less flaky ([#500](https://github.com/orbcorp/orb-python/issues/500)) ([1eebaeb](https://github.com/orbcorp/orb-python/commit/1eebaeb04d0b84b36c517b8f64f8fe2e9409dd42))


### Chores

* **internal:** avoid pytest-asyncio deprecation warning ([#501](https://github.com/orbcorp/orb-python/issues/501)) ([13c0146](https://github.com/orbcorp/orb-python/commit/13c01468044209c5a17321cc7e766dcd3521906c))
* **internal:** version bump ([#497](https://github.com/orbcorp/orb-python/issues/497)) ([4fdc09b](https://github.com/orbcorp/orb-python/commit/4fdc09bb2d71f1a7a4445c589242f11cbb564414))


### Documentation

* **raw responses:** fix duplicate `the` ([#499](https://github.com/orbcorp/orb-python/issues/499)) ([27ae2b2](https://github.com/orbcorp/orb-python/commit/27ae2b2b0cd4609a12e553fb588e72bc7e6f84a5))

## 2.23.0 (2025-01-18)

Full Changelog: [v2.22.0...v2.23.0](https://github.com/orbcorp/orb-python/compare/v2.22.0...v2.23.0)

### Features

* **api:** api update ([#496](https://github.com/orbcorp/orb-python/issues/496)) ([07fa67c](https://github.com/orbcorp/orb-python/commit/07fa67c837abccaac994d3fe61ec099d95e0a4ac))


### Chores

* **internal:** version bump ([#493](https://github.com/orbcorp/orb-python/issues/493)) ([09c4724](https://github.com/orbcorp/orb-python/commit/09c47240beade631d15ade50f3a09447c4c49ab5))

## 2.22.0 (2025-01-16)

Full Changelog: [v2.21.0...v2.22.0](https://github.com/orbcorp/orb-python/compare/v2.21.0...v2.22.0)

### Features

* **api:** api update ([#491](https://github.com/orbcorp/orb-python/issues/491)) ([1f41a57](https://github.com/orbcorp/orb-python/commit/1f41a57f91218d275d85428d85458d6310aa15c4))
* **api:** api update ([#492](https://github.com/orbcorp/orb-python/issues/492)) ([8f48b6a](https://github.com/orbcorp/orb-python/commit/8f48b6aae6927aad5347f83fabf9c86059425dfe))


### Chores

* **internal:** version bump ([#469](https://github.com/orbcorp/orb-python/issues/469)) ([0c32ed8](https://github.com/orbcorp/orb-python/commit/0c32ed802f75842cd86bd2f631fc4cff5349e490))
* **internal:** version bump ([#489](https://github.com/orbcorp/orb-python/issues/489)) ([fe81c5e](https://github.com/orbcorp/orb-python/commit/fe81c5e9845f5848296e2b2d52fffe04b53040d7))

## 2.21.0 (2025-01-15)

Full Changelog: [v2.20.0...v2.21.0](https://github.com/orbcorp/orb-python/compare/v2.20.0...v2.21.0)

### Features

* **api:** api update ([#471](https://github.com/orbcorp/orb-python/issues/471)) ([d23ec0e](https://github.com/orbcorp/orb-python/commit/d23ec0e08cc5e8bd681a8c7947778a8445b81f78))
* **api:** api update ([#472](https://github.com/orbcorp/orb-python/issues/472)) ([0a22350](https://github.com/orbcorp/orb-python/commit/0a2235016cfba90da5f68e950579d0720bd40045))
* **api:** api update ([#474](https://github.com/orbcorp/orb-python/issues/474)) ([d2fb2aa](https://github.com/orbcorp/orb-python/commit/d2fb2aa50c27160a8fd386aec812e8f3ace527fe))
* **api:** api update ([#477](https://github.com/orbcorp/orb-python/issues/477)) ([59c3a8b](https://github.com/orbcorp/orb-python/commit/59c3a8bdfa3b18311e956511afd31d211c6f320d))
* **api:** api update ([#478](https://github.com/orbcorp/orb-python/issues/478)) ([4036eca](https://github.com/orbcorp/orb-python/commit/4036ecaf1d14f3c235c11ce1551490a86fab8066))


### Bug Fixes

* **client:** only call .close() when needed ([#481](https://github.com/orbcorp/orb-python/issues/481)) ([c14225c](https://github.com/orbcorp/orb-python/commit/c14225cd09e514dea91586874e851cf1933b9af5))
* correctly handle deserialising `cls` fields ([#485](https://github.com/orbcorp/orb-python/issues/485)) ([7a80005](https://github.com/orbcorp/orb-python/commit/7a80005983ff3799ea685034dd750c08c74704e7))


### Chores

* add missing isclass check ([#476](https://github.com/orbcorp/orb-python/issues/476)) ([cafafe4](https://github.com/orbcorp/orb-python/commit/cafafe4cfdfd12d1bbad5d1fce0ad0b992741993))
* **client:** simplify `Optional[object]` to just `object` ([#475](https://github.com/orbcorp/orb-python/issues/475)) ([f684ed4](https://github.com/orbcorp/orb-python/commit/f684ed42a5452933f4fe5a495b309a74267e4728))
* **internal:** bump httpx dependency ([#480](https://github.com/orbcorp/orb-python/issues/480)) ([6b04dea](https://github.com/orbcorp/orb-python/commit/6b04deaf0406eb2130ca9f159d42f84bd5ecac4a))
* **internal:** bump pyright dependency ([#487](https://github.com/orbcorp/orb-python/issues/487)) ([667a330](https://github.com/orbcorp/orb-python/commit/667a330e4074c66434a19d25fdfaf2a710f2d2c8))
* **internal:** codegen related update ([#473](https://github.com/orbcorp/orb-python/issues/473)) ([c24985f](https://github.com/orbcorp/orb-python/commit/c24985f1ff9e87de455a4b862045701f6c646bab))
* **internal:** codegen related update ([#484](https://github.com/orbcorp/orb-python/issues/484)) ([a429148](https://github.com/orbcorp/orb-python/commit/a429148a83f0e51afcb0b99d5661c706023da48f))
* **internal:** update deps ([#486](https://github.com/orbcorp/orb-python/issues/486)) ([4677063](https://github.com/orbcorp/orb-python/commit/4677063f95f37b7b982816871d8fa98871efd15f))
* **internal:** version bump ([#469](https://github.com/orbcorp/orb-python/issues/469)) ([e95eb1d](https://github.com/orbcorp/orb-python/commit/e95eb1d93a4990d3fe2d722abf05b4bfa558c745))


### Documentation

* fix typos ([#482](https://github.com/orbcorp/orb-python/issues/482)) ([b8a2ce6](https://github.com/orbcorp/orb-python/commit/b8a2ce60542927b91329a10dd2d39efac96d6d9b))
* more typo fixes ([#483](https://github.com/orbcorp/orb-python/issues/483)) ([569ad30](https://github.com/orbcorp/orb-python/commit/569ad308f81bc99620d2d08b3afc4ea95f0fe8d5))

## 2.20.0 (2024-12-19)

Full Changelog: [v2.19.0...v2.20.0](https://github.com/orbcorp/orb-python/compare/v2.19.0...v2.20.0)

### Features

* **api:** api update ([#466](https://github.com/orbcorp/orb-python/issues/466)) ([abcce3c](https://github.com/orbcorp/orb-python/commit/abcce3cf709af675b0ac2beb2aa1b401b1aada1c))


### Chores

* **internal:** fix some typos ([#465](https://github.com/orbcorp/orb-python/issues/465)) ([8ccbc2a](https://github.com/orbcorp/orb-python/commit/8ccbc2a9d62dc8853b8460562a8fb5760ed6608f))
* **internal:** remove some duplicated imports ([#462](https://github.com/orbcorp/orb-python/issues/462)) ([7ede2cb](https://github.com/orbcorp/orb-python/commit/7ede2cb2c3f741a69b3e5e47553dccc48d409ef6))
* **internal:** updated imports ([#463](https://github.com/orbcorp/orb-python/issues/463)) ([2487ca6](https://github.com/orbcorp/orb-python/commit/2487ca601d123fa24acc8135123f1029933c69c2))
* **internal:** version bump ([#460](https://github.com/orbcorp/orb-python/issues/460)) ([28a5746](https://github.com/orbcorp/orb-python/commit/28a57463640f9be6ee2faa238731525a65adcb2a))


### Documentation

* **readme:** example snippet for client context manager ([#464](https://github.com/orbcorp/orb-python/issues/464)) ([c832f0a](https://github.com/orbcorp/orb-python/commit/c832f0ad06c2048b2961d2b4c9a9febf5b43b9cd))

## 2.19.0 (2024-12-12)

Full Changelog: [v2.18.0...v2.19.0](https://github.com/orbcorp/orb-python/compare/v2.18.0...v2.19.0)

### Features

* **api:** api update ([#459](https://github.com/orbcorp/orb-python/issues/459)) ([6bc521d](https://github.com/orbcorp/orb-python/commit/6bc521d596131d092db8ec463ef3f19fd6460006))


### Chores

* **internal:** add support for TypeAliasType ([#458](https://github.com/orbcorp/orb-python/issues/458)) ([b03a8ef](https://github.com/orbcorp/orb-python/commit/b03a8ef06e4207f2051fe9a073078a125ce3f1d6))
* **internal:** bump pydantic dependency ([#455](https://github.com/orbcorp/orb-python/issues/455)) ([da23d38](https://github.com/orbcorp/orb-python/commit/da23d38f97aa2f474f56c25a2c2f5fc08a2dea3d))
* **internal:** bump pyright ([#457](https://github.com/orbcorp/orb-python/issues/457)) ([2a4d14a](https://github.com/orbcorp/orb-python/commit/2a4d14a279018d5e5a8cffcbadddf347e567641d))
* **internal:** version bump ([#451](https://github.com/orbcorp/orb-python/issues/451)) ([11a7427](https://github.com/orbcorp/orb-python/commit/11a7427530a285d2e2df2b3aa59964777015db01))
* make the `Omit` type public ([#454](https://github.com/orbcorp/orb-python/issues/454)) ([f92f377](https://github.com/orbcorp/orb-python/commit/f92f37709f85b33a1f4aa3667bdd58601405be6c))


### Documentation

* **readme:** fix http client proxies example ([#456](https://github.com/orbcorp/orb-python/issues/456)) ([db48031](https://github.com/orbcorp/orb-python/commit/db48031ec6b0de13d04ab872eee657dbffcff556))

## 2.18.0 (2024-12-03)

Full Changelog: [v2.17.0...v2.18.0](https://github.com/orbcorp/orb-python/compare/v2.17.0...v2.18.0)

### Features

* **api:** api update ([#450](https://github.com/orbcorp/orb-python/issues/450)) ([0f5fabb](https://github.com/orbcorp/orb-python/commit/0f5fabbee9dbeee5203d4282d43816cbbc9a2e5c))


### Chores

* **internal:** bump pyright ([#449](https://github.com/orbcorp/orb-python/issues/449)) ([0de91b3](https://github.com/orbcorp/orb-python/commit/0de91b38c438fb2c9bb611d5047dec111d770433))
* **internal:** codegen related update ([#448](https://github.com/orbcorp/orb-python/issues/448)) ([a9096c4](https://github.com/orbcorp/orb-python/commit/a9096c4d6f68f3829f870c535fee1b070db314b9))
* **internal:** version bump ([#445](https://github.com/orbcorp/orb-python/issues/445)) ([67b0288](https://github.com/orbcorp/orb-python/commit/67b02886b84161966490b333253bfd9b231397dc))

## 2.17.0 (2024-11-28)

Full Changelog: [v2.16.0...v2.17.0](https://github.com/orbcorp/orb-python/compare/v2.16.0...v2.17.0)

### Features

* api updates ([3dc9d02](https://github.com/orbcorp/orb-python/commit/3dc9d0223a4ed8eb8e76a2688e4e7d78cf1700a9))
* **api:** api update ([#436](https://github.com/orbcorp/orb-python/issues/436)) ([6f8c441](https://github.com/orbcorp/orb-python/commit/6f8c441a369dacf871344a5ab8b5d654011447fb))
* **api:** api update ([#440](https://github.com/orbcorp/orb-python/issues/440)) ([790b52a](https://github.com/orbcorp/orb-python/commit/790b52ac9898f55de3faf17ac3a27213f22bc711))
* **api:** api update ([#441](https://github.com/orbcorp/orb-python/issues/441)) ([e0268df](https://github.com/orbcorp/orb-python/commit/e0268dfe3a2f73acff5d1f7a6fcfea43a90ce3f0))
* **api:** api update ([#443](https://github.com/orbcorp/orb-python/issues/443)) ([285ba54](https://github.com/orbcorp/orb-python/commit/285ba54b140de61f24fab688c9c69ab80166ebed))


### Bug Fixes

* **client:** compat with new httpx 0.28.0 release ([#444](https://github.com/orbcorp/orb-python/issues/444)) ([e0f2966](https://github.com/orbcorp/orb-python/commit/e0f2966dfe55a98fc77285ea348a8872b5c09921))


### Chores

* fix formatting ([f3da812](https://github.com/orbcorp/orb-python/commit/f3da812e90ad9ea9d5ba881bfd322d8ede076708))
* **internal:** codegen related update ([#442](https://github.com/orbcorp/orb-python/issues/442)) ([f3efb3f](https://github.com/orbcorp/orb-python/commit/f3efb3fe137f751871ad97606d9c624ba5b5774e))
* **internal:** fix compat model_dump method when warnings are passed ([#437](https://github.com/orbcorp/orb-python/issues/437)) ([e03dc3b](https://github.com/orbcorp/orb-python/commit/e03dc3b864150b1a3de24952aa7a503e5dba7254))
* remove now unused `cached-property` dep ([#439](https://github.com/orbcorp/orb-python/issues/439)) ([e5e8485](https://github.com/orbcorp/orb-python/commit/e5e848510b6df79a3b1e61f5479a7241fcd18af6))


### Documentation

* add info log level to readme ([#438](https://github.com/orbcorp/orb-python/issues/438)) ([4576720](https://github.com/orbcorp/orb-python/commit/457672037ec56a9432800fec56c6deb68964b1df))

## 2.16.0 (2024-11-15)

Full Changelog: [v2.15.0...v2.16.0](https://github.com/orbcorp/orb-python/compare/v2.15.0...v2.16.0)

### Features

* **api:** api update ([#430](https://github.com/orbcorp/orb-python/issues/430)) ([5457ac2](https://github.com/orbcorp/orb-python/commit/5457ac24adc55caee65382214e0cbf9739e963f3))


### Chores

* rebuild project due to codegen change ([#427](https://github.com/orbcorp/orb-python/issues/427)) ([bf7c315](https://github.com/orbcorp/orb-python/commit/bf7c315a84c6b959369bfc1f255f9353ad5c3c6f))
* rebuild project due to codegen change ([#429](https://github.com/orbcorp/orb-python/issues/429)) ([2bfa0a2](https://github.com/orbcorp/orb-python/commit/2bfa0a206c28724761471ed98d5c619d33a2506b))

## 2.15.0 (2024-11-06)

Full Changelog: [v2.14.0...v2.15.0](https://github.com/orbcorp/orb-python/compare/v2.14.0...v2.15.0)

### Features

* **api:** api update ([#423](https://github.com/orbcorp/orb-python/issues/423)) ([1fa5e75](https://github.com/orbcorp/orb-python/commit/1fa5e759e608fb705a9dce4505db72d4661bd7a1))

## 2.14.0 (2024-11-06)

Full Changelog: [v2.13.0...v2.14.0](https://github.com/orbcorp/orb-python/compare/v2.13.0...v2.14.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#369](https://github.com/orbcorp/orb-python/issues/369)) ([f09762a](https://github.com/orbcorp/orb-python/commit/f09762a6261fc5b351043411d0a334f206931cba))
* **api:** OpenAPI spec update via Stainless API ([#370](https://github.com/orbcorp/orb-python/issues/370)) ([a8b582c](https://github.com/orbcorp/orb-python/commit/a8b582cfab2e2875ed402067510269b80429d828))

## 2.13.0 (2024-11-06)

Full Changelog: [v2.12.0...v2.13.0](https://github.com/orbcorp/orb-python/compare/v2.12.0...v2.13.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#368](https://github.com/orbcorp/orb-python/issues/368)) ([54cb9e7](https://github.com/orbcorp/orb-python/commit/54cb9e7df83d5a08bd8da427ad1facda128f1ab0))

## 2.12.0 (2024-11-06)

Full Changelog: [v2.11.0...v2.12.0](https://github.com/orbcorp/orb-python/compare/v2.11.0...v2.12.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#371](https://github.com/orbcorp/orb-python/issues/371)) ([4068313](https://github.com/orbcorp/orb-python/commit/40683137ba62769372640c32c5cd9b618a23685d))
* **api:** OpenAPI spec update via Stainless API ([#372](https://github.com/orbcorp/orb-python/issues/372)) ([478e200](https://github.com/orbcorp/orb-python/commit/478e2004d1ebc1d4c87871319f5d0d6a0f20be51))

## 2.11.0 (2024-11-06)

Full Changelog: [v2.10.0...v2.11.0](https://github.com/orbcorp/orb-python/compare/v2.10.0...v2.11.0)

### Features

* **api:** codegen changes ([#367](https://github.com/orbcorp/orb-python/issues/367)) ([57ab873](https://github.com/orbcorp/orb-python/commit/57ab873ce827c0dc7d833bedffe3f77d758aa05c))
* **api:** OpenAPI spec update via Stainless API ([#368](https://github.com/orbcorp/orb-python/issues/368)) ([5899921](https://github.com/orbcorp/orb-python/commit/58999214b3df22d91273ec6e1319d6c7989c2e5b))

## 2.10.0 (2024-11-06)

Full Changelog: [v2.9.0...v2.10.0](https://github.com/orbcorp/orb-python/compare/v2.9.0...v2.10.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#365](https://github.com/orbcorp/orb-python/issues/365)) ([c83347c](https://github.com/orbcorp/orb-python/commit/c83347cf6b6b6301a3b62c2bd53da44788d08cd9))

## 2.9.0 (2024-08-23)

Full Changelog: [v2.8.0...v2.9.0](https://github.com/orbcorp/orb-python/compare/v2.8.0...v2.9.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#362](https://github.com/orbcorp/orb-python/issues/362)) ([b32c5c4](https://github.com/orbcorp/orb-python/commit/b32c5c421b709cc364f9efef136e2c4873bcb1c6))

## 2.8.0 (2024-08-22)

Full Changelog: [v2.7.0...v2.8.0](https://github.com/orbcorp/orb-python/compare/v2.7.0...v2.8.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#359](https://github.com/orbcorp/orb-python/issues/359)) ([a82bc26](https://github.com/orbcorp/orb-python/commit/a82bc26fdaea04a8145237f337d92e78c52555c6))

## 2.7.0 (2024-08-21)

Full Changelog: [v2.6.0...v2.7.0](https://github.com/orbcorp/orb-python/compare/v2.6.0...v2.7.0)

### Features

* **api:** codegen changes ([#355](https://github.com/orbcorp/orb-python/issues/355)) ([59e41c2](https://github.com/orbcorp/orb-python/commit/59e41c27b9975127e099831d2bd2e8595356eff4))
* **api:** manual updates ([#357](https://github.com/orbcorp/orb-python/issues/357)) ([a9d9d93](https://github.com/orbcorp/orb-python/commit/a9d9d93ca37c2291fc6e4ee2a9c24db7d59c3206))

## 2.6.0 (2024-08-17)

Full Changelog: [v2.5.0...v2.6.0](https://github.com/orbcorp/orb-python/compare/v2.5.0...v2.6.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#352](https://github.com/orbcorp/orb-python/issues/352)) ([899a10f](https://github.com/orbcorp/orb-python/commit/899a10f2e7122f43e4502129f48f30dc05cc1a53))

## 2.5.0 (2024-08-16)

Full Changelog: [v2.4.0...v2.5.0](https://github.com/orbcorp/orb-python/compare/v2.4.0...v2.5.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#349](https://github.com/orbcorp/orb-python/issues/349)) ([dc573e4](https://github.com/orbcorp/orb-python/commit/dc573e48b5dda28ef03944c11590daa67e8b054e))

## 2.4.0 (2024-08-15)

Full Changelog: [v2.3.0...v2.4.0](https://github.com/orbcorp/orb-python/compare/v2.3.0...v2.4.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#346](https://github.com/orbcorp/orb-python/issues/346)) ([9906e02](https://github.com/orbcorp/orb-python/commit/9906e02fbe3f889942fd235ed19b0cc588797344))

## 2.3.0 (2024-08-15)

Full Changelog: [v2.2.0...v2.3.0](https://github.com/orbcorp/orb-python/compare/v2.2.0...v2.3.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#343](https://github.com/orbcorp/orb-python/issues/343)) ([b4db3f3](https://github.com/orbcorp/orb-python/commit/b4db3f330e2518878125f3e6b72ad555e0fe4873))

## 2.2.0 (2024-08-15)

Full Changelog: [v2.1.0...v2.2.0](https://github.com/orbcorp/orb-python/compare/v2.1.0...v2.2.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#340](https://github.com/orbcorp/orb-python/issues/340)) ([632a6bd](https://github.com/orbcorp/orb-python/commit/632a6bdf45dcf3e88212ab82c7748a3c47a9b6d0))

## 2.1.0 (2024-08-14)

Full Changelog: [v2.0.0...v2.1.0](https://github.com/orbcorp/orb-python/compare/v2.0.0...v2.1.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#338](https://github.com/orbcorp/orb-python/issues/338)) ([ff005e5](https://github.com/orbcorp/orb-python/commit/ff005e562aeebdc0b4c4a6f91f1dad7af7030d2e))
* **client:** add `retries_taken` to raw response class ([#334](https://github.com/orbcorp/orb-python/issues/334)) ([99d1df1](https://github.com/orbcorp/orb-python/commit/99d1df1a5da230325d47e8c1cc8bf1da53e74253))


### Chores

* **internal:** bump pyright ([#333](https://github.com/orbcorp/orb-python/issues/333)) ([7678fca](https://github.com/orbcorp/orb-python/commit/7678fca8726890c52693c1ff9747f81379749245))
* **internal:** bump ruff version ([#336](https://github.com/orbcorp/orb-python/issues/336)) ([dffe52f](https://github.com/orbcorp/orb-python/commit/dffe52ffdd81cd279b0c789d8c4bfc72493b848a))
* **internal:** test updates ([#335](https://github.com/orbcorp/orb-python/issues/335)) ([ef3b8d2](https://github.com/orbcorp/orb-python/commit/ef3b8d2fc6ae76a79cf08ddd9f3142c594459aa5))
* **internal:** update pydantic compat helper function ([#337](https://github.com/orbcorp/orb-python/issues/337)) ([d8a0d01](https://github.com/orbcorp/orb-python/commit/d8a0d01d4b2b43a8b6a7d6e69891d5ec4ff20809))
* **internal:** use `TypeAlias` marker for type assignments ([#331](https://github.com/orbcorp/orb-python/issues/331)) ([5208144](https://github.com/orbcorp/orb-python/commit/5208144f3767ed7e615ca066c9185b861ca73969))

## 2.0.0 (2024-08-02)

Full Changelog: [v1.56.0...v2.0.0](https://github.com/orbcorp/orb-python/compare/v1.56.0...v2.0.0)

### ⚠ BREAKING CHANGES

* **api:** remove methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#330](https://github.com/orbcorp/orb-python/issues/330))
* **api:** endpoint expects amount of new allocation price to be a string, not a number ([#297](https://github.com/orbcorp/orb-python/issues/297))
* **api:** add semi_annual cadence and remove metadata from update items ([#288](https://github.com/orbcorp/orb-python/issues/288))

### Features

* **api:** add 'status' to plan creation params ([#310](https://github.com/orbcorp/orb-python/issues/310)) ([561898f](https://github.com/orbcorp/orb-python/commit/561898f1fa75d83d83f0c1c50d382d04cbaff7d2))
* **api:** add cadence enum value 'custom' ([#327](https://github.com/orbcorp/orb-python/issues/327)) ([e1df500](https://github.com/orbcorp/orb-python/commit/e1df500b8f268eef2a0a8d65851ce903919f8bd2))
* **api:** add methods to prices and invoices ([#321](https://github.com/orbcorp/orb-python/issues/321)) ([0eaba5f](https://github.com/orbcorp/orb-python/commit/0eaba5fe665bf54bd02748587153bb42b080dc2d))
* **api:** add semi_annual cadence and remove metadata from update items ([#288](https://github.com/orbcorp/orb-python/issues/288)) ([4b07848](https://github.com/orbcorp/orb-python/commit/4b07848ecc9d2a4899e20710e121d5cdc984de79))
* **api:** add support for adding allocation price to subscription ([#295](https://github.com/orbcorp/orb-python/issues/295)) ([7e16ef5](https://github.com/orbcorp/orb-python/commit/7e16ef55cd743b63b0ee8f0a9e45052c610998fb))
* **api:** add support for query param include_all_blocks ([#301](https://github.com/orbcorp/orb-python/issues/301)) ([1b7b6a3](https://github.com/orbcorp/orb-python/commit/1b7b6a3236226bdd7bf7bd00d041a0c0a99f24bf))
* **api:** deprecate methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#329](https://github.com/orbcorp/orb-python/issues/329)) ([1cc12f1](https://github.com/orbcorp/orb-python/commit/1cc12f133f42ef99910ed4bf5f8e7bf0b42ab34e))
* **api:** external connections made optional when updating items ([#296](https://github.com/orbcorp/orb-python/issues/296)) ([9076f38](https://github.com/orbcorp/orb-python/commit/9076f38ee750cf1f59d6260befb9931d3f878743))
* **api:** remove methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#330](https://github.com/orbcorp/orb-python/issues/330)) ([62e5158](https://github.com/orbcorp/orb-python/commit/62e5158e1febd96d28081bd2c7faf023a410088d))
* **api:** updates ([#291](https://github.com/orbcorp/orb-python/issues/291)) ([38aaf34](https://github.com/orbcorp/orb-python/commit/38aaf34361e649e4111f8a4038afe82867c8d4d8))


### Bug Fixes

* **api:** endpoint expects amount of new allocation price to be a string, not a number ([#297](https://github.com/orbcorp/orb-python/issues/297)) ([cb8992b](https://github.com/orbcorp/orb-python/commit/cb8992bf23e9639a27d885e110966cb01acc3e61))
* **build:** include more files in sdist builds ([#300](https://github.com/orbcorp/orb-python/issues/300)) ([922476f](https://github.com/orbcorp/orb-python/commit/922476f4690435b72b12c6a06a92108cf9368d1a))
* **client/async:** avoid blocking io call for platform headers ([#294](https://github.com/orbcorp/orb-python/issues/294)) ([89f4bfe](https://github.com/orbcorp/orb-python/commit/89f4bfe6516912f25d0bbe6e8ecf3343a2e05300))
* **client:** always respect content-type multipart/form-data if provided ([#308](https://github.com/orbcorp/orb-python/issues/308)) ([9d980df](https://github.com/orbcorp/orb-python/commit/9d980dfe52c7e0a9cfdbd9dbed32540589353d1d))
* **docs:** fix link to advanced python httpx docs ([#298](https://github.com/orbcorp/orb-python/issues/298)) ([55cff13](https://github.com/orbcorp/orb-python/commit/55cff139e8175d1dce02004c9715a42006bbb11c))
* temporarily patch upstream version to fix broken release flow ([#299](https://github.com/orbcorp/orb-python/issues/299)) ([b0c95aa](https://github.com/orbcorp/orb-python/commit/b0c95aa994d16c17486bbd999115114174fd2eac))


### Chores

* **ci:** also run workflows for PRs targeting `next` ([#314](https://github.com/orbcorp/orb-python/issues/314)) ([4fc3bcb](https://github.com/orbcorp/orb-python/commit/4fc3bcb9dc201a36e907a56983cb0cf8498c1f54))
* **ci:** limit release doctor target branches ([#323](https://github.com/orbcorp/orb-python/issues/323)) ([fdf2291](https://github.com/orbcorp/orb-python/commit/fdf2291d68f4d0e119ff8ae4c6022f2ed95ca071))
* **ci:** update rye to v0.35.0 ([#309](https://github.com/orbcorp/orb-python/issues/309)) ([540ff37](https://github.com/orbcorp/orb-python/commit/540ff3705d0f986577012bde92cfd2a60c45825d))
* **deps:** bump anyio to v4.4.0 ([#303](https://github.com/orbcorp/orb-python/issues/303)) ([e02d74d](https://github.com/orbcorp/orb-python/commit/e02d74db5b900a2d7a8a3d3bbdb0356ab78db978))
* **docs:** document how to do per-request http client customization ([#322](https://github.com/orbcorp/orb-python/issues/322)) ([30320ae](https://github.com/orbcorp/orb-python/commit/30320ae1074928dc95ee1e23ed6aea8bf47759fd))
* **docs:** improve Coupon description ([#293](https://github.com/orbcorp/orb-python/issues/293)) ([5aa0f32](https://github.com/orbcorp/orb-python/commit/5aa0f328e70673ff0c928bd2b704b1e3822b480c))
* **docs:** minor update to formatting of API link in README ([#318](https://github.com/orbcorp/orb-python/issues/318)) ([67d26e4](https://github.com/orbcorp/orb-python/commit/67d26e4c49d1a0e3b482e660c50ad1bfe99c434f))
* **docs:** updates price intervals docs ([#302](https://github.com/orbcorp/orb-python/issues/302)) ([a05b099](https://github.com/orbcorp/orb-python/commit/a05b09901baddddec77db515ae7102dec167014e))
* fix error message import example ([#326](https://github.com/orbcorp/orb-python/issues/326)) ([4993ac4](https://github.com/orbcorp/orb-python/commit/4993ac4368cfe41249931e45aa7b030c0dceddce))
* gitignore test server logs ([#305](https://github.com/orbcorp/orb-python/issues/305)) ([9a8b82f](https://github.com/orbcorp/orb-python/commit/9a8b82f869b9bb975920f994b0bf8585196445d4))
* **internal:** add a `default_query` method ([#292](https://github.com/orbcorp/orb-python/issues/292)) ([8aa1d73](https://github.com/orbcorp/orb-python/commit/8aa1d7356132d6221b32654616669b8fa1aee9f7))
* **internal:** add helper function ([#312](https://github.com/orbcorp/orb-python/issues/312)) ([3d9704e](https://github.com/orbcorp/orb-python/commit/3d9704eaa3fc9acdd900a0e2357785ac93b18d6a))
* **internal:** add helper method for constructing `BaseModel`s ([#307](https://github.com/orbcorp/orb-python/issues/307)) ([73a4593](https://github.com/orbcorp/orb-python/commit/73a4593797c5bbca315f6ed846427e388c0445ec))
* **internal:** add reflection helper function ([#304](https://github.com/orbcorp/orb-python/issues/304)) ([986bd84](https://github.com/orbcorp/orb-python/commit/986bd84dcb22d9413430f578c28a5adccadaacfd))
* **internal:** add rich as a dev dependency ([#306](https://github.com/orbcorp/orb-python/issues/306)) ([d2a2f3f](https://github.com/orbcorp/orb-python/commit/d2a2f3fe411cb3d57b15c7f3bfd102523def0e8f))
* **internal:** add type construction helper ([#328](https://github.com/orbcorp/orb-python/issues/328)) ([6094016](https://github.com/orbcorp/orb-python/commit/60940163e63ef9798cfb7f177088892933000844))
* **internal:** minor import restructuring ([#315](https://github.com/orbcorp/orb-python/issues/315)) ([eeee65e](https://github.com/orbcorp/orb-python/commit/eeee65e7b30438c9133f47f0aa86b35e54878506))
* **internal:** minor options / compat functions updates ([#317](https://github.com/orbcorp/orb-python/issues/317)) ([2a05873](https://github.com/orbcorp/orb-python/commit/2a05873d80ae4e8bebdbcd2adb7cd1817377cc11))
* **internal:** minor request options handling changes ([#311](https://github.com/orbcorp/orb-python/issues/311)) ([cfcc3eb](https://github.com/orbcorp/orb-python/commit/cfcc3ebc299a387decd8812879a8ad851dc7d6da))
* **internal:** update formatting ([#319](https://github.com/orbcorp/orb-python/issues/319)) ([f212cc8](https://github.com/orbcorp/orb-python/commit/f212cc89ee7b8b783e0fad9fb09d3e772abdf1f4))
* **internal:** update formatting ([#320](https://github.com/orbcorp/orb-python/issues/320)) ([6dc313b](https://github.com/orbcorp/orb-python/commit/6dc313bc36ba258ae2522b649387ff6f42cee818))
* **internal:** update mypy ([#313](https://github.com/orbcorp/orb-python/issues/313)) ([e98ba62](https://github.com/orbcorp/orb-python/commit/e98ba6215dea14581b1d3b54b570a5f176948003))
* **tests:** update prism version ([#325](https://github.com/orbcorp/orb-python/issues/325)) ([a26627c](https://github.com/orbcorp/orb-python/commit/a26627c3b271916424bdd72b4087a51e3b36fc72))


### Documentation

* **examples:** use named params more ([#316](https://github.com/orbcorp/orb-python/issues/316)) ([a451ed6](https://github.com/orbcorp/orb-python/commit/a451ed63406c95767251f976805496a1cf300b5d))
* **readme:** fix example snippet imports ([#324](https://github.com/orbcorp/orb-python/issues/324)) ([47e954d](https://github.com/orbcorp/orb-python/commit/47e954df9d22f1b9cef2883b72479bd10a6a6b69))
* small updates ([#290](https://github.com/orbcorp/orb-python/issues/290)) ([4beb928](https://github.com/orbcorp/orb-python/commit/4beb9285099ff26ed8ca6a9f178f34daf87f053f))

## 1.56.0 (2024-05-29)

Full Changelog: [v1.55.0...v1.56.0](https://github.com/orbcorp/orb-python/compare/v1.55.0...v1.56.0)

### Features

* **api:** pricing model updates ([4dc829a](https://github.com/orbcorp/orb-python/commit/4dc829ad67edf6b4384c6b4432edb7f73c847167))
* **api:** update item endpoint ([#287](https://github.com/orbcorp/orb-python/issues/287)) ([4dc829a](https://github.com/orbcorp/orb-python/commit/4dc829ad67edf6b4384c6b4432edb7f73c847167))


### Chores

* **ci:** update rye install location ([#282](https://github.com/orbcorp/orb-python/issues/282)) ([667cef5](https://github.com/orbcorp/orb-python/commit/667cef59e90027b25829b2dd2bfcdd5917f68627))
* **internal:** bump pyright ([#284](https://github.com/orbcorp/orb-python/issues/284)) ([ef316cc](https://github.com/orbcorp/orb-python/commit/ef316cc860ed7571788a4fbb5509a273f5ac731c))
* **internal:** update bootstrap script ([#286](https://github.com/orbcorp/orb-python/issues/286)) ([72edfe5](https://github.com/orbcorp/orb-python/commit/72edfe561c937aeec2006986b64c7cb18bc8655f))


### Documentation

* **contributing:** update references to rye-up.com ([#285](https://github.com/orbcorp/orb-python/issues/285)) ([5502012](https://github.com/orbcorp/orb-python/commit/55020125e1397497a437de9fcce80f31f341c7d8))

## 1.55.0 (2024-05-23)

Full Changelog: [v1.54.0...v1.55.0](https://github.com/orbcorp/orb-python/compare/v1.54.0...v1.55.0)

### Features

* **api:** updates ([#281](https://github.com/orbcorp/orb-python/issues/281)) ([9293cda](https://github.com/orbcorp/orb-python/commit/9293cdab4af46bc5dbeb1f8dbc7d6dfc1ebf43d6))


### Chores

* **ci:** update rye install location ([#279](https://github.com/orbcorp/orb-python/issues/279)) ([a69dda3](https://github.com/orbcorp/orb-python/commit/a69dda372329408a5e8f5c25da8fb740297d4fd5))

## 1.54.0 (2024-05-22)

Full Changelog: [v1.53.0...v1.54.0](https://github.com/orbcorp/orb-python/compare/v1.53.0...v1.54.0)

### Features

* **api:** add adjustment interval to subscriptions ([#277](https://github.com/orbcorp/orb-python/issues/277)) ([7248240](https://github.com/orbcorp/orb-python/commit/7248240a566b0907f20a3c1639b7c5fa6129bb29))

## 1.53.0 (2024-05-16)

Full Changelog: [v1.52.0...v1.53.0](https://github.com/orbcorp/orb-python/compare/v1.52.0...v1.53.0)

### Features

* **api:** updates ([#276](https://github.com/orbcorp/orb-python/issues/276)) ([b82fbca](https://github.com/orbcorp/orb-python/commit/b82fbca25bf22a6ca49b5cdcc32f916ce8a880d9))


### Chores

* **internal:** add slightly better logging to scripts ([#274](https://github.com/orbcorp/orb-python/issues/274)) ([af172ca](https://github.com/orbcorp/orb-python/commit/af172ca303ee54e6d453bbeee9d0b77e93fcfdf6))

## 1.52.0 (2024-05-14)

Full Changelog: [v1.51.0...v1.52.0](https://github.com/orbcorp/orb-python/compare/v1.51.0...v1.52.0)

### Features

* **api:** updates ([#273](https://github.com/orbcorp/orb-python/issues/273)) ([199805d](https://github.com/orbcorp/orb-python/commit/199805d51549536bf508776452ddc72933507ace))


### Chores

* **internal:** bump pydantic dependency ([#271](https://github.com/orbcorp/orb-python/issues/271)) ([c40750a](https://github.com/orbcorp/orb-python/commit/c40750a90bb962d63bd4531d24d69e6b9e930a9f))

## 1.51.0 (2024-05-13)

Full Changelog: [v1.50.1...v1.51.0](https://github.com/orbcorp/orb-python/compare/v1.50.1...v1.51.0)

### Features

* **api:** updates ([#270](https://github.com/orbcorp/orb-python/issues/270)) ([cc12356](https://github.com/orbcorp/orb-python/commit/cc12356f4d04c4b97ae7eb9ebaf92abdd4192658))


### Chores

* **docs:** add SECURITY.md ([#268](https://github.com/orbcorp/orb-python/issues/268)) ([57ed634](https://github.com/orbcorp/orb-python/commit/57ed634ffbe8be758a1123359f5e61c7e09f7eb7))

## 1.50.1 (2024-05-10)

Full Changelog: [v1.50.0...v1.50.1](https://github.com/orbcorp/orb-python/compare/v1.50.0...v1.50.1)

### Bug Fixes

* **api:** remove alert parameters and method that aren't supported by the live API ([#267](https://github.com/orbcorp/orb-python/issues/267)) ([0719f0d](https://github.com/orbcorp/orb-python/commit/0719f0df752a85aee84067b3c50c1c879de1cebd))


### Chores

* **docs:** improve alert endpoints descriptions ([#263](https://github.com/orbcorp/orb-python/issues/263)) ([633b79d](https://github.com/orbcorp/orb-python/commit/633b79d89acc1c7c80768ee65464f93014b80b5a))
* rebuild project due to oas spec rename ([#266](https://github.com/orbcorp/orb-python/issues/266)) ([60072ac](https://github.com/orbcorp/orb-python/commit/60072ac2e0a3dc8ae6c0af9c8919ee77438a8d47))
* **types:** add union discriminator metadata ([#265](https://github.com/orbcorp/orb-python/issues/265)) ([4cfa964](https://github.com/orbcorp/orb-python/commit/4cfa96454f09914d15405b1d2bb3fe26d95cd2bc))

## 1.50.0 (2024-05-09)

Full Changelog: [v1.49.0...v1.50.0](https://github.com/orbcorp/orb-python/compare/v1.49.0...v1.50.0)

### Features

* **api:** add alert methods and models ([#261](https://github.com/orbcorp/orb-python/issues/261)) ([fca2f46](https://github.com/orbcorp/orb-python/commit/fca2f46382d5f88213d2b214cef88b8d6ac4902f))


### Chores

* **internal:** remove redundant decorator args ([#259](https://github.com/orbcorp/orb-python/issues/259)) ([944e9fd](https://github.com/orbcorp/orb-python/commit/944e9fdc862b5628afd4924a3dfe66870f5030c5))

## 1.49.0 (2024-05-08)

Full Changelog: [v1.48.0...v1.49.0](https://github.com/orbcorp/orb-python/compare/v1.48.0...v1.49.0)

### Features

* **api:** add method to enable alerts ([#255](https://github.com/orbcorp/orb-python/issues/255)) ([8531900](https://github.com/orbcorp/orb-python/commit/853190015924d67b6264db3f3f60cc143e037a6e))

## 1.48.0 (2024-05-03)

Full Changelog: [v1.47.1...v1.48.0](https://github.com/orbcorp/orb-python/compare/v1.47.1...v1.48.0)

### Features

* add webhooks verification helpers ([d3763df](https://github.com/orbcorp/orb-python/commit/d3763df9526cf311d85b32db4edba3e45e5030ae))
* **api:** add `invoice_source` to invoice ([#225](https://github.com/orbcorp/orb-python/issues/225)) ([4d65ea3](https://github.com/orbcorp/orb-python/commit/4d65ea32c00b414b048bfef207693c7b2d37179d))
* **api:** add effective_date field ([#231](https://github.com/orbcorp/orb-python/issues/231)) ([4db6fc1](https://github.com/orbcorp/orb-python/commit/4db6fc122e378b78a64a1acf39e1ee6706219261))
* **api:** add param to backfill create ([#247](https://github.com/orbcorp/orb-python/issues/247)) ([8a21054](https://github.com/orbcorp/orb-python/commit/8a21054c80251481a73d34bf6e08c54a40d4f172))
* **api:** add subscription update endpoint ([#238](https://github.com/orbcorp/orb-python/issues/238)) ([c116802](https://github.com/orbcorp/orb-python/commit/c1168027beec59d88637ef4ea8494ccfbd894f16))
* **api:** add the shared model PaginationMetadata ([#235](https://github.com/orbcorp/orb-python/issues/235)) ([0506ab6](https://github.com/orbcorp/orb-python/commit/0506ab6af67bdb2def0f6df28c2678738c43a16c))
* **api:** add tiered package with minimum price ([#220](https://github.com/orbcorp/orb-python/issues/220)) ([6f47aea](https://github.com/orbcorp/orb-python/commit/6f47aeaa3b8e7989559e969dd589aa20eeb0b725))
* **api:** price evaluation endpoint generally available ([#240](https://github.com/orbcorp/orb-python/issues/240)) ([c83a0b4](https://github.com/orbcorp/orb-python/commit/c83a0b4e13cdb01d1baa394d600f88dee8185b10))
* **api:** remove accidental null ([#215](https://github.com/orbcorp/orb-python/issues/215)) ([41dcb8c](https://github.com/orbcorp/orb-python/commit/41dcb8cc7a79ec9a7692112b7fe8ad26ddcf1635))
* **api:** timeframe_end and timeframe_start accept null ([#219](https://github.com/orbcorp/orb-python/issues/219)) ([3a3872e](https://github.com/orbcorp/orb-python/commit/3a3872e0e6982ddbf8470112aa2e6717f7f8bd75))
* **api:** updates ([#210](https://github.com/orbcorp/orb-python/issues/210)) ([5b302c6](https://github.com/orbcorp/orb-python/commit/5b302c6eded8517c30f599d71dbd3b7bd7bb0cc7))
* **api:** updates ([#228](https://github.com/orbcorp/orb-python/issues/228)) ([d0ffb6d](https://github.com/orbcorp/orb-python/commit/d0ffb6da7fc33b7f73a98957f0f934a762839e4b))
* **api:** updates ([#229](https://github.com/orbcorp/orb-python/issues/229)) ([dc48f78](https://github.com/orbcorp/orb-python/commit/dc48f788211674bd4c583abaedbb2cb447b81663))
* **api:** updates ([#252](https://github.com/orbcorp/orb-python/issues/252)) ([85d4759](https://github.com/orbcorp/orb-python/commit/85d4759b593cc6cc7a531f0fba9cb1b2c13baf8a))
* **client:** add DefaultHttpxClient and DefaultAsyncHttpxClient ([#224](https://github.com/orbcorp/orb-python/issues/224)) ([128a275](https://github.com/orbcorp/orb-python/commit/128a2759502c5fe4ffb1ca6eb064f9cc770849fc))
* **client:** add webhook secret argument ([#212](https://github.com/orbcorp/orb-python/issues/212)) ([b611a6c](https://github.com/orbcorp/orb-python/commit/b611a6cc05461d9f671013d30ffb064c12585902))
* **models:** add to_dict & to_json helper methods ([#226](https://github.com/orbcorp/orb-python/issues/226)) ([db7526a](https://github.com/orbcorp/orb-python/commit/db7526af6d978a9e30efd8a2bd2ec3b2b64f237f))
* **package:** export default constants ([#214](https://github.com/orbcorp/orb-python/issues/214)) ([1d80f5f](https://github.com/orbcorp/orb-python/commit/1d80f5f5ddba235105be06802de4dfab63ac58d7))


### Bug Fixes

* **api:** add shared model BillingCycleRelativeDate ([#237](https://github.com/orbcorp/orb-python/issues/237)) ([ed85a2a](https://github.com/orbcorp/orb-python/commit/ed85a2a011526f244f8da2f709ad7dd3039c6ffc))
* **api:** some path params were incorrectly typed as nullable ([#236](https://github.com/orbcorp/orb-python/issues/236)) ([f89e868](https://github.com/orbcorp/orb-python/commit/f89e868c1645a4f6d45f398cded1bea2b1706fb4))
* **docs:** doc improvements ([#242](https://github.com/orbcorp/orb-python/issues/242)) ([d7bc080](https://github.com/orbcorp/orb-python/commit/d7bc080c79678c9e4afff43ae65a306435e64445))
* **project:** use absolute github links on PyPi ([#216](https://github.com/orbcorp/orb-python/issues/216)) ([bb54f40](https://github.com/orbcorp/orb-python/commit/bb54f4068a50e3ca4ce7e87e5ce9f75259f1a082))


### Chores

* **client:** log response headers in debug mode ([#248](https://github.com/orbcorp/orb-python/issues/248)) ([b368546](https://github.com/orbcorp/orb-python/commit/b368546016f0d95e0c8f87f54388b62c6116c777))
* **client:** validate that max_retries is not None ([#218](https://github.com/orbcorp/orb-python/issues/218)) ([c885c17](https://github.com/orbcorp/orb-python/commit/c885c1755b467647bb42ab6b1ded3125dd90a705))
* **docs:** revise currency description ([#223](https://github.com/orbcorp/orb-python/issues/223)) ([b19a196](https://github.com/orbcorp/orb-python/commit/b19a196e63cc79d69e0249ae510357d614bd2691))
* fix typo ([#227](https://github.com/orbcorp/orb-python/issues/227)) ([cd4f7e2](https://github.com/orbcorp/orb-python/commit/cd4f7e2d071d6ea336466d41a0c707b47e60caf9))
* **internal:** add link to openapi spec ([#249](https://github.com/orbcorp/orb-python/issues/249)) ([b370433](https://github.com/orbcorp/orb-python/commit/b3704332e9fd5613ff182e7883c56eeebfaa8b15))
* **internal:** add lru_cache helper function ([#232](https://github.com/orbcorp/orb-python/issues/232)) ([a7b6f74](https://github.com/orbcorp/orb-python/commit/a7b6f74ca43e4480cf54b8c859a4c7cc5139bab9))
* **internal:** add scripts/test, scripts/mock and add ci job ([#250](https://github.com/orbcorp/orb-python/issues/250)) ([85b7769](https://github.com/orbcorp/orb-python/commit/85b77697608292090e5308885553abd9a9e0e540))
* **internal:** ban usage of lru_cache ([#233](https://github.com/orbcorp/orb-python/issues/233)) ([e7074d3](https://github.com/orbcorp/orb-python/commit/e7074d3efeba5b4ee5d1cd686f614f18222c04ee))
* **internal:** bump mock server version to ~5.8.0 ([#251](https://github.com/orbcorp/orb-python/issues/251)) ([d9d27b0](https://github.com/orbcorp/orb-python/commit/d9d27b014c244616d6b57264e325104986fb8d18))
* **internal:** bump pyright to 1.1.359 ([#234](https://github.com/orbcorp/orb-python/issues/234)) ([11ab6aa](https://github.com/orbcorp/orb-python/commit/11ab6aa7fb78ad5828837ce9ebfcb70d60eee413))
* **internal:** defer model build for import latency ([#221](https://github.com/orbcorp/orb-python/issues/221)) ([5a58805](https://github.com/orbcorp/orb-python/commit/5a58805776bdc08f3b045b8a1cf6117f99e49ac4))
* **internal:** formatting ([#230](https://github.com/orbcorp/orb-python/issues/230)) ([04ff195](https://github.com/orbcorp/orb-python/commit/04ff19541848db9f482f2215900f969229436975))
* **internal:** minor reformatting ([#246](https://github.com/orbcorp/orb-python/issues/246)) ([c549be2](https://github.com/orbcorp/orb-python/commit/c549be2564cefe0779cbcc272236c00d91bf3764))
* **internal:** reformat imports ([#245](https://github.com/orbcorp/orb-python/issues/245)) ([45181a9](https://github.com/orbcorp/orb-python/commit/45181a960e7af01dfea6aa1c3da874f39753d572))
* **internal:** restructure imports ([#239](https://github.com/orbcorp/orb-python/issues/239)) ([3dddf85](https://github.com/orbcorp/orb-python/commit/3dddf850cfaf3fffde98856f2b1dc3d91947f145))
* **internal:** streaming updates ([#222](https://github.com/orbcorp/orb-python/issues/222)) ([a207206](https://github.com/orbcorp/orb-python/commit/a2072064621318de18de7597caf2afb24ce3a93c))
* **internal:** update test helper function ([#244](https://github.com/orbcorp/orb-python/issues/244)) ([2c95701](https://github.com/orbcorp/orb-python/commit/2c9570140a896212ec8f29d3bcb5769325cbe46b))
* **internal:** use actions/checkout@v4 for codeflow ([#243](https://github.com/orbcorp/orb-python/issues/243)) ([5ee51b3](https://github.com/orbcorp/orb-python/commit/5ee51b32ff1e46896b0a5f7bd285ab1d825bcb94))


### Documentation

* **readme:** fix misleading timeout example value ([#253](https://github.com/orbcorp/orb-python/issues/253)) ([293da36](https://github.com/orbcorp/orb-python/commit/293da3662174d57cdb8dbcf8c2f38e687d974e80))

## 1.47.1 (2024-03-25)

Full Changelog: [v1.47.0...v1.47.1](https://github.com/orbcorp/orb-python/compare/v1.47.0...v1.47.1)

### Bug Fixes

* revert regression with 3.7 support ([#209](https://github.com/orbcorp/orb-python/issues/209)) ([11f44da](https://github.com/orbcorp/orb-python/commit/11f44da6ff3ca5f9f3d762a216fc0e434ae78ba0))


### Chores

* **internal:** formatting change ([#206](https://github.com/orbcorp/orb-python/issues/206)) ([b4bfd91](https://github.com/orbcorp/orb-python/commit/b4bfd91467762d409b0d1d699d914aeb5d730e72))


### Documentation

* **contributing:** fix typo ([#208](https://github.com/orbcorp/orb-python/issues/208)) ([1d2f286](https://github.com/orbcorp/orb-python/commit/1d2f2866dee4556bc0c3124ec73aca49d62b138a))

## 1.47.0 (2024-03-21)

Full Changelog: [v1.46.0...v1.47.0](https://github.com/orbcorp/orb-python/compare/v1.46.0...v1.47.0)

### Features

* **api:** introduce credits status ([d15d875](https://github.com/orbcorp/orb-python/commit/d15d875ee628eb8a3af8d3a2e67126b069984d1c))
* **api:** remove `scaling_factor` ([#205](https://github.com/orbcorp/orb-python/issues/205)) ([d15d875](https://github.com/orbcorp/orb-python/commit/d15d875ee628eb8a3af8d3a2e67126b069984d1c))


### Performance Improvements

* cache TypeAdapters ([#197](https://github.com/orbcorp/orb-python/issues/197)) ([536a387](https://github.com/orbcorp/orb-python/commit/536a38777b2b9fb5dc944eb712e9f31e389cc52f))


### Chores

* **internal:** construct error properties instead of using the raw response ([#204](https://github.com/orbcorp/orb-python/issues/204)) ([e5438a9](https://github.com/orbcorp/orb-python/commit/e5438a9958ba21a35c90d40edc4438450e91601b))
* **internal:** loosen input type for util function ([#202](https://github.com/orbcorp/orb-python/issues/202)) ([6d48c20](https://github.com/orbcorp/orb-python/commit/6d48c20cb8f0b64aaa2ce57804076987b422f9f4))
* **internal:** update generated pragma comment ([#200](https://github.com/orbcorp/orb-python/issues/200)) ([336a736](https://github.com/orbcorp/orb-python/commit/336a736ae99e6c54353da05891a0a68a78339cd0))


### Documentation

* fix typo in CONTRIBUTING.md ([#199](https://github.com/orbcorp/orb-python/issues/199)) ([5ffe938](https://github.com/orbcorp/orb-python/commit/5ffe9386e8baec7f94bcb0505ee25c153004767f))
* **readme:** document how to make undocumented requests ([#203](https://github.com/orbcorp/orb-python/issues/203)) ([9757d20](https://github.com/orbcorp/orb-python/commit/9757d20415f0ad8f42109d207800f6546be56ff4))
* updated invoice description ([#201](https://github.com/orbcorp/orb-python/issues/201)) ([ba19ce0](https://github.com/orbcorp/orb-python/commit/ba19ce050fedf92e06a6775d4b51f9b43b0a4d8d))

## 1.46.0 (2024-03-15)

Full Changelog: [v1.45.0...v1.46.0](https://github.com/orbcorp/orb-python/compare/v1.45.0...v1.46.0)

### Features

* **api:** create invoice metadata param ([#195](https://github.com/orbcorp/orb-python/issues/195)) ([e5504a6](https://github.com/orbcorp/orb-python/commit/e5504a69a54c4b5b6548ec7e4914c5dfb58cdd09))

## 1.45.0 (2024-03-14)

Full Changelog: [v1.44.0...v1.45.0](https://github.com/orbcorp/orb-python/compare/v1.44.0...v1.45.0)

### Features

* **api:** add matrix with allocation price ([#193](https://github.com/orbcorp/orb-python/issues/193)) ([45cc072](https://github.com/orbcorp/orb-python/commit/45cc0723c18b50506456591498798a1fa4994bff))

## 1.44.0 (2024-03-11)

Full Changelog: [v1.43.0...v1.44.0](https://github.com/orbcorp/orb-python/compare/v1.43.0...v1.44.0)

### Features

* **api:** updates ([#192](https://github.com/orbcorp/orb-python/issues/192)) ([876b19f](https://github.com/orbcorp/orb-python/commit/876b19f71822f752eb33e106466ac766cc73e148))


### Chores

* **internal:** improve deserialisation of discriminated unions ([#190](https://github.com/orbcorp/orb-python/issues/190)) ([5b96dd5](https://github.com/orbcorp/orb-python/commit/5b96dd5f664fb69a0db1a990e184a6bfbcb5b499))

## 1.43.0 (2024-03-09)

Full Changelog: [v1.42.3...v1.43.0](https://github.com/orbcorp/orb-python/compare/v1.42.3...v1.43.0)

### Features

* **api:** updates ([#189](https://github.com/orbcorp/orb-python/issues/189)) ([3b9e36f](https://github.com/orbcorp/orb-python/commit/3b9e36f1fbca43b9e29794778178056d94870b2e))


### Chores

* **ci:** uses Stainless GitHub App for releases ([#172](https://github.com/orbcorp/orb-python/issues/172)) ([d5b9f5f](https://github.com/orbcorp/orb-python/commit/d5b9f5fff40d93d4aad599b38b8771284619d01d))
* **client:** improve error message for invalid http_client argument ([#184](https://github.com/orbcorp/orb-python/issues/184)) ([17dacf2](https://github.com/orbcorp/orb-python/commit/17dacf22512f6bb7d3cc0c87905f92d964a84a76))
* **client:** use anyio.sleep instead of asyncio.sleep ([#178](https://github.com/orbcorp/orb-python/issues/178)) ([677ef7e](https://github.com/orbcorp/orb-python/commit/677ef7e68840dd04cfbd7cae8e6a5af9998bc306))
* **docs:** mention install from git repo ([#181](https://github.com/orbcorp/orb-python/issues/181)) ([795ae88](https://github.com/orbcorp/orb-python/commit/795ae882855d557105339689155110f4506da4c2))
* export NOT_GIVEN sentinel value ([#188](https://github.com/orbcorp/orb-python/issues/188)) ([7a739b9](https://github.com/orbcorp/orb-python/commit/7a739b9a3b0a06704e02944c1af01930335c2b97))
* **internal:** add core support for deserializing into number response ([#185](https://github.com/orbcorp/orb-python/issues/185)) ([247964e](https://github.com/orbcorp/orb-python/commit/247964ea68575e12ba5aad7c39675a48e3653474))
* **internal:** bump pyright ([#177](https://github.com/orbcorp/orb-python/issues/177)) ([f5c6f0c](https://github.com/orbcorp/orb-python/commit/f5c6f0c3b5a432933a053f227d630df20582c4c4))
* **internal:** bump pyright ([#186](https://github.com/orbcorp/orb-python/issues/186)) ([03ff063](https://github.com/orbcorp/orb-python/commit/03ff063b02838b75a1e8f602aae312afd12e44b6))
* **internal:** bump rye to v0.24.0 ([#175](https://github.com/orbcorp/orb-python/issues/175)) ([450508a](https://github.com/orbcorp/orb-python/commit/450508a34a4838b92c54ff10ba439f6d60808b04))
* **internal:** minor core client restructuring ([#179](https://github.com/orbcorp/orb-python/issues/179)) ([ace9451](https://github.com/orbcorp/orb-python/commit/ace945177ced39721f2eb8ea1ddd9b9b448b73bd))
* **internal:** refactor release environment script ([#173](https://github.com/orbcorp/orb-python/issues/173)) ([2503fbc](https://github.com/orbcorp/orb-python/commit/2503fbc1c20524c9057ab5a1ef25bb279ee35827))
* **internal:** split up transforms into sync / async ([#182](https://github.com/orbcorp/orb-python/issues/182)) ([17a94e7](https://github.com/orbcorp/orb-python/commit/17a94e75d071908b7e9048d26a26adaf16f2b52c))
* **internal:** support more input types ([#183](https://github.com/orbcorp/orb-python/issues/183)) ([fc2721e](https://github.com/orbcorp/orb-python/commit/fc2721e1638b3c79d5e22f573923c09142196c43))
* **internal:** support parsing Annotated types ([#187](https://github.com/orbcorp/orb-python/issues/187)) ([9982119](https://github.com/orbcorp/orb-python/commit/9982119ec618bba15f0e1cfa1eac9adc5168206a))
* **internal:** update deps ([#176](https://github.com/orbcorp/orb-python/issues/176)) ([abdbcc6](https://github.com/orbcorp/orb-python/commit/abdbcc69bb3efc80fabe4980c6eacc3cf8725dbd))


### Documentation

* add CONTRIBUTING.md ([#170](https://github.com/orbcorp/orb-python/issues/170)) ([87d1adf](https://github.com/orbcorp/orb-python/commit/87d1adfaaeb7afaf4741e9e26afb07ac7962b6c1))
* **contributing:** improve wording ([#180](https://github.com/orbcorp/orb-python/issues/180)) ([ff322f1](https://github.com/orbcorp/orb-python/commit/ff322f16b36dba9051c6c6c7c49d2c34419317ca))

## 1.42.3 (2024-02-07)

Full Changelog: [v1.42.2...v1.42.3](https://github.com/orbcorp/orb-python/compare/v1.42.2...v1.42.3)

### Bug Fixes

* change status serialization behavior ([#168](https://github.com/orbcorp/orb-python/issues/168)) ([fb5348b](https://github.com/orbcorp/orb-python/commit/fb5348bc15be70b3d5165916013d0f597265ad00))

## 1.42.2 (2024-02-06)

Full Changelog: [v1.42.1...v1.42.2](https://github.com/orbcorp/orb-python/compare/v1.42.1...v1.42.2)

### Bug Fixes

* **types:** loosen most List params types to Iterable ([#167](https://github.com/orbcorp/orb-python/issues/167)) ([ee5959e](https://github.com/orbcorp/orb-python/commit/ee5959e48c748cd89010d8a4e74b9b366746dde9))


### Chores

* **internal:** add lint command ([#166](https://github.com/orbcorp/orb-python/issues/166)) ([0cc21f7](https://github.com/orbcorp/orb-python/commit/0cc21f78e4a17364ad89917f5a9f32a4ecc039a3))
* **internal:** support serialising iterable types ([#164](https://github.com/orbcorp/orb-python/issues/164)) ([246a496](https://github.com/orbcorp/orb-python/commit/246a496c589b015931f273912d31fefacfe08a93))

## 1.42.1 (2024-02-04)

Full Changelog: [v1.42.0...v1.42.1](https://github.com/orbcorp/orb-python/compare/v1.42.0...v1.42.1)

### Bug Fixes

* prevent crash when platform.architecture() is not allowed ([#163](https://github.com/orbcorp/orb-python/issues/163)) ([20629a0](https://github.com/orbcorp/orb-python/commit/20629a05e67981b09a3b506ae32e5d3d64ca9420))


### Chores

* **interal:** make link to api.md relative ([#161](https://github.com/orbcorp/orb-python/issues/161)) ([7710cdc](https://github.com/orbcorp/orb-python/commit/7710cdcad2adeaa76d1ff7f7ee6e149a5e67c451))

## 1.42.0 (2024-02-01)

Full Changelog: [v1.41.0...v1.42.0](https://github.com/orbcorp/orb-python/compare/v1.41.0...v1.42.0)

### Features

* **api:** add `version` to plan ([#160](https://github.com/orbcorp/orb-python/issues/160)) ([de490e8](https://github.com/orbcorp/orb-python/commit/de490e80dd640df0a12132bbccaf692f3312db77))


### Chores

* **internal:** support pre-release versioning ([#158](https://github.com/orbcorp/orb-python/issues/158)) ([3dd41bb](https://github.com/orbcorp/orb-python/commit/3dd41bb0c9673ed434bdb95fc11391f735148117))

## 1.41.0 (2024-01-30)

Full Changelog: [v1.40.0...v1.41.0](https://github.com/orbcorp/orb-python/compare/v1.40.0...v1.41.0)

### Features

* **api:** price schema updates ([#156](https://github.com/orbcorp/orb-python/issues/156)) ([e995c09](https://github.com/orbcorp/orb-python/commit/e995c090615a17b3f622b001639ff1a3f619006e))

## 1.40.0 (2024-01-30)

Full Changelog: [v1.39.1...v1.40.0](https://github.com/orbcorp/orb-python/compare/v1.39.1...v1.40.0)

### Features

* **api:** add `external_customer_id` ([#155](https://github.com/orbcorp/orb-python/issues/155)) ([0e74ce3](https://github.com/orbcorp/orb-python/commit/0e74ce35a735c8900b291a476b4099b3bed6bc64))
* **client:** enable follow redirects by default ([#150](https://github.com/orbcorp/orb-python/issues/150)) ([94c7376](https://github.com/orbcorp/orb-python/commit/94c737641bd7bd06c388ed8bb549e84a6ee35e61))
* **client:** support parsing custom response types ([#153](https://github.com/orbcorp/orb-python/issues/153)) ([da133ec](https://github.com/orbcorp/orb-python/commit/da133ec1c09a43ee47462862981864b0661aa3a2))


### Chores

* **internal:** add internal helpers ([#147](https://github.com/orbcorp/orb-python/issues/147)) ([bf87d8e](https://github.com/orbcorp/orb-python/commit/bf87d8e4067e77bfa2ace0f4c8904e4994c28996))
* **internal:** cast type in mocked test ([#154](https://github.com/orbcorp/orb-python/issues/154)) ([579cda7](https://github.com/orbcorp/orb-python/commit/579cda758208204d9817e8bfffed19e88f526aca))
* **internal:** enable ruff type checking misuse lint rule ([#152](https://github.com/orbcorp/orb-python/issues/152)) ([a98b037](https://github.com/orbcorp/orb-python/commit/a98b037cc8689969a7f482a1476df3e280cb1696))
* **internal:** support multipart data with overlapping keys ([#151](https://github.com/orbcorp/orb-python/issues/151)) ([988e720](https://github.com/orbcorp/orb-python/commit/988e72066d898cb2c86913a255d3cccc72e3aba5))


### Refactors

* remove unnecessary builtin import ([#149](https://github.com/orbcorp/orb-python/issues/149)) ([285bbc2](https://github.com/orbcorp/orb-python/commit/285bbc2397151118d8fdbf5b5475673566d4cba8))

## 1.39.1 (2024-01-18)

Full Changelog: [v1.39.0...v1.39.1](https://github.com/orbcorp/orb-python/compare/v1.39.0...v1.39.1)

### Bug Fixes

* **ci:** ignore stainless-app edits to release PR title ([#146](https://github.com/orbcorp/orb-python/issues/146)) ([5a2e2b5](https://github.com/orbcorp/orb-python/commit/5a2e2b58b7763a99907ae3a3a8afd6a19789cb62))


### Chores

* **internal:** fix typing util function ([#140](https://github.com/orbcorp/orb-python/issues/140)) ([31a83a9](https://github.com/orbcorp/orb-python/commit/31a83a9d24ba25004ab234dc1b555a03d7333a1f))
* **internal:** remove redundant client test ([#142](https://github.com/orbcorp/orb-python/issues/142)) ([e315f4e](https://github.com/orbcorp/orb-python/commit/e315f4e00c4e2a45a657d56df3a22813264632a3))
* **internal:** share client instances between all tests ([#145](https://github.com/orbcorp/orb-python/issues/145)) ([64a4cb6](https://github.com/orbcorp/orb-python/commit/64a4cb6dfc3b5947701dba25dbe8c37b6050eb38))
* **internal:** speculative retry-after-ms support ([#143](https://github.com/orbcorp/orb-python/issues/143)) ([d7affe9](https://github.com/orbcorp/orb-python/commit/d7affe9e3fae951027d43307df10420143e69042))
* lazy load raw resource class properties ([#144](https://github.com/orbcorp/orb-python/issues/144)) ([72734a3](https://github.com/orbcorp/orb-python/commit/72734a340d158aae1e039d615a72bff2b9d89454))

## 1.39.0 (2024-01-17)

Full Changelog: [v1.38.1...v1.39.0](https://github.com/orbcorp/orb-python/compare/v1.38.1...v1.39.0)

### Features

* **api:** updates ([#139](https://github.com/orbcorp/orb-python/issues/139)) ([ab7998f](https://github.com/orbcorp/orb-python/commit/ab7998fa311038357c124fe556b9cd1a664d826b))


### Chores

* add write_to_file binary helper method ([#138](https://github.com/orbcorp/orb-python/issues/138)) ([f48014d](https://github.com/orbcorp/orb-python/commit/f48014d0792e01dde7206088ab672c6012d00deb))
* **internal:** updates to proxy helper ([#136](https://github.com/orbcorp/orb-python/issues/136)) ([15d29d5](https://github.com/orbcorp/orb-python/commit/15d29d513cd6b58fee06b6165bc2ce16fba7e096))

## 1.38.1 (2024-01-16)

Full Changelog: [v1.38.0...v1.38.1](https://github.com/orbcorp/orb-python/compare/v1.38.0...v1.38.1)

### Bug Fixes

* **client:** ensure path params are non-empty ([#134](https://github.com/orbcorp/orb-python/issues/134)) ([f318392](https://github.com/orbcorp/orb-python/commit/f318392b5ff32e4b53a021773220fda59aae0920))

## 1.38.0 (2024-01-15)

Full Changelog: [v1.37.0...v1.38.0](https://github.com/orbcorp/orb-python/compare/v1.37.0...v1.38.0)

### Features

* **api:** updates ([#133](https://github.com/orbcorp/orb-python/issues/133)) ([ace1234](https://github.com/orbcorp/orb-python/commit/ace12344fddc86150429c497f64f7fca030fc24e))
* **client:** add support for streaming raw responses ([#132](https://github.com/orbcorp/orb-python/issues/132)) ([171a504](https://github.com/orbcorp/orb-python/commit/171a504c2c74724fbedcd82d3696e8e1acf18eb9))


### Chores

* formatting ([#130](https://github.com/orbcorp/orb-python/issues/130)) ([4ae6c11](https://github.com/orbcorp/orb-python/commit/4ae6c1177b9d67e82baa44c4560e1372bfbd2f0a))

## 1.37.0 (2024-01-12)

Full Changelog: [v1.36.0...v1.37.0](https://github.com/orbcorp/orb-python/compare/v1.36.0...v1.37.0)

### Features

* add `None` default value to nullable response properties ([#123](https://github.com/orbcorp/orb-python/issues/123)) ([823f95c](https://github.com/orbcorp/orb-python/commit/823f95c2b504524de1bc65e00ca088d2552fad7b))
* **api:** add beta evaluate price endpoint ([#129](https://github.com/orbcorp/orb-python/issues/129)) ([5f8379a](https://github.com/orbcorp/orb-python/commit/5f8379a3acea6a9937219cb6878991a05a8c50b4))


### Chores

* add .keep files for examples and custom code directories ([#126](https://github.com/orbcorp/orb-python/issues/126)) ([672693d](https://github.com/orbcorp/orb-python/commit/672693d7c7cfec8d55d54ab328ea4c89f3527b55))
* **client:** improve debug logging for failed requests ([#127](https://github.com/orbcorp/orb-python/issues/127)) ([b35adf9](https://github.com/orbcorp/orb-python/commit/b35adf9795ce2321640904d43eb4ff806c8a1af8))
* **internal:** loosen type var restrictions ([#125](https://github.com/orbcorp/orb-python/issues/125)) ([60a2816](https://github.com/orbcorp/orb-python/commit/60a28169d5912c1a76f128c02012c062f507cb1f))
* **internal:** replace isort with ruff ([#121](https://github.com/orbcorp/orb-python/issues/121)) ([42b60df](https://github.com/orbcorp/orb-python/commit/42b60dfa929e6806fbddf6138af4df5a1557f2d7))
* use property declarations for resource members ([#124](https://github.com/orbcorp/orb-python/issues/124)) ([b60f5a8](https://github.com/orbcorp/orb-python/commit/b60f5a8a44687083c627d284fe3f7c105a3bbb84))


### Documentation

* **readme:** improve api reference ([#128](https://github.com/orbcorp/orb-python/issues/128)) ([5fbd017](https://github.com/orbcorp/orb-python/commit/5fbd01703a0dd0dd90f7359a703a8d6693c608ca))

## 1.36.0 (2024-01-01)

Full Changelog: [v1.35.2...v1.36.0](https://github.com/orbcorp/orb-python/compare/v1.35.2...v1.36.0)

### Features

* **api:** add currency fields ([#119](https://github.com/orbcorp/orb-python/issues/119)) ([35574d3](https://github.com/orbcorp/orb-python/commit/35574d339cff2ed011a17433af556ffed02af9b7))

## 1.35.2 (2023-12-28)

Full Changelog: [v1.35.1...v1.35.2](https://github.com/orbcorp/orb-python/compare/v1.35.1...v1.35.2)

### Bug Fixes

* **client:** correctly use custom http client auth ([#117](https://github.com/orbcorp/orb-python/issues/117)) ([863ebe8](https://github.com/orbcorp/orb-python/commit/863ebe87f4881f01afa7a39286a5b154ca047305))

## 1.35.1 (2023-12-26)

Full Changelog: [v1.35.0...v1.35.1](https://github.com/orbcorp/orb-python/compare/v1.35.0...v1.35.1)

### Bug Fixes

* use brackets instead of commas for array query params ([#116](https://github.com/orbcorp/orb-python/issues/116)) ([a03afeb](https://github.com/orbcorp/orb-python/commit/a03afeb4c13765e905a3e5fc8e52e1da4fa8e4be))


### Chores

* **ci:** run release workflow once per day ([#107](https://github.com/orbcorp/orb-python/issues/107)) ([8399dca](https://github.com/orbcorp/orb-python/commit/8399dcad701cac68076d88efba8aa2f6d456ad4b))
* **internal:** add bin script ([#113](https://github.com/orbcorp/orb-python/issues/113)) ([ed19a63](https://github.com/orbcorp/orb-python/commit/ed19a63151d3f4119fa70b68459242030a4ba199))
* **internal:** fix typos ([#111](https://github.com/orbcorp/orb-python/issues/111)) ([e2ba1db](https://github.com/orbcorp/orb-python/commit/e2ba1db59f6d8e86c625310d5017ece279788bd2))
* **internal:** minor utils restructuring ([#110](https://github.com/orbcorp/orb-python/issues/110)) ([1946480](https://github.com/orbcorp/orb-python/commit/19464809e1a6d4ba122b767ed59551ec0509503e))
* **internal:** updates to base client ([#108](https://github.com/orbcorp/orb-python/issues/108)) ([53ea238](https://github.com/orbcorp/orb-python/commit/53ea2380bb8280bd679255afed4300daeb1620ea))
* **internal:** use ruff instead of black for formatting ([#115](https://github.com/orbcorp/orb-python/issues/115)) ([ed83783](https://github.com/orbcorp/orb-python/commit/ed837839d28c1191bb4656577b8d80a411ce82dd))
* **package:** bump minimum typing-extensions to 4.7 ([#112](https://github.com/orbcorp/orb-python/issues/112)) ([440c756](https://github.com/orbcorp/orb-python/commit/440c756ffab480330f7a01dbbb129a26f41c1612))


### Documentation

* **api:** updates ([#109](https://github.com/orbcorp/orb-python/issues/109)) ([692c3e8](https://github.com/orbcorp/orb-python/commit/692c3e8ea49d3fe7dfc2f03d78be25cc2237fb9f))
* avoid normalizing trailing space ([#106](https://github.com/orbcorp/orb-python/issues/106)) ([09fd3f8](https://github.com/orbcorp/orb-python/commit/09fd3f8e37d3138bd32532aba6729e24b208684c))
* improve README timeout comment ([#101](https://github.com/orbcorp/orb-python/issues/101)) ([69a6970](https://github.com/orbcorp/orb-python/commit/69a6970e11ba88969a3c17dcd4374f8197b88dca))


### Refactors

* **client:** simplify cleanup ([#103](https://github.com/orbcorp/orb-python/issues/103)) ([54ac0dd](https://github.com/orbcorp/orb-python/commit/54ac0ddb1b703e011e84f184e6e90ee9f31e2055))
* remove unused model types used in params ([#105](https://github.com/orbcorp/orb-python/issues/105)) ([e18a59e](https://github.com/orbcorp/orb-python/commit/e18a59e47125aafb2e81f29f45fe9e866c738d28))
* simplify internal error handling ([#104](https://github.com/orbcorp/orb-python/issues/104)) ([cd0f847](https://github.com/orbcorp/orb-python/commit/cd0f8472457ac651c2fa44dc1e464cac78257c59))

## 1.35.0 (2023-12-11)

Full Changelog: [v1.34.1...v1.35.0](https://github.com/orbcorp/orb-python/compare/v1.34.1...v1.35.0)

### Features

* **api:** updates ([#99](https://github.com/orbcorp/orb-python/issues/99)) ([3b9bc05](https://github.com/orbcorp/orb-python/commit/3b9bc053aab713661aa372952e44e30a76f8bd81))

## 1.34.1 (2023-12-08)

Full Changelog: [v1.34.0...v1.34.1](https://github.com/orbcorp/orb-python/compare/v1.34.0...v1.34.1)

### Bug Fixes

* avoid leaking memory when Client.with_options is used ([#97](https://github.com/orbcorp/orb-python/issues/97)) ([b65cdf2](https://github.com/orbcorp/orb-python/commit/b65cdf2017fa80622e879ad6c4c700cbe04fb329))

## 1.34.0 (2023-12-08)

Full Changelog: [v1.33.4...v1.34.0](https://github.com/orbcorp/orb-python/compare/v1.33.4...v1.34.0)

### Features

* **api:** remove unsupported field ([#95](https://github.com/orbcorp/orb-python/issues/95)) ([fbb9a6a](https://github.com/orbcorp/orb-python/commit/fbb9a6ad26b452fbf8985007f770ed2c903e3b66))

## 1.33.4 (2023-12-08)

Full Changelog: [v1.33.3...v1.33.4](https://github.com/orbcorp/orb-python/compare/v1.33.3...v1.33.4)

### Bug Fixes

* **errors:** properly assign APIError.body ([#94](https://github.com/orbcorp/orb-python/issues/94)) ([7ee4eea](https://github.com/orbcorp/orb-python/commit/7ee4eea7f164e0b0685149d1591571c6c9566d77))


### Chores

* **internal:** enable more lint rules ([#93](https://github.com/orbcorp/orb-python/issues/93)) ([a3dd337](https://github.com/orbcorp/orb-python/commit/a3dd3377f5246ba6d1302224981a45c9c3a9121d))
* **internal:** minor updates to pagination ([#91](https://github.com/orbcorp/orb-python/issues/91)) ([cc341f4](https://github.com/orbcorp/orb-python/commit/cc341f40366a81e9f1db9bd4ad049d2228cc15b5))
* **internal:** reformat imports ([#89](https://github.com/orbcorp/orb-python/issues/89)) ([26a17d4](https://github.com/orbcorp/orb-python/commit/26a17d4cd116a58ce16657bc8e189bbd4dda775a))
* **internal:** reformat imports ([#92](https://github.com/orbcorp/orb-python/issues/92)) ([55b46bb](https://github.com/orbcorp/orb-python/commit/55b46bb375aee8a00d79177bad06c907d854b1fa))
* **internal:** update formatting ([#90](https://github.com/orbcorp/orb-python/issues/90)) ([ce98611](https://github.com/orbcorp/orb-python/commit/ce98611dd7fe75931d01f7119244388c51224a74))

## 1.33.3 (2023-12-04)

Full Changelog: [v1.33.2...v1.33.3](https://github.com/orbcorp/orb-python/compare/v1.33.2...v1.33.3)

### Chores

* **package:** lift anyio v4 restriction ([#84](https://github.com/orbcorp/orb-python/issues/84)) ([70cbb10](https://github.com/orbcorp/orb-python/commit/70cbb104fe927cebfa5e3d42a3c29f0ed4ab19ab))

## 1.33.2 (2023-12-01)

Full Changelog: [v1.33.1...v1.33.2](https://github.com/orbcorp/orb-python/compare/v1.33.1...v1.33.2)

### Bug Fixes

* **client:** correct base_url setter implementation ([#83](https://github.com/orbcorp/orb-python/issues/83)) ([83ad98c](https://github.com/orbcorp/orb-python/commit/83ad98c68e6103792d0e9739db105c82ae44f6f4))


### Chores

* **internal:** remove unused type var ([#82](https://github.com/orbcorp/orb-python/issues/82)) ([a9a3dbe](https://github.com/orbcorp/orb-python/commit/a9a3dbe325cbc0b3621469208871a616abe3979b))
* **internal:** replace string concatenation with f-strings ([#81](https://github.com/orbcorp/orb-python/issues/81)) ([d290faf](https://github.com/orbcorp/orb-python/commit/d290faf226356c4968bca7308306ae02e6bcb600))


### Documentation

* **readme:** update example snippets ([#79](https://github.com/orbcorp/orb-python/issues/79)) ([da58b27](https://github.com/orbcorp/orb-python/commit/da58b276e4c352f5f1bacb03455277f33f872243))

## 1.33.1 (2023-11-30)

Full Changelog: [v1.33.0...v1.33.1](https://github.com/orbcorp/orb-python/compare/v1.33.0...v1.33.1)

### Bug Fixes

* **client:** ensure retried requests are closed ([#78](https://github.com/orbcorp/orb-python/issues/78)) ([af69dbb](https://github.com/orbcorp/orb-python/commit/af69dbbf926375b4383badf61b22471ccca48661))


### Chores

* **internal:** add tests for proxy change ([#77](https://github.com/orbcorp/orb-python/issues/77)) ([3d80ca9](https://github.com/orbcorp/orb-python/commit/3d80ca9ba3dcadafe21c2066b7e605c27771edf9))
* **internal:** update lock file ([#74](https://github.com/orbcorp/orb-python/issues/74)) ([d3c1761](https://github.com/orbcorp/orb-python/commit/d3c1761a169d423394d0ae6a7f30a0549d344029))
* **internal:** updates to proxy helper ([#76](https://github.com/orbcorp/orb-python/issues/76)) ([80e0f3d](https://github.com/orbcorp/orb-python/commit/80e0f3dc784b29adc1b32005f5bfc75f51fff2e3))

## 1.33.0 (2023-11-28)

Full Changelog: [v1.32.0...v1.33.0](https://github.com/orbcorp/orb-python/compare/v1.32.0...v1.33.0)

### Features

* **api:** updates ([#73](https://github.com/orbcorp/orb-python/issues/73)) ([1e4d614](https://github.com/orbcorp/orb-python/commit/1e4d6148fcb859c095fd46e21841aff004475430))


### Chores

* **deps:** bump mypy to v1.7.1 ([#72](https://github.com/orbcorp/orb-python/issues/72)) ([e7f7b47](https://github.com/orbcorp/orb-python/commit/e7f7b47e99c4e1ae73c09de6c83d8879e0172bae))
* **internal:** options updates ([#67](https://github.com/orbcorp/orb-python/issues/67)) ([8f91e55](https://github.com/orbcorp/orb-python/commit/8f91e55e750372c77dfd98202cd445560343e747))
* **internal:** revert recent options change ([#70](https://github.com/orbcorp/orb-python/issues/70)) ([6ff55a6](https://github.com/orbcorp/orb-python/commit/6ff55a6bff7f7281b6288cb7a3042fd51e3a29f0))
* **internal:** send more detailed x-stainless headers ([#71](https://github.com/orbcorp/orb-python/issues/71)) ([7dd46f3](https://github.com/orbcorp/orb-python/commit/7dd46f3ed8ba12999cbb3376b48f01c12f7e80e3))


### Documentation

* **api:** update metadata docstrings ([#69](https://github.com/orbcorp/orb-python/issues/69)) ([cf25b7c](https://github.com/orbcorp/orb-python/commit/cf25b7c8280a5dae5796fc5506db794ccba3b425))

## 1.32.0 (2023-11-22)

Full Changelog: [v1.31.2...v1.32.0](https://github.com/orbcorp/orb-python/compare/v1.31.2...v1.32.0)

### Features

* **api:** updates ([#66](https://github.com/orbcorp/orb-python/issues/66)) ([cfefc76](https://github.com/orbcorp/orb-python/commit/cfefc763c7d1e08e280b076ee5c88274ab42c1a4))


### Chores

* **client:** improve copy method ([#63](https://github.com/orbcorp/orb-python/issues/63)) ([ae3eed5](https://github.com/orbcorp/orb-python/commit/ae3eed56e988ff66e793116c8a0c80c5b5d87869))
* **package:** add license classifier metadata ([#65](https://github.com/orbcorp/orb-python/issues/65)) ([da28530](https://github.com/orbcorp/orb-python/commit/da28530b636f74e64a343957437daaeb80da49ef))

## 1.31.2 (2023-11-21)

Full Changelog: [v1.31.1...v1.31.2](https://github.com/orbcorp/orb-python/compare/v1.31.1...v1.31.2)

### Bug Fixes

* **client:** attempt to parse unknown json content types ([#61](https://github.com/orbcorp/orb-python/issues/61)) ([2ff1f69](https://github.com/orbcorp/orb-python/commit/2ff1f69a8a7b6a138002cf8eef49d76e71a6bb2e))

## 1.31.1 (2023-11-20)

Full Changelog: [v1.31.0...v1.31.1](https://github.com/orbcorp/orb-python/compare/v1.31.0...v1.31.1)

### Chores

* **internal:** update some test values ([#60](https://github.com/orbcorp/orb-python/issues/60)) ([cf1e4a9](https://github.com/orbcorp/orb-python/commit/cf1e4a9a241eb6fdd66f42f05f5dbaa2c3fec2ed))
* **internal:** update type hint for helper function ([#59](https://github.com/orbcorp/orb-python/issues/59)) ([191e197](https://github.com/orbcorp/orb-python/commit/191e19734a80480dfaa4ea614baef2d565264bea))


### Documentation

* **readme:** fix link to docs website ([#58](https://github.com/orbcorp/orb-python/issues/58)) ([4510e87](https://github.com/orbcorp/orb-python/commit/4510e8728e7282b16c9e91ca97b74106681b0666))
* **readme:** minor updates ([#56](https://github.com/orbcorp/orb-python/issues/56)) ([0d09713](https://github.com/orbcorp/orb-python/commit/0d097132f1884d193e8fee9a781c29d8afe25f32))

## 1.31.0 (2023-11-16)

Full Changelog: [v1.30.3...v1.31.0](https://github.com/orbcorp/orb-python/compare/v1.30.3...v1.31.0)

### Features

* **api:** updates ([#55](https://github.com/orbcorp/orb-python/issues/55)) ([dbfb455](https://github.com/orbcorp/orb-python/commit/dbfb455e7019597b33f723b9d5682e378489eb2d))
* **client:** support reading the base url from an env variable ([#54](https://github.com/orbcorp/orb-python/issues/54)) ([04d5ca5](https://github.com/orbcorp/orb-python/commit/04d5ca523c38a36e72c42587e323a55b7a9d09a4))


### Chores

* **internal:** fix devcontainer interpeter path ([#52](https://github.com/orbcorp/orb-python/issues/52)) ([a35fe95](https://github.com/orbcorp/orb-python/commit/a35fe959fe9bbe9a4ecd4a50148c4c5d447643b6))
* **internal:** fix typo in NotGiven docstring ([#50](https://github.com/orbcorp/orb-python/issues/50)) ([7e1d704](https://github.com/orbcorp/orb-python/commit/7e1d704c9a4baebf09bb9b95d4e0baf5e2c9809e))


### Documentation

* fix code comment typo ([#53](https://github.com/orbcorp/orb-python/issues/53)) ([0171b18](https://github.com/orbcorp/orb-python/commit/0171b183ee377d4c1aaa9dab7d0c4faaa1b1c1f9))

## 1.30.3 (2023-11-13)

Full Changelog: [v1.30.2...v1.30.3](https://github.com/orbcorp/orb-python/compare/v1.30.2...v1.30.3)

### Bug Fixes

* **client:** retry if SSLWantReadError occurs in the async client ([#48](https://github.com/orbcorp/orb-python/issues/48)) ([52d5c13](https://github.com/orbcorp/orb-python/commit/52d5c134035252e12290930ffc7797f3e386f7cc))

## 1.30.2 (2023-11-10)

Full Changelog: [v1.30.1...v1.30.2](https://github.com/orbcorp/orb-python/compare/v1.30.1...v1.30.2)

### Bug Fixes

* **client:** serialise pydantic v1 default fields correctly in params ([#46](https://github.com/orbcorp/orb-python/issues/46)) ([dc058e3](https://github.com/orbcorp/orb-python/commit/dc058e30be77833522880b651a7eed16b23bc7c3))

## 1.30.1 (2023-11-10)

Full Changelog: [v1.30.0...v1.30.1](https://github.com/orbcorp/orb-python/compare/v1.30.0...v1.30.1)

### Bug Fixes

* **models:** mark unknown fields as set in pydantic v1 ([#45](https://github.com/orbcorp/orb-python/issues/45)) ([c965317](https://github.com/orbcorp/orb-python/commit/c9653177220c301b99b95455a58c0cdd9088091e))


### Chores

* **internal:** base client updates ([#44](https://github.com/orbcorp/orb-python/issues/44)) ([79ff165](https://github.com/orbcorp/orb-python/commit/79ff1652c90c689452ed7e2ce264f72ae9c1bfe5))


### Documentation

* reword package description ([#42](https://github.com/orbcorp/orb-python/issues/42)) ([6994f49](https://github.com/orbcorp/orb-python/commit/6994f492fe7c0e890017bf0275990cc5a0ae147e))

## 1.30.0 (2023-11-09)

Full Changelog: [v1.29.0...v1.30.0](https://github.com/orbcorp/orb-python/compare/v1.29.0...v1.30.0)

### Features

* **api:** updates ([#41](https://github.com/orbcorp/orb-python/issues/41)) ([ea5d1a4](https://github.com/orbcorp/orb-python/commit/ea5d1a460b0c2ee26ed2844b3f19cbc65762b922))
* **client:** support passing chunk size for binary responses ([#40](https://github.com/orbcorp/orb-python/issues/40)) ([6cc1be0](https://github.com/orbcorp/orb-python/commit/6cc1be01b788208d963cd8c4a300ca8c8649420d))
* **client:** support passing httpx.Timeout to method timeout argument ([#35](https://github.com/orbcorp/orb-python/issues/35)) ([65c7fc9](https://github.com/orbcorp/orb-python/commit/65c7fc93f25d8d651f6dcb0472a98695d6d4acb6))


### Chores

* **docs:** fix github links ([#38](https://github.com/orbcorp/orb-python/issues/38)) ([2a83f73](https://github.com/orbcorp/orb-python/commit/2a83f73006fb0edbc063360b90bad706375ca318))
* **internal:** fix some typos ([#37](https://github.com/orbcorp/orb-python/issues/37)) ([b0fc909](https://github.com/orbcorp/orb-python/commit/b0fc909f70c539d529b1eeb24aa4aa9683999dbd))
* **internal:** improve github devcontainer setup ([#39](https://github.com/orbcorp/orb-python/issues/39)) ([3fabb8f](https://github.com/orbcorp/orb-python/commit/3fabb8f4bc47f418b7d4ec7833048589802298db))

## 1.29.0 (2023-11-06)

Full Changelog: [v1.28.1...v1.29.0](https://github.com/orbcorp/orb-python/compare/v1.28.1...v1.29.0)

### Features

* **api:** remove unsupported params ([#33](https://github.com/orbcorp/orb-python/issues/33)) ([abd325f](https://github.com/orbcorp/orb-python/commit/abd325f78c1d58c30207bf69ba36b32229626fac))

## 1.28.1 (2023-11-06)

Full Changelog: [v1.28.0...v1.28.1](https://github.com/orbcorp/orb-python/compare/v1.28.0...v1.28.1)

### Bug Fixes

* prevent TypeError in Python 3.8 (ABC is not subscriptable) ([#32](https://github.com/orbcorp/orb-python/issues/32)) ([f21abfa](https://github.com/orbcorp/orb-python/commit/f21abfae14e1897cd501e09a1dc3051e5c7e54ec))


### Chores

* **internal:** remove unused int/float conversion ([#29](https://github.com/orbcorp/orb-python/issues/29)) ([0b701e1](https://github.com/orbcorp/orb-python/commit/0b701e1812c7293fd313f759944e400e202eab69))


### Documentation

* **readme:** improve example snippets ([#31](https://github.com/orbcorp/orb-python/issues/31)) ([3815aad](https://github.com/orbcorp/orb-python/commit/3815aad75faa9ce55a499eaabb04c3c3f15b1701))

## 1.28.0 (2023-11-03)

Full Changelog: [v1.27.0...v1.28.0](https://github.com/orbcorp/orb-python/compare/v1.27.0...v1.28.0)

### Features

* **api:** updates ([#13](https://github.com/orbcorp/orb-python/issues/13)) ([4256067](https://github.com/orbcorp/orb-python/commit/42560678cd0b5bdfeafb5f3940aa06e6266fc193))
* **api:** updates ([#8](https://github.com/orbcorp/orb-python/issues/8)) ([c9c4a66](https://github.com/orbcorp/orb-python/commit/c9c4a664b617f2e6749ccecdd83580adf3ff8a33))
* **client:** adjust retry behavior to be exponential backoff ([#4](https://github.com/orbcorp/orb-python/issues/4)) ([62c25f6](https://github.com/orbcorp/orb-python/commit/62c25f6cf9456cb3ea26a79272417e79b366603c))
* **client:** allow binary returns ([#26](https://github.com/orbcorp/orb-python/issues/26)) ([9a25d2f](https://github.com/orbcorp/orb-python/commit/9a25d2f07d4fd5b18ab2702240a4c470c680715d))
* **client:** improve file upload types ([#3](https://github.com/orbcorp/orb-python/issues/3)) ([91b3d5c](https://github.com/orbcorp/orb-python/commit/91b3d5c4b383f2ccc1fad7209ad834aeeecaf96e))
* **client:** improve retry behaviour ([#6](https://github.com/orbcorp/orb-python/issues/6)) ([04d94d2](https://github.com/orbcorp/orb-python/commit/04d94d22b7ad214ba748f0a1722b67d5b756e5c8))
* **client:** support passing BaseModels to request params at runtime ([#27](https://github.com/orbcorp/orb-python/issues/27)) ([e8d0844](https://github.com/orbcorp/orb-python/commit/e8d08448ab25e34955f3ae5ca2501565cbe2d192))
* **github:** include a devcontainer setup ([#25](https://github.com/orbcorp/orb-python/issues/25)) ([fc96155](https://github.com/orbcorp/orb-python/commit/fc961559403ad78cb144c348635afbf00410640d))
* **package:** add classifiers ([#16](https://github.com/orbcorp/orb-python/issues/16)) ([fa652f3](https://github.com/orbcorp/orb-python/commit/fa652f3a4b68afb1204c4f6c0f74b00b39f1b9af))


### Bug Fixes

* **binaries:** don't synchronously block in astream_to_file ([#28](https://github.com/orbcorp/orb-python/issues/28)) ([ad6ebef](https://github.com/orbcorp/orb-python/commit/ad6ebefccc8e1cb178b0cc394103ff646a130d72))
* **client:** include more detail in error messages ([#12](https://github.com/orbcorp/orb-python/issues/12)) ([7b64c85](https://github.com/orbcorp/orb-python/commit/7b64c851f6825ec8d2e2f8fcc6174f88f3676d59))
* rename customer.credits.ledger.create_entry_by_exteral_id and RequestValidationErrors ([#9](https://github.com/orbcorp/orb-python/issues/9)) ([bd8dbe9](https://github.com/orbcorp/orb-python/commit/bd8dbe9335a24ff0830d7dad90676fa1d55202d0))


### Chores

* **internal:** minor restructuring of base client ([#15](https://github.com/orbcorp/orb-python/issues/15)) ([550d18c](https://github.com/orbcorp/orb-python/commit/550d18c72e0eb2c06dc83329f07d207a6cf2b0de))
* **internal:** require explicit overrides ([#11](https://github.com/orbcorp/orb-python/issues/11)) ([4dab0a6](https://github.com/orbcorp/orb-python/commit/4dab0a6da2d4992046c6a125b460bd21fb26cd10))


### Documentation

* improve to dictionary example ([#7](https://github.com/orbcorp/orb-python/issues/7)) ([3dac2fd](https://github.com/orbcorp/orb-python/commit/3dac2fd2595e1e2b62f85f284daa4c519998942d))

## 1.27.0 (2023-10-20)

Full Changelog: [v1.26.0...v1.27.0](https://github.com/orbcorp/orb-python/compare/v1.26.0...v1.27.0)

### Features

* **init:** initial commit ([33d4af6](https://github.com/orbcorp/orb-python/commit/33d4af66059edfeffd6b39f058867d1babfd8fa9))


### Chores

* correct version ([58bb98d](https://github.com/orbcorp/orb-python/commit/58bb98df611c05e4b89fb5c2e4a1d7a99dbb312e))


### Documentation

* improve code examples ([927512a](https://github.com/orbcorp/orb-python/commit/927512a8d90168348136c312527b816344ec3a88))
