# Python Microservices Library

[![PyPI version](https://badge.fury.io/py/py-ms.svg)](https://badge.fury.io/py/py-ms)
[![Build Status](https://travis-ci.org/python-microservices/pyms.svg?branch=master)](https://travis-ci.org/python-microservices/pyms)
[![Coverage Status](https://coveralls.io/repos/github/python-microservices/pyms/badge.svg?branch=master)](https://coveralls.io/github/python-microservices/pyms?branch=master)
[![Requirements Status](https://requires.io/github/python-microservices/pyms/requirements.svg?branch=master)](https://requires.io/github/python-microservices/pyms/requirements/?branch=master)
[![Total alerts](https://img.shields.io/lgtm/alerts/g/python-microservices/pyms.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/python-microservices/pyms/alerts/)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/python-microservices/pyms.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/python-microservices/pyms/context:python)
[![Documentation Status](https://readthedocs.org/projects/py-ms/badge/?version=latest)](https://python-microservices.github.io/home/)
[![Gitter](https://img.shields.io/gitter/room/DAVFoundation/DAV-Contributors.svg)](https://gitter.im/python-microservices/pyms)

PyMS, Python MicroService, is a [Microservice chassis pattern](https://microservices.io/patterns/microservice-chassis.html)
like Spring Boot (Java) or Gizmo (Golang). PyMS is a collection of libraries, best practices and recommended ways to build
microservices with Python which handles cross-cutting concerns:

- Externalized configuration
- Logging
- Health checks
- Metrics
- Distributed tracing

PyMS is powered by [Flask](https://flask.palletsprojects.com/en/1.1.x/), [Connexion](https://github.com/zalando/connexion)
and [Opentracing](https://opentracing.io/).

Get started with [Installation](https://python-microservices.github.io/installation/)
and then get an overview with the [Quickstart](https://python-microservices.github.io/quickstart/).

## Documentation

To know how to use, install or build a project see the [docs](https://python-microservices.github.io/).

## Installation

```bash
pip install py-ms[all]
```

## Quickstart

See our [quickstart webpage](https://python-microservices.github.io/quickstart/)

## Create a project from scaffold

See our [Create a project from scaffold webpage](https://python-microservices.github.io/quickstart/#create-a-project-from-scaffold)

## How To contribute

We appreciate opening issues and pull requests to make PyMS even more stable & useful! See [This doc](https://python-microservices.github.io/contributing/)
for more details.
