"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateSubscriptionFrame = void 0;
const ColdObservable_1 = require("rxjs/internal/testing/ColdObservable");
const HotObservable_1 = require("rxjs/internal/testing/HotObservable");
const parseSubscriptionMarble_1 = require("../marbles/parseSubscriptionMarble");
const calculateSubscriptionFrame = (observable, unsubscriptionMarbles, frameTimeFactor) => {
    const { subscribedFrame, unsubscribedFrame } = parseSubscriptionMarble_1.parseSubscriptionMarble(unsubscriptionMarbles, frameTimeFactor);
    if (subscribedFrame === Number.POSITIVE_INFINITY) {
        return { subscribedFrame: 0, unsubscribedFrame };
    }
    //looks internal of Observable implementation to determine source is hot or cold observable.
    //if source is hot, subscription / unsubscription works as specified,
    //if source is cold, subscription always triggers start of observable - adjust unsubscription frame as well
    let source = observable;
    while (!!source) {
        if (source instanceof HotObservable_1.HotObservable) {
            return { subscribedFrame, unsubscribedFrame };
        }
        else if (source instanceof ColdObservable_1.ColdObservable) {
            return {
                subscribedFrame: 0,
                unsubscribedFrame: unsubscribedFrame === Number.POSITIVE_INFINITY ? unsubscribedFrame : unsubscribedFrame - subscribedFrame
            };
        }
        source = source.source;
    }
    throw new Error('Cannot detect source observable type');
};
exports.calculateSubscriptionFrame = calculateSubscriptionFrame;
//# sourceMappingURL=calculateSubscriptionFrame.js.map