"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribe = exports.complete = exports.error = exports.next = exports.TestMessageValue = void 0;
const rxjs_1 = require("rxjs");
const SubscriptionLog_1 = require("rxjs/internal/testing/SubscriptionLog");
/**
 * Represents single metadata value emitted by HotObservable<T> or ColdObservable<T>
 *
 */
class TestMessageValue {
    constructor(frame, notification) {
        this.frame = frame;
        this.notification = notification;
    }
}
exports.TestMessageValue = TestMessageValue;
/**
 * Utility function to generate TestMessage represents value for Observer::next()
 * @param frame virtual frame time when value will be emitted
 * @param value
 */
const next = (frame, value) => new TestMessageValue(frame, rxjs_1.Notification.createNext(value));
exports.next = next;
/**
 * Utility function to generate TestMessage represents error for Observer::error()
 * @param frame virtual frame time when value will be emitted
 * @param value
 */
const error = (frame, error = '#') => new TestMessageValue(frame, rxjs_1.Notification.createError(error));
exports.error = error;
/**
 * Utility function to generate TestMessage represents completion for Observer::complete()
 * @param frame virtual frame time when value will be emitted
 */
const complete = (frame) => new TestMessageValue(frame, rxjs_1.Notification.createComplete());
exports.complete = complete;
const subscribe = (subscribedFrame = Number.POSITIVE_INFINITY, unsubscribedFrame = Number.POSITIVE_INFINITY) => new SubscriptionLog_1.SubscriptionLog(subscribedFrame, unsubscribedFrame);
exports.subscribe = subscribe;
//# sourceMappingURL=TestMessage.js.map