"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ObservableMarbleToken = void 0;
/**
 * Defines tokens for marble diagram DSL to represent Observables.
 *
 */
var ObservableMarbleToken;
(function (ObservableMarbleToken) {
    /**
     * The passage of time without any events
     */
    ObservableMarbleToken["TIMEFRAME"] = "-";
    /**
     * Error
     */
    ObservableMarbleToken["ERROR"] = "#";
    /**
     * Whitespace does nothing, for aligning between marbles
     *
     */
    ObservableMarbleToken["NOOP"] = " ";
    /**
     * Indicates start emitting simultaneouly.
     * Values between SIMULTANEOUS_START and SIMULTANEOUS_END considered to be
     * emitted simultaneously.
     *
     */
    ObservableMarbleToken["SIMULTANEOUS_START"] = "(";
    /**
     * Indicates end emitting simultaneouly.
     * Values between SIMULTANEOUS_START and SIMULTANEOUS_END considered to be
     * emitted simultaneously.
     */
    ObservableMarbleToken["SIMULTANEOUS_END"] = ")";
    /**
     * Indicates time passed multiple times of TIMEFRAME.
     * This token is single token, actual usage should be like
     * `...${n}...` , represents timeframe of `-` * n times.
     *
     */
    ObservableMarbleToken["TIMEFRAME_EXPAND"] = ".";
    /**
     * Completion of the stream
     */
    ObservableMarbleToken["COMPLETE"] = "|";
})(ObservableMarbleToken = exports.ObservableMarbleToken || (exports.ObservableMarbleToken = {}));
//# sourceMappingURL=ObservableMarbleToken.js.map