import { BlockResponse } from '@taquito/rpc';
import { MonoTypeOperatorFunction, Observable, SchedulerLike } from 'rxjs';
import { Context } from '../context';
import { DelegationWalletOperation } from './delegation-operation';
import { WalletOperation } from './operation';
import { OriginationWalletOperation } from './origination-operation';
import { TransactionWalletOperation } from './transaction-operation';
export declare const cacheUntil: <T>(cacheUntilObs: Observable<any>) => MonoTypeOperatorFunction<T>;
export declare const createNewPollingBasedHeadObservable: (pollingTimer: Observable<number>, sharedHeadOb: Observable<BlockResponse>, context: Context, scheduler?: SchedulerLike | undefined) => Observable<BlockResponse>;
export interface OperationFactoryConfig {
    blockIdentifier?: string;
}
export declare class OperationFactory {
    private context;
    constructor(context: Context);
    private sharedHeadObs;
    private createNewHeadObservable;
    private createPastBlockWalker;
    private createHeadObservableFromConfig;
    createOperation(hash: string, config?: OperationFactoryConfig): Promise<WalletOperation>;
    createTransactionOperation(hash: string, config?: OperationFactoryConfig): Promise<TransactionWalletOperation>;
    createDelegationOperation(hash: string, config?: OperationFactoryConfig): Promise<DelegationWalletOperation>;
    createOriginationOperation(hash: string, config?: OperationFactoryConfig): Promise<OriginationWalletOperation>;
}
