import { Context } from '../context';
import { OpKind } from '../operations/types';
import { WalletDelegateParams, WalletOriginateParams, WalletProvider, WalletTransferParams } from './interface';
import { WalletParamsWithKind } from './wallet';
export declare class LegacyWalletProvider implements WalletProvider {
    private context;
    constructor(context: Context);
    getPKH(): Promise<string>;
    mapTransferParamsToWalletParams(params: WalletTransferParams): Promise<import("../operations/types").withKind<Pick<import("../operations/types").TransferParams, "to" | "amount" | "parameter" | "mutez">, OpKind.TRANSACTION>>;
    mapOriginateParamsToWalletParams(params: WalletOriginateParams): Promise<import("../operations/types").withKind<Pick<import("../operations/types").OriginateParams, "mutez" | "balance" | "code" | "delegate" | "init" | "storage">, OpKind.ORIGINATION>>;
    mapDelegateParamsToWalletParams(params: WalletDelegateParams): Promise<import("../operations/types").withKind<Pick<import("../operations/types").DelegateParams, "delegate">, OpKind.DELEGATION>>;
    sendOperations(params: WalletParamsWithKind[]): Promise<string>;
}
