"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wallet = exports.WalletOperationBatch = void 0;
var contract_1 = require("../contract");
var types_1 = require("../operations/types");
var WalletOperationBatch = /** @class */ (function () {
    function WalletOperationBatch(walletProvider, context) {
        this.walletProvider = walletProvider;
        this.context = context;
        this.operations = [];
    }
    /**
     *
     * @description Add a transaction operation to the batch
     *
     * @param params Transfer operation parameter
     */
    WalletOperationBatch.prototype.withTransfer = function (params) {
        this.operations.push(__assign({ kind: types_1.OpKind.TRANSACTION }, params));
        return this;
    };
    /**
     *
     * @description Add a transaction operation to the batch
     *
     * @param params Transfer operation parameter
     */
    WalletOperationBatch.prototype.withContractCall = function (params) {
        return this.withTransfer(params.toTransferParams());
    };
    /**
     *
     * @description Add a delegation operation to the batch
     *
     * @param params Delegation operation parameter
     */
    WalletOperationBatch.prototype.withDelegation = function (params) {
        this.operations.push(__assign({ kind: types_1.OpKind.DELEGATION }, params));
        return this;
    };
    /**
     *
     * @description Add an origination operation to the batch
     *
     * @param params Origination operation parameter
     */
    WalletOperationBatch.prototype.withOrigination = function (params) {
        this.operations.push(__assign({ kind: types_1.OpKind.ORIGINATION }, params));
        return this;
    };
    WalletOperationBatch.prototype.mapOperation = function (param) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _a = param.kind;
                        switch (_a) {
                            case types_1.OpKind.TRANSACTION: return [3 /*break*/, 1];
                            case types_1.OpKind.ORIGINATION: return [3 /*break*/, 2];
                            case types_1.OpKind.DELEGATION: return [3 /*break*/, 4];
                        }
                        return [3 /*break*/, 5];
                    case 1: return [2 /*return*/, this.walletProvider.mapTransferParamsToWalletParams(__assign({}, param))];
                    case 2:
                        _c = (_b = this.walletProvider).mapOriginateParamsToWalletParams;
                        return [4 /*yield*/, this.context.parser.prepareCodeOrigination(__assign({}, param))];
                    case 3: return [2 /*return*/, _c.apply(_b, [_d.sent()])];
                    case 4: return [2 /*return*/, this.walletProvider.mapDelegateParamsToWalletParams(__assign({}, param))];
                    case 5: throw new Error("Unsupported operation kind: " + param.kind);
                }
            });
        });
    };
    /**
     *
     * @description Add a group operation to the batch. Operation will be applied in the order they are in the params array
     *
     * @param params Operations parameter
     */
    WalletOperationBatch.prototype.with = function (params) {
        var e_1, _a;
        try {
            for (var params_1 = __values(params), params_1_1 = params_1.next(); !params_1_1.done; params_1_1 = params_1.next()) {
                var param = params_1_1.value;
                switch (param.kind) {
                    case types_1.OpKind.TRANSACTION:
                        this.withTransfer(param);
                        break;
                    case types_1.OpKind.ORIGINATION:
                        this.withOrigination(param);
                        break;
                    case types_1.OpKind.DELEGATION:
                        this.withDelegation(param);
                        break;
                    default:
                        throw new Error("Unsupported operation kind: " + param.kind);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (params_1_1 && !params_1_1.done && (_a = params_1.return)) _a.call(params_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return this;
    };
    /**
     *
     * @description Submit batch operation to wallet
     *
     */
    WalletOperationBatch.prototype.send = function () {
        return __awaiter(this, void 0, void 0, function () {
            var ops, _a, _b, op, _c, _d, e_2_1, opHash;
            var e_2, _e;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        ops = [];
                        _f.label = 1;
                    case 1:
                        _f.trys.push([1, 6, 7, 8]);
                        _a = __values(this.operations), _b = _a.next();
                        _f.label = 2;
                    case 2:
                        if (!!_b.done) return [3 /*break*/, 5];
                        op = _b.value;
                        _d = (_c = ops).push;
                        return [4 /*yield*/, this.mapOperation(op)];
                    case 3:
                        _d.apply(_c, [_f.sent()]);
                        _f.label = 4;
                    case 4:
                        _b = _a.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_2_1 = _f.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (_b && !_b.done && (_e = _a.return)) _e.call(_a);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7 /*endfinally*/];
                    case 8: return [4 /*yield*/, this.walletProvider.sendOperations(ops)];
                    case 9:
                        opHash = _f.sent();
                        return [2 /*return*/, this.context.operationFactory.createOperation(opHash)];
                }
            });
        });
    };
    return WalletOperationBatch;
}());
exports.WalletOperationBatch = WalletOperationBatch;
var Wallet = /** @class */ (function () {
    function Wallet(context) {
        this.context = context;
        this.walletCommand = function (send) {
            return {
                send: send,
            };
        };
    }
    Object.defineProperty(Wallet.prototype, "walletProvider", {
        get: function () {
            return this.context.walletProvider;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @description Retrieve the PKH of the account that is currently in use by the wallet
     *
     * @param option Option to use while fetching the PKH.
     * If forceRefetch is specified the wallet provider implementation will refetch the PKH from the wallet
     */
    Wallet.prototype.pkh = function (_a) {
        var _b = _a === void 0 ? {} : _a, forceRefetch = _b.forceRefetch;
        return __awaiter(this, void 0, void 0, function () {
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        if (!(!this._pkh || forceRefetch)) return [3 /*break*/, 2];
                        _c = this;
                        return [4 /*yield*/, this.walletProvider.getPKH()];
                    case 1:
                        _c._pkh = _d.sent();
                        _d.label = 2;
                    case 2: return [2 /*return*/, this._pkh];
                }
            });
        });
    };
    /**
     *
     * @description Originate a new contract according to the script in parameters.
     *
     * @returns An operation handle with the result from the rpc node
     *
     * @param originateParams Originate operation parameter
     */
    Wallet.prototype.originate = function (params) {
        var _this = this;
        return this.walletCommand(function () { return __awaiter(_this, void 0, void 0, function () {
            var mappedParams, _a, _b, opHash, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _b = (_a = this.walletProvider).mapOriginateParamsToWalletParams;
                        return [4 /*yield*/, this.context.parser.prepareCodeOrigination(__assign({}, params))];
                    case 1: return [4 /*yield*/, _b.apply(_a, [_d.sent()])];
                    case 2:
                        mappedParams = _d.sent();
                        return [4 /*yield*/, this.walletProvider.sendOperations([mappedParams])];
                    case 3:
                        opHash = _d.sent();
                        if (!!this.context.proto) return [3 /*break*/, 5];
                        _c = this.context;
                        return [4 /*yield*/, this.context.rpc.getBlock()];
                    case 4:
                        _c.proto = (_d.sent()).protocol;
                        _d.label = 5;
                    case 5: return [2 /*return*/, this.context.operationFactory.createOriginationOperation(opHash)];
                }
            });
        }); });
    };
    /**
     *
     * @description Set the delegate for a contract.
     *
     * @returns An operation handle with the result from the rpc node
     *
     * @param delegateParams operation parameter
     */
    Wallet.prototype.setDelegate = function (params) {
        var _this = this;
        return this.walletCommand(function () { return __awaiter(_this, void 0, void 0, function () {
            var mappedParams, opHash;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.walletProvider.mapDelegateParamsToWalletParams(__assign({}, params))];
                    case 1:
                        mappedParams = _a.sent();
                        return [4 /*yield*/, this.walletProvider.sendOperations([mappedParams])];
                    case 2:
                        opHash = _a.sent();
                        return [2 /*return*/, this.context.operationFactory.createDelegationOperation(opHash)];
                }
            });
        }); });
    };
    /**
     *
     * @description Register the current address as delegate.
     *
     * @returns An operation handle with the result from the rpc node
     *
     */
    Wallet.prototype.registerDelegate = function () {
        var _this = this;
        return this.walletCommand(function () { return __awaiter(_this, void 0, void 0, function () {
            var mappedParams, _a, _b, opHash;
            var _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _b = (_a = this.walletProvider).mapDelegateParamsToWalletParams;
                        _c = {};
                        return [4 /*yield*/, this.pkh()];
                    case 1: return [4 /*yield*/, _b.apply(_a, [(_c.delegate = _d.sent(),
                                _c)])];
                    case 2:
                        mappedParams = _d.sent();
                        return [4 /*yield*/, this.walletProvider.sendOperations([mappedParams])];
                    case 3:
                        opHash = _d.sent();
                        return [2 /*return*/, this.context.operationFactory.createDelegationOperation(opHash)];
                }
            });
        }); });
    };
    /**
     *
     * @description Transfer tezos tokens from current address to a specific address or call a smart contract.
     *
     * @returns A wallet command from which we can send the operation to the wallet
     *
     * @param params operation parameter
     */
    Wallet.prototype.transfer = function (params) {
        var _this = this;
        return this.walletCommand(function () { return __awaiter(_this, void 0, void 0, function () {
            var mappedParams, opHash;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.walletProvider.mapTransferParamsToWalletParams(params)];
                    case 1:
                        mappedParams = _a.sent();
                        return [4 /*yield*/, this.walletProvider.sendOperations([mappedParams])];
                    case 2:
                        opHash = _a.sent();
                        return [2 /*return*/, this.context.operationFactory.createTransactionOperation(opHash)];
                }
            });
        }); });
    };
    /**
     *
     * @description Create a batch of operation
     *
     * @returns A batch object from which we can add more operation or send a command to the wallet to execute the batch
     *
     * @param params List of operation to initialize the batch with
     */
    Wallet.prototype.batch = function (params) {
        var batch = new WalletOperationBatch(this.walletProvider, this.context);
        if (Array.isArray(params)) {
            batch.with(params);
        }
        return batch;
    };
    /**
     *
     * @description Create an smart contract abstraction for the address specified. Calling entrypoints with the returned
     * smart contract abstraction will leverage the wallet provider to make smart contract calls
     *
     * @param address Smart contract address
     */
    Wallet.prototype.at = function (address, contractAbstractionComposer) {
        if (contractAbstractionComposer === void 0) { contractAbstractionComposer = function (x) { return x; }; }
        return __awaiter(this, void 0, void 0, function () {
            var script, entrypoints, blockHeader, chainId, abs;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.context.rpc.getScript(address)];
                    case 1:
                        script = _a.sent();
                        return [4 /*yield*/, this.context.rpc.getEntrypoints(address)];
                    case 2:
                        entrypoints = _a.sent();
                        return [4 /*yield*/, this.context.rpc.getBlockHeader()];
                    case 3:
                        blockHeader = _a.sent();
                        chainId = blockHeader.chain_id;
                        abs = new contract_1.ContractAbstraction(address, script, this, this.context.contract, entrypoints, chainId);
                        return [2 /*return*/, contractAbstractionComposer(abs, this.context)];
                }
            });
        });
    };
    return Wallet;
}());
exports.Wallet = Wallet;
//# sourceMappingURL=wallet.js.map