import { MichelsonType, MichelsonData, MichelsonCode, MichelsonContract, MichelsonContractSection, MichelsonReturnType } from "./michelson-types";
import { MichelsonError } from "./utils";
import { ParserOptions } from "./micheline-parser";
export interface Context extends ParserOptions {
    contract?: MichelsonContract;
    traceCallback?: (t: InstructionTrace) => void;
}
export declare class MichelsonInstructionError extends MichelsonError<MichelsonCode> {
    stackState: MichelsonReturnType;
    /**
     * @param val Value of a type node caused the error
     * @param stackState Current stack state
     * @param message An error message
     */
    constructor(val: MichelsonCode, stackState: MichelsonReturnType, message?: string);
}
export declare function assertTypeAnnotationsValid(t: MichelsonType, field?: boolean): void;
export interface InstructionTrace {
    op: MichelsonCode;
    in: MichelsonType[];
    out: MichelsonReturnType;
}
export declare function contractSection<T extends "parameter" | "storage" | "code">(contract: MichelsonContract, section: T): MichelsonContractSection<T>;
export declare function contractEntryPoint(src: MichelsonContract | MichelsonType, ep?: string): MichelsonType | null;
export declare function contractEntryPoints(src: MichelsonContract | MichelsonType): [string, MichelsonType][];
export declare function assertContractValid(contract: MichelsonContract, ctx?: Context): MichelsonReturnType;
export declare function assertDataValid(d: MichelsonData, t: MichelsonType, ctx?: Context): void;
export declare function functionType(inst: MichelsonCode, stack: MichelsonType[], ctx?: Context): MichelsonReturnType;
export declare function assertTypesEqual<T1 extends MichelsonType | MichelsonType[], T2 extends T1>(a: T1, b: T2, field?: boolean): void;
export declare function isTypeAnnotationsValid(t: MichelsonType, field?: boolean): boolean;
export declare function isContractValid(contract: MichelsonContract, ctx?: Context): MichelsonReturnType | null;
export declare function isDataValid(d: MichelsonData, t: MichelsonType, ctx?: Context): boolean;
export declare function isTypeEqual<T1 extends MichelsonType | MichelsonType[], T2 extends T1>(a: T1, b: T2, field?: boolean): boolean;
