# -*- coding: utf-8 -*-

"""
wordsapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from wordsapi.api_helper import APIHelper
from wordsapi.models.pronunciation_details import PronunciationDetails


class PronunciationResponse(object):

    """Implementation of the 'PronunciationResponse' model.

    This custom type contains response for pronunciation endpoint.

    Attributes:
        word (string): The word that is searched.
        pronunciation (PronunciationDetails): This model contains
            pronunciation details of a specific word.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "word": 'word',
        "pronunciation": 'pronunciation'
    }

    _optionals = [
        'word',
        'pronunciation',
    ]

    _nullables = [
        'word',
    ]

    def __init__(self,
                 word=APIHelper.SKIP,
                 pronunciation=APIHelper.SKIP):
        """Constructor for the PronunciationResponse class"""

        # Initialize members of the class
        if word is not APIHelper.SKIP:
            self.word = word 
        if pronunciation is not APIHelper.SKIP:
            self.pronunciation = pronunciation 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary

        word = dictionary.get("word") if "word" in dictionary.keys() else APIHelper.SKIP
        pronunciation = PronunciationDetails.from_dictionary(dictionary.get('pronunciation')) if 'pronunciation' in dictionary.keys() else APIHelper.SKIP 
        # Return an object of this model
        return cls(word,
                   pronunciation)
